

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMUsers.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/UMUsers.script,v $ $Id: UMUsers.script,v 1.13.2.12 2020/10/04 00:54:06 abilbrey Exp $";

SET QUOTED_IDENTIFIER ON

SET  NOCOUNT ON
SET IDENTITY_INSERT UMUsers ON


---------------------------------------------------------------------------

-- BECAUSE WE HAVEN'T DEFINED OUR OWN FUNCTIONS BY THE TIME THIS SCRIPT --

-- IS RUN, WE NEED TO "ROLL OUR OWN"                                    --

--------------------------------------------------------------------------

----Set     @nowTime            = dbo.GetUnixTime (GetUTCdate())

----

DECLARE @nowTime            int

DECLARE @DateTimeArg datetime

SET @DateTimeArg = getUTCdate()

DECLARE @dateTimeBase DATETIME

set @dateTimeBase = '01/01/1970'

if (@DateTimeArg < @dateTimeBase)

  set @nowTime = 0

  ELSE

    set @nowTime =  datediff(second, '01/01/1970', @DateTimeArg)

--------------------------------------------------------------------------
SET IDENTITY_INSERT UMUsers OFF


declare @user_valid int

declare @user_perm int

declare @user_hide int

declare @user_admin int

set @user_valid = 0x001

set @user_perm = 0x002

set @user_hide = 0x004

set @user_admin = 0x040

--make admin part of administrative group

declare @i_MasterGroupId	int

declare @i_UserId	int

SET @i_MasterGroupId = (Select ID from UMGroups where (groupFlags&0x0008)=0x0008)

IF NOT EXISTS(SELECT UMUsers.login FROM UMUsers WHERE (((UMUsers.flags & @user_admin) <> 0) AND UMUsers.Name <> 'ROMS')) 

BEGIN
	INSERT INTO UMUsers(login, name, password, description, email, Pager, datePasswordSet, dateExpires, modified, pVer, enabled, policy, lastLogInTime, credSetTime, umDSproviderId, flags, userGuid, origUserGuid, origCCId)


	VALUES ('admin', 'Administrator', '2', 'Administrator', '', '', 0, 0, 0, 50, 1, 0, 0, 0, 0, @user_valid |@user_perm |@user_admin, NEWID(), '', 0)

END

ELSE

	UPDATE UMUsers SET userGuid=NEWID() WHERE ((UMUsers.flags & @user_admin) <> 0) AND (UMUsers.Name <> 'ROMS') AND (userGuid is null OR userGuid = '')

SET @i_UserId = (SELECT id FROM UMUsers WHERE (((UMUsers.flags & @user_admin) <> 0) AND (UMUsers.Name <> 'ROMS')))

IF NOT EXISTS (SELECT * FROM UMUserGroup WHERE userid = @i_UserId and groupid = @i_MasterGroupId)

BEGIN
	INSERT INTO UMUserGroup


	VALUES (@i_UserId, @i_MasterGroupId, 0)

END

/*

--Insert ROMS User

IF EXISTS(SELECT UMUsers.login FROM UMUsers WHERE UMUsers.login = 'ROMS')

BEGIN

	UPDATE UMUsers

	SET name = 'ROMS',

		password = '2ed9dCCpCCCpyCCpyCCpMCCpyCCMpCCdhCCdiCCM9CCpdCCpCCCpCCCpCCCdmCCdECCdpCCMPCC',

		description = 'ROMS User',

		dateExpires = 0,

		pVer = 50,

		enabled = 1,

		policy = 0,

		lastLogInTime = 0,

		credSetTime = 0,

		umDSproviderId = 0,

		flags = (@user_valid | @user_perm | @user_hide)

	WHERE login = 'ROMS'

END

ELSE

BEGIN
	INSERT INTO UMUsers(login, name, password, description, email, Pager, datePasswordSet, dateExpires, modified, pVer, enabled, policy, lastLogInTime, credSetTime, umDSproviderId, flags, userGuid, origUserGuid, origCCId)


	VALUES ('ROMS', 'ROMS', '2ed9dCCpCCCpyCCpyCCpMCCpyCCMpCCdhCCdiCCM9CCpdCCpCCCpCCCpCCCdmCCdECCdpCCMPCC', 'ROMS User', '', '', 0, 0, 0, 50, 1, 0, 0, 0, 0, @user_valid | @user_perm | @user_hide, '', '', 0)

END

SET @i_UserId = (SELECT id FROM UMUsers WHERE login = 'ROMS')

IF NOT EXISTS (SELECT * FROM UMUserGroup WHERE userid = @i_UserId and groupid = @i_MasterGroupId)

BEGIN
	INSERT INTO UMUserGroup


	VALUES (@i_UserId, @i_MasterGroupId, 0)

END

  -------------------  ADD WBA USER   ---------------------

declare @i_WBA_UserId		int

declare @i_WBA_UserLogin	Nvarchar(50) = N'wba_gui__'

declare @i_WBA_UserPassword	varchar(50)  = '2hql300rl00rX003x005R00lv00rR00'

IF EXISTS (SELECT * FROM UMUsers WHERE login = @i_WBA_UserLogin)

BEGIN

	UPDATE UMUsers

	SET name = @i_WBA_UserLogin,

		password = @i_WBA_UserPassword,

		description = 'Common User Login for WBA',

		email = '',

		datePasswordSet = 0,

		dateExpires = 0,

		pVer = 50,

		enabled = 1,

		policy = 0,

		lastLogInTime = 0,

		credSetTime = 0,

		umDSproviderId = 0,

		flags = (@user_valid | @user_perm | @user_hide)

	WHERE login = @i_WBA_UserLogin

END

ELSE

BEGIN
	INSERT INTO UMUsers(login, name, password, description, email, Pager, datePasswordSet, dateExpires, modified, pVer, enabled, policy, lastLogInTime, credSetTime, umDSproviderId, flags, userGuid, origUserGuid, origCCId)


	VALUES (@i_WBA_UserLogin, @i_WBA_UserLogin, @i_WBA_UserPassword, 'Common User Login for WBA', '', '', 0, 0, 0, 50, 1, 0, 0, 0, 0, @user_valid | @user_perm |@user_hide, '', '', 0)

END

SET @i_WBA_UserId = ISNULL((SELECT id FROM UMUsers WHERE login = @i_WBA_UserLogin), 0)

IF @i_MasterGroupId <> 0  AND NOT EXISTS (SELECT * FROM UMUserGroup WHERE userId = @i_WBA_UserId and groupid = @i_MasterGroupId)

BEGIN
	INSERT INTO UMUserGroup (userId, GroupId, flag)


	VALUES (@i_WBA_UserId, @i_MasterGroupId, 0)

END

---------------  END ADD WBA USER   ---------------------

*/
SET IDENTITY_INSERT UMUsers ON


IF NOT EXISTS (SELECT * FROM UMUSERS WHERE id = -10)

	INSERT UMUSERS (id, name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified,

						pVer, Pager, lastLogInTime, credSetTime, umDSproviderId)

VALUES(-10, 'SRM Advisory User', '', '_+_SRM_Advisory_#User{1Name', 'Password Disabled', 'No Email', @nowTime, 0, 0, 0, 0x002, 0,

						0,    '',    0,             0,            0)

IF NOT EXISTS (SELECT * FROM UMUSERS WHERE id = -20)

	INSERT UMUSERS (id, name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified,

						pVer, Pager, lastLogInTime, credSetTime, umDSproviderId, userGuid)

VALUES(-20, 'Public Sharing User', '', '_+_PublicSharingUser_', '2exxxxx', 'No Email', @nowTime, 0, 0, 1, @user_valid | @user_perm |@user_hide, 0,

						0,    '',    0,             0,            0, NEWID())

ELSE

BEGIN

UPDATE UMUsers SET enabled=1 WHERE id = -20 AND enabled = 0

UPDATE UMUsers SET userGuid=NEWID() WHERE id = -20 AND userGuid IS null

END

IF NOT EXISTS (SELECT * FROM UMUSERS WHERE id = -40)

	INSERT UMUSERS (id, name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified,

						pVer, Pager, lastLogInTime, credSetTime, umDSproviderId, userGuid)

VALUES(-40, 'Dummy User For Outlook Addin Content Store ', '', 'OutlookAddinContentStore', '2exxxxx', 'No Email', @nowTime, 0, 0, 1, @user_valid | @user_perm |@user_hide, 0,

						0,    '',    0,             0,            0, NEWID())

ELSE

BEGIN

UPDATE UMUsers SET enabled=1 WHERE id = -40 AND enabled = 0

UPDATE UMUsers SET userGuid=NEWID() WHERE id = -40 AND userGuid IS null

END

IF NOT EXISTS (SELECT * FROM UMUSERS WHERE id = -30)

	INSERT UMUSERS (id, name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified,

						pVer, Pager, lastLogInTime, credSetTime, umDSproviderId)

VALUES(-30, 'Dummy WebReports Tag User', 'Dummy WebReports Tag user is referred in DM2DocTags and UserToTagXML tables.', '_+_DummyWebReportsTagUser_', 'Password Disabled', 'No Email', @nowTime, 0, 0, 0, @user_perm |@user_hide, 0,

						0,    '',    0,             0,            0)

IF NOT EXISTS (SELECT * FROM UMUSERS WHERE id = -50)

    INSERT UMUSERS (id, name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified,

                        pVer, Pager, lastLogInTime, credSetTime, umDSproviderId, userGuid)

VALUES(-50, 'Events Organizer Public User', 'Dummy user for Event Organizer', '_+_EventOrganizerPublicUser_', '2exxxxx', 'No Email', @nowTime, 0, 0, 1, @user_valid | @user_perm |@user_hide, 0,

                        0,    '',    0,             0,            0, NEWID())

ELSE

BEGIN

UPDATE UMUsers SET enabled=1 WHERE id = -50 AND enabled = 0

UPDATE UMUsers SET userGuid=NEWID() WHERE id = -50 AND userGuid IS null

END
SET IDENTITY_INSERT UMUsers OFF


--System created admin user for Create As and other applications 

DECLARE @systemCreatedAdminLoginName VARCHAR(1024) = 'SystemCreatedAdmin'

IF NOT EXISTS (SELECT * FROM UMUsers WHERE flags & 0x1000 <> 0)

BEGIN

	--According to Amey we should set password as 9+RandomGUID so that this user cannot even accidentally login.

	DECLARE @newUserPassword VARCHAR(512)

	DECLARE @newUserPasswordRandomGUID VARCHAR(512) = NEWID()

	SET @newUserPassword = '9' + @newUserPasswordRandomGUID

	IF EXISTS (SELECT 1 FROM UMUsers WHERE login = @systemCreatedAdminLoginName)

		SET @systemCreatedAdminLoginName  = @systemCreatedAdminLoginName + '_' + CAST(@nowTime AS VARCHAR(50))

	IF NOT EXISTS (SELECT 1 FROM UMUsers WHERE login = @systemCreatedAdminLoginName)				-- Still let us check once for login; If it already exists, inserting again will fail upgrade. 
		INSERT INTO UMUsers (name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified,


							pVer, Pager, lastLogInTime, credSetTime, umDSproviderId, userGuid)

VALUES('System Administrator', 'System created Admin user', @systemCreatedAdminLoginName, @newUserPassword, '', @nowTime, 0, 0, 1, @user_valid | @user_perm | @user_hide | 0x1000 | 0x2000, 0,

							0,	'',		0,			0,				0, NEWID())

	-- Else let us not insert anything. We can give a script for that customer to insert system admin user.

DECLARE @systemCreatedAdminUserId INT = (SELECT id FROM UMUsers WHERE flags & 0x1000 <> 0)

	IF @systemCreatedAdminUserId IS NOT NULL 

		IF NOT EXISTS (SELECT 1 FROM UMUserGroup WHERE @i_MasterGroupId = groupId AND @systemCreatedAdminUserId = userId)
			INSERT INTO UMUserGroup (userId, groupId, flag)


				SELECT @systemCreatedAdminUserId, @i_MasterGroupId, 0

END

ELSE

BEGIN

	-- Earlier the name was SystemAdmin. So change it to SystemCreatedAdmin.

IF EXISTS (SELECT 1 FROM UMUsers WHERE login = 'SystemAdmin' AND flags & 0x1000 <> 0)

	BEGIN

		IF EXISTS (SELECT 1 FROM UMUsers WHERE login = @systemCreatedAdminLoginName)		

			SET @systemCreatedAdminLoginName  = @systemCreatedAdminLoginName + '_' + CAST(@nowTime AS VARCHAR(50))

		IF NOT EXISTS (SELECT 1 FROM UMUsers WHERE login = @systemCreatedAdminLoginName)

			UPDATE UMUsers

			SET

				login = @systemCreatedAdminLoginName

			WHERE

flags & 0x1000 <> 0

	END

END

DECLARE @createAsUserPasswordFixGUID VARCHAR(512) = 'B2CA37EF-D449-4E33-9D82-E75E69158F67'

IF NOT EXISTS (SELECT TOP 1 1

			   FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK)

			   WHERE

					SqlScriptGUID = @createAsUserPasswordFixGUID)

BEGIN

	UPDATE UMUsers 

	SET password = '9' + CAST(NEWID() AS VARCHAR(512))

	WHERE

flags & 0x800 <> 0
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@createAsUserPasswordFixGUID, 'CreateAsUserPasswordFix', 'Fixing empty password for Create As users', @nowTime, 16, 0 , (16 + 1))

END

-- We need to have these hidden CreateAs users enabled. 

-- Because Schedule Reports code checks explicitly if user is enabled. 

-- When this user is made as Schedule Reports owner, if he is disabled, the report does not run. 

-- This user cannot login since his password is not allowed to login. So we are good. 

DECLARE @enableCreateAsUsersGUID VARCHAR(512) = 'E5F610A9-6684-42A5-96B1-206B5D85868B'

IF NOT EXISTS (SELECT TOP 1 1

			   FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK)   

			   WHERE

					SqlScriptGUID = @enableCreateAsUsersGUID) 

BEGIN

    DECLARE @userNewLogin TABLE(userId int, newLogin varchar(510),providerId int) 
	INSERT INTO @userNewLogin


	SELECT PROP.attrVal,

		   CASE WHEN(G.umdsproviderId=0) THEN G.name ELSE provider.domainname+'\'+G.name

									END, 

		  G.umdsProviderId

	FROM

	UMGroupsPROP PROP   

	JOIN UMGroups G ON  G.id=Prop.componentNameId

	LEFT JOIN UMDSProviders provider ON G.umdsproviderId=provider.id

WHERE PROP.attrName = N'Create As User' AND PROP.modified = 0

	UPDATE TBL

	SET newLogin=newLogin+' Group'

	FROM @userNewLogin TBL JOIN UMUSers ON newLogin=login

	UPDATE TBL		

	SET TBL.enabled = 1 ,TBL.login=newLogin ,umdsproviderId=providerId

	FROM UMUsers TBL JOIN @userNewLogin ON id=userId

WHERE TBL.flags & 0x800<> 0
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@enableCreateAsUsersGUID, 'EnableHiddenUser', 'Enabling hidden users, created when user select a User Group as creator for client group', @nowTime, 16, 0 , (16 + 1))

END

-- To solve issue username=Create As User in Alerts:

-- Update UMUsers table make name = login for users which are created when a User Group is selected as creator for client group. 

DECLARE @setCorrectCreateAsUsername VARCHAR(512) = 'E5F610A9-6684-42A5-96B1-206B5D85868C'

IF NOT EXISTS (SELECT TOP 1 1

			   FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK)   

			   WHERE

					SqlScriptGUID = @setCorrectCreateAsUsername) 

BEGIN

UPDATE UMUsers SET name = login WHERE (flags & 0x800 = 0x800)
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@setCorrectCreateAsUsername, 'SetCorrectUserName', 'Setting username same as that of login for users which are created when a User Group is selected as creator for client group', @nowTime, 16, 0 , (16 + 1))

END

SET  NOCOUNT OFF

