

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMUserGroup.script] ---------- 


SET QUOTED_IDENTIFIER OFF
INSERT INTO UMUserGroup


SELECT DSG.userId,  DSG.groupId,DSG.flag

FROM UMDSUSERGROUP DSG LEFT OUTER JOIN UMUSERGROUP G on  G.userId=DSG.userId and G.groupId=DSG.groupId

WHERE G.userId IS NULL

SET QUOTED_IDENTIFIER ON

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '7A6A878E-51A5-4160-AFCE-62559CADE31E')

BEGIN

	BEGIN TRY

		BEGIN TRANSACTION

		-- Get All UserGroup for Plans that are not Laptop Plans

		DECLARE @userGroupsID TABLE (groupId INT)
		INSERT INTO @userGroupsID


		SELECT APP.attrVal FROM APP_PLANPROP APP

		INNER JOIN APP_PLAN AP

ON APP.componentNameId=AP.id AND APP.attrName='Assigned user group' AND AP.subType <> 33554439

		-- Just to be safe. Let's not delete User Groups which has some users in it. This way we ensure of no capability loss

		DELETE FROM @userGroupsID WHERE groupId IN (SELECT groupId FROM UMUserGroup)

		-- -- remove existing associations and group itself

		DELETE FROM UMUserGroup WHERE groupId IN (SELECT groupId FROM @userGroupsID )

		DELETE FROM UMGroupsProp WHERE componentNameId IN (SELECT groupId FROM @userGroupsID )

		DELETE FROM UMGroups WHERE id IN (SELECT groupId FROM @userGroupsID )
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('7A6A878E-51A5-4160-AFCE-62559CADE31E', 'Removal of Unwanted UserGroup for Plans', 'Removal of unwanted UserGroups for Plan other than Laptop Plans', dbo.getUnixTime(GetUTCDate()), 16, 0, (16 + 2))

		COMMIT TRANSACTION

    END TRY

    BEGIN CATCH

		ROLLBACK TRANSACTION

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		RAISERROR('Failed to removal of unwanted UserGroup for Plans', 16, 1)  

	END CATCH

END

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '1c32c3dc-12ca-45f2-aa1b-67186016f9ec')

BEGIN

	BEGIN TRY

		BEGIN TRANSACTION

			DELETE ins

				FROM UMUserGroup ins

				INNER JOIN UMUSERS UU

                   ON ins.userId=UU.id

                 INNER JOIN UMGroups UG

                 	ON UG.id=ins.groupId AND UG.name='Tenant Users'

                 INNER JOIN UMDSProviders UUUD1

                 	ON UUUD1.id=UU.umDSproviderId

                 INNER JOIN UMDSProviders UU_UdOwner

                 	ON (UUUD1.serviceType=5 AND UU_UdOwner.id=UUUD1.id) OR (UUUD1.serviceType in (2,12) AND UU_UdOwner.id=UUUD1.ownerCompany) OR (UUUD1.serviceType not in (2,5,12) AND UU_UdOwner.id=0)

                 INNER JOIN UMDSProviders UGUD2

                 	ON UGUD2.id=UG.umDSproviderId

                 INNER JOIN UMDSProviders UG_UdOwner

                 	ON (UGUD2.serviceType=5 AND UG_UdOwner.id=UGUD2.id) OR (UGUD2.serviceType in (2,12) AND UG_UdOwner.id=UGUD2.ownerCompany) OR (UGUD2.serviceType not in (2,5,12) AND UG_UdOwner.id=0)

                 WHERE UG_UdOwner.id<>UU_UdOwner.id 
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('1c32c3dc-12ca-45f2-aa1b-67186016f9ec', 'Removal of wrong user to  UserGroups association', 'Removal of association of users from one company to UserGroups of another company.', dbo.getUnixTime(GetUTCDate()), 16, 0, (16 + 2))

		COMMIT TRANSACTION

    END TRY

    BEGIN CATCH

		ROLLBACK TRANSACTION

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		RAISERROR('Failed to remove of wrong user to userGroups association', 16, 1)  

	END CATCH

END

GO

SET QUOTED_IDENTIFIER ON

GO	

