

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMSecurityAssociations.script] ---------- 


SET QUOTED_IDENTIFIER OFF

SET QUOTED_IDENTIFIER ON 

DECLARE @masterGroupId INTEGER = (Select ID from UMGroups where (groupFlags&0x0008)=0x0008)

DECLARE @roleId INTEGER =(SELECT id FROM UMRoles WHERE name like 'Master' and (flags & 1 | 2 <> 0))

UPDATE UMSecurityAssociations

set entityType1=1, entityId1=2

WHERE entityType1=126

IF NOT EXISTS( SELECT * FROM  UMSecurityAssociations WHERE roleId=@roleId and userOrGroupId=@masterGroupId and isUser=0 and entityType1=1 and isCreator = 1)
	INSERT INTO UMSecurityAssociations(roleId,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects,roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,isCreator,authorId)


VALUES(@roleId,@masterGroupId,0,1,1,0,0,0,1,2,0,0,0,0,0,0,0,0,1,1)

ELSE

	UPDATE UMSecurityAssociations

	SET roleId =@roleId,

		userOrGroupId=@masterGroupId,

		isUser =0,

		isRoleAllowed=1,

		propagateToChildObjects=1,

		roleValidityDate=0,

		timeZone=0,

		exclude=0,

entityType1=1,

		entityId1=2,

		entityType2=0,

		entityId2=0,

		entityType3=0,

		entityId3=0,

		entityType4=0,

		entityId4=0,

		entityType5=0,

		entityId5=0,

		isCreator=1,

		authorId=1

WHERE roleId=@roleId and isUser=0 and userOrGroupId=@masterGroupId and entityType1=1 and entityId1=2 and isCreator = 1

IF EXISTS (SELECT  1 from UMGroups where name like 'View All' and groupFlags&(convert(int, 0x8000))<>0)

BEGIN

DECLARE @viewAllgroupId INTEGER = (SELECT  id from UMGroups where name like 'View All' and groupFlags&(convert(int, 0x8000))<>0)

SET @roleId = (SELECT id FROM UMRoles WHERE name='View' and flags&1 | 2<>0)

IF NOT EXISTS( SELECT * FROM  UMSecurityAssociations WHERE roleId=@roleId and userOrGroupId= @viewAllgroupId and isUser=0 and entityType1=1 and isCreator = 1)
	INSERT INTO UMSecurityAssociations(roleId,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects,roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,isCreator,authorId)


VALUES(@roleId, @viewAllgroupId ,0,1,1,0,0,0,1,2,0,0,0,0,0,0,0,0,1,1)

ELSE

	UPDATE UMSecurityAssociations

	SET roleId =@roleId,

		userOrGroupId= @viewAllgroupId ,

		isUser =0,

		isRoleAllowed=1,

		propagateToChildObjects=1,

		roleValidityDate=0,

		timeZone=0,

		exclude=0,

entityType1=1,

		entityId1=2,

		entityType2=0,

		entityId2=0,

		entityType3=0,

		entityId3=0,

		entityType4=0,

		entityId4=0,

		entityType5=0,

		entityId5=0,

		isCreator=1,

		authorId=1

WHERE roleId=@roleId and isUser=0 and userOrGroupId= @viewAllgroupId and entityType1=1 and entityId1=2 and isCreator = 1

END

--Handling smart client groups 

--We missed creating these creator associations for smart client groups for fresh installation v11. 

--So we are creating them now. This is only for existing setups. 

--Going forward these associations will be inserted by default during the smart client group creation. 

--So only to run this one time we have global param check 

--1. For upgraded setups from v10, we will have the upgrade script setting the creator associations from old table UMUSerAndGroupEntityAssociation.

--2. For all fresh installations here after and edge clients created here after, the creator associations will be done during the client group creation.

IF NOT EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'OldReleaseNumber')				--not upgraded 

BEGIN

	IF (SELECT TOP 1 id FROM SimAllGalaxyRel ORDER BY id DESC) = 16						--v11

	BEGIN

		IF NOT EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'SCGCreatorsFix' AND value = '1')			--key is not there 

		BEGIN

			DECLARE @creatorId INT = ISNULL((SELECT TOP (1) id FROM UMUsers WHERE (flags & 0x40 = 0x40)), 1)						--admin user

			DECLARE @masterRoleID INT = ISNULL((SELECT id FROM UMRoles WHERE name = 'Master' AND (flags & (1 | 2) <> 0)), 1)		--Master role

			DECLARE @systemOwnerCapabilityRoleId INT = (SELECT roleId FROM UMOwnerRoles WHERE entityType = 1 AND entityId = 2)		--system owner capability role

			DECLARE @clientGroupId INT 

			SET @clientGroupId = (SELECT id FROM APP_ClientGroup WHERE name = 'Media Agents' AND (flag & 0x1000 <> 0))

			IF @clientGroupId IS NOT NULL 

			BEGIN

				IF NOT EXISTS (SELECT 1 

							   FROM UMSecurityAssociations 

							   WHERE entityType1 = 28 AND entityId1 = @clientGroupId AND isCreator = 1)

				BEGIN
					INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 


									SELECT CASE WHEN @systemOwnerCapabilityRoleId IS NOT NULL THEN @systemOwnerCapabilityRoleId ELSE @masterRoleID END, 0, @creatorId, 1, 28, @clientGroupId, 1, 1

				END

			END

			SET @clientGroupID = (SELECT id FROM APP_ClientGroup WHERE name = 'Laptop Clients' AND (flag & 0x1000 <> 0))

			IF @clientGroupId IS NOT NULL 

			BEGIN

				IF NOT EXISTS (SELECT 1 

							   FROM UMSecurityAssociations 

							   WHERE entityType1 = 28 AND entityId1 = @clientGroupId AND isCreator = 1)

				BEGIN
					INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 


									SELECT CASE WHEN @systemOwnerCapabilityRoleId IS NOT NULL THEN @systemOwnerCapabilityRoleId ELSE @masterRoleID END, 0, @creatorId, 1, 28, @clientGroupId, 1, 1

				END

			END

			SET @clientGroupID = (SELECT id FROM APP_ClientGroup WHERE name = 'Edge Clients' AND (flag & 0x1000 <> 0))

			IF @clientGroupId IS NOT NULL 

			BEGIN

				IF NOT EXISTS (SELECT 1 

							   FROM UMSecurityAssociations 

							   WHERE entityType1 = 28 AND entityId1 = @clientGroupId AND isCreator = 1)

				BEGIN
					INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 


									SELECT CASE WHEN @systemOwnerCapabilityRoleId IS NOT NULL THEN @systemOwnerCapabilityRoleId ELSE @masterRoleID END, 0, @creatorId, 1, 28, @clientGroupId, 1, 1

				END

			END
			INSERT INTO GxGlobalParam (name, value, created, modified)			--insert the key now, next time the script is run this code will not execute 


				VALUES ('SCGCreatorsFix', '1', datediff(second, '01/01/1970', GETDATE()), 0)

		END			--check for the gxGlobalParam key		

	END

END

UPDATE UMSecurityAssociations 

SET entityType1 = 15

WHERE entityType1 = 62

-- Below code has to executed only once.

-- LM share was with permission 0 before. Now created a new permission for lm shares.

-- So , here updating the previously created shares with new permission.

DECLARE @sqlScriptGuiID NVARCHAR(MAX)= '5015D341-7075-4D8B-AC78-2F62DA75DE76'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @sqlScriptGuiID)

BEGIN

	DECLARE @nowTime INTEGER

	SET @nowTime =  datediff(second, '01/01/1970', GetUTCdate())    

	UPDATE UMSecurityAssociations

SET permissionId = 216

WHERE permissionId = 31 AND entityType1 = 9674
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@sqlScriptGuiID, 'LMUpdatePermissionForSharedEntityScript', 'Script to update view permission of lm shared entity into searchShare view', @nowTime, 16, 0, 18)

END

-- Add "Use Proxy" for all entities that have "Agent Management" permission

DECLARE @UseProxyPermUpgradeGuid uniqueidentifier = 'E2212D9F-0CA3-4A12-8BA7-3644062837AB'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @UseProxyPermUpgradeGuid)

BEGIN

EXEC sec_addPermissionForPermission 2,252
INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@UseProxyPermUpgradeGuid, 'UpgradeUseProxyPermission', 'Update script to add Use Proxy Permission', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

END

