

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMRolesCapabilityBitMask.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- --------------------------------------------------------------------------------------

--                                                                      

--       This script is 1-time script for updating UMRoles::capabilityBitMask   

--       based on UMRolesWithPermissionsExpanded table.     

--                                                                      

--       It will affect roles created till now. Going forward, UMRolesCapabilityBitMask 

--		 trigger will take care of it. 

--        

--		 Reason for writing it separate .script is there are 2 files that create roles

--		 during installation - UMRoles.script, UMDefaultRoles.script 

--		 This script will be present at the last of the .lst so this will cover up all 

--		 roles till now. 

--

--       Authors: jswaminathan 

-- -------------------------------------------------------------------------------------*/

SET NOCOUNT ON

DECLARE @umrolesCapabilityBitMaskGUID VARCHAR(256) = '7D06CB43-9AD5-443F-A47B-758C0EC97E59'

IF NOT EXISTS (SELECT TOP 1 * 

			  FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) 

			  WHERE	

					gp.SqlScriptGUID = @umrolesCapabilityBitMaskGUID	

			  )

BEGIN

	DECLARE @nowTime INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

	UPDATE R 

	SET capabilitiesBitMask = 

								(

									SELECT ISNULL(CAST(SUM(POWER(2.0,permissionId-1)) AS BIGINT),0)				-- We cannot use bitwiseOr here. Using SUM is fine, because permissionIds are unique in here. 

									FROM UMRolesWithPermissionsExpanded R1 

									WHERE

										R1.roleID = R.id AND R1.permissionId < 64 

								)

	FROM UMRoles R
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@umrolesCapabilityBitMaskGUID, 'UMRolesCapabilityBitMask', 'Populate roles capability bit mask', @nowTime, 16, 0 , (16 + 2))

END

DECLARE @umrolesPermissionsStringGUID VARCHAR(256) = '6214CD12-39E2-44F9-8B3B-6E617BBAF280'

IF NOT EXISTS (SELECT TOP 1 * 

			  FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) 

			  WHERE	

					gp.SqlScriptGUID = @umrolesPermissionsStringGUID	

			  )

BEGIN

	DECLARE @tempRoleId INT 

	DECLARE tempCursor CURSOR FOR 

		SELECT id 

		FROM UMRoles

	OPEN tempCursor 

	FETCH NEXT FROM tempCursor INTO @tempRoleID 

	WHILE @@FETCH_STATUS = 0

	BEGIN

DECLARE @permissionsSeedString VARCHAR(512) = REPLICATE('0',512)

		SELECT @permissionsSeedString = STUFF(@permissionsSeedString,permissionId,1,'1')

		FROM UMRolesWithPermissionsExpanded

		WHERE

			roleId = @tempRoleId 

		UPDATE UMRoles 

		SET permissionsString = @permissionsSeedString

		WHERE

			id = @tempRoleId

		FETCH NEXT FROM tempCursor INTO @tempRoleID 

	END

	CLOSE tempCursor 

	DEALLOCATE tempCursor 

	SET @nowTime = DATEDIFF(second, '01/01/1970', GETUTCDATE())
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@umrolesPermissionsStringGUID, 'UMRolesPermissionsString', 'Populate roles capability String bit mask', @nowTime, 16, 0 , (16 + 2))

END

SET NOCOUNT OFF
