

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMPruneSessionAuditEntries.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- .script 

-- ALLOW_COMMENTS_BELOW_HERE:

-- ---------------------------------------------------------------------- 

-- 

--           Copyright (c) 2020  CommVault Systems, Inc. 

--                  All rights reserved. 

-- 

-- 

--        This is unpublished proprietary source code of CommVault 

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

BEGIN TRY

    DECLARE @guid UNIQUEIDENTIFIER = 'DAA3A896-2687-419D-9D76-4C40EF22036A' 

    DECLARE @deletePubicUserSession INT = 0 

    SELECT @deletePubicUserSession = 1 

    FROM   gxuniquesqlscriptexectracking gp WITH(NOLOCK) 

    WHERE  gp.sqlscriptguid = @guid 

    IF @deletePubicUserSession = 0 

    BEGIN 

		DECLARE @curUtcDateTime BIGINT = Datediff(second, '01/01/1970', Getutcdate()) 

		DECLARE @tableName NVARCHAR(20) = N'UMSessionAudit' 

		DECLARE @changeDescription NVARCHAR(150) = N'Deleting entries for Public Sharing Users from UMSessionAudit table as they are of no significance' 

DELETE FROM UMSessionAudit WHERE userId = -20
		INSERT INTO gxuniquesqlscriptexectracking 


					(sqlscriptguid, 

					 NAME, 

					 description, 

					 createdtime, 

					 createdrelid, 

					 expiretime, 

					 expirerelid) 

		VALUES     (@guid, 

					@tableName, 

					@changeDescription, 

					@curUtcDateTime, 

16, 0 , (16+ 2 ))

		PRINT N'Script for deleting Public Sharing User entry from UMSessionAudit table executed successfully..' 

	END 

ELSE 

  PRINT N'Script for deleteing Public Sharing User entry from UMSessionAudit table already executed..' 

END TRY 

BEGIN CATCH 

    PRINT N'Error occured. At Line(' 

          + Cast(Error_line() AS NVARCHAR) 

          + N') ErrorNo(' 

          + Cast(Error_number() AS NVARCHAR) 

          + N') ErrorMsg(' + Error_message() + N').' 

END CATCH 

SET NOCOUNT OFF

