

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMPermissions.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

/*

ADD THE NEWLY ADDED PERMISSION TO UMPermissionEntityTypeMap.script

If the permission is not needed to be mapped with any entity, set

entity type as 0. Else map it to the desired entity.

*/

/*

When we are just adding a new permission use the NEW_ROW_IF_NOT_EXIST macro with the new permission

When we are deleting a permission use the DELETE_PERMISSION macro with the permission

If you want to re-order the permission from one category to another category then NEW_ROW_IF_NOT_EXIST macro 

will itself take care of that. You just need to mention the new category Id as input 

Make sure to add all NEW_ROW_IF_NOT_EXIST rows for new permissions before the first DELETE_CATEGORY statement 

starts

*/

/*This macro has these inputs 

--1. x_permissionId - new permissionId 

--2. x_categoryId - category Id 

--3. x_permissionName - new permission name 

--4. x_flag - flags for permission 

--5. x_messageId - message Id for this permission (for localization purposes) 

--6. x_oldPermissionId - some permissions were dependent on old permissions 

--(eg, when we created permission called as Edit Workflow it was dependent on Edit permission)

--(whoever had Edit permission had Edit Workflow also)

--(can be 0 if there is no such dependency)*/

SET  NOCOUNT ON

IF EXISTS (select * from sysobjects where name='expandRolePermissionOnNewNewPermissionTblScript')

    DROP PROCEDURE expandRolePermissionOnNewNewPermissionTblScript

GO

CREATE  PROCEDURE expandRolePermissionOnNewNewPermissionTblScript

@permissionId INTEGER

AS

BEGIN

IF EXISTS (SELECT id from UMpermissions where id=@permissionId and flags & 2 <>0)

		RETURN

	DECLARE @categoryId INTEGER=(SELECT categoryId FROM UMPermissions WHERE id=@permissionId)

	DECLARE @parentRoleId TABLE( roleId integer);

	WITH parentIds ( parentId,categoryId)

	AS

		(	SELECT id,id FROM UMCategories WHERE id=@categoryId   

			UNION ALL

			SELECT parentCategoryId,id FROM UMCategories JOIN parentIds on UMCategories.id=parentIds.parentId and parentCategoryId<>0 

		)
	INSERT INTO @parentRoleId 


	 SELECT DISTINCT R.id FROM

	 (SELECT  roleId

		FROM UMRolesPermissions  RP 

		JOIN parentIds parent 

ON (RP.hierarchyLevel=121 and parent.parentId =RP.categoryId and excludeCategory<>1 )

		UNION ALL

		SELECT roleId

FROM UMRolesPermissions  WHERE hierarchyLevel=123

	 ) roles  JOIN UMRoles  R ON  R.id=roles.roleId   WHERE R.disabled<>1 and R.id NOT IN(SELECT roleId FROM UMRolesPermissions RP JOIN parentIds parent 

ON  RP.hierarchyLevel=121 and parent.parentId =RP.categoryId and excludeCategory=1)
	INSERT INTO UMRolesWithPermissionsExpanded


	SELECT roleId,@categoryId, @permissionId FROM @parentRoleId where roleId not in (select roleId FROM UMRolesWithPermissionsExpanded WHERE categoryId=@categoryId and permissionId=@permissionId)

END

GO

IF EXISTS (SELECT * FROM sysobjects WHERE name  = 'deletePermissionScript')

	DROP PROCEDURE deletePermissionScript

GO

CREATE PROCEDURE deletePermissionScript

@permissionId INTEGER

AS

BEGIN

	DELETE FROM UMSecurityAssociations WHERE permissionId = @permissionId

	DELETE FROM UMOwnerRoles WHERE permissionId = @permissionId 

	DELETE FROM UMRolesWithPermissionsExpanded WHERE permissionId=@permissionId

DELETE FROM UMRolesPermissions WHERE permissionId=@permissionId  and hierarchyLevel= 122

	DELETE FROM UMPermissions WHERE id=@permissionId

END

GO

IF EXISTS(select * from sysobjects where id = object_id(N'[dbo].[getAllParentsForCatOrPerm_TblScript]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))

	drop function [dbo].[getAllParentsForCatOrPerm_TblScript] 

GO

CREATE FUNCTION getAllParentsForCatOrPerm_TblScript (@categoryId INT, @permissionId INT)

	RETURNS @parentsTbl TABLE

	(

				categoryId INT

	)

	AS

	BEGIN

                IF @permissionId <> 0			--this is a permission

                BEGIN
					INSERT INTO @parentsTbl


						SELECT categoryId		--immediate parent

						FROM UMPermissions

						WHERE id = @permissionId

						UNION

						SELECT Parent.categoryId	--for immediate parent category go recursively to find all parent categories

						FROM UMPermissions AS Perm

						CROSS APPLY dbo.getAllParentsForCatOrPerm_TblScript(Perm.categoryId, 0) AS Parent

						WHERE Perm.id = @permissionId

                END

                ELSE IF @categoryId <> 0			--this is a category

                BEGIN
					INSERT INTO @parentsTbl			--immediate parent


						SELECT parentCategoryId

						FROM UMCategories

						WHERE id = @categoryId AND parentCategoryId <> 0

						UNION

						SELECT Parent.categoryId	--for immediate parent category go recursively to find all parent categories

						FROM UMCategories AS Cat

						CROSS APPLY dbo.getAllParentsForCatOrPerm_TblScript(Cat.parentCategoryId, 0) AS parent

						WHERE Cat.id = @categoryId AND Cat.parentCategoryId <> 0

                END

                RETURN

	END

	GO

IF EXISTS (SELECT * FROM sysobjects WHERE name  = 'ReOrderPermissionScript')

	DROP PROCEDURE ReOrderPermissionScript

GO

CREATE PROCEDURE ReOrderPermissionScript	

@permissionId INTEGER,

@newCategoryId INTEGER

AS

BEGIN	

	DECLARE @oldCategoryId INTEGER=0

	SET @oldCategoryId = (SELECT categoryId FROM UMPermissions where id=@permissionId)

	If(@newCategoryId=@oldCategoryId)

		RETURN

	DECLARE  @permisisonRoleId table(roleId INTEGER , newCategoryExcluded INTEGER DEFAULT 0)

	DECLARE  @includedNewCategoryRole table(includedRole integer)

	DECLARE  @excludeNewCategoryRole table(excludeRole integer)

	DECLARE  @newCategoryAndParent table(categoryId integer)

	--1. get all the parent categories to which this new category belongs to 

	--should we include the newCategoryId also in this?
	INSERT INTO @newCategoryAndParent


	select categoryId FROM dbo.getAllParentsForCatOrPerm_TblScript(@newCategoryId,0)

	UNION

	SELECT @newcategoryId			--explicitly include the new category ID also 

	--2. get the role list for whom this or any parent of this new category id is excluded 

	--check for excludeCategoryId = 0 ? 
	INSERT INTO @excludeNewCategoryRole


	SELECT roleId 

	FROM UMRolesPermissions RP JOIN @newCategoryAndParent CAT on RP.categoryId=CAT.categoryId

WHERE RP.excludeCategory = 1 AND RP.hierarchyLevel = 121

	--3. get the role list that "effectively" includes the new category (without excluding any of its parent)

	--can include the category, parent category or all categories 

	--without excluding any of the parent category 
	INSERT INTO @includedNewCategoryRole


	SELECT DISTINCT roleId 

	FROM UMRolesPermissions

WHERE ((categoryId IN (SELECT categoryId FROM @newCategoryAndParent) AND hierarchyLevel = 121 AND excludeCategory = 0) OR

(hierarchyLevel = 123))

		  AND roleId NOT IN (SELECT excludeRole FROM @excludeNewCategoryRole)	  

	--4. get the role list that has this permission id selected 
	INSERT INTO @permisisonRoleId


	SELECT roleId,0

	FROM UMRolesWithPermissionsExpanded

	WHERE permissionId=@permissionId 

	--5. mark the flag for all the roles for whom the new category is excluded 

	--for them we will not insert the permission even though it was selected in the old model 

	UPDATE @permisisonRoleId

	set newCategoryExcluded=1

	WHERE  roleId in (SELECT excludeRole from @excludeNewCategoryRole)

	--6. delete the old rows that are honoring the oldCategoryId-permissionId mapping 

	--simple UPDATE on these tables would not work. Because there can be a role that had this permissionId selected explicitly

	--but the new category excluded. In this case we should not include the permission in the role after this re-ordering 

	--so let us first delete the old entries, see what are the roles (that had this permission selected already) are eligible 

	--for including this after re-ordering and then include it 

	--example: consider a hierarchy C-C'-C'' and a permission P1 (belonging to some category C1) that was explicitly included in a role R1. 

	--so UMRolesPermissions initially had a entry R1 - C1 - P1. Assume that R1 had the categoty C'' excluded. So after moving 

	--P1 to C'', we should not have R1 include P1. If we just do a UPDATE we cannot handle these kind of situations 

	DELETE FROM UMRolesPermissions WHERE categoryId=@oldCategoryId and permissionId=@permissionId

	DELETE FROM UMRolesWithPermissionsExpanded WHERE categoryId=@oldCategoryId and permissionId=@permissionId

	--7. update UMPermissions to set the category id as new Category ID 

	UPDATE UMPermissions

	SET categoryId=@newCategoryId

	WHERE id=@permissionId

	--8. we should insert this permission only for those roles (that already had this permission) that dont have any of its new parent category excluded or included 

	--If parent category is excluded, then we cannot include this permission

	--If parent category is included, then there is no need to insert this permission explicitly 	

	--dont do for hidden permission

IF EXISTS (SELECT id from UMpermissions where id=@permissionId and flags & 2 <>0)

		RETURN
	INSERT INTO UMRolesPermissions


SELECT roleId,122,@newCategoryId,@permissionId,0,0

	FROM @permisisonRoleId 

	WHERE roleId not in (select includedRole FROM @includedNewCategoryRole)

		 AND newCategoryExcluded=0

	--9. this permission is now present on all these roles 

	--those that already has this permission selected (except the ones that exclude any of the new categories)

	--those roles that contain the new category or its parent 
	INSERT INTO UMRolesWithPermissionsExpanded


	SELECT DISTINCT roleId,@newCategoryId, @permissionId FROM @permisisonRoleId where newCategoryExcluded=0 

	UNION

	SELECT DISTINCT includedRole,@newCategoryId,@permissionId FROM @includedNewCategoryRole

END

GO

IF EXISTS (SELECT * FROM sysobjects WHERE name  = 'mapNewPermissionToOldPermissionTblScript')

	DROP PROCEDURE mapNewPermissionToOldPermissionTblScript

GO

CREATE PROCEDURE mapNewPermissionToOldPermissionTblScript	

@newpermissionId INTEGER,

@oldpermissionId INTEGER

AS

BEGIN	

	--mapNewPermissionToOldPermissionTblScript

	--we should set the new permission in sync with old permission in all applicable tables 

	IF (@oldPermissionId = 0) 

		RETURN 

	DECLARE  @permissionRoleId table(roleId INTEGER, newPermissionExcluded INTEGER DEFAULT 0)

	DECLARE  @includedNewPermissionRole table(includedRole integer)

	DECLARE  @excludeNewPermissionRole table(excludeRole integer)

	DECLARE  @newCategoryAndParent table(categoryId integer)

	--1. get all the parent categories to which this new permission belongs to 	
	INSERT INTO @newCategoryAndParent


	SELECT categoryId FROM dbo.getAllParentsForCatOrPerm_Tblscript(0, @newPermissionId)

	--2. get the role list for whom any of the new permission's parent is excluded
	INSERT INTO @excludeNewPermissionRole


	SELECT roleId FROM UMRolesPermissions RP JOIN @newCategoryAndParent CAT on RP.categoryId=CAT.categoryId

WHERE RP.excludeCategory = 1 AND RP.hierarchyLevel = 121

	--3. get the role list that "effectively" includes the new permission (without excluding any of its parent)

	--can include the category, parent category or all categories 

	--without excluding any of the parent category 
	INSERT INTO @includedNewPermissionRole


	SELECT DISTINCT roleId 

	FROM UMRolesPermissions

WHERE ((categoryId IN (SELECT categoryId FROM @newCategoryAndParent) AND hierarchyLevel = 121 AND excludeCategory = 0) OR

(hierarchyLevel = 123))

		  AND roleId NOT IN (SELECT excludeRole FROM @excludeNewPermissionRole)

	--4. get the role list that has the old permission id selected 
	INSERT INTO @permissionRoleId


	SELECT roleId,0

	FROM UMRolesWithPermissionsExpanded

	WHERE permissionId=@oldPermissionId 

	--5. mark the flag for all the roles for whom the new permission's parent is excluded 

	--for them we will not insert the permission even though it was selected in the old model 

	UPDATE @permissionRoleId

	set newPermissionExcluded = 1

	WHERE  roleId in (SELECT excludeRole from @excludeNewPermissionRole)

	--6. we should insert this permission only for those roles (that already had the old permission) that dont have any of its new parent category excluded or included 

	--If parent category is excluded, then we cannot include this permission

	--If parent category is included, then there is no need to insert this permission explicitly 	

	DECLARE @newCategoryId INT = (SELECT categoryId FROM UMPermissions WHERE id = @newPermissionId)

IF EXISTS (SELECT id from UMpermissions where id=@newpermissionId and flags & 2 =0)

	BEGIN
		INSERT INTO UMRolesPermissions


SELECT roleId, 122, @newCategoryId, @newpermissionId, 0, 0

		FROM @permissionRoleId 

		WHERE roleId not in (select includedRole FROM @includedNewPermissionRole)

			 AND newPermissionExcluded=0

	--7. this permission is now present on all these roles 

	--those that already has the old permission selected (except the ones that exclude any of the new categories)

	--those roles that contain the new category or its parent 
		INSERT INTO UMRolesWithPermissionsExpanded


		SELECT DISTINCT roleId,@newCategoryId, @newpermissionId FROM @permissionRoleId where newPermissionExcluded=0 

		UNION

		SELECT DISTINCT includedRole,@newCategoryId,@newpermissionId FROM @includedNewPermissionRole

	END

	--8. All the security associations that had the old permission should be duplicated with this new permission 
	INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId)


		SELECT roleId, @newPermissionId, userOrGroupId, isUser, isRoleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, 

			   entityType1, entityId1, entityType2, entityID2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, 

			   includeAll, isCreator, authorId 

		FROM UMSecurityAssociations

		WHERE permissionId = @oldPermissionId
	INSERT INTO UMOwnerRoles  


		SELECT entityType, entityId, roleId, @newPermissionId, authorId 

		FROM UMOwnerRoles  

		WHERE permissionId = @oldPermissionId 

END

GO

IF  EXISTS (select * from sysobjects where name='deleteCategoryTblScript')

  DROP PROCEDURE deleteCategoryTblScript

GO

	CREATE PROCEDURE deleteCategoryTblScript

	@categoryId INTEGER,

	@updatePermissionTbl INTEGER =0

	AS

	BEGIN

		DECLARE @childPermissionCategory TABLE( categoryId integer,permissionId integer);

		WITH ChildCategory ( categoryId,permissionsId)

		AS

		(

			SELECT id ,0  FROM UMCategories where id=@categoryId

			UNION ALL

			SELECT id ,0 FROM UMCategories  JOIN ChildCategory ON  parentCategoryId=ChildCategory.categoryId  and parentCategoryId<>0 	

		)
		INSERT INTO @childPermissionCategory


		SELECT * FROM ChildCategory

		UNION

		SELECT UMPermissions.categoryId ,UMPermissions.id FROM UMPermissions JOIN ChildCategory ON ChildCategory.categoryId=UMPermissions.categoryId;

		DELETE RPE

		FROM  UMRolesWithPermissionsExpanded  RPE 

		JOIN @childPermissionCategory  child ON  child.categoryId=RPE.categoryId

		DELETE RP

		FROM UMRolesPermissions RP

JOIN @childPermissionCategory child ON (hierarchyLevel =121 AND RP.categoryId=child.categoryId)

OR(hierarchyLevel= 122 AND RP.permissionId=child.permissionId)

		DECLARE @childPermissionTbl TABLE(permissionId INTEGER)
		INSERT INTO @childPermissionTbl


		SELECT id  FROM UMPermissions P JOIN @childPermissionCategory child ON P.categoryId=child.categoryId

		IF(@updatePermissionTbl=1)

		BEGIN	

			UPDATE P

			set categoryId=0

			FROM UMPermissions P where id in (SELECT permissionId FROM @childPermissionTbl)

		END

		ELSE

		BEGIN

			DELETE FROM UMSecurityAssociations WHERE permissionId in (SELECT permissionId FROM @childPermissionTbl)

			DELETE FROM UMOwnerRoles WHERE permissionId in (SELECT permissionId FROM @childPermissionTbl)

			DELETE FROM UMRolesWithPermissionsExpanded WHERE permissionId in (SELECT permissionId FROM @childPermissionTbl)

			DELETE P

			FROM UMPermissions P where id in (SELECT permissionId FROM @childPermissionTbl)

		END

		DELETE C

		FROM UMCategories C JOIN @childPermissionCategory child ON C.id=child.categoryId

	END

GO

IF EXISTS (select * from sysobjects where name='ReOrderPermissionScriptonFlagChange')

    DROP PROCEDURE ReOrderPermissionScriptonFlagChange

GO

CREATE PROCEDURE ReOrderPermissionScriptonFlagChange

@permissionId INTEGER,

@newFlags integer,

@oldFlags integer

AS

BEGIN

	--Permission change from non hidden to hiden

	--SO now just delete it from existing roles.

IF(@newFlags&2<>0 and @oldFlags&2=0)

	 BEGIN

		DELETE FROM UMRolesPermissions where permissionId=@permissionId

		DELETE FROM UMRolesWithPermissionsExpanded where permissionID=@permissionId

		RETURN

	 END

	 --permission  change from hidden to non hidden.

	 --so now we should insert it where category is selected or all permission is selected

IF(@newFlags&2=0 and @oldFlags&2<>0)

	 BEGIN

		EXEC expandRolePermissionOnNewNewPermissionTblScript @permissionId

	END

END

SET QUOTED_IDENTIFIER OFF       

GO

--UM_PERMISSIONS_HIDDEN_PERMISSION| UM_PERMISSIONS_NO_ASSOCIATION

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=0) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(0,0,'Dummy',0,0) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 0 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 0, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=0) 
				IF(@oldcategoryId<>0) 
				BEGIN 
					EXEC ReOrderPermissionScript 0,0 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=0)
				UPDATE UMPermissions 
				SET permissionName='Dummy',	flags=0,messageId=0 
				WHERE id=0 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 0,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=101) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(101,14,'Add, delete and modify a user',0,(2403 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 101 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 101, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=101) 
				IF(@oldcategoryId<>14) 
				BEGIN 
					EXEC ReOrderPermissionScript 101,14 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=101)
				UPDATE UMPermissions 
				SET permissionName='Add, delete and modify a user',	flags=0,messageId=(2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=101 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 101,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=102) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(102,14,'Add, delete and modify a user group',0,(2404 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 102 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 102, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=102) 
				IF(@oldcategoryId<>14) 
				BEGIN 
					EXEC ReOrderPermissionScript 102,14 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=102)
				UPDATE UMPermissions 
				SET permissionName='Add, delete and modify a user group',	flags=0,messageId=(2404 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=102 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 102,0,@oldFlags 
			END 
	GO

EXEC deletePermissionScript 104 
		GO

EXEC deletePermissionScript 105 
		GO

EXEC deletePermissionScript 106 
		GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=107) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(107,107,'Change security settings',0,(2406 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 107 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 107, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=107) 
				IF(@oldcategoryId<>107) 
				BEGIN 
					EXEC ReOrderPermissionScript 107,107 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=107)
				UPDATE UMPermissions 
				SET permissionName='Change security settings',	flags=0,messageId=(2406 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=107 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 107,0,@oldFlags 
			END 
	GO

EXEC deletePermissionScript 108 
		GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=2) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(2,102,'Agent Management',0,(970 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 2 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 2, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=2) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 2,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=2)
				UPDATE UMPermissions 
				SET permissionName='Agent Management',	flags=0,messageId=(970 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=2 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 2,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=3) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(3,102,'Agent Scheduling',0,(971 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 3 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 3, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=3) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 3,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=3)
				UPDATE UMPermissions 
				SET permissionName='Agent Scheduling',	flags=0,messageId=(971 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=3 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 3,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=12) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(12,102,'Data Protection Operations',0,(975 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 12 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 12, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=12) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 12,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=12)
				UPDATE UMPermissions 
				SET permissionName='Data Protection Operations',	flags=0,messageId=(975 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=12 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 12,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=20) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(20,102,'In Place Recover',0,(976 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 20 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 20, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=20) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 20,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=20)
				UPDATE UMPermissions 
				SET permissionName='In Place Recover',	flags=0,messageId=(976 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=20 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 20,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=22) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(22,102,'Out of Place Recover',0,(977 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 22 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 22, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=22) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 22,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=22)
				UPDATE UMPermissions 
				SET permissionName='Out of Place Recover',	flags=0,messageId=(977 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=22 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 22,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=13) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(13,102,'Browse',0,(978 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 13 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 13, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=13) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 13,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=13)
				UPDATE UMPermissions 
				SET permissionName='Browse',	flags=0,messageId=(978 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=13 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 13,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=24) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(24,102,'EndUser Access',0,(1137 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 24 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 24, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=24) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 24,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=24)
				UPDATE UMPermissions 
				SET permissionName='EndUser Access',	flags=0,messageId=(1137 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=24 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 24,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=25) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(25,102,'Compliance Search',0,(1138 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 25 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 25, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=25) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 25,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=25)
				UPDATE UMPermissions 
				SET permissionName='Compliance Search',	flags=0,messageId=(1138 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=25 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 25,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=27) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(27,102,'Tag Management',0,(1335 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 27 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 27, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=27) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 27,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=27)
				UPDATE UMPermissions 
				SET permissionName='Tag Management',	flags=0,messageId=(1335 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=27 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 27,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=29) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(29,102,'Legal Hold Management',0,(1337 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 29 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 29, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=29) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 29,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=29)
				UPDATE UMPermissions 
				SET permissionName='Legal Hold Management',	flags=0,messageId=(1337 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=29 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 29,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=32) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(32,102,'Annotation Management',0,(1366 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 32 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 32, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=32) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 32,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=32)
				UPDATE UMPermissions 
				SET permissionName='Annotation Management',	flags=0,messageId=(1366 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=32 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 32,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=36) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(36,102,'Recover and Download',0,(1711 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 36 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 36, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=36) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 36,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=36)
				UPDATE UMPermissions 
				SET permissionName='Recover and Download',	flags=0,messageId=(1711 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=36 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 36,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=5) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(5,102,'Upload',0,(2149 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 5 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 5, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=5) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 5,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=5)
				UPDATE UMPermissions 
				SET permissionName='Upload',	flags=0,messageId=(2149 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=5 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 5,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=6) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(6,102,'Download',0,(2150 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 6 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 6, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=6) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 6,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=6)
				UPDATE UMPermissions 
				SET permissionName='Download',	flags=0,messageId=(2150 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=6 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 6,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=38) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(38,102,'Live Browse',0,(2151 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 38 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 38, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=38) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 38,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=38)
				UPDATE UMPermissions 
				SET permissionName='Live Browse',	flags=0,messageId=(2151 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=38 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 38,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=39) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(39,102,'Full Machine Recovery',0,(2152 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 39 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 39, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=39) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 39,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=39)
				UPDATE UMPermissions 
				SET permissionName='Full Machine Recovery',	flags=0,messageId=(2152 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=39 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 39,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=40) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(40,102,'Sharing',0,(2153 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 40 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 40, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=40) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 40,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=40)
				UPDATE UMPermissions 
				SET permissionName='Sharing',	flags=0,messageId=(2153 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=40 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 40,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=42) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(42,102,'Out of Place Full Machine Recovery',0,(2324 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 42 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 42, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=42) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 42,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=42)
				UPDATE UMPermissions 
				SET permissionName='Out of Place Full Machine Recovery',	flags=0,messageId=(2324 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=42 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 42,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=7) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(7,102,'Install Package/Update ',0,(2492 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 7 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 7, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=7) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 7,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=7)
				UPDATE UMPermissions 
				SET permissionName='Install Package/Update ',	flags=0,messageId=(2492 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=7 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 7,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=253) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(253,102,'Delete Client',0,(3960 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (2 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 253 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 253, 2 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=253) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 253,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=253)
				UPDATE UMPermissions 
				SET permissionName='Delete Client',	flags=0,messageId=(3960 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=253 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 253,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=141) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(141,102,'Change Content',0,(2794 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 141 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 141, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=141) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 141,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=141)
				UPDATE UMPermissions 
				SET permissionName='Change Content',	flags=0,messageId=(2794 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=141 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 141,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=262) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(262,102,'Live Recovery',2,(4668 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 262 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 262, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=262) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 262,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=262)
				UPDATE UMPermissions 
				SET permissionName='Live Recovery',	flags=2,messageId=(4668 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=262 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 262,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=16) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(16,107,'Job Management',0,(967 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 16 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 16, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=16) 
				IF(@oldcategoryId<>107) 
				BEGIN 
					EXEC ReOrderPermissionScript 16,107 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=16)
				UPDATE UMPermissions 
				SET permissionName='Job Management',	flags=0,messageId=(967 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=16 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 16,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=1) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(1,107,'Administrative Management',0,(969 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 1 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 1, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=1) 
				IF(@oldcategoryId<>107) 
				BEGIN 
					EXEC ReOrderPermissionScript 1,107 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=1)
				UPDATE UMPermissions 
				SET permissionName='Administrative Management',	flags=0,messageId=(969 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=1 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 1,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=15) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(15,107,'Report Management',0,(980 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 15 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 15, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=15) 
				IF(@oldcategoryId<>107) 
				BEGIN 
					EXEC ReOrderPermissionScript 15,107 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=15)
				UPDATE UMPermissions 
				SET permissionName='Report Management',	flags=0,messageId=(980 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=15 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 15,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=18) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(18,107,'Alert Management',0,(981 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 18 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 18, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=18) 
				IF(@oldcategoryId<>107) 
				BEGIN 
					EXEC ReOrderPermissionScript 18,107 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=18)
				UPDATE UMPermissions 
				SET permissionName='Alert Management',	flags=0,messageId=(981 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=18 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 18,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=31) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(31,107,'View',0,(1136 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 31 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 31, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=31) 
				IF(@oldcategoryId<>107) 
				BEGIN 
					EXEC ReOrderPermissionScript 31,107 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=31)
				UPDATE UMPermissions 
				SET permissionName='View',	flags=0,messageId=(1136 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=31 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 31,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=264) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(264,107,'Collect Diagnostics',0,(4695 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 264 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 264, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=264) 
				IF(@oldcategoryId<>107) 
				BEGIN 
					EXEC ReOrderPermissionScript 264,107 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=264)
				UPDATE UMPermissions 
				SET permissionName='Collect Diagnostics',	flags=0,messageId=(4695 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=264 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 264,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=9) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(9,101,'License Management',0,(974 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 9 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 9, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=9) 
				IF(@oldcategoryId<>101) 
				BEGIN 
					EXEC ReOrderPermissionScript 9,101 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=9)
				UPDATE UMPermissions 
				SET permissionName='License Management',	flags=0,messageId=(974 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=9 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 9,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=41) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(41,101,'Download Center Management',0,(2236 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 41 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 41, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=41) 
				IF(@oldcategoryId<>101) 
				BEGIN 
					EXEC ReOrderPermissionScript 41,101 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=41)
				UPDATE UMPermissions 
				SET permissionName='Download Center Management',	flags=0,messageId=(2236 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=41 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 41,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=8) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(8,104,'Library Management',0,(973 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 8 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 8, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=8) 
				IF(@oldcategoryId<>104) 
				BEGIN 
					EXEC ReOrderPermissionScript 8,104 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=8)
				UPDATE UMPermissions 
				SET permissionName='Library Management',	flags=0,messageId=(973 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=8 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 8,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=11) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(11,104,'Library Administration',0,(1261 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 11 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 11, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=11) 
				IF(@oldcategoryId<>104) 
				BEGIN 
					EXEC ReOrderPermissionScript 11,104 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=11)
				UPDATE UMPermissions 
				SET permissionName='Library Administration',	flags=0,messageId=(1261 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=11 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 11,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=10) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(10,104,'MediaAgent Management',0,(968 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 10 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 10, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=10) 
				IF(@oldcategoryId<>104) 
				BEGIN 
					EXEC ReOrderPermissionScript 10,104 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=10)
				UPDATE UMPermissions 
				SET permissionName='MediaAgent Management',	flags=0,messageId=(968 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=10 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 10,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=26) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(26,104,'VaultTracker Operations',0,(1178 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 26 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 26, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=26) 
				IF(@oldcategoryId<>104) 
				BEGIN 
					EXEC ReOrderPermissionScript 26,104 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=26)
				UPDATE UMPermissions 
				SET permissionName='VaultTracker Operations',	flags=0,messageId=(1178 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=26 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 26,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=33) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(33,103,'Execute',0,(1339 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 33 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 33, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=33) 
				IF(@oldcategoryId<>103) 
				BEGIN 
					EXEC ReOrderPermissionScript 33,103 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=33)
				UPDATE UMPermissions 
				SET permissionName='Execute',	flags=0,messageId=(1339 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=33 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 33,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=34) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(34,103,'Add/Append',0,(1340 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 34 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 34, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=34) 
				IF(@oldcategoryId<>103) 
				BEGIN 
					EXEC ReOrderPermissionScript 34,103 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=34)
				UPDATE UMPermissions 
				SET permissionName='Add/Append',	flags=0,messageId=(1340 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=34 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 34,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=35) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(35,103,'Delete',0,(1341 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 35 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 35, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=35) 
				IF(@oldcategoryId<>103) 
				BEGIN 
					EXEC ReOrderPermissionScript 35,103 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=35)
				UPDATE UMPermissions 
				SET permissionName='Delete',	flags=0,messageId=(1341 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=35 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 35,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=65) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(65,101,'Install client',1,(2491 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (7 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 65 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 65, 7 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=65) 
				IF(@oldcategoryId<>101) 
				BEGIN 
					EXEC ReOrderPermissionScript 65,101 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=65)
				UPDATE UMPermissions 
				SET permissionName='Install client',	flags=1,messageId=(2491 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=65 
				IF(@oldFlags<>1)			
					EXEC ReOrderPermissionScriptonFlagChange 65,1,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=109) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(109,105,'Edit Monitoring Policy',0,(2484 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (34 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 109 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 109, 34 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=109) 
				IF(@oldcategoryId<>105) 
				BEGIN 
					EXEC ReOrderPermissionScript 109,105 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=109)
				UPDATE UMPermissions 
				SET permissionName='Edit Monitoring Policy',	flags=0,messageId=(2484 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=109 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 109,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=110) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(110,105,'Execute Monitoring Policy',0,(2485 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (33 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 110 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 110, 33 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=110) 
				IF(@oldcategoryId<>105) 
				BEGIN 
					EXEC ReOrderPermissionScript 110,105 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=110)
				UPDATE UMPermissions 
				SET permissionName='Execute Monitoring Policy',	flags=0,messageId=(2485 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=110 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 110,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=111) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(111,105,'Delete Monitoring Policy',0,(2486 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (35 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 111 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 111, 35 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=111) 
				IF(@oldcategoryId<>105) 
				BEGIN 
					EXEC ReOrderPermissionScript 111,105 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=111)
				UPDATE UMPermissions 
				SET permissionName='Delete Monitoring Policy',	flags=0,messageId=(2486 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=111 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 111,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=216) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(216,105,'Search Share',0,(3200 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 216 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 216, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=216) 
				IF(@oldcategoryId<>105) 
				BEGIN 
					EXEC ReOrderPermissionScript 216,105 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=216)
				UPDATE UMPermissions 
				SET permissionName='Search Share',	flags=0,messageId=(3200 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=216 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 216,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=133) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(133,106,'Create Workflow',4,(2584 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 133 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 133, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=133) 
				IF(@oldcategoryId<>106) 
				BEGIN 
					EXEC ReOrderPermissionScript 133,106 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=133)
				UPDATE UMPermissions 
				SET permissionName='Create Workflow',	flags=4,messageId=(2584 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=133 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 133,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=112) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(112,106,'Edit Workflow',0,(2487 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (34 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 112 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 112, 34 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=112) 
				IF(@oldcategoryId<>106) 
				BEGIN 
					EXEC ReOrderPermissionScript 112,106 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=112)
				UPDATE UMPermissions 
				SET permissionName='Edit Workflow',	flags=0,messageId=(2487 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=112 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 112,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=113) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(113,106,'Execute Workflow',0,(2488 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (33 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 113 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 113, 33 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=113) 
				IF(@oldcategoryId<>106) 
				BEGIN 
					EXEC ReOrderPermissionScript 113,106 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=113)
				UPDATE UMPermissions 
				SET permissionName='Execute Workflow',	flags=0,messageId=(2488 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=113 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 113,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=114) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(114,106,'Delete Workflow',0,(2489 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (35 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 114 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 114, 35 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=114) 
				IF(@oldcategoryId<>106) 
				BEGIN 
					EXEC ReOrderPermissionScript 114,106 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=114)
				UPDATE UMPermissions 
				SET permissionName='Delete Workflow',	flags=0,messageId=(2489 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=114 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 114,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=119) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(119,102,'Overwrite on Restore',0,(2558 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (20 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 119 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 119, 20 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=119) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 119,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=119)
				UPDATE UMPermissions 
				SET permissionName='Overwrite on Restore',	flags=0,messageId=(2558 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=119 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 119,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=121) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(121,110,'Add Datasource',4,(2572 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 121 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 121, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=121) 
				IF(@oldcategoryId<>110) 
				BEGIN 
					EXEC ReOrderPermissionScript 121,110 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=121)
				UPDATE UMPermissions 
				SET permissionName='Add Datasource',	flags=4,messageId=(2572 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=121 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 121,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=122) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(122,110,'Edit Datasource',0,(2573 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 122 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 122, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=122) 
				IF(@oldcategoryId<>110) 
				BEGIN 
					EXEC ReOrderPermissionScript 122,110 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=122)
				UPDATE UMPermissions 
				SET permissionName='Edit Datasource',	flags=0,messageId=(2573 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=122 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 122,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=123) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(123,110,'Delete Datasource',0,(2574 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 123 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 123, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=123) 
				IF(@oldcategoryId<>110) 
				BEGIN 
					EXEC ReOrderPermissionScript 123,110 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=123)
				UPDATE UMPermissions 
				SET permissionName='Delete Datasource',	flags=0,messageId=(2574 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=123 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 123,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=124) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(124,110,'Query Datasource',0,(2575 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 124 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 124, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=124) 
				IF(@oldcategoryId<>110) 
				BEGIN 
					EXEC ReOrderPermissionScript 124,110 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=124)
				UPDATE UMPermissions 
				SET permissionName='Query Datasource',	flags=0,messageId=(2575 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=124 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 124,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=125) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(125,111,'Add DataSet',4,(2576 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 125 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 125, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=125) 
				IF(@oldcategoryId<>111) 
				BEGIN 
					EXEC ReOrderPermissionScript 125,111 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=125)
				UPDATE UMPermissions 
				SET permissionName='Add DataSet',	flags=4,messageId=(2576 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=125 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 125,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=126) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(126,111,'Edit DataSet',0,(2577 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 126 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 126, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=126) 
				IF(@oldcategoryId<>111) 
				BEGIN 
					EXEC ReOrderPermissionScript 126,111 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=126)
				UPDATE UMPermissions 
				SET permissionName='Edit DataSet',	flags=0,messageId=(2577 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=126 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 126,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=127) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(127,111,'Delete DataSet',0,(2578 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 127 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 127, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=127) 
				IF(@oldcategoryId<>111) 
				BEGIN 
					EXEC ReOrderPermissionScript 127,111 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=127)
				UPDATE UMPermissions 
				SET permissionName='Delete DataSet',	flags=0,messageId=(2578 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=127 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 127,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=128) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(128,111,'Query DataSet',0,(2579 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 128 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 128, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=128) 
				IF(@oldcategoryId<>111) 
				BEGIN 
					EXEC ReOrderPermissionScript 128,111 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=128)
				UPDATE UMPermissions 
				SET permissionName='Query DataSet',	flags=0,messageId=(2579 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=128 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 128,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=129) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(129,112,'Add Report',4,(2580 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 129 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 129, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=129) 
				IF(@oldcategoryId<>112) 
				BEGIN 
					EXEC ReOrderPermissionScript 129,112 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=129)
				UPDATE UMPermissions 
				SET permissionName='Add Report',	flags=4,messageId=(2580 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=129 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 129,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=130) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(130,112,'Edit Report',0,(2581 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 130 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 130, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=130) 
				IF(@oldcategoryId<>112) 
				BEGIN 
					EXEC ReOrderPermissionScript 130,112 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=130)
				UPDATE UMPermissions 
				SET permissionName='Edit Report',	flags=0,messageId=(2581 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=130 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 130,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=131) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(131,112,'Delete Report',0,(2582 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 131 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 131, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=131) 
				IF(@oldcategoryId<>112) 
				BEGIN 
					EXEC ReOrderPermissionScript 131,112 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=131)
				UPDATE UMPermissions 
				SET permissionName='Delete Report',	flags=0,messageId=(2582 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=131 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 131,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=132) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(132,112,'Execute Report',0,(2583 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 132 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 132, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=132) 
				IF(@oldcategoryId<>112) 
				BEGIN 
					EXEC ReOrderPermissionScript 132,112 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=132)
				UPDATE UMPermissions 
				SET permissionName='Execute Report',	flags=0,messageId=(2583 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=132 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 132,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=134) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(134,113,'File Analytics',0,(2588 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 134 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 134, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=134) 
				IF(@oldcategoryId<>113) 
				BEGIN 
					EXEC ReOrderPermissionScript 134,113 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=134)
				UPDATE UMPermissions 
				SET permissionName='File Analytics',	flags=0,messageId=(2588 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=134 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 134,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=135) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(135,113,'Email Analytics',0,(2589 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 135 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 135, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=135) 
				IF(@oldcategoryId<>113) 
				BEGIN 
					EXEC ReOrderPermissionScript 135,113 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=135)
				UPDATE UMPermissions 
				SET permissionName='Email Analytics',	flags=0,messageId=(2589 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=135 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 135,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=136) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(136,113,'Web Analytics',0,(2590 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 136 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 136, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=136) 
				IF(@oldcategoryId<>113) 
				BEGIN 
					EXEC ReOrderPermissionScript 136,113 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=136)
				UPDATE UMPermissions 
				SET permissionName='Web Analytics',	flags=0,messageId=(2590 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=136 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 136,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=137) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(137,113,'Data Connectors',0,(2591 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 137 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 137, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=137) 
				IF(@oldcategoryId<>113) 
				BEGIN 
					EXEC ReOrderPermissionScript 137,113 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=137)
				UPDATE UMPermissions 
				SET permissionName='Data Connectors',	flags=0,messageId=(2591 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=137 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 137,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=138) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(138,107,'Events Organizer',0,(2592 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 138 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 138, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=138) 
				IF(@oldcategoryId<>107) 
				BEGIN 
					EXEC ReOrderPermissionScript 138,107 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=138)
				UPDATE UMPermissions 
				SET permissionName='Events Organizer',	flags=0,messageId=(2592 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=138 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 138,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=115) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(115,108,'Create Schedule Policy',4,(2597 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 115 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 115, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=115) 
				IF(@oldcategoryId<>108) 
				BEGIN 
					EXEC ReOrderPermissionScript 115,108 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=115)
				UPDATE UMPermissions 
				SET permissionName='Create Schedule Policy',	flags=4,messageId=(2597 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=115 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 115,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=116) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(116,108,'Edit Schedule Policy',0,(2598 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 116 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 116, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=116) 
				IF(@oldcategoryId<>108) 
				BEGIN 
					EXEC ReOrderPermissionScript 116,108 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=116)
				UPDATE UMPermissions 
				SET permissionName='Edit Schedule Policy',	flags=0,messageId=(2598 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=116 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 116,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=117) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(117,108,'Delete Schedule Policy',0,(2599 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 117 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 117, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=117) 
				IF(@oldcategoryId<>108) 
				BEGIN 
					EXEC ReOrderPermissionScript 117,108 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=117)
				UPDATE UMPermissions 
				SET permissionName='Delete Schedule Policy',	flags=0,messageId=(2599 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=117 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 117,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=118) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(118,108,'Edit Schedule Policy Associations',0,(2600 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 118 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 118, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=118) 
				IF(@oldcategoryId<>108) 
				BEGIN 
					EXEC ReOrderPermissionScript 118,108 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=118)
				UPDATE UMPermissions 
				SET permissionName='Edit Schedule Policy Associations',	flags=0,messageId=(2600 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=118 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 118,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=151) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(151,117,'Create Alert',4,(2814 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 151 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 151, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=151) 
				IF(@oldcategoryId<>117) 
				BEGIN 
					EXEC ReOrderPermissionScript 151,117 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=151)
				UPDATE UMPermissions 
				SET permissionName='Create Alert',	flags=4,messageId=(2814 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=151 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 151,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=152) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(152,117,'Edit Alert',0,(2815 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 152 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 152, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=152) 
				IF(@oldcategoryId<>117) 
				BEGIN 
					EXEC ReOrderPermissionScript 152,117 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=152)
				UPDATE UMPermissions 
				SET permissionName='Edit Alert',	flags=0,messageId=(2815 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=152 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 152,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=153) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(153,117,'Delete Alert',0,(2816 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 153 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 153, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=153) 
				IF(@oldcategoryId<>117) 
				BEGIN 
					EXEC ReOrderPermissionScript 153,117 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=153)
				UPDATE UMPermissions 
				SET permissionName='Delete Alert',	flags=0,messageId=(2816 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=153 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 153,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=154) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(154,117,'Edit Alert Associations',0,(2817 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 154 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 154, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=154) 
				IF(@oldcategoryId<>117) 
				BEGIN 
					EXEC ReOrderPermissionScript 154,117 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=154)
				UPDATE UMPermissions 
				SET permissionName='Edit Alert Associations',	flags=0,messageId=(2817 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=154 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 154,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=155) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(155,117,'Add/Remove Recipients',0,(2818 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 155 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 155, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=155) 
				IF(@oldcategoryId<>117) 
				BEGIN 
					EXEC ReOrderPermissionScript 155,117 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=155)
				UPDATE UMPermissions 
				SET permissionName='Add/Remove Recipients',	flags=0,messageId=(2818 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=155 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 155,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=156) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(156,118,'Create Plan',4,(2836 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 156 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 156, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=156) 
				IF(@oldcategoryId<>118) 
				BEGIN 
					EXEC ReOrderPermissionScript 156,118 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=156)
				UPDATE UMPermissions 
				SET permissionName='Create Plan',	flags=4,messageId=(2836 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=156 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 156,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=157) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(157,118,'Edit Plan',0,(2837 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 157 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 157, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=157) 
				IF(@oldcategoryId<>118) 
				BEGIN 
					EXEC ReOrderPermissionScript 157,118 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=157)
				UPDATE UMPermissions 
				SET permissionName='Edit Plan',	flags=0,messageId=(2837 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=157 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 157,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=158) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(158,118,'Delete Plan',0,(2838 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 158 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 158, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=158) 
				IF(@oldcategoryId<>118) 
				BEGIN 
					EXEC ReOrderPermissionScript 158,118 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=158)
				UPDATE UMPermissions 
				SET permissionName='Delete Plan',	flags=0,messageId=(2838 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=158 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 158,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=159) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(159,118,'Use Plan',0,(2839 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 159 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 159, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=159) 
				IF(@oldcategoryId<>118) 
				BEGIN 
					EXEC ReOrderPermissionScript 159,118 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=159)
				UPDATE UMPermissions 
				SET permissionName='Use Plan',	flags=0,messageId=(2839 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=159 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 159,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=145) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(145,115,'Laptop',0,(2801 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 145 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 145, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=145) 
				IF(@oldcategoryId<>115) 
				BEGIN 
					EXEC ReOrderPermissionScript 145,115 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=145)
				UPDATE UMPermissions 
				SET permissionName='Laptop',	flags=0,messageId=(2801 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=145 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 145,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=146) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(146,115,'Edge Drive',0,(2802 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 146 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 146, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=146) 
				IF(@oldcategoryId<>115) 
				BEGIN 
					EXEC ReOrderPermissionScript 146,115 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=146)
				UPDATE UMPermissions 
				SET permissionName='Edge Drive',	flags=0,messageId=(2802 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=146 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 146,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=147) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(147,115,'eGovernance',0,(2803 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 147 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 147, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=147) 
				IF(@oldcategoryId<>115) 
				BEGIN 
					EXEC ReOrderPermissionScript 147,115 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=147)
				UPDATE UMPermissions 
				SET permissionName='eGovernance',	flags=0,messageId=(2803 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=147 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 147,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=148) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(148,115,'DLP',0,(2793 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 148 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 148, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=148) 
				IF(@oldcategoryId<>115) 
				BEGIN 
					EXEC ReOrderPermissionScript 148,115 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=148)
				UPDATE UMPermissions 
				SET permissionName='DLP',	flags=0,messageId=(2793 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=148 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 148,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=149) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(149,115,'eDiscovery',0,(2804 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 149 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 149, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=149) 
				IF(@oldcategoryId<>115) 
				BEGIN 
					EXEC ReOrderPermissionScript 149,115 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=149)
				UPDATE UMPermissions 
				SET permissionName='eDiscovery',	flags=0,messageId=(2804 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=149 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 149,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=150) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(150,115,'Mobile Backup',0,(2805 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 150 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 150, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=150) 
				IF(@oldcategoryId<>115) 
				BEGIN 
					EXEC ReOrderPermissionScript 150,115 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=150)
				UPDATE UMPermissions 
				SET permissionName='Mobile Backup',	flags=0,messageId=(2805 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=150 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 150,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=215) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(215,115,'Archiving',0,(3166 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 215 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 215, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=215) 
				IF(@oldcategoryId<>115) 
				BEGIN 
					EXEC ReOrderPermissionScript 215,115 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=215)
				UPDATE UMPermissions 
				SET permissionName='Archiving',	flags=0,messageId=(3166 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=215 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 215,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=139) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(139,116,'Add, delete and modify folders',0,(2792 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 139 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 139, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=139) 
				IF(@oldcategoryId<>116) 
				BEGIN 
					EXEC ReOrderPermissionScript 139,116 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=139)
				UPDATE UMPermissions 
				SET permissionName='Add, delete and modify folders',	flags=0,messageId=(2792 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=139 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 139,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=140) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(140,116,'Add, delete and modify content for DLP',0,(2793 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 140 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 140, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=140) 
				IF(@oldcategoryId<>116) 
				BEGIN 
					EXEC ReOrderPermissionScript 140,116 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=140)
				UPDATE UMPermissions 
				SET permissionName='Add, delete and modify content for DLP',	flags=0,messageId=(2793 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=140 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 140,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=142) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(142,116,'Allow privacy',0,(2795 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 142 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 142, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=142) 
				IF(@oldcategoryId<>116) 
				BEGIN 
					EXEC ReOrderPermissionScript 142,116 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=142)
				UPDATE UMPermissions 
				SET permissionName='Allow privacy',	flags=0,messageId=(2795 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=142 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 142,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=143) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(143,116,'Allow change of client names',0,(2796 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 143 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 143, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=143) 
				IF(@oldcategoryId<>116) 
				BEGIN 
					EXEC ReOrderPermissionScript 143,116 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=143)
				UPDATE UMPermissions 
				SET permissionName='Allow change of client names',	flags=0,messageId=(2796 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=143 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 143,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=160) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(160,119,'Create VM Snapshot',0,(2958 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 160 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 160, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=160) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 160,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=160)
				UPDATE UMPermissions 
				SET permissionName='Create VM Snapshot',	flags=0,messageId=(2958 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=160 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 160,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=161) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(161,119,'Delete VM Snapshot',0,(2959 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 161 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 161, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=161) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 161,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=161)
				UPDATE UMPermissions 
				SET permissionName='Delete VM Snapshot',	flags=0,messageId=(2959 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=161 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 161,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=162) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(162,119,'Revert VM Snapshot',0,(2960 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 162 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 162, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=162) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 162,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=162)
				UPDATE UMPermissions 
				SET permissionName='Revert VM Snapshot',	flags=0,messageId=(2960 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=162 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 162,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=163) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(163,119,'Edit VM',0,(2961 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 163 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 163, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=163) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 163,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=163)
				UPDATE UMPermissions 
				SET permissionName='Edit VM',	flags=0,messageId=(2961 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=163 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 163,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=164) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(164,119,'Delete VM',0,(2962 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 164 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 164, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=164) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 164,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=164)
				UPDATE UMPermissions 
				SET permissionName='Delete VM',	flags=0,messageId=(2962 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=164 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 164,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=165) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(165,119,'Renew VM',0,(2963 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 165 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 165, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=165) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 165,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=165)
				UPDATE UMPermissions 
				SET permissionName='Renew VM',	flags=0,messageId=(2963 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=165 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 165,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=166) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(166,119,'Clone VM',0,(2964 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 166 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 166, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=166) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 166,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=166)
				UPDATE UMPermissions 
				SET permissionName='Clone VM',	flags=0,messageId=(2964 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=166 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 166,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=167) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(167,119,'Power ON VM',0,(2965 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 167 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 167, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=167) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 167,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=167)
				UPDATE UMPermissions 
				SET permissionName='Power ON VM',	flags=0,messageId=(2965 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=167 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 167,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=168) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(168,119,'Power OFF VM',0,(2966 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 168 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 168, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=168) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 168,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=168)
				UPDATE UMPermissions 
				SET permissionName='Power OFF VM',	flags=0,messageId=(2966 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=168 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 168,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=169) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(169,119,'Refresh VM',0,(2967 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 169 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 169, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=169) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 169,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=169)
				UPDATE UMPermissions 
				SET permissionName='Refresh VM',	flags=0,messageId=(2967 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=169 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 169,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=263) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(263,119,'Live Mount',2,(4667 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 263 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 263, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=263) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 263,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=263)
				UPDATE UMPermissions 
				SET permissionName='Live Mount',	flags=2,messageId=(4667 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=263 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 263,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=170) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(170,102,'Run Command with System Account',0,(2977 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 170 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 170, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=170) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 170,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=170)
				UPDATE UMPermissions 
				SET permissionName='Run Command with System Account',	flags=0,messageId=(2977 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=170 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 170,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=171) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(171,102,'Run Command with User Account',0,(2978 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 171 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 171, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=171) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 171,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=171)
				UPDATE UMPermissions 
				SET permissionName='Run Command with User Account',	flags=0,messageId=(2978 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=171 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 171,0,@oldFlags 
			END 
	GO

--	This needs to be executed only once during upgrade case only.

DECLARE @currentTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeType')

AND NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTrackINg WHERE SqlScriptGUID = '3679CB6C-2F34-4395-9184-8B4A8CD16A90')	-- GUID NOT present

BEGIN

	UPDATE UMPermissions

SET flags=0x1000

WHERE id IN ( 170 , 171 )

END

IF NOT EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeType')

	BEGIN

	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTrackINg WHERE SqlScriptGUID = '3679CB6C-2F34-4395-9184-8B4A8CD16A90')	-- GUID NOT present

	BEGIN

		INSERT GXUniqueSQLScriptExecTrackINg(SqlScriptGUID,Name,Description,CreatedTime,CreatedRelId,ExpireTime,ExpireRelId)

		VALUES('3679CB6C-2F34-4395-9184-8B4A8CD16A90','UpgradeSecurityForPrePost','Upgrade Security For Pre/Post',@currentTime,16,0,18)

	END

END

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=172) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(172,120,'Administration',0,(2991 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 172 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 172, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=172) 
				IF(@oldcategoryId<>120) 
				BEGIN 
					EXEC ReOrderPermissionScript 172,120 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=172)
				UPDATE UMPermissions 
				SET permissionName='Administration',	flags=0,messageId=(2991 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=172 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 172,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=173) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(173,120,'Management',0,(2992 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 173 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 173, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=173) 
				IF(@oldcategoryId<>120) 
				BEGIN 
					EXEC ReOrderPermissionScript 173,120 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=173)
				UPDATE UMPermissions 
				SET permissionName='Management',	flags=0,messageId=(2992 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=173 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 173,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=182) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(182,120,'View Royalty Report',0,(3184 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 182 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 182, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=182) 
				IF(@oldcategoryId<>120) 
				BEGIN 
					EXEC ReOrderPermissionScript 182,120 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=182)
				UPDATE UMPermissions 
				SET permissionName='View Royalty Report',	flags=0,messageId=(3184 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=182 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 182,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=201) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(201,130,'Data Cube View',2,(1136 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 201 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 201, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=201) 
				IF(@oldcategoryId<>130) 
				BEGIN 
					EXEC ReOrderPermissionScript 201,130 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=201)
				UPDATE UMPermissions 
				SET permissionName='Data Cube View',	flags=2,messageId=(1136 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=201 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 201,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=202) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(202,130,'Data Cube Edit',2,(1340 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 202 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 202, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=202) 
				IF(@oldcategoryId<>130) 
				BEGIN 
					EXEC ReOrderPermissionScript 202,130 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=202)
				UPDATE UMPermissions 
				SET permissionName='Data Cube Edit',	flags=2,messageId=(1340 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=202 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 202,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=203) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(203,130,'Data Cube Delete',2,(1341 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 203 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 203, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=203) 
				IF(@oldcategoryId<>130) 
				BEGIN 
					EXEC ReOrderPermissionScript 203,130 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=203)
				UPDATE UMPermissions 
				SET permissionName='Data Cube Delete',	flags=2,messageId=(1341 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=203 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 203,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=204) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(204,130,'Data Cube Execute',2,(1339 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 204 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 204, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=204) 
				IF(@oldcategoryId<>130) 
				BEGIN 
					EXEC ReOrderPermissionScript 204,130 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=204)
				UPDATE UMPermissions 
				SET permissionName='Data Cube Execute',	flags=2,messageId=(1339 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=204 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 204,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=174) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(174,121,'Create Subclient Policy',4,(3019 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 174 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 174, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=174) 
				IF(@oldcategoryId<>121) 
				BEGIN 
					EXEC ReOrderPermissionScript 174,121 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=174)
				UPDATE UMPermissions 
				SET permissionName='Create Subclient Policy',	flags=4,messageId=(3019 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=174 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 174,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=175) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(175,121,'Edit Subclient Policy',0,(3021 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 175 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 175, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=175) 
				IF(@oldcategoryId<>121) 
				BEGIN 
					EXEC ReOrderPermissionScript 175,121 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=175)
				UPDATE UMPermissions 
				SET permissionName='Edit Subclient Policy',	flags=0,messageId=(3021 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=175 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 175,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=176) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(176,121,'Delete Subclient Policy',0,(3020 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 176 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 176, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=176) 
				IF(@oldcategoryId<>121) 
				BEGIN 
					EXEC ReOrderPermissionScript 176,121 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=176)
				UPDATE UMPermissions 
				SET permissionName='Delete Subclient Policy',	flags=0,messageId=(3020 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=176 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 176,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=177) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(177,121,'Edit Subclient Policy Associations',0,(3018 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 177 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 177, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=177) 
				IF(@oldcategoryId<>121) 
				BEGIN 
					EXEC ReOrderPermissionScript 177,121 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=177)
				UPDATE UMPermissions 
				SET permissionName='Edit Subclient Policy Associations',	flags=0,messageId=(3018 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=177 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 177,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=206) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(206,205,'Storage Provisioning Administrator',0,(3029 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 206 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 206, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=206) 
				IF(@oldcategoryId<>205) 
				BEGIN 
					EXEC ReOrderPermissionScript 206,205 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=206)
				UPDATE UMPermissions 
				SET permissionName='Storage Provisioning Administrator',	flags=0,messageId=(3029 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=206 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 206,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=207) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(207,205,'Storage Provisioning User',0,(3030 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 207 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 207, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=207) 
				IF(@oldcategoryId<>205) 
				BEGIN 
					EXEC ReOrderPermissionScript 207,205 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=207)
				UPDATE UMPermissions 
				SET permissionName='Storage Provisioning User',	flags=0,messageId=(3030 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=207 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 207,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=178) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(178,102,'VPN Management',0,(3095 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 178 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 178, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=178) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 178,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=178)
				UPDATE UMPermissions 
				SET permissionName='VPN Management',	flags=0,messageId=(3095 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=178 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 178,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=208) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(208,131,'Create Custom Property',0,(3104 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 208 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 208, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=208) 
				IF(@oldcategoryId<>131) 
				BEGIN 
					EXEC ReOrderPermissionScript 208,131 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=208)
				UPDATE UMPermissions 
				SET permissionName='Create Custom Property',	flags=0,messageId=(3104 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=208 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 208,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=209) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(209,131,'Update Custom Property',0,(3107 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 209 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 209, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=209) 
				IF(@oldcategoryId<>131) 
				BEGIN 
					EXEC ReOrderPermissionScript 209,131 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=209)
				UPDATE UMPermissions 
				SET permissionName='Update Custom Property',	flags=0,messageId=(3107 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=209 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 209,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=210) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(210,131,'Delete Custom Property',0,(3105 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 210 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 210, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=210) 
				IF(@oldcategoryId<>131) 
				BEGIN 
					EXEC ReOrderPermissionScript 210,131 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=210)
				UPDATE UMPermissions 
				SET permissionName='Delete Custom Property',	flags=0,messageId=(3105 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=210 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 210,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=218) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(218,133,'Use Credential',0,(3456 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 218 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 218, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=218) 
				IF(@oldcategoryId<>133) 
				BEGIN 
					EXEC ReOrderPermissionScript 218,133 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=218)
				UPDATE UMPermissions 
				SET permissionName='Use Credential',	flags=0,messageId=(3456 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=218 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 218,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=220) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(220,133,'Modify Credential Account',0,(3499 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 220 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 220, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=220) 
				IF(@oldcategoryId<>133) 
				BEGIN 
					EXEC ReOrderPermissionScript 220,133 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=220)
				UPDATE UMPermissions 
				SET permissionName='Modify Credential Account',	flags=0,messageId=(3499 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=220 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 220,0,@oldFlags 
			END 
	GO

--CATEGORY_REGION Permissions

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=246) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(246,136,'Create Region',4,(3753 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 246 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 246, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=246) 
				IF(@oldcategoryId<>136) 
				BEGIN 
					EXEC ReOrderPermissionScript 246,136 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=246)
				UPDATE UMPermissions 
				SET permissionName='Create Region',	flags=4,messageId=(3753 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=246 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 246,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=247) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(247,136,'Edit Region',0,(3755 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 247 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 247, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=247) 
				IF(@oldcategoryId<>136) 
				BEGIN 
					EXEC ReOrderPermissionScript 247,136 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=247)
				UPDATE UMPermissions 
				SET permissionName='Edit Region',	flags=0,messageId=(3755 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=247 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 247,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=248) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(248,136,'Delete Region',0,(3754 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 248 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 248, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=248) 
				IF(@oldcategoryId<>136) 
				BEGIN 
					EXEC ReOrderPermissionScript 248,136 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=248)
				UPDATE UMPermissions 
				SET permissionName='Delete Region',	flags=0,messageId=(3754 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=248 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 248,0,@oldFlags 
			END 
	GO

declare @guidForVPN uniqueidentifier = '0F00C1D1-0BE7-4DB8-A458-33A3D5064FD5'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

-- In case of fresh install, we dont need to do upgrade security for VPN. So we insert the key into GXUniqueSQLScriptExecTrackINg here itself.  

IF NOT EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeType')

    BEGIN

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTrackINg WHERE SqlScriptGUID = @guidForVPN)    -- GUID NOT present

    BEGIN

        INSERT GXUniqueSQLScriptExecTrackINg(SqlScriptGUID,Name,Description,CreatedTime,CreatedRelId,ExpireTime,ExpireRelId)

		VALUES(@guidForVPN,'UpgradeSecurityForVPN','Upgrade Security For VPN Management',@curUtcDateTime,16,0,18)

    END

END

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=179) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(179,122,'Create Client Group',4,(3111 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 179 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 179, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=179) 
				IF(@oldcategoryId<>122) 
				BEGIN 
					EXEC ReOrderPermissionScript 179,122 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=179)
				UPDATE UMPermissions 
				SET permissionName='Create Client Group',	flags=4,messageId=(3111 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=179 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 179,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=180) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(180,122,'Delete Client Group',0,(3112 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 180 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 180, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=180) 
				IF(@oldcategoryId<>122) 
				BEGIN 
					EXEC ReOrderPermissionScript 180,122 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=180)
				UPDATE UMPermissions 
				SET permissionName='Delete Client Group',	flags=0,messageId=(3112 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=180 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 180,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=181) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(181,122,'Change Client Associations',0,(3110 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 181 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 181, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=181) 
				IF(@oldcategoryId<>122) 
				BEGIN 
					EXEC ReOrderPermissionScript 181,122 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=181)
				UPDATE UMPermissions 
				SET permissionName='Change Client Associations',	flags=0,messageId=(3110 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=181 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 181,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=219) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(219,102,'Delete Data',0,(3470 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 219 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 219, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=219) 
				IF(@oldcategoryId<>102) 
				BEGIN 
					EXEC ReOrderPermissionScript 219,102 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=219)
				UPDATE UMPermissions 
				SET permissionName='Delete Data',	flags=0,messageId=(3470 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=219 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 219,0,@oldFlags 
			END 
	GO

/*******************************************************************************

Below definitions are for EDISCOVERY project: Task creation

********************************************************************************/

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=221) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(221,220,'Create EDiscovery Task',0,(3473 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 221 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 221, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=221) 
				IF(@oldcategoryId<>220) 
				BEGIN 
					EXEC ReOrderPermissionScript 221,220 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=221)
				UPDATE UMPermissions 
				SET permissionName='Create EDiscovery Task',	flags=0,messageId=(3473 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=221 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 221,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=222) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(222,220,'Edit EDiscovery Task',0,(3475 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 222 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 222, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=222) 
				IF(@oldcategoryId<>220) 
				BEGIN 
					EXEC ReOrderPermissionScript 222,220 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=222)
				UPDATE UMPermissions 
				SET permissionName='Edit EDiscovery Task',	flags=0,messageId=(3475 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=222 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 222,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=223) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(223,220,'View EDiscovery Task',0,(3476 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 223 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 223, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=223) 
				IF(@oldcategoryId<>220) 
				BEGIN 
					EXEC ReOrderPermissionScript 223,220 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=223)
				UPDATE UMPermissions 
				SET permissionName='View EDiscovery Task',	flags=0,messageId=(3476 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=223 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 223,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=224) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(224,220,'Delete EDiscovery Task',0,(3474 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 224 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 224, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=224) 
				IF(@oldcategoryId<>220) 
				BEGIN 
					EXEC ReOrderPermissionScript 224,220 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=224)
				UPDATE UMPermissions 
				SET permissionName='Delete EDiscovery Task',	flags=0,messageId=(3474 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=224 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 224,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=4) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(4,134,'Operations on Storage Policy\Copy',0,(3481 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 4 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 4, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=4) 
				IF(@oldcategoryId<>134) 
				BEGIN 
					EXEC ReOrderPermissionScript 4,134 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=4)
				UPDATE UMPermissions 
				SET permissionName='Operations on Storage Policy\Copy',	flags=0,messageId=(3481 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=4 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 4,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=225) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(225,134,'Create Storage Policy',0,(3978 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (4 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 225 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 225, 4 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=225) 
				IF(@oldcategoryId<>134) 
				BEGIN 
					EXEC ReOrderPermissionScript 225,134 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=225)
				UPDATE UMPermissions 
				SET permissionName='Create Storage Policy',	flags=0,messageId=(3978 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=225 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 225,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=226) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(226,134,'Edit Storage Policy\Copy',0,(3480 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (4 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 226 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 226, 4 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=226) 
				IF(@oldcategoryId<>134) 
				BEGIN 
					EXEC ReOrderPermissionScript 226,134 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=226)
				UPDATE UMPermissions 
				SET permissionName='Edit Storage Policy\Copy',	flags=0,messageId=(3480 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=226 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 226,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=227) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(227,134,'Delete Storage Policy\Copy',0,(3479 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (4 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 227 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 227, 4 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=227) 
				IF(@oldcategoryId<>134) 
				BEGIN 
					EXEC ReOrderPermissionScript 227,134 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=227)
				UPDATE UMPermissions 
				SET permissionName='Delete Storage Policy\Copy',	flags=0,messageId=(3479 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=227 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 227,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=254) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(254,134,'Create Storage Policy Copy',0,(3977 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (225 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 254 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 254, 225 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=254) 
				IF(@oldcategoryId<>134) 
				BEGIN 
					EXEC ReOrderPermissionScript 254,134 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=254)
				UPDATE UMPermissions 
				SET permissionName='Create Storage Policy Copy',	flags=0,messageId=(3977 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=254 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 254,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=230) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(230,229,'Create CVApp',2,(3535 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 230 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 230, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=230) 
				IF(@oldcategoryId<>229) 
				BEGIN 
					EXEC ReOrderPermissionScript 230,229 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=230)
				UPDATE UMPermissions 
				SET permissionName='Create CVApp',	flags=2,messageId=(3535 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=230 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 230,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=231) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(231,229,'Edit CVApp',2,(3537 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 231 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 231, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=231) 
				IF(@oldcategoryId<>229) 
				BEGIN 
					EXEC ReOrderPermissionScript 231,229 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=231)
				UPDATE UMPermissions 
				SET permissionName='Edit CVApp',	flags=2,messageId=(3537 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=231 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 231,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=232) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(232,229,'Delete CVApp',2,(3536 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 232 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 232, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=232) 
				IF(@oldcategoryId<>229) 
				BEGIN 
					EXEC ReOrderPermissionScript 232,229 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=232)
				UPDATE UMPermissions 
				SET permissionName='Delete CVApp',	flags=2,messageId=(3536 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=232 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 232,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=233) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(233,229,'Execute CVApp',2,(3538 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 233 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 233, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=233) 
				IF(@oldcategoryId<>229) 
				BEGIN 
					EXEC ReOrderPermissionScript 233,229 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=233)
				UPDATE UMPermissions 
				SET permissionName='Execute CVApp',	flags=2,messageId=(3538 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=233 
				IF(@oldFlags<>2)			
					EXEC ReOrderPermissionScriptonFlagChange 233,2,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=241) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(241,135,'Create Role',4,(3708 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 241 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 241, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=241) 
				IF(@oldcategoryId<>135) 
				BEGIN 
					EXEC ReOrderPermissionScript 241,135 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=241)
				UPDATE UMPermissions 
				SET permissionName='Create Role',	flags=4,messageId=(3708 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=241 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 241,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=242) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(242,135,'Edit Role',0,(3710 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 242 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 242, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=242) 
				IF(@oldcategoryId<>135) 
				BEGIN 
					EXEC ReOrderPermissionScript 242,135 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=242)
				UPDATE UMPermissions 
				SET permissionName='Edit Role',	flags=0,messageId=(3710 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=242 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 242,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=243) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(243,135,'Delete Role',0,(3709 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 243 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 243, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=243) 
				IF(@oldcategoryId<>135) 
				BEGIN 
					EXEC ReOrderPermissionScript 243,135 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=243)
				UPDATE UMPermissions 
				SET permissionName='Delete Role',	flags=0,messageId=(3709 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=243 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 243,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=259) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(259,104,'Register Distributed Storage',0,(4633 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 259 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 259, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=259) 
				IF(@oldcategoryId<>104) 
				BEGIN 
					EXEC ReOrderPermissionScript 259,104 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=259)
				UPDATE UMPermissions 
				SET permissionName='Register Distributed Storage',	flags=0,messageId=(4633 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=259 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 259,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=260) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(260,104,'Manage Distributed Storage',0,(4632 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 260 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 260, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=260) 
				IF(@oldcategoryId<>104) 
				BEGIN 
					EXEC ReOrderPermissionScript 260,104 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=260)
				UPDATE UMPermissions 
				SET permissionName='Manage Distributed Storage',	flags=0,messageId=(4632 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=260 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 260,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=261) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(261,104,'Use Distributed Storage',0,(4641 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 261 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 261, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=261) 
				IF(@oldcategoryId<>104) 
				BEGIN 
					EXEC ReOrderPermissionScript 261,104 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=261)
				UPDATE UMPermissions 
				SET permissionName='Use Distributed Storage',	flags=0,messageId=(4641 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=261 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 261,0,@oldFlags 
			END 
	GO

/*Below are for Appstudio */

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=234) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(234,230,'Create Table',4,(3590 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 234 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 234, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=234) 
				IF(@oldcategoryId<>230) 
				BEGIN 
					EXEC ReOrderPermissionScript 234,230 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=234)
				UPDATE UMPermissions 
				SET permissionName='Create Table',	flags=4,messageId=(3590 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=234 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 234,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=235) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(235,230,'Change Table Schema',0,(3588 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 235 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 235, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=235) 
				IF(@oldcategoryId<>230) 
				BEGIN 
					EXEC ReOrderPermissionScript 235,230 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=235)
				UPDATE UMPermissions 
				SET permissionName='Change Table Schema',	flags=0,messageId=(3588 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=235 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 235,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=236) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(236,230,'Access Records',0,(3583 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 236 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 236, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=236) 
				IF(@oldcategoryId<>230) 
				BEGIN 
					EXEC ReOrderPermissionScript 236,230 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=236)
				UPDATE UMPermissions 
				SET permissionName='Access Records',	flags=0,messageId=(3583 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=236 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 236,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=237) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(237,231,'Create Application',4,(3589 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 237 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 237, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=237) 
				IF(@oldcategoryId<>231) 
				BEGIN 
					EXEC ReOrderPermissionScript 237,231 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=237)
				UPDATE UMPermissions 
				SET permissionName='Create Application',	flags=4,messageId=(3589 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=237 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 237,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=238) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(238,231,'Change Application Schema',0,(3587 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 238 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 238, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=238) 
				IF(@oldcategoryId<>231) 
				BEGIN 
					EXEC ReOrderPermissionScript 238,231 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=238)
				UPDATE UMPermissions 
				SET permissionName='Change Application Schema',	flags=0,messageId=(3587 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=238 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 238,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=239) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(239,231,'Access Application',0,(3582 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 239 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 239, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=239) 
				IF(@oldcategoryId<>231) 
				BEGIN 
					EXEC ReOrderPermissionScript 239,231 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=239)
				UPDATE UMPermissions 
				SET permissionName='Access Application',	flags=0,messageId=(3582 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=239 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 239,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=240) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(240,119,'Select VM Restore Destination Host',0,(3694 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 240 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 240, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=240) 
				IF(@oldcategoryId<>119) 
				BEGIN 
					EXEC ReOrderPermissionScript 240,119 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=240)
				UPDATE UMPermissions 
				SET permissionName='Select VM Restore Destination Host',	flags=0,messageId=(3694 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=240 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 240,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=244) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(244,104,'Array Management',0,(3750 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 244 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 244, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=244) 
				IF(@oldcategoryId<>104) 
				BEGIN 
					EXEC ReOrderPermissionScript 244,104 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=244)
				UPDATE UMPermissions 
				SET permissionName='Array Management',	flags=0,messageId=(3750 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=244 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 244,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=245) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(245,104,'Array Administration',0,(3749 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 245 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 245, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=245) 
				IF(@oldcategoryId<>104) 
				BEGIN 
					EXEC ReOrderPermissionScript 245,104 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=245)
				UPDATE UMPermissions 
				SET permissionName='Array Administration',	flags=0,messageId=(3749 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=245 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 245,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=252) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(252,107,'Use Proxy',0,(3933 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 252 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 252, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=252) 
				IF(@oldcategoryId<>107) 
				BEGIN 
					EXEC ReOrderPermissionScript 252,107 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=252)
				UPDATE UMPermissions 
				SET permissionName='Use Proxy',	flags=0,messageId=(3933 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=252 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 252,0,@oldFlags 
			END 
	GO

-- One time update to unhide permissions in Category, Features

DECLARE @unhideFeaturesPermissionGuid uniqueidentifier = 'A5815CFC-89E9-4503-AD52-297DA985112A'

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @unhideFeaturesPermissionGuid)

BEGIN

UPDATE UMPermissions SET flags = 0 WHERE categoryId=115
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


    VALUES(@unhideFeaturesPermissionGuid , 'UnHide_Permissions_Features_Category', 'UnHide Permissions in Features Category', @nowTime, 16, 0 , (16 + 2))

END

-- Reseller project: Split add,edit,delete domain into individual permissions

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=249) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(249,14,'Add Domain',4,(3767 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 249 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 249, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=249) 
				IF(@oldcategoryId<>14) 
				BEGIN 
					EXEC ReOrderPermissionScript 249,14 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=249)
				UPDATE UMPermissions 
				SET permissionName='Add Domain',	flags=4,messageId=(3767 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=249 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 249,4,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=250) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(250,14,'Edit Domain',0,(3769 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 250 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 250, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=250) 
				IF(@oldcategoryId<>14) 
				BEGIN 
					EXEC ReOrderPermissionScript 250,14 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=250)
				UPDATE UMPermissions 
				SET permissionName='Edit Domain',	flags=0,messageId=(3769 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=250 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 250,0,@oldFlags 
			END 
	GO

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=251) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(251,14,'Delete Domain',0,(3768 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (0 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 251 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 251, 0 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=251) 
				IF(@oldcategoryId<>14) 
				BEGIN 
					EXEC ReOrderPermissionScript 251,14 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=251)
				UPDATE UMPermissions 
				SET permissionName='Delete Domain',	flags=0,messageId=(3768 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=251 
				IF(@oldFlags<>0)			
					EXEC ReOrderPermissionScriptonFlagChange 251,0,@oldFlags 
			END 
	GO

-- One time upgrade script for splitting add,edit and delete domain permission into individual permissions.

-- Passing old permission Id to the macro is not working correctly for roles with old permission excluded. Fixing that would be regressive now, so let's write our own upgrade script. That is easier to test as well. 

DECLARE @splitDomainPermissionsGUID VARCHAR(128) = '873F3F3A-E667-4F5C-BB5E-48E35C3E71EF'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking (NOLOCK) WHERE SqlScriptGUID = @splitDomainPermissionsGUID)

BEGIN	

	DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

	IF OBJECT_ID('tempdb.dbo.#rolesWithDomainPermissionsIncluded') IS NOT NULL

		DROP TABLE #rolesWithDomainPermissionsIncluded

	CREATE TABLE #rolesWithDomainPermissionsIncluded			

	(

		roleID INT PRIMARY KEY

	)

	IF OBJECT_ID('tempdb.dbo.#rolesWithDomainPermissionIncludedExplicit') IS NOT NULL			-- Need these to correctly insert into UMRolesPermissions table. 

		DROP TABLE #rolesWithDomainPermissionIncludedExplicit

	CREATE TABLE #rolesWithDomainPermissionIncludedExplicit

	(

		roleId INT PRIMARY KEY

	)

	IF OBJECT_ID('tempdb.dbo.#rolesWithDomainPermissionExcludedExplicit') IS NOT NULL

		DROP TABLE #rolesWithDomainPermissionExcludedExplicit

	CREATE TABLE #rolesWithDomainPermissionExcludedExplicit

	(

		roleId INT PRIMARY KEY

	)
	INSERT INTO #rolesWithDomainPermissionsIncluded


		SELECT DISTINCT roleID 

		FROM UMRolesWithPermissionsExpanded 

		WHERE

permissionID = 103				-- 103
	INSERT INTO #rolesWithDomainPermissionIncludedExplicit


		SELECT DISTINCT roleId 

		FROM UMRolesPermissions 

		WHERE

permissionID = 103

			AND excludePermission = 0
	INSERT INTO #rolesWithDomainPermissionExcludedExplicit


		SELECT DISTINCT roleId 

		FROM UMRolesPermissions 

		WHERE

permissionID = 103

			AND excludePermission = 1
	INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


SELECT roleId, 122, 14, 249, 0, 0

		FROM #rolesWithDomainPermissionIncludedExplicit

		UNION

SELECT roleId, 122, 14, 249, 0, 1

		FROM #rolesWithDomainPermissionExcludedExplicit

		UNION

SELECT roleId, 122, 14, 250, 0, 0

		FROM #rolesWithDomainPermissionIncludedExplicit

		UNION

SELECT roleId, 122, 14, 250, 0, 1

		FROM #rolesWithDomainPermissionExcludedExplicit

		UNION

SELECT roleId, 122, 14, 251, 0, 0

		FROM #rolesWithDomainPermissionIncludedExplicit

		UNION

SELECT roleId, 122, 14, 251, 0, 1

		FROM #rolesWithDomainPermissionExcludedExplicit

		EXCEPT 

		SELECT * FROM UMRolesPermissions
	INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)


SELECT roleId, 14, 249

		FROM #rolesWithDomainPermissionsIncluded

		UNION

SELECT roleId, 14, 250

		FROM #rolesWithDomainPermissionsIncluded

		UNION

SELECT roleId, 14, 251

		FROM #rolesWithDomainPermissionsIncluded

		EXCEPT 

		SELECT * FROM UMRolesWithPermissionsExpanded
	INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId)


SELECT roleId, 249, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId

		FROM UMSecurityAssociations 

		WHERE

permissionID = 103

		UNION

SELECT roleId, 250, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId

		FROM UMSecurityAssociations 

		WHERE

permissionID = 103

		UNION

SELECT roleId, 251, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId

		FROM UMSecurityAssociations 

		WHERE

permissionID = 103

		EXCEPT

		SELECT roleId, permissionId, userOrGroupId, isUser, isRoleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId FROM UMSecurityAssociations
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


		VALUES(@splitDomainPermissionsGUID , 'SplitDomainPermissions', 'Splitting add, edit, delete Domain permission to individual permissions', @nowTime, 16, 0 , (16 + 2))

END

EXEC deletePermissionScript 103 
		GO

EXEC deletePermissionScript 217 
		GO

EXEC deletePermissionScript 256 
		GO

EXEC deletePermissionScript 257 
		GO

EXEC deletePermissionScript 258 
		GO

-- Whoever had Add Domain before SP19, give them Create Company permission also. Going forward, Create Company permission should be checked for creating a new company. 

IF NOT EXISTS(SELECT * FROM UMPermissions WHERE id=255) 
			BEGIN 
				INSERT INTO UMPermissions 					
				VALUES(255,14,'Create Company',4,(4417 | (CAST(POWER(2, 24) AS BIGINT) * 35))) 
				IF (249 = 0) 
					EXEC expandRolePermissionOnNewNewPermissionTblScript 255 
				ELSE 
					EXEC mapNewPermissionToOldPermissionTblScript 255, 249 
			END 
			ELSE 
			BEGIN 
				DECLARE @oldcategoryId INTEGER=(SELECT categoryId from UMPermissions where id=255) 
				IF(@oldcategoryId<>14) 
				BEGIN 
					EXEC ReOrderPermissionScript 255,14 
				END 
				DECLARE @oldFlags INTEGER=(SELECT flags from UMpermissions where id=255)
				UPDATE UMPermissions 
				SET permissionName='Create Company',	flags=4,messageId=(4417 | (CAST(POWER(2, 24) AS BIGINT) * 35)) 
				WHERE id=255 
				IF(@oldFlags<>4)			
					EXEC ReOrderPermissionScriptonFlagChange 255,4,@oldFlags 
			END 
	GO

/*****************************************************************

No new permissions should be added after this comment.

ADD THE NEWLY ADDED PERMISSION TO UMPermissionEntityTypeMap.script

If the permission is not needed to be mapped with any entity, set

entity type as 0. Else map it to the desired entity.

******************************************************************/

/***********************************************************

No new permissions should be added after this comment 

***********************************************************/

EXEC deleteCategoryTblScript 100 ,0  
		GO

IF EXISTS (SELECT 1 

		   FROM UMPermissions 

WHERE id > 512

		  )

BEGIN

	RAISERROR('Maximum permission Ids limit reached. Please contact Security team to increase the limit.',

			16,

			1)

END

