

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMOperatorGroup.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

--  +==============================================================================+

--  |		Name: UMOperatorGroup

--	|			  Adding it as a separate script at the last of all UM scripts 

--	|			  to avoid all the Foreign Key constraints. 

--  |		Author: jswaminathan

--  +==============================================================================+

SET QUOTED_IDENTIFIER ON 

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @tenantOperatorGroupCreateGUID VARCHAR(128) = '571D91C9-1D7D-490F-8EA5-09464FD6127C'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @tenantOperatorGroupCreateGUID)

BEGIN

    BEGIN TRY

        -- Need to create role also here. Since UMRoles.script is placed after UMGroups.script in the .lst file. (Don't want to change the order now since UMRoles is doing something based on UMGroupsProp).

        -- Also it is better to create all the items related to the Tenant Operator project in one place. 

        DECLARE @tenantOperatorRole INT = 0

        BEGIN

IF NOT EXISTS (SELECT 1 FROM UMRoles WHERE flags & 512 <> 0)

            BEGIN   

DECLARE @tenantOperatorRoleName VARCHAR(1024) = 'Tenant Operator'

                IF EXISTS (SELECT 1 FROM UMRoles WHERE name = @tenantOperatorRoleName)

                        SET @tenantOperatorRoleName = @tenantOperatorRoleName + CAST(NEWID() AS VARCHAR(512))
                INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)


VALUES(2, @tenantOperatorRoleName, 'System created role for tenant operators', 0, 0, (512 | 2 | 128), 1, @nowTime, 0, NEWID(), '')

            END     

            SELECT @tenantOperatorRole = id             

            FROM UMRoles 

            WHERE

flags & 512 <> 0        -- 512

            IF (@tenantOperatorRole <> 0) AND NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole)

            BEGIN

                -- Include all permissions. 

IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 123 AND categoryId = 0 AND permissionId = 0 AND excludeCategory = 0 AND excludePermission = 0)

                BEGIN
                        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 123, 0, 0, 0, 0)

                END                 

                -- Exclude browse.

IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 13 AND excludeCategory = 0 AND excludePermission = 1)

                BEGIN
                        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 122, 102, 13, 0, 1)

                END 

                -- Exclude Restore related permissions. 

IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 20 AND excludeCategory = 0 AND excludePermission = 1)

                BEGIN
                        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 122, 102, 20, 0, 1)

                END 

IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 22 AND excludeCategory = 0 AND excludePermission = 1)

                BEGIN
                        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 122, 102, 22, 0, 1)

                END 

IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 38 AND excludeCategory = 0 AND excludePermission = 1)

                BEGIN
                        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 122, 102, 38, 0, 1)

                END 

IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 36 AND excludeCategory = 0 AND excludePermission = 1)

                BEGIN
                        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 122, 102, 36, 0, 1)

                END 

IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 42 AND excludeCategory = 0 AND excludePermission = 1)

                BEGIN
                        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 122, 102, 42, 0, 1)

                END 

IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 39 AND excludeCategory = 0 AND excludePermission = 1)

                BEGIN
                        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 122, 102, 39, 0, 1)

                END 

IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 119 AND excludeCategory = 0 AND excludePermission = 1)

                BEGIN
                        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 122, 102, 119, 0, 1)

                END 

				-- Exclude EV_FAST_COMPLIANCE_SEARCH (Compliance search) permission.

If NOT EXISTS (SELECT 1 FROM UMRolesPermissions (NOLOCK) WHERE roleId = @tenantOperatorRole AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 25 AND excludeCategory = 0 AND excludePermission = 1)

				BEGIN
						INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRole, 122, 102, 25, 0, 1)

				END

            END

            IF (@tenantOperatorRole <> 0) AND NOT EXISTS (SELECT 1 FROM UMRolesWithPermissionsExpanded WHERE roleId = @tenantOperatorRole)

            BEGIN   
                INSERT INTO UMRolesWithPermissionsExpanded


                    SELECT @tenantOperatorRole, categoryId, id

                    FROM UMPermissions

                    WHERE id <> 0 

AND flags & 2 = 0

                          AND id NOT IN (                                           

13

,20

,22

,38

,36

,42

,39

,119

,25

                                        )       

                    EXCEPT

                    SELECT roleId, categoryId, permissionId

                    FROM UMRolesWithPermissionsExpanded

                    WHERE roleId = @tenantOperatorRole

            END

        END

        -- Associate this tenant opeator role with all the existing companies.
        INSERT INTO APP_CompanyProp (componentNameId, attrName, attrType, attrVal, created, modified)


SELECT P.id, 'Operator Role', 7, CAST(@tenantOperatorRole AS VARCHAR(MAX)), @nowTime, 0

            FROM UMDSProviders P (NOLOCK)

                LEFT JOIN APP_CompanyProp CP(NOLOCK)

                    ON P.id = CP.componentNameId 

AND CP.attrName = 'Operator Role'

            WHERE

P.serviceType = 5

                AND CP.attrVal IS NULL

        -- Create Tenant Operator user group for the companies that do not have it. 
        INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)


SELECT (CAST(0x40000 AS INT) | CAST(0x0001 AS INT)), 0, 0, 1, 'Tenant Operator', '', 2, NEWID(), P.id, '', 0

            FROM UMDSProviders P

                LEFT JOIN UMGroups G

ON P.id = G.umdsProviderID AND (G.groupFlags & 0x40000 <> 0)

            WHERE

serviceType = 5

                AND G.id IS NULL

        -- Associate tenant operator user group with tenant operator role on the company + create client group on commcell.  

        IF @tenantOperatorRole <> 0
            INSERT INTO UMSecurityAssociations (isUser, userOrGroupId, entityType1, entityId1, roleId, permissionId, authorId)


SELECT 0, G.id, 61, G.umdsProviderId, @tenantOperatorRole, 0, 1

                FROM UMGroups G 

                    LEFT JOIN UMSecurityAssociations Sec 

                        ON Sec.isUser = 0 AND Sec.userOrGroupId = G.id 

AND Sec.entityType1 = 61 AND Sec.entityId1 = G.umdsProviderId

                            AND Sec.roleID = @tenantOperatorRole

                WHERE

(G.groupFlags & 0x40000 <> 0)

                    AND Sec.userOrGroupId IS NULL

                UNION

SELECT 0, G.id, 1, 2, 0, 179, 1

                FROM UMGroups G 

                    LEFT JOIN UMSecurityAssociations Sec 

                        ON Sec.isUser = 0 AND Sec.userOrGroupId = G.id  

AND Sec.entityType1 = 1 AND Sec.entityId1 = 2

AND Sec.permissionId = 179

                WHERE

(G.groupFlags & 0x40000 <> 0)

                    AND Sec.userOrGroupId IS NULL

                UNION

SELECT 0, G.id, 1, 2, 0, 151, 1

                FROM UMGroups G 

                    LEFT JOIN UMSecurityAssociations Sec 

                        ON Sec.isUser = 0 AND Sec.userOrGroupId = G.id  

AND Sec.entityType1 = 1 AND Sec.entityId1 = 2

AND Sec.permissionId = 151

                WHERE

(G.groupFlags & 0x40000 <> 0)

                    AND Sec.userOrGroupId IS NULL

                UNION

SELECT 0, G.id, 1, 2, 0, 115, 1

                FROM UMGroups G 

                    LEFT JOIN UMSecurityAssociations Sec 

                        ON Sec.isUser = 0 AND Sec.userOrGroupId = G.id  

AND Sec.entityType1 = 1 AND Sec.entityId1 = 2

AND Sec.permissionId = 115

                WHERE

(G.groupFlags & 0x40000 <> 0)

                    AND Sec.userOrGroupId IS NULL                           
        INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@tenantOperatorGroupCreateGUID, 'Tenant Operator role and group', 'Creation of tenant operator role and group', @nowTime, 16, 0 , (16 + 2))

    END TRY

    BEGIN CATCH

        PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    END CATCH

END

-- For existing setups, set Add Domain for tenant admin and tenant operator groups. 

DECLARE @tenantAdminAddDomainGUID VARCHAR(128) = '01937394-00DB-4BC2-880B-821C96596FF4'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @tenantAdminAddDomainGUID)

BEGIN

	BEGIN TRY
		INSERT INTO UMSecurityAssociations (isUser, userOrGroupId, roleId, permissionId, entityType1, entityId1, authorId)


SELECT 0, G.id, 0, 249, 1, 2, 1

			FROM UMGroups G(NOLOCK)

			WHERE

				(

(G.groupFlags & 0x10000 <> 0)

OR (G.groupFlags & 0x40000 <> 0)

				)

				AND NOT EXISTS 

				(

					SELECT 1

					FROM UMSecurityAssociations (NOLOCK)

					WHERE

						isUser = 0

						AND userOrGroupId = G.id

AND permissionId = 249

AND entityType1 = 1

						AND entityId1 = 2

				)
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@tenantAdminAddDomainGUID, 'Tenant Admin Add Domain', 'Give tenant admin add domain permission', @nowTime, 16, 0 , (16 + 2))

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	END CATCH

END

-- Upgrade script to migrate operators from existing Company properties table into Operators table.

DECLARE @migrateOperatorsGUID VARCHAR(128) = '86E748CB-E8B3-44A5-B6F4-EB8234CB174A'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @migrateOperatorsGUID)

BEGIN

	BEGIN TRY

		-- Get operator role for each company. (Not all might use the Global tenant operator role).

		IF OBJECT_ID('tempdb.dbo.#operatorRoles') IS NOT NULL

			DROP TABLE #operatorRoles 

		CREATE TABLE #operatorRoles 

		(

			companyId INT,

			roleId INT,

			UNIQUE CLUSTERED (companyId, roleId)

		);
		INSERT INTO #operatorRoles 


			SELECT DISTINCT componentNameId, CAST(attrVal AS INT) 

			FROM App_CompanyProp (NOLOCK)

			WHERE

attrName = 'Operator Role'				-- 'Operator Role'

				AND modified = 0

		IF OBJECT_ID('temp.dbo.#operatorsTempTbl') IS NOT NULL

			DROP TABLE #operatorsTempTbl 

		CREATE TABLE #operatorsTempTbl 

		(

			isUser INT,

			userOrGroupId INT,

			roleId INT,

			companyId INT,

			PRIMARY KEY (isUser, userOrGroupId, roleId, companyId)

		);
		INSERT INTO #operatorsTempTbl (isUser, userOrGroupId, roleId, companyId)


SELECT CASE WHEN Operators.attrName = 'Operator User Id' THEN 1 ELSE 0 END,

					CAST(Operators.attrVal AS INT),

					OperatorRoles.roleId,

					componentNameId			

			FROM APP_CompanyProp Operators(NOLOCK)		

				INNER JOIN #operatorRoles OperatorRoles (NOLOCK)

					ON Operators.componentNameId = OperatorRoles.companyId 

AND (Operators.attrName = 'Operator User Id' OR Operators.attrName = 'Operator User Group Id')				--  'Operator User Id'/ 'Operator User Group Id'

					AND Operators.modified = 0

			UNION

			SELECT 0, G.id, ORoles.roleId, ORoles.companyId			-- Make an entry for tenant operator group of existing companies with their operator role in Operators table. 

			FROM UMGroups G (NOLOCK) 

				INNER JOIN #operatorRoles ORoles (NOLOCK) 

					ON G.umdsProviderId = ORoles.companyId 

			WHERE

G.groupFlags & 0x40000 <> 0
		INSERT INTO UMOperators (companyId, isUser, userOrGroupId, roleId, flags) 


			SELECT O.companyId, O.isUser, O.userOrGroupId, O.roleId, 0

			FROM #operatorsTempTbl O

				LEFT JOIN UMOperators O1 

					ON O.isUser = O1.isUser 

					AND O.userOrGroupId = O1.userOrGroupId 

					AND O.roleId = O1.roleId 

					AND O.companyId = O1.companyId 

			WHERE

				O1.isUser IS NULL			-- Insert only those entries not already present in the table. 
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@migrateOperatorsGUID, 'MigrateOperatorsIntoUMOperators', 'Moves operator data from Company properties table into Operators table', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

	END	TRY

	BEGIN CATCH

			PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

			ERROR MESSAGE: ' + ERROR_MESSAGE() + '

			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	END CATCH

END

-- Tenant Operator role needs to be a public role. So that all tenant admins can see this role. 

-- The above Insert query correctly sets it as public. But Upgrade Security For Roles stored procedure was buggily setting it as private. 

-- Fixed that code in the stored procedure, this is just for existing setups. 

IF EXISTS (SELECT TOP 1 1 FROM UMRoles WHERE flags & 512 <> 0 AND isPrivate = 1)

BEGIN

	UPDATE UMRoles 

	SET isPrivate = 0						-- Tenant Operator role needs to be a public role. So that all tenant admins and operators can see this role. 

	WHERE

flags & 512 <> 0

END

-- CMR 269636: For existing companies (before SP13), security associations from tenant admins were not copied into tenant operators. 

-- The stored procedure changes done on Populate Security Associations, works only for the security associations going forward. 

-- This script is to copy the existing explicit security associations from tenant admin (like plan, etc.). to tenant operators. 

DECLARE @copySecurityAssocToTenantOperatorsGUID VARCHAR(1024) = '4876E587-8A57-4CA5-A788-EEC925B5147C'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @copySecurityAssocToTenantOperatorsGUID)

BEGIN

	BEGIN TRY	

		IF OBJECT_ID('tempdb.dbo.#tenantGroupsTbl') IS NOT NULL

			DROP TABLE #tenantGroupsTbl

		CREATE TABLE #tenantGroupsTbl

		(

			companyId INT PRIMARY KEY,

			tenantAdminId INT,

			tenantOperatorGroupId INT

		)
		INSERT INTO #tenantGroupsTbl (companyId, tenantAdminId, tenantOperatorGroupId)


			SELECT DISTINCT GAdmin.umdsProviderId, GAdmin.id, GOperator.id                      

			FROM UMGroups GAdmin

				INNER JOIN UMGroups GOperator 

					ON GAdmin.umdsProviderId = GOperator.umdsProviderId 

			WHERE

GAdmin.groupFlags & 0x10000 <> 0                    -- GF_GROUP_TENANT_ADMIN(0x10000)

AND GOperator.groupFlags & 0x40000 <> 0          -- GF_GROUP_TENANT_OPERATOR(0x40000)
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, isCreator, authorId)


			SELECT TAdmin.roleId, TAdmin.permissionId, 

					T1.tenantOperatorGroupId, 0, 

					TAdmin.entityType1, TAdmin.entityId1,  

					TAdmin.entityType2, TAdmin.entityId2, 

					TAdmin.entityType3, TAdmin.entityId3, 

					TAdmin.entityType4, TAdmin.entityId4, 

					TAdmin.entityType5, TAdmin.entityId5, 

					TAdmin.includeAll, TAdmin.isCreator, 

					TAdmin.authorId  

			FROM UMSecurityAssociations TAdmin

				INNER JOIN #tenantGroupsTbl T1 

					ON TAdmin.isUser = 0 AND TAdmin.userOrgroupId = T1.tenantAdminId

					AND TAdmin.isCreator = 0

AND TAdmin.entityType1 NOT IN (61, 28)           -- Tenant Admin will have Tenant Admin role on his own company (entityType: 61) and the company smart client group (entityType: 28).

																	-- Tenant Operator should not get that role on these 2 entities. So skipping these 2 entity types generically for now 

																	-- (same logic is there in Populate Security Associations stored proc as well).

				LEFT JOIN UMSecurityAssociations TOperator 

					ON TOperator.isUser = 0 AND TOperator.userOrgroupId = T1.tenantOperatorGroupId

					AND TOperator.entityType1 = TAdmin.entityType1 AND TOperator.entityId1 = TAdmin.entityId1 

					AND TOperator.entityType2 = TAdmin.entityType2 AND TOperator.entityId2 = TAdmin.entityId2

					AND TOperator.entityType3 = TAdmin.entityType3 AND TOperator.entityId3 = TAdmin.entityId3 

					AND TOperator.entityType4 = TAdmin.entityType4 AND TOperator.entityId4 = TAdmin.entityId4

					AND TOperator.entityType5 = TAdmin.entityType5 AND TOperator.entityId5 = TAdmin.entityId5 

					AND TOperator.roleId = TAdmin.roleId AND TOperator.permissionId = TAdmin.permissionId 

			WHERE

				TOperator.isUser IS NULL
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@copySecurityAssocToTenantOperatorsGUID, 'CopySecurityAssocToTenantOperators', 'Copies explicit security associations from tenant admin to tenant operator', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

	END	TRY

	BEGIN CATCH

			PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

			ERROR MESSAGE: ' + ERROR_MESSAGE() + '

			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	END CATCH

END

-- By this time, both roles are created. 

DECLARE @tenantAdminRoleId INT = 0

DECLARE @tenantOperatorRoleId INT = 0

SELECT @tenantAdminRoleId = id FROM UMRoles (NOLOCK) WHERE flags & 256 <> 0

SELECT @tenantOperatorRoleId = id FROM UMRoles (NOLOCK) WHERE flags & 512 <> 0

DECLARE @fixTenantOperatorUGGUID VARCHAR(1024) = 'ED34F524-6C61-4809-88DB-AD40A4E3D4F9'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @fixTenantOperatorUGGUID)

BEGIN

	BEGIN TRY

		-- Requirement of this script: According to design, Tenant Operator UG is to be used only for these 2 reasons. 

			-- 1. To include all the impersonate User accounts. 

			-- 2. When any entity is shared with Tenant Admin, then Tenant Operators also should get the same role on that entity. 

		-- But some customers have been tampering with the Tenant Operator UG manually by,

			-- 1. Including company users into the UGs. 

			-- 2. Configuring explicit roles on the UG. 

		-- This script is to fix all such cases. 			

		-- To make the user experience almost consistent, as it was before the upgrade, we will move all manually added users out of this UG

		-- and assign the Operator & Security associations they were inheriting from this UG, directly to the Users.  			

DECLARE @tenantAdminGroupFlag INT = CAST(0x10000 AS INT)

DECLARE @tenantOperatorGroupFlag INT = CAST(0x40000 AS INT)

		IF OBJECT_ID('tempdb.dbo.#CompanyUGs') IS NOT NULL

			DROP TABLE #CompanyUGs

		CREATE TABLE #CompanyUGs

		(

			companyId INT PRIMARY KEY,			-- Ideally every company should have only one Tenant Admin & Tenant Operator UG.

			tenantAdminGroupId INT,

			tenantOperatorGroupId INT

		)
		INSERT INTO #CompanyUGs


			SELECT DISTINCT 

				G1.umdsProviderId,

				G1.id,

				G2.id

			FROM UMGroups G1 (NOLOCK)

				INNER JOIN UMGroups G2 (NOLOCK) 

					ON (G1.umdsProviderId = G2.umdsProviderId) AND ((G1.groupFlags & @tenantAdminGroupFlag) <> 0) AND ((G2.groupFlags & @tenantOperatorGroupFlag) <> 0)

		-- Step 1: Handling manually added Users and AD groups membership. 

		BEGIN

DECLARE @impersonateUserFlag INT = CAST(0x8000 AS INT)

			IF OBJECT_ID('tempdb.dbo.#tamperedTenantOperatorUG1') IS NOT NULL

				DROP TABLE #tamperedTenantOperatorUG1

			CREATE TABLE #tamperedTenantOperatorUG1

			(

				tenantOperatorGroupId INT,

				isUser INT,

				userOrGroupId INT

			)
			CREATE CLUSTERED INDEX tamperedTenantOperatorUG1_Idx1 ON #tamperedTenantOperatorUG1 (tenantOperatorGroupId, isUser, userOrGroupId)			INSERT INTO #tamperedTenantOperatorUG1


				SELECT 

					CG.tenantOperatorGroupId,

					1,

					UG.userId

				FROM UMUserGroup UG(NOLOCK)

					INNER JOIN #CompanyUGs CG 

						ON UG.groupId = CG.tenantOperatorGroupId

					INNER JOIN UMUsers U (NOLOCK)

						ON (U.id = UG.userId) AND ((U.flags & 1) <> 0) AND ((U.flags & @impersonateUserFlag) = 0)		-- Tenant Operator UG contains users other than Impersonate users. They are trouble !!!

				UNION 

				SELECT 

					CG.tenantOperatorGroupId,

					0,

					UG.umdsGroupId

				FROM UMDSGroupMaps UG (NOLOCK)

					INNER JOIN #CompanyUGs CG 

						ON UG.umGroupId = CG.tenantOperatorGroupId								-- Tenant Operator UG should not even have an AD User group added. If so, trouble !!!

			-- Copy the Security associations inherited from Tenant Operator UG, directly into trouble user Ids and AD group Ids 
			INSERT INTO UMSecurityAssociations (isUser, userOrgroupId, roleId, permissionId, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, authorId)


				SELECT DISTINCT T.isUser, T.userOrGroupId, Sec.roleId, Sec.permissionId, Sec.entityType1, Sec.entityId1, Sec.entityType2, Sec.entityId2, Sec.entityType3, Sec.entityId3, Sec.entityType4, Sec.entityId4, Sec.entityType5, Sec.entityId5, Sec.includeAll, Sec.authorId

				FROM #tamperedTenantOperatorUG1 T

					INNER JOIN UMSecurityAssociations Sec (NOLOCK)

						ON Sec.isUser = 0 AND Sec.userOrgroupId = T.tenantOperatorGroupId

					LEFT OUTER JOIN UMSecurityAssociations Sec1 (NOLOCK)		-- Insert only if row not already exists.

						ON Sec1.isUser = T.isUser AND Sec1.userOrgroupId = T.userOrGroupId AND Sec1.roleId = Sec.roleId AND Sec1.permissionId = Sec.permissionId 

						AND Sec1.entityType1 = Sec.entityType1 AND Sec1.entityId1 = Sec.entityID1 AND Sec1.entityType2 = Sec.entityType2 AND Sec1.entityId2 = Sec.entityID2

						AND Sec1.entityType3 = Sec.entityType3 AND Sec1.entityId3 = Sec.entityID3 AND Sec1.entityType4 = Sec.entityType4 AND Sec1.entityId4 = Sec.entityID4

						AND Sec1.entityType5 = Sec.entityType5 AND Sec1.entityId5 = Sec.entityID5 

				WHERE 

					Sec1.isUser IS NULL	

			-- Copy the Owner associations inherited from Tenant Operator UG, directly into trouble user Ids and AD group Ids 
			INSERT INTO UMOwners (isUser, userOrgroupId, entityType, entityId, authorId)


				SELECT DISTINCT T.isUser, T.userOrGroupId, Sec.entityType, Sec.entityId, Sec.authorId

				FROM #tamperedTenantOperatorUG1 T

					INNER JOIN UMOwners Sec (NOLOCK)

						ON Sec.isUser = 0 AND Sec.userOrgroupId = T.tenantOperatorGroupId

					LEFT OUTER JOIN UMOwners Sec1 (NOLOCK)							-- Insert only if row not already exists.

						ON Sec1.isUser = T.isUser AND Sec1.userOrgroupId = T.userOrGroupId AND Sec1.entityType = Sec.entityType AND Sec1.entityId = Sec.entityID				

				WHERE 

					Sec1.isUser IS NULL	

			-- Copy the Operator associations inherited from Tenant Operator UG, directly into trouble user Ids and AD group Ids 
			INSERT INTO UMOperators (isUser, userOrGroupId, roleId, companyId, flags)


				SELECT DISTINCT T.isUser, T.userOrgroupId, Sec.roleId, Sec.companyId, Sec.flags

				FROM #tamperedTenantOperatorUG1 T

					INNER JOIN UMOperators Sec (NOLOCK)

						ON Sec.isUser = 0 AND Sec.userOrgroupId = T.tenantOperatorGroupId

					LEFT OUTER JOIN UMOperators Sec1 (NOLOCK)						-- Insert only if row not already exists.

						ON Sec1.isUser = T.isUser AND Sec1.userOrgroupId = T.userOrGroupId AND Sec1.roleId = Sec.roleId AND Sec1.companyId = Sec.companyId				

				WHERE 

					Sec1.isUser IS NULL	

			-- Drop these trouble user Ids and AD group Ids. 

			DELETE UG

			FROM UMUserGroup UG

				INNER JOIN #tamperedTenantOperatorUG1 T

					ON UG.groupId = T.tenantOperatorGroupId AND UG.userId = T.userOrGroupId AND T.isUser = 1

			DELETE UG

			FROM UMDSGroupMaps UG

				INNER JOIN #tamperedTenantOperatorUG1 T

					ON UG.umgroupId = T.tenantOperatorGroupId 

		END

		-- Step 2: Handling Security associations of the Tenant Operator UG. 

		BEGIN

			-- a. Drop them off UMOperators and it's corresponding Security role.

			DELETE Sec

			FROM #CompanyUGs CG	

				INNER JOIN UMOperators UMO

					ON UMO.isUser = 0 AND UMO.userOrgroupId = CG.tenantOperatorGroupId

				INNER JOIN UMSecurityAssociations Sec

ON Sec.isUser = UMO.isUser AND Sec.userOrGroupId = UMO.userOrgroupId AND Sec.entityType1 = 61 AND Sec.entityId1 = UMO.companyId AND Sec.roleId = UMO.roleId

			DELETE UMO

			FROM #CompanyUGs CG	

				INNER JOIN UMOperators UMO

					ON UMO.isUser = 0 AND UMO.userOrgroupId = CG.tenantOperatorGroupId

			-- b. Drop them off Security associations, except 

				-- a. Creator entries.

				-- b. Any entity shared with Tenant Admins. 

				-- c. Smart folder entries. 

			-- These are expected entries going forward. We will keep only them for existing companies too. Anything else, chop it off. 

			DELETE Sec 

			FROM UMSecurityAssociations Sec

				INNER JOIN #CompanyUGs CG

					ON Sec.isUser = 0 AND Sec.userOrgroupId = CG.tenantOperatorGroupId 

				LEFT OUTER JOIN UMSecurityAssociations Sec1

					ON Sec1.isUser = 0 AND Sec1.userOrgroupId = CG.tenantAdminGroupId 

					AND Sec1.entityType1 = Sec.entityType1 AND Sec1.entityId1 = Sec.entityID1 AND Sec1.entityType2 = Sec.entityType2 AND Sec1.entityId2 = Sec.entityID2

					AND Sec1.entityType3 = Sec.entityType3 AND Sec1.entityId3 = Sec.entityID3 AND Sec1.entityType4 = Sec.entityType4 AND Sec1.entityId4 = Sec.entityID4

					AND Sec1.entityType5 = Sec.entityType5 AND Sec1.entityId5 = Sec.entityID5 

					AND (Sec1.roleId = Sec.roleId OR (Sec1.roleId = @tenantAdminRoleId AND Sec.roleId = @tenantOperatorRoleId)) AND Sec1.permissionId = Sec.permissionId

			WHERE

(Sec.isCreator = 0) AND (Sec1.isUser IS NULL) AND (Sec.entityType1 <> 127)

			-- c. Drop off any Owner associations. 

			DELETE Sec

			FROM UMOwners Sec

				INNER JOIN #CompanyUGs CG

					ON Sec.isUser = 0 AND Sec.userOrgroupId = CG.tenantOperatorGroupId 

		END

		-- Step 3: Hide it. 

		UPDATE UMGroups 

SET groupFlags |= 0x0010

		FROM #CompanyUGs

		WHERE id = tenantOperatorGroupId
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@fixTenantOperatorUGGUID, 'FixTenantOperatorUserGroup', 'Hides Tenant Operator User group', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

	END TRY

	BEGIN CATCH

			PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

			ERROR MESSAGE: ' + ERROR_MESSAGE() + '

			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	END CATCH

END

-- Tenant Admin and Tenant Operator roles should include Change Client Associations and Delete Client group permissions. 

-- The reason it was removed from them previously, was we did not want any tenant admin / operator to tamper with the system created Company SCG.

-- Now we have made the system created Company SCG non-editable and deletable from code. So we do not need the change on Roles anymore. 

DECLARE @fixTenantAdminAndOperatorRoles VARCHAR(1024) = '72494D62-1DE9-4E3A-917D-FBC445F32003'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @fixTenantAdminAndOperatorRoles)

BEGIN

	BEGIN TRY

		-- If the permissions are explicitly excluded, then remove those exclusion rows. 

		DELETE 

		FROM UMRolesPermissions 

		WHERE 

			(roleID IN (@tenantAdminRoleId, @tenantOperatorRoleId))

AND (permissionID IN (181, 180))

			AND (excludePermission = 1)

		-- If this table does not contain those permissions, include them. 

IF NOT EXISTS (SELECT 1 FROM UMRolesWithPermissionsExpanded WHERE roleId = @tenantAdminRoleId AND categoryId = 122 AND permissionId = 181)
			INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)


VALUES (@tenantAdminRoleId, 122, 181)

IF NOT EXISTS (SELECT 1 FROM UMRolesWithPermissionsExpanded WHERE roleId = @tenantAdminRoleId AND categoryId = 122 AND permissionId = 180)
			INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)


VALUES (@tenantAdminRoleId, 122, 180)

IF NOT EXISTS (SELECT 1 FROM UMRolesWithPermissionsExpanded WHERE roleId = @tenantOperatorRoleId AND categoryId = 122 AND permissionId = 181)
			INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)


VALUES (@tenantOperatorRoleId, 122, 181)

IF NOT EXISTS (SELECT 1 FROM UMRolesWithPermissionsExpanded WHERE roleId = @tenantOperatorRoleId AND categoryId = 122 AND permissionId = 180)
			INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)


VALUES (@tenantOperatorRoleId, 122, 180)
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@fixTenantAdminAndOperatorRoles, 'FixTenantAdminAndOperatorRoles', 'Include CG permissions into Tenant Admin and Operator roles', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

	END TRY

	BEGIN CATCH

			PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

			ERROR MESSAGE: ' + ERROR_MESSAGE() + '

			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

			RAISERROR ('Failed in FixTenantAdminAndOperatorRoles section', 16, 1)

	END CATCH

END

-- Keep both tenant operator and tenant admin related modification script in this file. -- advice by Jagadeesh.

-- UMRoles.script and this file would have created tenant admin and tenant operator roles respectively before this point of time.

DECLARE @excludingComplianceSearchPermisionForSystemCreatedTenantAdminAndTenantOperatorRoles_GUID VARCHAR(128) = '2119983A-5B72-4F76-A756-8AD40490412C'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking (NOLOCK) WHERE SqlScriptGUID = @excludingComplianceSearchPermisionForSystemCreatedTenantAdminAndTenantOperatorRoles_GUID)

BEGIN

	IF(@tenantOperatorRoleId <> 0)

	BEGIN 

		-- In short, If Compliance Search permission exists for unmodified tenant operator role, remove it. 

		-- Default role has CV_ALL_CATEGORIES_TYPE selected and without excluding EV_FAST_COMPLIANCE_SEARCH.

		-- Only for the above combination, we are updating the tenant operator role with exluded EV_FAST_COMPLIANCE_SEARCH permission. 

		-- [As system created Tenant Operator role is not System protected for modification, it can be modified by user]

		-- All other cases meant that, user has overriden the default tenant operator role permission and we are not disturbing it in that case. 

IF EXISTS (SELECT 1 FROM UMRolesPermissions (NOLOCK) WHERE roleId = @tenantOperatorRoleId AND hierarchyLevel = 123 AND categoryId = 0 AND permissionId = 0 AND excludeCategory = 0 AND excludePermission = 0)

AND NOT EXISTS(SELECT 1 FROM UMRolesPermissions (NOLOCK) WHERE roleId = @tenantOperatorRoleId AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 25 AND excludeCategory = 0 AND excludePermission = 1)

		BEGIN
				INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantOperatorRoleId, 122, 102, 25, 0, 1)

DELETE FROM UMRolesWithPermissionsExpanded WHERE roleId = @tenantOperatorRoleId AND permissionId = 25 AND categoryId = 102

		END 

	END 

	IF(@tenantAdminRoleId <> 0)

	BEGIN

		-- In short, If Compliance Search permission exists for unmodified tenant admin role, remove it. 

		-- Default role has CV_ALL_CATEGORIES_TYPE selected and without excluding EV_FAST_COMPLIANCE_SEARCH.

		-- Only for the above combination, we are updating the tenant admin role with excluded EV_FAST_COMPLIANCE_SEARCH permission. 

		-- [As system created Tenant admin role is not System protected for modification, it can be modified by user]

		-- All other cases meant that, user has overriden the default role permission and we are not disturbing it in that case. 

IF EXISTS (SELECT 1 FROM UMRolesPermissions (NOLOCK) WHERE roleId = @tenantAdminRoleId AND hierarchyLevel = 123 AND categoryId = 0 AND permissionId = 0 AND excludeCategory = 0 AND excludePermission = 0)

AND NOT EXISTS (SELECT 1 FROM UMRolesPermissions (NOLOCK) WHERE roleId = @tenantAdminRoleId AND hierarchyLevel = 122 AND categoryId = 102 AND permissionId = 25 AND excludeCategory = 0 AND excludePermission = 1)

		BEGIN
				INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES (@tenantAdminRoleId, 122, 102, 25, 0, 1)

DELETE FROM UMRolesWithPermissionsExpanded WHERE roleId = @tenantAdminRoleId AND permissionId = 25 AND categoryId = 102

		END 

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@excludingComplianceSearchPermisionForSystemCreatedTenantAdminAndTenantOperatorRoles_GUID, 'ExcludingComplianceSearchPermisionForSystemCreatedTenantAdminAndTenantOperatorRoles', 'Excluding Compliance Search permission from unmodified system created Tenant Admin and Tenant Operator roles', @nowTime, 16, 0 , (16 + 2))

END

