

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMGroupsProp.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON 

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/UMGroupsProp.script,v $ $Id: UMGroupsProp.script,v 1.1.2.4.16.1 2021/03/30 22:19:07 nramalingam Exp $";

GO

SET NOCOUNT ON

-- Tbl script file should not have any function calls because they may not exist during upgrade

DECLARE @nowTime int = datediff(second, '01/01/1970', getUTCDate())

-- Script to enable TFA on all groups if enabled at Commcell Level.

DECLARE @twofactorAuthGUID    VARCHAR(40) = '79085777-4181-4A36-97C8-3D818DE2FAD6'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @twofactorAuthGUID)

BEGIN

	DECLARE @isTFAEnabledAtCC INT = ISNULL((

select Convert(int, value) from GxGlobalParam where Name = 'EnableTwoFactorAuthentication'

), 0)

IF @isTFAEnabledAtCC = 1

	BEGIN

		MERGE   UMGroupsProp AS TGT

			USING   (SELECT id FROM UMGroups where umdsproviderId = 0 ) AS SRC

ON      TGT.componentNameId = SRC.id and TGT.attrName = 'DisableTwoFactorAuthentication' AND TGT.attrType = 7

			--WHEN    MATCHED THEN        UPDATE SET TGT.attrVal = 0 --Dont do any thing if the group is already disabled 

			WHEN    NOT MATCHED THEN    INSERT (componentNameId, attrName, attrType, attrVal, created, modified) 

VALUES(SRC.id, 'DisableTwoFactorAuthentication', 7, 0, @nowTime ,0);

	END

	-- Update script table , so that this code doesn't execute anymore'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES(@twofactorAuthGUID, 'TwoFactorAuthAtGroups', 'Upgrade  Script to enable two factor authentcation on all user groups if enabled at Commcell Level', 

@nowTime, 16, 0 , (16 + 2))

END

--During edit of usergroups, sec_performUserGroupOperation incorrectly set property 'Enforce Edge Drive Quota' to 100 instead of 0.

--This one time update will fix invalid attrval by updating the property to 0 from 100.

DECLARE @fixEnforceEdgeDriveQuotaInUMGroupsPropGUID VARCHAR(128) = '09591A69-CCB9-4726-A9B2-0011E8F46924'

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @fixEnforceEdgeDriveQuotaInUMGroupsPropGUID)

BEGIN	

	UPDATE UMGroupsProp SET attrval = '0' WHERE attrname = N'Enforce Edge Drive Quota' AND attrval = '100'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@fixEnforceEdgeDriveQuotaInUMGroupsPropGUID, 'FixEnforceEdgeDriveQuotaInUMGroupsProp', 'Fix Enforce Edge Drive Quota in UMGroups from 100 to 0', @nowTime, 16, 0 , (16 + 1))

END

-- Script to replace property 'AddTwoFactorAuthentication' with 'DisableTwoFactorAuthentication' for enabling TFA with user group inclusion at commcell level.

DECLARE @TFAUserGroupInclusionGUID    VARCHAR(40) = '3551F0E7-5CEA-48B8-BFC5-76B9064F8E13'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @TFAUserGroupInclusionGUID)

BEGIN

	DECLARE @tfaModeAtCommcell INT = ISNULL((

select Convert(int, value) from GxGlobalParam where Name = 'EnableTwoFactorAuthentication'

), 0)

IF @tfaModeAtCommcell = 2

	BEGIN

		-- REMOVE PROPERTY 'DisableTwoFactorAuthentication' FOR COMMCELL USER GROUPS

		DELETE UMGP

		FROM UMGroupsProp UMGP

JOIN UMGroups UMP ON UMGP.attrName = 'DisableTwoFactorAuthentication' AND UMGP.componentNameId = UMP.id

		JOIN UMDSProviders UMDSP ON UMP.umdsproviderId = UMDSP.id

		WHERE UMP.umdsproviderId = 0 

OR (UMDSP.ownerCompany = 0 AND UMDSP.serviceType IN (2, 6, 8, 9, 10, 14))

		-- INSERT 'DisableTwoFactorAuthentication' IF PROPERTY 'AddTwoFactorAuthentication' IS SET FOR COMMCELL USER GROUPS
		INSERT INTO UMGroupsProp


SELECT UMP.id, 'DisableTwoFactorAuthentication', 7, (CASE WHEN UMGP.attrVal = '1' THEN '0' ELSE '1' END), @nowTime, 0

		FROM UMGroupsProp UMGP

JOIN UMGroups UMP ON UMGP.attrName = 'AddTwoFactorAuthentication' AND UMGP.componentNameId = UMP.id

		JOIN UMDSProviders UMDSP ON UMP.umdsproviderId = UMDSP.id

		WHERE UMP.umdsproviderId = 0 

OR (UMDSP.ownerCompany = 0 AND UMDSP.serviceType IN (2, 6, 8, 9, 10, 14))

	END

	-- REMOVE PROPERTY 'AddTwoFactorAuthentication' WHICH IS DEPRECATED FOR COMMCELL USER GROUPS

	DELETE UMGP

	FROM UMGroupsProp UMGP

JOIN UMGroups UMP ON UMGP.attrName = 'AddTwoFactorAuthentication' AND UMGP.componentNameId = UMP.id

	JOIN UMDSProviders UMDSP ON UMP.umdsproviderId = UMDSP.id

	WHERE UMP.umdsproviderId = 0 

OR (UMDSP.ownerCompany = 0 AND UMDSP.serviceType IN (2, 6, 8, 9, 10, 14))

	-- FIX PROPERTY 'DisableTwoFactorAuthentication' TO CORRECT VALUE WHEN IT WAS SET TO 3

UPDATE UMGroupsProp SET attrVal = '1' WHERE attrName = 'DisableTwoFactorAuthentication' AND attrVal = '3' AND modified = 0

	-- Update script table , so that this code doesn't execute anymore'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@TFAUserGroupInclusionGUID, 'TwoFactorAuthAtGroups', 'Upgrade Script to replace property AddTwoFactorAuthentication with DisableTwoFactorAuthentication if TFA is set as enabled with user group inclusion at commcell level for commcell user groups', @nowTime, 16, 0 , (16 + 2))

END

SET NOCOUNT OFF

GO

