

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMGroups.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON 

	declare @myFlags integer

	declare @myMasterFlags integer

set @myFlags = (convert(int, 0x8000) + convert(int, 0x0001))

set @myMasterFlags = (convert(int, 0x8000) + convert(int, 0x0001)) + convert(int, 0x0008)

IF NOT EXISTS(SELECT 1 FROM UMgroups where (groupFlags&0x0008)=0x0008)

	BEGIN

UPDATE UMGROUPS 
			SET name='master' ,description='Administrative Group',groupFlags=@myMasterFlags,allCapabilities=1,allAssociations=1, selfAssociation=1, origCCId =DEFAULT 
			WHERE LTRIM(RTRIM(name))='master' and umdsProviderId=0

	END

IF NOT EXISTS(SELECT * FROM UMGroups WHERE LTRIM(RTRIM(name))='CV_Restricted_Visibility' and umdsProviderId = 0) 
			INSERT INTO UMGroups(name, description,  groupFlags, allCapabilities, allAssociations, selfAssociation, origCCId, GUID, umdsProviderId)  VALUES ('CV_Restricted_Visibility', 'Limited capability visibility',  @myFlags, 0, 0, 1, DEFAULT, newid(), 0)
		ELSE 
		UPDATE UMGROUPS 
			SET name='CV_Restricted_Visibility' ,description='Limited capability visibility',groupFlags=@myFlags,allCapabilities=0,allAssociations=0, selfAssociation=1, origCCId =DEFAULT 
			WHERE LTRIM(RTRIM(name))='CV_Restricted_Visibility' and umdsProviderId = 0

	IF NOT EXISTS(SELECT 1 FROM APP_Client WHERE id = 2)

	BEGIN

DELETE UGC FROM UMGroups UMG INNER JOIN UMGroupCapability UGC ON UMG.id = UGC.groupId AND UMG.name = 'View All'

DELETE UGP FROM UMGroups UMG INNER JOIN UMGroupsProp UGP ON UMG.id = UGP.componentNameId AND UMG.name = 'View All'

DELETE FROM UMGroups WHERE name = 'View All'

	END

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @changeLaptopusersGroupNameGuid    VARCHAR(40) = '8249C52B-47B4-4A9F-BA45-C827C4EA6DDA'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @changeLaptopusersGroupNameGuid)

BEGIN

UPDATE  UMGroups  SET name='Tenant Users'

	FROM UMDSProviders P 

	WHERE  P.id =umdsProviderId AND P.serviceType=5 AND name = 'Laptop users' AND groupFlags<>0

	-- Update script table , so that this code doesn't execute anymore'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@changeLaptopusersGroupNameGuid, 'LaptopUsersGroupNameChange', 'change organization user group Laptop Users to Tenant Users', @nowTime, 16, 0 , (16 + 2))

END

DECLARE @updateTenantAdminGroupCapabilities    VARCHAR(40) = '32343a2e-0ee7-47a1-9f24-b5411edb90e1'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @updateTenantAdminGroupCapabilities)

BEGIN

	BEGIN TRY

		IF OBJECT_ID ('tempdb.dbo.#TenantAdminGroupsDetails') IS NOT NULL

							DROP TABLE #TenantAdminGroupsDetails

		CREATE TABLE #TenantAdminGroupsDetails (umdsProviderId INT PRIMARY KEY, groupId INT)

DECLARE @tenantAdminRoleId int = ISNULL((SELECT id FROM UMRoles WHERE (flags & 256 <> 0)), 1)

DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
		INSERT INTO #TenantAdminGroupsDetails


		SELECT UP.id,UG.id FROM UMDSProviders UP

		INNER JOIN UMGroups UG

ON UG.umdsProviderId=UP.id AND UP.serviceType=5 AND UG.groupFlags & 0x10000 = 0x10000 and UP.flags&0x0002=0

DELETE FROM UMOwners WHERE entityType=61 AND entityId IN (SELECT umdsProviderId FROM #TenantAdminGroupsDetails)

DELETE FROM UMOwnerRoles WHERE entityType=61 AND entityId IN (SELECT umdsProviderId FROM #TenantAdminGroupsDetails)

		MERGE UMSecurityAssociations TGT

		USING (SELECT umdsproviderId AS entityId, groupId AS userOrGroupId FROM #TenantAdminGroupsDetails)  AS SRC

ON TGT.roleid=@tenantAdminRoleId AND TGT.permissionId=0 AND SRC.userOrGroupId=TGT.userOrGroupId AND TGT.isUser=0 AND SRC.entityId=TGT.entityId1 AND TGT.entitytype1=61

		WHEN NOT MATCHED THEN

		INSERT (roleID, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)

VALUES(@tenantAdminRoleId, 0, SRC.userOrGroupId, 0, 61, SRC.entityId, 0, @adminUserId);

		IF OBJECT_ID ('tempdb.dbo.#TenantAdminGroupsDetails') IS NOT NULL DROP TABLE #TenantAdminGroupsDetails
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@updateTenantAdminGroupCapabilities, 'Tenant Admin Security Change', 'Change Capabilities for Tenant Admin', @nowTime, 16, 0 , (16 + 2))

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	END CATCH

END

-- Script to add black listed Groups flag to Laptop Admins Group

DECLARE @addBlackListedGroupsFlagToLaptopAdmins    VARCHAR(40) = 'C33E46B8-D114-422E-A40F-4123D80D6819'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @addBlackListedGroupsFlagToLaptopAdmins)

BEGIN

UPDATE  UMGroups  SET groupFlags = (groupFlags | CAST(0x20000 AS INTEGER)), description = N'When users in this group install the laptop package, they cannot activate the laptop and they are not added as client owners.'

	WHERE  name = 'Laptop Admins'

	-- Update script table , so that this code doesn't execute anymore'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@addBlackListedGroupsFlagToLaptopAdmins, 'LaptopAdminsBlackListedFlag', 'Upgrade of Laptop Admins Group to contain BlackListed Flag', @nowTime, 16, 0 , (16 + 2))

END

-- Until SP17, we had a bug, where UGs created by Company user was set with umdsProviderId = 0. This was fixed in update form 77756.

-- This script is to fix existing setups. 

DECLARE @fixCompanyUGGUID VARCHAR(40) = '4F1D1B36-D2B4-48A8-BAEA-E6E406A6F23D'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @fixCompanyUGGUID)

BEGIN

	UPDATE G

	SET umdsProviderId = Sec.companyId 

	FROM UMGroups G

		INNER JOIN UMSecurityAssociations Sec

ON Sec.entityType1 = 15 AND Sec.entityId1 = G.id AND Sec.isCreator = 1 AND Sec.companyId <> 0

			-- This means that a UG has been created by a Company user. 

	WHERE 

		G.umdsProviderId = 0

	-- Update script table, so that this code doesn't execute anymore
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@fixCompanyUGGUID, 'FixCompanyUserGroup', 'Fix umdsProviderId of company user groups which are set as 0', @nowTime, 16, 0 , (16 + 2))

END

DECLARE @pruneDeletedUMDSGroups VARCHAR(40) = 'D152F5F8-6C15-443C-BB06-08AD6F7C3C18'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking (nolock) WHERE SqlScriptGUID = @pruneDeletedUMDSGroups)

BEGIN 

	BEGIN TRY

IF EXISTS (SELECT 1 FROM umgroups (nolock) WHERE groupFlags & 0x0001 = 0 AND umdsProviderId <> 0)

		BEGIN 

			-- deleted groups of umdsproviderID <> 0 are not pruned in umgroups and umdsgroups table, Rather GF_GROUP_ENABLED bit of UmGroups.groupFlags is disable. 

			-- As same flag is used for both enabled status and deleted groups having umdsproviderID <> 0, we are not able to disable/enable tenant operator groups. 

			-- this GF_GROUP_ENABLED flag information is only stored in UmGroups table, not in UmDSGroups table. Hence using UmGroups script to prune UMDSGroups table as well. 

			IF OBJECT_ID ('tempdb.dbo.#UMDSGroupstoDelete') IS NOT NULL

				DROP TABLE #UMDSGroupstoDelete

			CREATE TABLE #UMDSGroupstoDelete (groupIdsToDelete INT PRIMARY KEY)
insert into #UMDSGroupstoDelete(groupIdsToDelete) (select id from umgroups(nolock) where groupFlags & 0x0001 = 0 and umdsProviderId <> 0)


			delete NTnotificationExternalGroups where externalGroupId in (select groupIdsToDelete from #UMDSGroupstoDelete)

			delete from UMDSgroups where id in (select groupIdsToDelete from #UMDSGroupstoDelete)

			delete from umgroups where id in (select groupIdsToDelete from #UMDSGroupstoDelete)

			IF OBJECT_ID ('tempdb.dbo.#UMDSGroupstoDelete') IS NOT NULL DROP TABLE #UMDSGroupstoDelete

		END

		-- Update script table, so that this code doesn't execute anymore
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@pruneDeletedUMDSGroups, 'PruneDeletedUMDSGroups', 'Pruning deleted UMDS Groups from umgroups and umdsgroups. deleted UMDS groups are just marked as disable. This prevent us from enable/disable tenant groups', @nowTime, 16, 0 , (16 + 2))

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	END CATCH

END

-- All Tenant Admins User group and All Tenant Users User group creation. 

DECLARE @systemCreatedUGGUID VARCHAR(40) = '79EB9328-3948-4749-80EA-C04128654FA9'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @systemCreatedUGGUID)

BEGIN

	-- 1. All Tenant Admin UG. 

	BEGIN 

DECLARE @allTenantAdminGroupName VARCHAR(1024) = 'All Tenant Admins'

		DECLARE @allTenantAdminGroupId INT = 0

		IF EXISTS (SELECT TOP 1 1 FROM UMGroups (NOLOCK) WHERE (name = @allTenantAdminGroupName) AND (umdsProviderID = 0))

			SET @allTenantAdminGroupName = @allTenantAdminGroupName + '(System Created)'
		INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)


VALUES (CAST(0x0010 AS INT ) | (CAST(0x0001 AS INT) | CAST(0x0040 AS INT) | CAST(0x0100 AS INT) ),

					0,

					0,

					1,

					@allTenantAdminGroupName,

					'System created Commvault User group for all Tenant Admins',

					2,

					NEWID(),

					0,

					'',

					0)

		SELECT @allTenantAdminGroupId = id 

		FROM UMGroups 

		WHERE (name = @allTenantAdminGroupName) AND (umdsProviderID = 0)
		INSERT INTO UMDSGroupMaps (umGroupId, umdsGroupId, flag)


			SELECT DISTINCT 

				@allTenantAdminGroupId,

				id,

				0

			FROM UMGroups 

WHERE ((groupflags & CAST(0x10000 AS INT)) <> 0)

	END

	-- 2. All Tenant Users UG. 

	BEGIN 

DECLARE @allTenantUsersGroupName VARCHAR(1024) = 'All Tenant Users'

		DECLARE @allTenantUsersGroupId INT = 0

		IF EXISTS (SELECT TOP 1 1 FROM UMGroups (NOLOCK) WHERE (name = @allTenantUsersGroupName) AND (umdsProviderID = 0))

			SET @allTenantUsersGroupName = @allTenantUsersGroupName + '(System Created)'
		INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)


VALUES (CAST(0x0010 AS INT ) | (CAST(0x0001 AS INT) | CAST(0x0080 AS INT) | CAST(0x0100 AS INT) ),

					0,

					0,

					1,

					@allTenantUsersGroupName,

					'System created Commvault User group for all Tenant Users',

					2,

					NEWID(),

					0,

					'',

					0)

		SELECT @allTenantUsersGroupId = id 

		FROM UMGroups 

		WHERE (name = @allTenantUsersGroupName) AND (umdsProviderID = 0)
		INSERT INTO UMDSGroupMaps (umGroupId, umdsGroupId, flag)


			SELECT DISTINCT 

				@allTenantUsersGroupId,

				id,

				0

			FROM UMGroups 

WHERE ((groupflags & CAST(1073741824 AS INT)) <> 0)

	END

	-- Update script table, so that this code doesn't execute anymore
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@systemCreatedUGGUID, 'CreateSystemCreatedUGs', 'Create All Tenant Admins and All Tenant Users UGs', @nowTime, 16, 0 , (16 + 2))

END

