

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMDefaultRoles.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- 	+-----------------------------------------------------------------------------------+

--	| 			Script: UMDefaultRoles.script

--	|	This script is used to populate default system created roles

--	|	This script should be used only for creating normal roles that are 

--	|	created during installation / upgrade. These roles are editable and deletable

--	|	from GUI. The reason they are not present in UMRoles.script is because 

--	|	we will populate all the 3 tables for these roles at a single shot. 

--	|	And we will handle some scenarios like the roles should not get 

--	|	re-created on running the script again (if they are deleted / re-named)

--	|	and to honor the changes made to the roles.

--	|	Basically the code for one role should be run only once for the first 

--	|	time and should not be repeated after that 

-- 	+------------------------------------------------------------------------------------+

--This is replica of the function getAllPermissionsForCategory

--Any change made to getAllPermissionsForCategoryTblScript should be replicated here also 

IF EXISTS(select 1 from sysobjects where id = object_id(N'[dbo].[getAllPermissionsForCategoryTblScript]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))

	drop function [dbo].[getAllPermissionsForCategoryTblScript] 

GO

CREATE FUNCTION getAllPermissionsForCategoryTblScript (@categoryId INT,@skipHiddenPermission int =1)

RETURNS @permissionsTbl TABLE 

(

	categoryId INT,

	permissionId INT

)

AS

BEGIN
	INSERT INTO @permissionsTbl 


		SELECT categoryid, id

		FROM UMPermissions 

WHERE categoryId = @categoryId and(@skipHiddenPermission=0 OR flags&0x002=0 )

		UNION

		SELECT Perm.categoryid, Perm.permissionId

		FROM UMCategories AS Cat 

		CROSS APPLY dbo.getAllPermissionsForCategoryTblScript(Cat.id,@skipHiddenPermission) AS Perm

		WHERE parentCategoryId = @categoryId                                  

	RETURN   

END

GO

--This is a replica of the sp sec_expandRoleWithPermissions

--Any change made to sec_expandRoleWithPermissions should be replicated here also 

IF EXISTS (SELECT 1 FROM sysobjects WHERE name  = 'expandRolePermissionsTblScript')

	DROP PROCEDURE expandRolePermissionsTblScript

GO

CREATE PROCEDURE expandRolePermissionsTblScript

@roleID INT

AS  

BEGIN	

	DELETE UMRolesWithPermissionsExpanded 

	WHERE roleId = @roleId 

DECLARE @allCategories INT = 123

DECLARE @categoryEntityType INT = 121

DECLARE @permissionEntityType INT = 122

	DECLARE @includedPermissionsTbl TABLE 

	(

		categoryId INT,

		permissionId INT

	)

	DECLARE @excludedPermissionsTbl TABLE 

	(

		categoryId INT,

		permissionId INT

	)

	IF EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @roleId AND hierarchyLevel = @allCategories)
		INSERT INTO @includedPermissionsTbl 


			SELECT categoryId, id 

			FROM UMPermissions 

			WHERE id <> 0

	ELSE
		INSERT INTO @includedPermissionsTbl 


			SELECT DISTINCT T.categoryid, T.permissionId 

			FROM UMRolesPermissions RolePerm

			CROSS APPLY dbo.getAllPermissionsForCategoryTblScript(RolePerm.categoryId,1) AS T

			WHERE roleId = @roleId AND hierarchyLevel = @categoryEntityType AND excludeCategory = 0

			UNION

			SELECT DISTINCT categoryId, permissionId 

			FROM UMRolesPermissions 

			WHERE roleId = @roleId AND hierarchyLevel = @permissionEntityType AND excludePermission = 0
	INSERT INTO @excludedPermissionsTbl 


		SELECT DISTINCT T.categoryId, T.permissionId

		FROM UMRolesPermissions RolePerm 

		CROSS APPLY dbo.getAllPermissionsForCategoryTblScript(RolePerm.categoryId,1) AS T

		WHERE roleId = @roleId AND hierarchyLevel = @categoryEntityType AND excludeCategory = 1

		UNION 

		SELECT categoryId, permissionId 

		FROM UMRolesPermissions 

		WHERE roleId = @roleId AND hierarchyLevel = @permissionEntityType AND excludePermission = 1 
	INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId) 


		SELECT @roleId, categoryId, permissionId 

		FROM @includedPermissionsTbl 

		EXCEPT 

		SELECT @roleId, categoryId, permissionId 

		FROM @excludedPermissionsTbl 

END

GO

--GxGlobalParam key: 'System created default roles'

--This counter will be incrementing with each role created

--So if the counter is above the value assigned for a specific role, then means that role is already created

--and should not get re-created

--This arrangement is done because these roles are normal roles created just for user convenience.

--So if any of them gets deleted / re-named then we should not re-create them when the table script is run again

--This parameter should be used only for these roles that are "system-created-but-editable-and-deletable-from-GUI"

DECLARE @roleId INT = 0

--End user role (GxGlobalParamKeyValue: 1)

IF ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'System created default roles' AND modified = 0), 0) < 1

BEGIN

IF NOT EXISTS (SELECT 1 FROM UMRoles WHERE name = 'End Users')

	BEGIN
		INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)


VALUES (2, 'End Users', 'System created role for end users', 0, 0, 128, 1, datediff(second, '01/01/1970', GETUTCDATE()), 0, NEWID(), '')

		SET @roleId = 0

		SET @roleId = ISNULL((SELECT id 

					  FROM UMRoles 

WHERE name = 'End Users'), 0)

		IF @roleId <> 0 

		BEGIN

			IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @roleId)
				INSERT INTO UMRolesPermissions 


SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 5

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 2

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 3

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 12

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 6

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 24

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 20

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 38

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 22

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 40

			EXEC expandRolePermissionsTblScript @roleId

		END		

	END

IF NOT EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'System created default roles')
		INSERT INTO GxGlobalParam (name, value, created, modified)


SELECT 'System created default roles', '1', datediff(second, '01/01/1970', GETUTCDATE()), 0

	ELSE 

		UPDATE GxGlobalParam 

		SET value = '1'

WHERE name = 'System created default roles' AND modified = 0

END

--Compliance search role (GxGlobalParamKeyValue: 2)

IF ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'System created default roles' AND modified = 0), 0) < 2

BEGIN

IF NOT EXISTS (SELECT 1 FROM UMRoles WHERE name = 'Compliance')

	BEGIN
		INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)


VALUES (2, 'Compliance', 'System created role for compliance', 0, 0, 128, 1, datediff(second, '01/01/1970', GETUTCDATE()), 0, NEWID(), '')

		SET @roleId = 0

		SET @roleId = ISNULL((SELECT id 

					  FROM UMRoles 

WHERE name = 'Compliance'), 0)

		IF @roleId <> 0 

		BEGIN

			IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @roleId)
				INSERT INTO UMRolesPermissions 


SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 27

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 32

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 25

					UNION			

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 6

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 29

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 22

			EXEC expandRolePermissionsTblScript @roleId

		END				

	END

	UPDATE GxGlobalParam 

	SET value = '2'

WHERE name = 'System created default roles' AND modified = 0

END

--Client admins role (GxGlobalParamKeyValue: 3)

IF ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'System created default roles' AND modified = 0), 0) < 3

BEGIN

IF NOT EXISTS (SELECT 1 FROM UMRoles WHERE name = 'Client Admins')

	BEGIN
		INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)


VALUES (2, 'Client Admins', 'System created role for client admins', 0, 0, 128, 1, datediff(second, '01/01/1970', GETUTCDATE()), 0, NEWID(), '')

		SET @roleId = 0

		SET @roleId = ISNULL((SELECT id 

					  FROM UMRoles 

WHERE name = 'Client Admins'), 0)

		IF @roleId <> 0 

		BEGIN

			IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @roleId)
				INSERT INTO UMRolesPermissions 


SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 2

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 3

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 13

					UNION			

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 12

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 20

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 22

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 39

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 42

					UNION

SELECT @roleId, 122, categoryId, id, 0, 0

					FROM UMPermissions 

WHERE id = 7

			EXEC expandRolePermissionsTblScript @roleId

		END		

	END

	UPDATE GxGlobalParam 

	SET value = '3'

WHERE name = 'System created default roles' AND modified = 0

END

-- MR 253013: Add Download permission to Client Admins role by default. 

DECLARE @addDownloadPermissionToClientAdmins VARCHAR(128) = '7C4B257F-9BD3-4656-AE8B-4A1E895C2701'

IF NOT EXISTS (SELECT TOP 1 1

			   FROM GXUniqueSQLScriptExecTracking

			   WHERE

					SqlScriptGUID = @addDownloadPermissionToClientAdmins)

BEGIN

	SET @roleId = 0

	SELECT @roleId = id 

	FROM UMRoles 

	WHERE

name = 'Client Admins'

AND flags & 128 <> 0

	IF @roleId <> 0

	BEGIN		

DECLARE @permissionID INT = 6

		DECLARE @categoryID INT

		SELECT @categoryId = categoryId

		FROM UMPermissions 

		WHERE

			id = @permissionId 

		IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @roleID AND permissionId = @permissionId)

		BEGIN
			INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


VALUES(@roleId, 122, @categoryId, @permissionId, 0, 0)

		END

		IF NOT EXISTS (SELECT 1 FROM UMRolesWithPermissionsExpanded WHERE roleId = @roleId AND permissionId = @permissionId)

		BEGIN
			INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)


				VALUES(@roleId, @categoryId, @permissionId)

		END

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@addDownloadPermissionToClientAdmins, 'AddDownloadPermissionToClientAdminsRole', 'Add download permission to client admins by default', DATEDIFF(SECOND, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

END

--MSP role for associating user group to client group(GxGlobalParamKeyValue: 4)

IF ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'System created default roles' AND modified = 0), 0) < 4

BEGIN

IF NOT EXISTS (SELECT 1 FROM UMRoles WHERE name = 'MSP Subscription')

	BEGIN
		INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)


VALUES (2, 'MSP Subscription', 'Role for company user group client group associations', 0, 0, (16|128), 1, datediff(second, '01/01/1970', GETUTCDATE()), 0, NEWID(), '')

		SET @roleId = 0

		SET @roleId = ISNULL((SELECT id 

					  FROM UMRoles 

WHERE name = 'MSP Subscription'), 0)

		IF @roleId <> 0 

		BEGIN

			IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions WHERE roleId = @roleId)
				INSERT INTO UMRolesPermissions 


SELECT @roleId, 123, 0, 0, 0, 0

			EXEC expandRolePermissionsTblScript @roleId

		END		

	END

	UPDATE GxGlobalParam 

	SET value = '4'

WHERE name = 'System created default roles' AND modified = 0

END

--alert owner role

IF NOT EXISTS (SELECT 1 FROM UMRoles WHERE name = 'Alert Owner')

BEGIN
	INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)


VALUES (2, 'Alert Owner', 'System created role for alert owners', 0, 0, (1 | 2|128), 1, DATEDIFF(SECOND, '01/01/1970', GETUTCDATE()), 0, NEWID(), '')

END

ELSE

BEGIN

	UPDATE UMRoles 

SET name = 'Alert Owner', description = 'System created role for alert owners', disabled = 0, isPrivate = 0, flags = (1 | 2|128), ownerId = 1

WHERE name = 'Alert Owner'

END

SET @roleId = 0

SET @roleId = ISNULL((SELECT id

					FROM UMRoles 

WHERE (flags & 1 | 2 <> 0) and name = 'Alert Owner'),0)

IF (@roleId <> 0)

BEGIN

	IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions 

WHERE roleId = @roleId AND hierarchyLevel = 121 AND categoryId = 117 AND permissionId = 0 AND excludeCategory = 0 AND excludePermission = 0)

	BEGIN
		INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


SELECT @roleId, 121, 117, 0, 0, 0

	END

	IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions 

WHERE roleId = @roleId AND hierarchyLevel = 122 AND permissionId = 151 AND excludeCategory = 0 AND excludePermission = 1)

	BEGIN
		INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


SELECT @roleId, 122, categoryId, id, 0, 1

FROM UMPermissions WHERE id = 151

	END

	IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions 

WHERE roleId = @roleId AND hierarchyLevel = 122 AND permissionId = 31 AND excludeCategory = 0 AND excludePermission = 0)

	BEGIN
		INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


SELECT @roleId, 122, categoryId, id, 0, 0

FROM UMPermissions WHERE id = 31

	END

	IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions 

WHERE roleId = @roleId AND hierarchyLevel = 122 AND permissionId = 107 AND excludeCategory = 0 AND excludePermission = 0)

	BEGIN
		INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


SELECT @roleId, 122, categoryId, id, 0, 0

FROM UMPermissions WHERE id = 107

	END

	EXEC expandRolePermissionsTblScript @roleId

END

-- VM End User role.

DECLARE @vmEndUserRoleGUID VARCHAR(128) = '14723B98-F7F0-42FA-B33B-AC0D57D1B003'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking (NOLOCK) WHERE SqlScriptGUID = @vmEndUserRoleGUID)

BEGIN

IF NOT EXISTS (SELECT 1 FROM UMRoles (NOLOCK) WHERE	name = 'VM End User')

	BEGIN

		-- If role is not yet created, then create one and assign the permissions. 

		-- If role is already there, just leave it as it is. Some testers have created and assigned permissions already. 
		INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)


			VALUES (2, 

'VM End User',

					'System created role for VM End Users', 

					0, 

					0, 

128,				-- have this flag so CCM does not fail.

1,

					DATEDIFF(SECOND, '01/01/1970', GETUTCDATE()), 

					0, 

					NEWID(), 

					'')

SET @roleId = (SELECT id FROM UMRoles (NOLOCK) WHERE name = 'VM End User')
		INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)


SELECT @roleId, 122, categoryId, id, 0, 0

			FROM UMPermissions P (NOLOCK)

			WHERE

P.id IN (6

,13

,20

,22

,39

,42)
		INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)


			SELECT @roleId, categoryId, id

			FROM UMPermissions P (NOLOCK)

			WHERE

P.id IN (6

,13

,20

,22

,39

,42)

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@vmEndUserRoleGUID, 'VMEndUserRole', 'Default role for VM end users', DATEDIFF(SECOND, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

END

/**********************************

No new code after this comments

***********************************/

IF EXISTS(select * from sysobjects where id = object_id(N'[dbo].[getAllPermissionsForCategoryTblScript]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))

	drop function [dbo].[getAllPermissionsForCategoryTblScript] 

GO

IF EXISTS (SELECT * FROM sysobjects WHERE name  = 'expandRolePermissionsTblScript')

	DROP PROCEDURE expandRolePermissionsTblScript

GO

