

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMCategories.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

/*

When we are just adding a new category use the NEW_ROW_IF_NOT_EXIST macro with the new category 

When we are deleting a category verify if we want to delete all permissions along with it 

If so then just use DELETE_CATEGORY macro with this category. But if you want to re-order the permission

into a new category then dont delete the category now. In UMPermissions.script after permission re-ordering

is done, call DELETE_CATEGORY from there

If changing parent categoryId, include UMPermission.script too in same form, as UMRolesWithPermissionsExpanded need to be recomputed with new parent category.

*/

/*This macro has these inputs 

--1. x_permissionId - new permissionId 

--2. x_categoryId - category Id 

--3. x_permissionName - new permission name 

--4. x_flag - flags for permission 

--5. x_messageId - message Id for this permission (for localization purposes) 

--6. x_oldPermissionId - some permissions were dependent on old permissions 

--(eg, when we created permission called as Edit Workflow it was dependent on Edit permission)

--(whoever had Edit permission had Edit Workflow also)

--(can be 0 if there is no such dependency)*/

IF EXISTS (select * from sysobjects where name='deleteCategoryTblScript')

    DROP PROCEDURE deleteCategoryTblScript

GO

CREATE PROCEDURE deleteCategoryTblScript

@categoryId INTEGER,

@updatePermissionTbl INTEGER =0

AS

BEGIN

	DECLARE @childPermissionCategory TABLE( categoryId integer,permissionId integer);

	WITH ChildCategory ( categoryId,permissionsId)

	AS

	(

		SELECT id ,0  FROM UMCategories where id=@categoryId

		UNION ALL

		SELECT id ,0 FROM UMCategories  JOIN ChildCategory ON  parentCategoryId=ChildCategory.categoryId  and parentCategoryId<>0 	

	)
	INSERT INTO @childPermissionCategory


	SELECT * FROM ChildCategory

	UNION

	SELECT UMPermissions.categoryId ,UMPermissions.id FROM UMPermissions JOIN ChildCategory ON ChildCategory.categoryId=UMPermissions.categoryId;

	DELETE RPE

	FROM  UMRolesWithPermissionsExpanded  RPE 

	JOIN @childPermissionCategory  child ON  child.categoryId=RPE.categoryId

	DELETE RP

	FROM UMRolesPermissions RP

JOIN @childPermissionCategory child ON (hierarchyLevel =121 AND RP.categoryId=child.categoryId)

OR(hierarchyLevel= 122 AND RP.permissionId=child.permissionId)

	DECLARE @childPermissionTbl TABLE(permissionId INTEGER)
	INSERT INTO @childPermissionTbl


	SELECT id  FROM UMPermissions P JOIN @childPermissionCategory child ON P.categoryId=child.categoryId

	IF(@updatePermissionTbl=1)

	BEGIN	

		UPDATE P

		set categoryId=0

		FROM UMPermissions P where id in (SELECT permissionId FROM @childPermissionTbl)

	END

	ELSE

	BEGIN

		DELETE FROM UMSecurityAssociations WHERE permissionId in (SELECT permissionId FROM @childPermissionTbl)

		DELETE FROM UMOwnerRoles WHERE permissionId in (SELECT permissionId FROM @childPermissionTbl)

		DELETE FROM UMRolesWithPermissionsExpanded WHERE permissionId in (SELECT permissionId FROM @childPermissionTbl)

		DELETE P

		FROM UMPermissions P where id in (SELECT permissionId FROM @childPermissionTbl)

	END

	DELETE C

	FROM UMCategories C JOIN @childPermissionCategory child ON C.id=child.categoryId

END

GO

IF EXISTS(select * from sysobjects where id = object_id(N'[dbo].[getAllParentsForCatOrPerm_TblScript]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))

	drop function [dbo].[getAllParentsForCatOrPerm_TblScript] 

GO

CREATE FUNCTION getAllParentsForCatOrPerm_TblScript (@categoryId INT, @permissionId INT)

	RETURNS @parentsTbl TABLE

	(

				categoryId INT

	)

	AS

	BEGIN

                IF @permissionId <> 0			--this is a permission

                BEGIN
					INSERT INTO @parentsTbl


						SELECT categoryId		--immediate parent

						FROM UMPermissions

						WHERE id = @permissionId

						UNION

						SELECT Parent.categoryId	--for immediate parent category go recursively to find all parent categories

						FROM UMPermissions AS Perm

						CROSS APPLY dbo.getAllParentsForCatOrPerm_TblScript(Perm.categoryId, 0) AS Parent

						WHERE Perm.id = @permissionId

                END

                ELSE IF @categoryId <> 0			--this is a category

                BEGIN
					INSERT INTO @parentsTbl			--immediate parent


						SELECT parentCategoryId

						FROM UMCategories

						WHERE id = @categoryId AND parentCategoryId <> 0

						UNION

						SELECT Parent.categoryId	--for immediate parent category go recursively to find all parent categories

						FROM UMCategories AS Cat

						CROSS APPLY dbo.getAllParentsForCatOrPerm_TblScript(Cat.parentCategoryId, 0) AS parent

						WHERE Cat.id = @categoryId AND Cat.parentCategoryId <> 0

                END

                RETURN

	END

	GO

IF EXISTS (SELECT * FROM sysobjects WHERE name  = 'mapNewCategoryToOldPermissionTblScript')

	DROP PROCEDURE mapNewCategoryToOldPermissionTblScript

GO

CREATE PROCEDURE mapNewCategoryToOldPermissionTblScript

@newCategoryId INT, 

@oldPermissionId INT 

AS

BEGIN

	IF @oldPermissionId = 0 

		RETURN 

	DECLARE  @permissionRoleId table(roleId INTEGER, newCategoryExcluded INTEGER DEFAULT 0)

	DECLARE  @includedNewCategoryRole table(includedRole integer)

	DECLARE  @excludeNewCategoryRole table(excludeRole integer)

	DECLARE  @newCategoryAndParent table(categoryId integer)

	--1. get all the parent categories to which this new category belongs to 	
	INSERT INTO @newCategoryAndParent


	SELECT categoryId FROM dbo.getAllParentsForCatOrPerm_Tblscript(@newCategoryId, 0)

	UNION

	SELECT	@newCategoryId

	--2. get the role list for whom any of the new category's parent is excluded
	INSERT INTO @excludeNewCategoryRole


	SELECT roleId 

	FROM UMRolesPermissions RP JOIN @newCategoryAndParent CAT 

	on RP.categoryId=CAT.categoryId

WHERE RP.excludeCategory = 1 AND RP.hierarchyLevel = 121

	--3. get the role list that "effectively" includes the new category (without excluding any of its parent)

	--can include the category, parent category or all categories 

	--without excluding any of the parent category 
	INSERT INTO @includedNewCategoryRole


	SELECT DISTINCT roleId 

	FROM UMRolesPermissions

WHERE ((categoryId IN (SELECT categoryId FROM @newCategoryAndParent) AND hierarchyLevel = 121 AND excludeCategory = 0) OR

(hierarchyLevel = 123))

			AND roleId NOT IN (SELECT excludeRole FROM @excludeNewCategoryRole)

	--4. get the role list that has the old category id selected 
	INSERT INTO @permissionRoleId


	SELECT roleId,0

	FROM UMRolesWithPermissionsExpanded

	WHERE permissionId=@oldPermissionId

	--5. mark the flag for all the roles for whom the new categories's parent is excluded 

	--for them we will not insert the permission even though it was selected in the old model 

	UPDATE @permissionRoleId

	set newCategoryExcluded = 1

	WHERE  roleId in (SELECT excludeRole from @excludeNewCategoryRole) 

	--6. we should insert this permission only for those roles (that already had the old permission) that dont have any of its new parent category excluded or included 

	--If parent category is excluded, then we cannot include this permission

	--If parent category is included, then there is no need to insert this permission explicitly 
	INSERT INTO UMRolesPermissions


SELECT roleId, 121, @newCategoryId, 0, 0, 0

	FROM @permissionRoleId 

	WHERE roleId not in (select includedRole FROM @includedNewCategoryRole)

			AND newCategoryExcluded=0

END

GO

SET QUOTED_IDENTIFIER OFF 

GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=0) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(0,"Dummy",0,0,0,0) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 0, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=0) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 0) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 0,1 
				INSERT INTO UMCategories 					
				VALUES(0,"Dummy", @flags,0,0,0) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName="Dummy",flags = @flags,messageId=0,hierarchyLevel=0 
				WHERE  id=0 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=14) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(14,'User Management',0,(2402 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 14, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=14) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 14) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 14,1 
				INSERT INTO UMCategories 					
				VALUES(14,'User Management', @flags,(2402 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='User Management',flags = @flags,messageId=(2402 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=14 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=101) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(101,'Commcell',0,(2472 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 101, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=101) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 101) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 101,1 
				INSERT INTO UMCategories 					
				VALUES(101,'Commcell', @flags,(2472 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Commcell',flags = @flags,messageId=(2472 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=101 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=102) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(102,'Client',0,(2471 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 102, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=102) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 102) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 102,1 
				INSERT INTO UMCategories 					
				VALUES(102,'Client', @flags,(2471 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Client',flags = @flags,messageId=(2471 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=102 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=103) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(103,'Content Director',0,(2473 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 103, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=103) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 103) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 103,1 
				INSERT INTO UMCategories 					
				VALUES(103,'Content Director', @flags,(2473 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Content Director',flags = @flags,messageId=(2473 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=103 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=104) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(104,'Storage Management',0,(2470 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 104, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=104) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 104) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 104,1 
				INSERT INTO UMCategories 					
				VALUES(104,'Storage Management', @flags,(2470 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Storage Management',flags = @flags,messageId=(2470 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=104 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=107) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(107,'Global',0,(2474 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 107, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=107) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 107) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 107,1 
				INSERT INTO UMCategories 					
				VALUES(107,'Global', @flags,(2474 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Global',flags = @flags,messageId=(2474 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=107 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=105) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(105,'Monitoring Policy',0,(2482 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 105, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=105) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 105) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 105,1 
				INSERT INTO UMCategories 					
				VALUES(105,'Monitoring Policy', @flags,(2482 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Monitoring Policy',flags = @flags,messageId=(2482 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=105 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=114) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(114,'Developer Tools',0,(2710 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 114, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=114) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 114) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 114,1 
				INSERT INTO UMCategories 					
				VALUES(114,'Developer Tools', @flags,(2710 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Developer Tools',flags = @flags,messageId=(2710 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=114 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=106) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(106,'Workflow',0,(2483 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 106, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=106) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 106) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>114) 
			BEGIN 
				EXEC deleteCategoryTblScript 106,1 
				INSERT INTO UMCategories 					
				VALUES(106,'Workflow', @flags,(2483 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Workflow',flags = @flags,messageId=(2483 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=3 
				WHERE  id=106 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=110) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(110,'DataSource',0,(2570 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 110, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=110) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 110) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>114) 
			BEGIN 
				EXEC deleteCategoryTblScript 110,1 
				INSERT INTO UMCategories 					
				VALUES(110,'DataSource', @flags,(2570 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='DataSource',flags = @flags,messageId=(2570 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=3 
				WHERE  id=110 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=111) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(111,'Dataset',0,(2569 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 111, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=111) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 111) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>114) 
			BEGIN 
				EXEC deleteCategoryTblScript 111,1 
				INSERT INTO UMCategories 					
				VALUES(111,'Dataset', @flags,(2569 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Dataset',flags = @flags,messageId=(2569 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=3 
				WHERE  id=111 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=112) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(112,'Report',0,(2571 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 112, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=112) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 112) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>114) 
			BEGIN 
				EXEC deleteCategoryTblScript 112,1 
				INSERT INTO UMCategories 					
				VALUES(112,'Report', @flags,(2571 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Report',flags = @flags,messageId=(2571 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=3 
				WHERE  id=112 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=113) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(113,'Analytics',0,(2587 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 113, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=113) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 113) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 113,1 
				INSERT INTO UMCategories 					
				VALUES(113,'Analytics', @flags,(2587 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Analytics',flags = @flags,messageId=(2587 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=113 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=108) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(108,'Schedule Policy',0x1000,(2596 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 108, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=108) 
			DECLARE @flags INT 
			SET @flags = 0x1000		
			IF (0x1000 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 108) = 0	
				BEGIN	
					SET @flags = (0x1000 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 108,1 
				INSERT INTO UMCategories 					
				VALUES(108,'Schedule Policy', @flags,(2596 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Schedule Policy',flags = @flags,messageId=(2596 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=108 
			END 
		END 
	GO

DECLARE @flag INT = 0

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeType')

	BEGIN	

SET @flag = 0x1000

	END

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=117) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(117,'Alert',@flag,(2813 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 117, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=117) 
			DECLARE @flags INT 
			SET @flags = @flag		
			IF (@flag & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 117) = 0	
				BEGIN	
					SET @flags = (@flag & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 117,1 
				INSERT INTO UMCategories 					
				VALUES(117,'Alert', @flags,(2813 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Alert',flags = @flags,messageId=(2813 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=117 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=118) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(118,'Plan',0,(2835 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 118, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=118) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 118) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 118,1 
				INSERT INTO UMCategories 					
				VALUES(118,'Plan', @flags,(2835 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Plan',flags = @flags,messageId=(2835 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=118 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=115) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(115,'Features',0,(2800 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 115, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=115) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 115) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 115,1 
				INSERT INTO UMCategories 					
				VALUES(115,'Features', @flags,(2800 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Features',flags = @flags,messageId=(2800 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=115 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=116) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(116,'Access Policies',0,(2806 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 116, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=116) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 116) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 116,1 
				INSERT INTO UMCategories 					
				VALUES(116,'Access Policies', @flags,(2806 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Access Policies',flags = @flags,messageId=(2806 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=116 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=119) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(119,'VM Operations',0,(2957 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 119, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=119) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 119) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 119,1 
				INSERT INTO UMCategories 					
				VALUES(119,'VM Operations', @flags,(2957 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='VM Operations',flags = @flags,messageId=(2957 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=119 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=120) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(120,'Billing',0,(2990 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 120, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=120) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 120) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 120,1 
				INSERT INTO UMCategories 					
				VALUES(120,'Billing', @flags,(2990 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Billing',flags = @flags,messageId=(2990 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=120 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=130) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(130,'Data Cube',2,(2781 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 130, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=130) 
			DECLARE @flags INT 
			SET @flags = 2		
			IF (2 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 130) = 0	
				BEGIN	
					SET @flags = (2 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 130,1 
				INSERT INTO UMCategories 					
				VALUES(130,'Data Cube', @flags,(2781 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Data Cube',flags = @flags,messageId=(2781 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=130 
			END 
		END 
	GO

EXEC deleteCategoryTblScript 109,0 
		GO

DECLARE @flag1 INT = 0

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeType')

	BEGIN	

SET @flag1 = 0x1000

	END

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=121) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(121,'Subclient Policy',@flag1,(2562 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 121, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=121) 
			DECLARE @flags INT 
			SET @flags = @flag1		
			IF (@flag1 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 121) = 0	
				BEGIN	
					SET @flags = (@flag1 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 121,1 
				INSERT INTO UMCategories 					
				VALUES(121,'Subclient Policy', @flags,(2562 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Subclient Policy',flags = @flags,messageId=(2562 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=121 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=205) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(205,'Storage Provisioning',0,(3031 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 205, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=205) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 205) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 205,1 
				INSERT INTO UMCategories 					
				VALUES(205,'Storage Provisioning', @flags,(3031 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Storage Provisioning',flags = @flags,messageId=(3031 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=205 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=131) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(131,'Custom Property',0,(3102 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 131, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=131) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 131) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 131,1 
				INSERT INTO UMCategories 					
				VALUES(131,'Custom Property', @flags,(3102 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Custom Property',flags = @flags,messageId=(3102 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=131 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=133) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(133,'Credential Management',0,(3448 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 133, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=133) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 133) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 133,1 
				INSERT INTO UMCategories 					
				VALUES(133,'Credential Management', @flags,(3448 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Credential Management',flags = @flags,messageId=(3448 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=133 
			END 
		END 
	GO

--we cannot reuse the variable here because every NEW_ROW_IF_NOT_EXIST ends with a GO statement there by rendering the variables unusable after that 

DECLARE @flag INT = 0

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeType')

	BEGIN	

SET @flag = 0x1000

	END

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=122) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(122,'Client Group',@flag,(3109 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 122, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=122) 
			DECLARE @flags INT 
			SET @flags = @flag		
			IF (@flag & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 122) = 0	
				BEGIN	
					SET @flags = (@flag & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 122,1 
				INSERT INTO UMCategories 					
				VALUES(122,'Client Group', @flags,(3109 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Client Group',flags = @flags,messageId=(3109 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=122 
			END 
		END 
	GO

DECLARE @flag2 INT = 0

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeType')

	BEGIN	

SET @flag2 = 0x1000

	END

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=134) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(134,'Storage Policy Management',@flag2,(3477 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 134, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=134) 
			DECLARE @flags INT 
			SET @flags = @flag2		
			IF (@flag2 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 134) = 0	
				BEGIN	
					SET @flags = (@flag2 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 134,1 
				INSERT INTO UMCategories 					
				VALUES(134,'Storage Policy Management', @flags,(3477 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Storage Policy Management',flags = @flags,messageId=(3477 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=134 
			END 
		END 
	GO

-- Task entity for EDiscovery project

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=220) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(220,'EDiscoveryTask',0,(3472 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 220, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=220) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 220) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 220,1 
				INSERT INTO UMCategories 					
				VALUES(220,'EDiscoveryTask', @flags,(3472 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='EDiscoveryTask',flags = @flags,messageId=(3472 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=220 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=229) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(229,'CVApp',2,(3533 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 229, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=229) 
			DECLARE @flags INT 
			SET @flags = 2		
			IF (2 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 229) = 0	
				BEGIN	
					SET @flags = (2 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>114) 
			BEGIN 
				EXEC deleteCategoryTblScript 229,1 
				INSERT INTO UMCategories 					
				VALUES(229,'CVApp', @flags,(3533 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='CVApp',flags = @flags,messageId=(3533 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=3 
				WHERE  id=229 
			END 
		END 
	GO

-- Region entity for Plan based elastic storage project

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=136) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(136,'Region Management',0,(3751 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 136, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=136) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 136) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>0) 
			BEGIN 
				EXEC deleteCategoryTblScript 136,1 
				INSERT INTO UMCategories 					
				VALUES(136,'Region Management', @flags,(3751 | (CAST(POWER(2, 24) AS BIGINT) * 35)),0,2) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Region Management',flags = @flags,messageId=(3751 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=2 
				WHERE  id=136 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=230) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(230,'Table',0,(3591 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 230, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=230) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 230) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>114) 
			BEGIN 
				EXEC deleteCategoryTblScript 230,1 
				INSERT INTO UMCategories 					
				VALUES(230,'Table', @flags,(3591 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Table',flags = @flags,messageId=(3591 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=3 
				WHERE  id=230 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=231) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(231,'Application',0,(3584 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 231, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=231) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 231) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>114) 
			BEGIN 
				EXEC deleteCategoryTblScript 231,1 
				INSERT INTO UMCategories 					
				VALUES(231,'Application', @flags,(3584 | (CAST(POWER(2, 24) AS BIGINT) * 35)),114,3) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Application',flags = @flags,messageId=(3584 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=3 
				WHERE  id=231 
			END 
		END 
	GO

IF NOT EXISTS(SELECT * FROM UMCategories WHERE id=135) 
		BEGIN 
			INSERT INTO UMCategories 					
			VALUES(135,'Role',0,(3044 | (CAST(POWER(2, 24) AS BIGINT) * 35)),14,3) 
			IF (0 <> 0) 
			BEGIN 
				EXEC mapNewCategoryToOldPermissionTblScript 135, 0 
			END 
		END 
		ELSE 
		BEGIN 
			DECLARE @oldParentCategoryId INTEGER=( SELECT parentCategoryId FROM UMCategories WHERE id=135) 
			DECLARE @flags INT 
			SET @flags = 0		
			IF (0 & CAST(0x1000 AS INT) <> 0)		
			BEGIN	
				IF (SELECT flags & CAST(0x1000 AS INT) FROM UMCategories WHERE id = 135) = 0	
				BEGIN	
					SET @flags = (0 & (~(CAST(0x1000 AS INT))))		
				END	
			END				
			IF(@oldParentCategoryId<>14) 
			BEGIN 
				EXEC deleteCategoryTblScript 135,1 
				INSERT INTO UMCategories 					
				VALUES(135,'Role', @flags,(3044 | (CAST(POWER(2, 24) AS BIGINT) * 35)),14,3) 
			END 
			ELSE 
			BEGIN 
				UPDATE UMCategories 
				SET categoryName='Role',flags = @flags,messageId=(3044 | (CAST(POWER(2, 24) AS BIGINT) * 35)),hierarchyLevel=3 
				WHERE  id=135 
			END 
		END 
	GO

-- One time update to unhide Category, Features

DECLARE @unhideFeaturesGuid uniqueidentifier = '792D4602-4336-4A0B-BB73-D190FA4214EA'

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @unhideFeaturesGuid)

BEGIN

UPDATE UMCategories SET flags = 0 WHERE ID=115
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


    VALUES(@unhideFeaturesGuid , 'UnHide_Features_Category', 'UnHide Features Category', @nowTime, 16, 0 , (16 + 2))

END

-- One time update to unhide Category, Features

DECLARE @modifyCredentialPolicyName uniqueidentifier = '0AC12FC5-7130-4047-8369-913C63FE4BDB'

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @modifyCredentialPolicyName)

BEGIN

UPDATE UMCategories SET categoryName = 'Credential Management' WHERE ID=133
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


    VALUES(@modifyCredentialPolicyName , 'Rename Credential policy Name', 'Rename Credential policy name', @nowTime, 16, 0 , (16 + 2))

END

-- Remove deprecated category distribute storage

EXEC deleteCategoryTblScript 137,0 
		GO

-- Remove deprecated category Mobile Policy

EXEC deleteCategoryTblScript 132,0 
		GO
