

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMAssignCreateAlertPermission.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code.

-- ------------------------------------------------------------------------------------------------------*/

SET NOCOUNT ON

GO

DECLARE @AssignCreateAlertPermScriptExec INT = 0

SELECT

    @AssignCreateAlertPermScriptExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = 'F529888C-0324-457B-9426-E15987165CA4'

IF (@AssignCreateAlertPermScriptExec = 0)

BEGIN

	DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	DECLARE @userOrGroupIdTbl TABLE

	(

		userOrGroupId INT,

		isUser INT

	)
	INSERT INTO @userOrGroupIdTbl


		SELECT DISTINCT UMS.userOrGroupId, UMS.isUser

			FROM UMSecurityAssociations UMS

			INNER JOIN UMRolesWithPermissionsExpanded Roles

				ON UMS.roleId = Roles.roleId

AND Roles.permissionId = 18

WHERE (UMS.isUser = 1 AND UMS.userOrGroupId <> 1) OR (UMS.isUser = 0 AND UMS.userOrGroupId <> 1)			--If the user is admin user or userGroup is admin group (master group), then no need to assign the permissions explicitly

		UNION

		SELECT DISTINCT userOrGroupId, isUser

			FROM UMSecurityAssociations

WHERE permissionId = 18

AND ((isUser = 1 AND userOrGroupId <> 1) OR (isUser = 0 AND userOrGroupId <> 1))							--If the user is admin user or userGroup is admin group (master group), then no need to assign the permissions explicitly

DECLARE @alertCreatorRoleId INT = ISNULL((SELECT id FROM UMRoles WHERE name LIKE 'Alert Creator'), 0)

	IF @alertCreatorRoleId <> 0
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 


SELECT DISTINCT @alertCreatorRoleId, 0, Tbl.userOrGroupId, Tbl.isUser, 1, 2, 0, 1		--USE_MACRO

				FROM @userOrGroupIdTbl Tbl LEFT OUTER JOIN UMSecurityAssociations UMS

					ON Tbl.userOrGroupId = UMS.userOrGroupId

					AND Tbl.isUser = UMS.isUser

					AND UMS.roleId = @alertCreatorRoleId

AND UMS.entityType1 = 1

					AND UMS.entityId1 = 2

				WHERE UMS.userOrGroupId IS NULL

	ELSE
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 


SELECT DISTINCT 0, 151, Tbl.userOrGroupId, Tbl.isUser, 1, 2, 0, 1		--USE_MACRO

				FROM @userOrGroupIdTbl Tbl LEFT OUTER JOIN UMSecurityAssociations UMS

					ON Tbl.userOrGroupId = UMS.userOrGroupId

					AND Tbl.isUser = UMS.isUser

AND UMS.permissionId = 151

AND UMS.entityType1 = 1

					AND UMS.entityId1 = 2

				WHERE UMS.userOrGroupId IS NULL
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('F529888C-0324-457B-9426-E15987165CA4', 'AssignCreateAlertPermScriptExec', 'Assign Create Alert Permission to users and user groups having Alert Management Permission', @nowTime, 16, 0 , (16 + 1))

END

SET NOCOUNT OFF

GO

