

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_UpdateRestoreDestinationForReplications.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/TM_UpdateRestoreDestinationForReplications.script,v $ $Id: TM_UpdateRestoreDestinationForReplications.script,v 1.1.2.2 2019/12/12 22:39:22 vdevassy Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

declare @guid uniqueidentifier = '0C299446-16FE-419A-BBE2-6D1B2AAD13F8'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	IF object_id('tempdb.dbo.#completedPattern_initInfoTable') is not null 

		DROP TABLE #completedPattern_initInfoTable

	DECLARE @VSAREP_DELETED INT = 1

CREATE TABLE #completedPattern_initInfoTable(stId INT, tkId INT, patId INT, apId INT, scId INT, restoreSource NVARCHAR(1024) DEFAULT '', restoreDestination NVARCHAR(1024) DEFAULT '', restoreSourceIndex INT DEFAULT 0, replicationId INT DEFAULT 0)
	INSERT INTO #completedPattern_initInfoTable


	(stId , tkId , apId , scId , restoreSource, restoreSourceIndex)

	SELECT DISTINCT ST.subTaskId, ST.taskId, AE.apptypeId, AE.subclientId, 	fs.value('@val','NVARCHAR(MAX)'), 

	ROW_NUMBER() OVER (PARTITION BY ST.subTaskId ORDER BY (SELECT 1) ) as restoreSourceIndex

	FROM TM_SubTask ST WITH (NOLOCK)

	JOIN TM_Task T (NOLOCK) ON T.taskId = ST.taskId

	JOIN TM_AssocEntity AE WITH (NOLOCK) ON AE.taskId = ST.taskId

	JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = ST.subTaskId

	CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions/fileOption/sourceItem') F(fs)	

	INNER JOIN App_AppTypeGroupAssoc ON AE.apptypeId = App_AppTypeGroupAssoc.appTypeid AND App_AppTypeGroupAssoc.typeOfGroup = 0																		

	INNER JOIN App_AppTypeGroup ON App_AppTypeGroup.typeOfGroup = 0 AND

	App_AppTypeGroup.groupName='APPGRP_FileSystemIDA'

	AND App_AppTypeGroupAssoc.appGroupId = App_AppTypeGroup.appTypeGroupId

WHERE ST.operationType = 1007

	-- Update restore destination depending on the index of source. 

	UPDATE RI

	SET restoreDestination = DestItems.DestPAth

	FROM #completedPattern_initInfoTable RI

	INNER JOIN 

	(

		SELECT FSSubtasks.stId subTaskId, fs.value('@val','NVARCHAR(MAX)') as DestPath, ROW_NUMBER() OVER (PARTITION BY FSSubtasks.stId ORDER BY (SELECT 1) ) as SourceIndex

		FROM #completedPattern_initInfoTable FSSubtasks JOIN TM_SubTaskXMLOptions SO WITH (NOLOCK) ON SO.subTaskId = FSSubtasks.stId

		CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions/destination/destPath') F(fs)

	) DestItems ON DestItems.subTaskId = RI.stId AND RI.restoreSourceIndex = DestItems.SourceIndex	

	UPDATE #completedPattern_initInfoTable

	SET replicationId = T.repId

	FROM

	(

		SELECT taskId, subclientId, restoreSource resSource, replicationId repId

		FROM APP_LiveSyncReplication (NOLOCK) LS 

		-- Flags = 1 indicates replication pair deleted

		where (flags & @VSAREP_DELETED) = 0

	) T

	WHERE T.taskId = tkId	

	AND T.subclientId = scId		

	AND T.subclientId > 0

	AND ISNULL(T.resSource, '') = restoreSource

	UPDATE App_LiveSyncReplication

	SET restoreDestination = completedPattern_initInfoTable.restoreDestination

	FROM App_LiveSyncReplication INNER JOIN #completedPattern_initInfoTable completedPattern_initInfoTable

	ON App_LiveSyncReplication.replicationId = completedPattern_initInfoTable.replicationId

	AND completedPattern_initInfoTable.restoreDestination IS NOT NULL AND LEN(completedPattern_initInfoTable.restoreDestination)>0

	IF object_id('tempdb.dbo.#completedPattern_initInfoTable') is not null 

		DROP TABLE #completedPattern_initInfoTable
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'LiveSyncUpdateRestoreDestination', 'Update restore destination for FS live sync replications', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET NOCOUNT OFF

GO

