

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_UpdateExternalGroupId.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

----------------------------------------------------------------------------

-- Till 10.0 the external groups were stored in UMDSGroups. From 11.0, they 

-- are stored in UMGroups. So the existing groups will be migrated to UMGroups

-- The id value of the external groups present in the entries will be replaced

-- by the UMGroups.id value

----------------------------------------------------------------------------

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

DECLARE @isTranStarted INT = 0

DECLARE @errorCode INT = 0 

DECLARE @errorString NVARCHAR(MAX) = N''

BEGIN TRY

BEGIN TRAN

SET @isTranStarted = 1

DECLARE @ifAlreadyUpdated INTEGER=0

SET @ifAlreadyUpdated = ISNULL((SELECT TOP 1 CONVERT(INTEGER,value)from GXGlobalParam  where name like 'TMTables_UMDSGroupUpdated' and modified=0),0)

IF(@ifAlreadyUpdated=0)

BEGIN

DECLARE @jobOptionsId AS INT 

DECLARE @jobOptionsXML AS NVARCHAR(MAX)

DECLARE JobOptionsCursor CURSOR FOR 

	SELECT id, value  

	FROM TM_JobOptions 

	WHERE optionId IN (1081998262, 1065811864, 2143319884, 1998167144)

OPEN JobOptionsCursor 

FETCH NEXT FROM JobOptionsCursor INTO @jobOptionsId, @jobOptionsXML 

WHILE @@FETCH_STATUS = 0 

BEGIN

	DECLARE @var AS XML = CAST(@jobOptionsXML AS XML)

	DECLARE @userGroupName NVARCHAR(MAX) = N''

	DECLARE @providerID INT = 0

	DECLARE @userGroupId AS INT 

	SET @userGroupName = @var.value('(//./@userGroupName)[1]','nvarchar(max)')	

	IF CHARINDEX('\', @userGroupName) <= 0			

	BEGIN

		--accidentally stepped on simpana user group. Abort!!!

		FETCH NEXT FROM JobOptionsCursor INTO @jobOptionsId, @jobOptionsXML 

		CONTINUE

	END

	SET @providerID = ISNULL((SELECT id FROM UMDSProviders WITH (NOLOCK) WHERE domainName = SUBSTRING(@userGroupName, 1, CHARINDEX('\', @userGroupName)-1)), 0)

	IF @providerID = 0

	BEGIN

		--accidentally stepped on simpana user group. Abort!!!

		FETCH NEXT FROM JobOptionsCursor INTO @jobOptionsId, @jobOptionsXML 

		CONTINUE

	END

	SET @userGroupId = ISNULL((SELECT id FROM UMGroups WITH (NOLOCK) WHERE name = SUBSTRING(@userGroupName, CHARINDEX('\', @userGroupName)+1, LEN(@userGroupName)) AND umdsProviderId = @providerID), 0)

	SET @var.modify('replace value of (//./@userGroupId)[1] with sql:variable("@userGroupId")')

	UPDATE TM_JobOptions 

	SET value = CAST(@var AS NVARCHAR(MAX))

	WHERE id = @jobOptionsId 

	FETCH NEXT FROM JobOptionsCursor INTO @jobOptionsId, @jobOptionsXML 

END

CLOSE JobOptionsCursor

DEALLOCATE JobOptionsCursor

DECLARE @subTaskOptionsId AS INT 

DECLARE @subTaskOptionsXML AS NVARCHAR(MAX)

DECLARE subTaskOptionsCursor CURSOR FOR 

	SELECT id, value 

	FROM TM_SubTaskOptions 

	WHERE optionId IN (1081998262, 1065811864, 2143319884, 1998167144)

OPEN subTaskOptionsCursor

FETCH NEXT FROM subTaskOptionsCursor INTO @subTaskOptionsId, @subTaskOptionsXML

WHILE @@FETCH_STATUS = 0

BEGIN

	DECLARE @var1 AS XML = CAST(@subTaskOptionsXML AS XML)

	DECLARE @userGroupName1 NVARCHAR(MAX) = N''

	DECLARE @providerID1 INT = 0

	DECLARE @userGroupID1 INT = 0

	SET @userGroupName1 = @var1.value('(//./@userGroupName)[1]','nvarchar(max)')		

	IF CHARINDEX('\', @userGroupName1) <= 0			

	BEGIN

		--accidentally stepped on simpana user group. Abort!!!

		FETCH NEXT FROM subTaskOptionsCursor INTO @subTaskOptionsId, @subTaskOptionsXML

		CONTINUE

	END

	SET @providerID1 = ISNULL((SELECT id FROM UMDSProviders WITH (NOLOCK) WHERE domainName = SUBSTRING(@userGroupName1, 1, CHARINDEX('\', @userGroupName1)-1)), 0)

	IF @providerID1 = 0

	BEGIN

		--accidentally stepped on simpana user group. Abort!!!

		FETCH NEXT FROM subTaskOptionsCursor INTO @subTaskOptionsId, @subTaskOptionsXML

		CONTINUE

	END

	SET @userGroupId1 = ISNULL((SELECT id FROM UMGroups WITH (NOLOCK) WHERE name = SUBSTRING(@userGroupName1, CHARINDEX('\', @userGroupName1)+1, LEN(@userGroupName1)) AND umdsProviderId = @providerID1), 0)

	SET @var1.modify('replace value of (//./@userGroupId)[1] with sql:variable("@userGroupId1")')

	UPDATE TM_SubTaskOptions 

	SET value = CAST(@var1 AS NVARCHAR(MAX))

	WHERE id = @subTaskOptionsId 

	FETCH NEXT FROM subTaskOptionsCursor INTO @subTaskOptionsId, @subTaskOptionsXML

END

CLOSE subTaskOptionsCursor

DEALLOCATE subTaskOptionsCursor

IF OBJECT_ID ('tempdb.dbo.#subTasksWithExternalGroupEntity') IS NOT NULL

	DROP TABLE #subTasksWithExternalGroupEntity

--List of subtasks that have external groups entity

SELECT DISTINCT subTaskId 

	INTO #subTasksWithExternalGroupEntity

FROM TM_SubTaskOptions 

WHERE optionId IN (1081998262, 1065811864, 2143319884, 1998167144)

DECLARE @subTaskXMLOptionsId AS INT 

DECLARE @subTaskXMLOptionsXML AS XML

DECLARE subTaskXMLOptionsCursor CURSOR FOR 

	SELECT #subTasksWithExternalGroupEntity.subTaskId, TM_SubTaskXMLOptions.xmlValue 

	FROM #subTasksWithExternalGroupEntity INNER JOIN TM_SubTaskXMLOptions 

	ON #subTasksWithExternalGroupEntity.subTaskid = TM_SubTaskXMLOptions.subTaskId

OPEN subTaskXMLOptionsCursor

FETCH NEXT FROM subTaskXMLOptionsCursor INTO @subTaskXMLOptionsId, @subTaskXMLOptionsXML

WHILE @@FETCH_STATUS = 0 

BEGIN

		DECLARE @var3 AS XML = @subTaskXMLOptionsXML

		DECLARE @count AS INT 

		DECLARE @i AS INT 

		SET @count = @var3.value('count(//./externalUserGroups)', 'int')

		IF @count IS NULL

			SET @count = 0

		SET @i = 0 

		WHILE @i < @count 

		BEGIN

			SET @i = @i+1 

			DECLARE @tempUserGroupName1 NVARCHAR(MAX) = N''

			DECLARE @tempProviderId1 INT = 0

			DECLARE @tempUserGroupId1 INT = 0

			SET @tempUserGroupName1 = @var3.value('(((//./externalUserGroups)[sql:variable("@i")])/@userGroupName)[1]', 'nvarchar(max)')

			IF CHARINDEX('\', @tempUserGroupName1) <= 0			

			BEGIN

				--accidentally stepped on simpana user group. Abort!!!				

				CONTINUE

			END

			SET @tempProviderId1 = ISNULL((SELECT id FROM UMDSProviders WITH (NOLOCK) WHERE domainName = SUBSTRING(@tempUserGroupName1, 1, CHARINDEX('\', @tempUserGroupName1)-1)), 0)

			IF @tempProviderId1 = 0

			BEGIN

				--accidentally stepped on simpana user group. Abort!!!				

				CONTINUE

			END

			SET @tempUserGroupId1 = ISNULL((SELECT id FROM UMGroups WITH (NOLOCK) WHERE name = SUBSTRING(@tempUserGroupName1, CHARINDEX('\', @tempUserGroupName1)+1, LEN(@tempUserGroupName1)) AND umdsProviderId = @tempProviderId1), 0)

			SET @var3.modify('replace value of (((//./externalUserGroups)[sql:variable("@i")])/@userGroupId)[1] with sql:variable("@tempUserGroupId1")')

		END

		SET @count = 0 

		SET @i = 0 

		SET @count = @var3.value('count(//./emailExternalUserGroups)', 'int')

		IF @count IS NULL

			SET @count = 0

		SET @i = 0 

		WHILE @i < @count 

		BEGIN

			SET @i = @i+1 

			DECLARE @tempUserGroupName2 NVARCHAR(MAX) = N''

			DECLARE @tempProviderID2 INT = 0 

			DECLARE @tempUserGroupId2 INT = 0

			SET @tempUserGroupName2 = @var3.value('(((//./emailExternalUserGroups)[sql:variable("@i")])/@userGroupName)[1]', 'nvarchar(max)')

			IF CHARINDEX('\', @tempUserGroupName2) <= 0			

			BEGIN								

				--accidentally stepped on simpana user group. Abort!!!				

				CONTINUE

			END

			SET @tempProviderID2 = ISNULL((SELECT id FROM UMDSProviders WITH (NOLOCK) WHERE domainName = SUBSTRING(@tempUserGroupName2, 1, CHARINDEX('\', @tempUserGroupName2)-1)), 0)

			IF @tempProviderID2 = 0

			BEGIN

				--accidentally stepped on simpana user group. Abort!!!				

				CONTINUE

			END

			SET @tempUserGroupId2 = ISNULL((SELECT id FROM UMGroups WITH (NOLOCK) WHERE name = SUBSTRING(@tempUserGroupName2, CHARINDEX('\', @tempUserGroupName2)+1, LEN(@tempUserGroupName2)) AND umdsProviderId = @tempProviderID2), 0)

			SET @var3.modify('replace value of (((//./emailExternalUserGroups)[sql:variable("@i")])/@userGroupId)[1] with sql:variable("@tempUserGroupId2")')

		END

		SET @count = 0 

		SET @i = 0 

		SET @count = @var3.value('count(//./externalGroups)', 'int')

		IF @count IS NULL

			SET @count = 0

		SET @i = 0 

		WHILE @i < @count 

		BEGIN

			SET @i = @i+1 

			DECLARE @tempUserGroupName3 AS NVARCHAR(MAX) = N''

			DECLARE @tempProviderID3 AS INT = 0

			DECLARE @tempUserGroupId3 AS INT = 0

			SET @tempUserGroupName3 = @var3.value('(((//./externalGroups)[sql:variable("@i")])/@userGroupName)[1]', 'nvarchar(max)')

			IF CHARINDEX('\', @tempUserGroupName3) <= 0			

			BEGIN

				--accidentally stepped on simpana user group. Abort!!!				

				CONTINUE

			END

			SET @tempProviderID3 = ISNULL((SELECT id FROM UMDSProviders WITH (NOLOCK) WHERE domainName = SUBSTRING(@tempUserGroupName3, 1, CHARINDEX('\', @tempUserGroupName3)-1)), 0)

			IF @tempProviderID3 = 0

			BEGIN

				--accidentally stepped on simpana user group. Abort!!!				

				CONTINUE

			END

			SET @tempUserGroupId3 = ISNULL((SELECT id FROM UMGroups WITH (NOLOCK) WHERE name = SUBSTRING(@tempUserGroupName3, CHARINDEX('\', @tempUserGroupName3)+1, LEN(@tempUserGroupName3)) AND umdsProviderId = @tempProviderID3), 0)

			SET @var3.modify('replace value of (((//./externalGroups)[sql:variable("@i")])/@userGroupId)[1] with sql:variable("@tempUserGroupId3")')

		END

		UPDATE TM_SubTaskXMLOptions 

		SET xmlValue = @var3 

		WHERE subTaskId = @subTaskXMLOptionsId 

		FETCH NEXT FROM subTaskXMLOptionsCursor INTO @subTaskXMLOptionsId, @subTaskXMLOptionsXML	

END

CLOSE subTaskXMLOptionsCursor

DEALLOCATE subTaskXMLOptionsCursor

IF EXISTS(SELECT TOP 1 CONVERT(INTEGER,value)from GXGlobalParam  where name like 'TMTables_UMDSGroupUpdated' and modified=0)

       UPDATE GXGlobalParam

       SET value='1'

       WHERE name like 'TMTables_UMDSGroupUpdated' and modified=0

ELSE
       INSERT INTO GXGlobalParam


       VALUES('TMTables_UMDSGroupUpdated','1',datediff(second, '01/01/1970', GetUTCdate()),0)

END

IF OBJECT_ID ('tempdb.dbo.#subTasksWithExternalGroupEntity') IS NOT NULL

	DROP TABLE #subTasksWithExternalGroupEntity

END TRY

BEGIN CATCH 

	SET @errorCode = ERROR_NUMBER() 

	SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF @isTranStarted = 1

	IF @errorCode = 0

	BEGIN

		COMMIT TRAN

		PRINT 'Script completed successfully'

	END

	ELSE 	

	BEGIN

		ROLLBACK TRAN

		RAISERROR(@errorString, 16, 1)

	END

GO

SET NOCOUNT OFF

SET QUOTED_IDENTIFIER ON

