

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_Task.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/TM_Task.script,v $ $Id: TM_Task.script,v 1.13.274.4.8.1 2021/01/13 00:21:35 abilbrey Exp $";

DECLARE @currentTime INT = DATEDIFF(second, '01/01/1970', GETDATE())

IF not exists (select * from TM_Task where (taskName = 'Default' and defaultTask = 1))

BEGIN
	insert into TM_Task(taskName    ,


				   taskType		,

				   flags		,	

				   status		,	

				   created		,	

				   modified		,

				   alertId		,	

				   ownerId		,	

				   runUserId	,	

				   initiatedFrom,	

				   sequenceNumber,

				   localeId		,

				   description,

				   deleted,

				   disabled,

				   uninstalled,

				   invalid,

				   defaultTask,

				   savedReport,

				   serial,

				   policyType,

				   origCCId,

				   GUID,

				   isEZOperation,

				   isAgentlessSRM,	

				   hidden)	

			values ('Default',

					0,

0x10,

					8,

					0,

					0,

					0,

					1,

					1,

					0,

					0,

					0,

					'Default entry',

					0,

					0,

					0,

					0,

					1,

					0,

					0, 

					0,

					2,

					'',

					0,

					0,

					0)
	END
	IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'FE86B278-26F7-49A0-AABE-8923C23F555A')

	BEGIN

		--Deleting system created data analytics schedule as support exists for the same in post backup phase.

DECLARE @sysDATaskId INT = ISNULL((SELECT TOP 1 t.taskId FROM TM_Task T WHERE T.flags & (CAST(0x4 AS INT)| CAST(0x10000 AS INT)) = (CAST(0x4 AS INT)| CAST(0x10000 AS INT))),0)

		IF @sysDATaskId > 0

		BEGIN

			UPDATE TM_Task SET flags = 0, deleted = 1 WHERE taskId = @sysDATaskId

		END
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('FE86B278-26F7-49A0-AABE-8923C23F555A', 'DeleteSystemCreatedDATask', 'Deleting system created data analytics schedule', @currentTime, 16, 0, (16 + 2))

	END

DECLARE @guidPlanLogPolicy uniqueidentifier = '534FB819-D256-4C76-B969-1C4265BFA1CD'

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @guidPlanLogPolicy)

BEGIN

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @currentDate    DATETIME = GetUTCDate()

	DECLARE @userId     INTEGER

	DECLARE @l_taskId1      INTEGER

	DECLARE @l_subTaskId1   INTEGER

	DECLARE @l_patternId1   INTEGER

	DECLARE @xmlText        XML

	DECLARE @isTranStarted INT = 0

	SET @userId = (SELECT TOP(1) id FROM UMUSERS WHERE flags & 0x4 <> 0x4 AND flags & 0x40 = 0x40 )

	-- When this section executes it changed the schema of #TM_IDTable for the other Tbl Scripts to fail during dbupgrade due to the planId Column added!

	IF OBJECT_ID('tempdb.dbo.#TM_IDTable_Plan') IS NOT NULL

		DROP TABLE #TM_IDTable_Plan

	CREATE TABLE #TM_IDTable_Plan(id INT, planId INT, type INT)

	IF OBJECT_ID('tempdb.dbo.#PlanWithoutLog') IS NOT NULL

		DROP TABLE #PlanWithoutLog

	CREATE TABLE #PlanWithoutLog(planId INT, planName NVARCHAR(510))

	--Server Plan with schedule policy and without log schedule policy
	INSERT INTO #PlanWithoutLog


	SELECT PL.id, PL.name FROM App_Plan PL

	INNER JOIN APP_PlanProp PLP ON PLP.componentnameId = PL.id AND PLP.attrName = 'Schedule Policy'

	LEFT JOIN APP_PlanProp PLP1 on PLP1.componentnameId = PL.id AND PLP1.attrName = 'Log Schedule Policy'

	WHERE PL.subType = 33554437 AND PLP1.attrName IS NULL

	DECLARE @planId INT = 0

	DECLARE @planName NVARCHAR(510) =''

	BEGIN TRY

	IF @@TRANCOUNT = 0

	BEGIN

		BEGIN TRAN

		SET @isTranStarted = 1

	END

			DECLARE Log_schedule_creation CURSOR FOR   

			SELECT planId, planName FROM #PlanWithoutLog

			OPEN Log_schedule_creation  

			FETCH NEXT FROM Log_schedule_creation   

			INTO @planId, @planName

			WHILE @@FETCH_STATUS = 0  

			BEGIN 
				INSERT INTO TM_Task(taskName,


									taskType,

									flags,  

									status, 

									created,    

									modified,

									alertId,    

									ownerId,    

									runUserId,  

									initiatedFrom,  

									sequenceNumber,

									localeId,

									description,

									deleted,

									disabled,

									uninstalled,

									invalid,

									defaultTask,

									savedReport,

									serial,

									policyType,

									origCCId,

									GUID,

									isEZOperation,

									isAgentlessSRM,

									hidden)

						OUTPUT  INSERTED.taskId , @planId, 1 INTO #TM_IDTable_Plan    

						VALUES             (@planName+' Log schedule policy for the database clients',                             -- Task Name

4,             -- Task Type

536870912,        -- Task Flags

											0,                              -- Status

											@currentTime,                   -- Created

											0,                              -- Modified

											0,                              -- Alert ID

											@userId,                            -- Owner ID

											@userId,                            -- Run User ID

1,            -- Initiated From

											1,                              -- Seq No

											0,                              -- Locale ID

											'Schedule policy created automatically for '+@planName+' plan from script.',                             -- Description

											0,                              -- Deleted

											0,                              -- Disabled

											0,                              -- Uninstalled

											0,                              -- Invalid

											0,                              -- Default Task ???

											0,                              -- Saved Report

											0,                              -- Serial

											0,                              -- Policy Type

											DEFAULT,                        -- Original CC ID

											newid(),                        -- GUID

											0,                              -- isEZOperation

											0,                              -- isAgentlessSRM

											0)                              -- hidden

				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log schedule policy  -- Failed to insert in TM_Task'

					GOTO ERROR_EXIT

				END

				SET @l_taskId1 = (SELECT id FROM #TM_IDTable_Plan WHERE type = 1 and planId = @planId)
				INSERT INTO TM_AssocFilter(taskId,


										   filter_type,

										   filter_value,

										   flags) 

				VALUES

				( @l_taskId1,1,13,0)

				,( @l_taskId1,1,114,0)

				,( @l_taskId1,1,129,0)

				,( @l_taskId1,1,100,0)

				,( @l_taskId1,1,11,0)

				,( @l_taskId1,1,111,0)

				,( @l_taskId1,1,101,0)

				,( @l_taskId1,1,90,0)

				,( @l_taskId1,1,83,0)

				,( @l_taskId1,1,12,0)

				,( @l_taskId1,1,10,0)

				,( @l_taskId1,1,14,0)

				,( @l_taskId1,1,104,0)

				,( @l_taskId1,1,134,0)

				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log schedule policy  -- Failed to insert in TM_AssocFilter'

					GOTO ERROR_EXIT

				END

				--Inserting log schedule policy and log RPO into plan prop table
				INSERT INTO App_PlanProp (componentNameId,attrName,attrType,attrVal,created,modified)


VALUES (@planId,'Log schedule policy',7,@l_taskId1,@currentTime,0)

IF NOT EXISTS(SELECT 1 FROM APP_PlanProp WHERE componentnameId=@planId AND attrName='Log RPO In Minutes' and modified = 0)

				BEGIN
					INSERT INTO App_PlanProp (componentNameId,attrName,attrType,attrVal,created,modified)


SELECT @planId,'Log RPO In Minutes',7,'240',@currentTime,0

				END

IF NOT EXISTS(SELECT 1 FROM APP_PlanProp WHERE componentnameId=@planId AND attrName='Database Addon' and modified = 0)

				BEGIN
					INSERT INTO App_PlanProp (componentNameId,attrName,attrType,attrVal,created,modified)


SELECT @planId,'Database Addon',7,'1',@currentTime,0

				END

				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log schedule policy  -- Failed to insert in APP_PlanProp'

					GOTO ERROR_EXIT

				END	

				--Creating subtask
				INSERT INTO TM_SubTask (subTaskName,


										taskId,

										subTaskType ,   

										operationType,  

										flags       ,   

										subTaskOrder,

										deleted,

										uninstalled,

										defaultTask)

				OUTPUT  INSERTED.subTaskId , @planId, 2 INTO #TM_IDTable_Plan 

				VALUES                 ('Incremental automatic schedule for logs',           -- SubTask Name

										@l_taskId1,                 -- Task ID

2,        -- SubTask Type

2,   -- Operation Type

0x10000,      -- Flags

										0,                          -- SubTask Order

										0,                          -- Deleted

										0,                          -- Uninstalled

										0)                          -- Default Task ???

				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log schedule policy  -- Failed to insert in TM_SubTask'

					GOTO ERROR_EXIT

				END

				SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable_Plan WHERE type = 2 and planId = @planId)
				INSERT INTO TM_Pattern(name,


									   ownerId,

									   status,

									   flags,

									   freq_type,

									   freq_interval,

									   freq_relative_interval,

									   freq_recurrence_factor,

									   freq_subday_interval,

									   skipOccurence,

									   skipDayNumber,

									   active_start_date,

									   active_start_time,

									   active_end_date,

									   active_end_time,

									   active_end_occurence,

									   created,

									   modified,

									   tzId,

									   calendarId,

									   description,

									   local_start_date,

									   local_end_date,

									   disabled,

									   deleted,

									   scheduling,

									   freq_restart_interval)

				OUTPUT  INSERTED.patternId , @planId, 3 INTO #TM_IDTable_Plan                

				VALUES                ('',                          -- Name

									   @userId,                     -- Owner ID

									   0,                           -- Status

									   0,                           -- Flags

1024,              -- Freq Type

									   240,                           -- Freq Interval

									   0,                           -- Freq Relative Interval

									   0,                           -- Freq Recurrence Factor

									   0,                           -- Freq Subday Interval

									   0,                           -- Skip Occurrence

									   0,                           -- Skip Day Number

									   @currentDate,                -- Active Start Date

									   0,                       -- Active Start Time

									   '1970-01-01 00:00:00',       -- Active End Date  

									   0,                           -- Active End Time

									   0,                           -- Active End Occurrence

									   @currentTime,                -- Created

									   0,                           -- Modified

									   1000,                    -- Time Zone Id 

									   1,                           -- Calendar Id

									   '',                         -- Description

									   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date

									   0,                           -- Local End Date

									   0,                           -- Disabled

									   0,                           -- Deleted

									   0,                           -- Scheduling

									   0)                           -- freq_restart_interval

				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log schedule Policy -- Failed to insert in TM_Pattern '

					GOTO ERROR_EXIT

				END

				SET @l_patternId1 = (SELECT id FROM #TM_IDTable_Plan WHERE type = 3 and planId = @planId)

				-- Create Pattern Assoc
				INSERT INTO TM_PatternAssoc(patternId,


											subTaskId,

											flags,

											disabled,

											deleted,

											scheduling)

				VALUES                     (@l_patternId1,              -- Pattern ID

											@l_subTaskId1,              -- SubTask ID

											0,                          -- Flags

											0,                          -- Disabled

											0,                          -- Deleted

											0)                          -- Scheduling

				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log schedule Policy -- Failed to insert in TM_PatternAssoc '

					GOTO ERROR_EXIT

				END

				-- SubTask XML Options
				INSERT INTO TM_SubTaskXMLOptions(subTaskID,


												 xmlValue)

				VALUES (@l_subTaskId1,

						'<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" sybaseSkipFullafterLogBkp="0" backupLevel="2" incLevel="1" runIncrementalBackup="1" cumulative="0" doNotTruncateLog="0"><dataOpt useCatalogServer="1" followMountPoints="1" enforceTransactionLogUsage="0" skipConsistencyCheck="0" daysBetweenSyntheticBackup="7" autoCopy="0" /><oracleOptions><deleteArchLogOptions backupArchiveLogCriteria="0" /><backupArchLogOptions backupArchiveLogCriteria="7" startLSN="1" endLSN="1" backupArchiveLog="1" /></oracleOptions><distAppsBackupOptions runLogBkp="1" runDataBkp="0" /></backupOpts><commonOpts><perfJobOpts /><automaticSchedulePattern maxBackupInterval="4" sweepStartTime="86400" useStorageSpaceFromMA="0" minBackupIntervalMinutes="15" maxBackupIntervalMinutes="0" minBackupInterval="0"><logFileNum threshold="50" enabled="1" /><diskUsedPercent threshold="80" enabled="1" /><logPercent threshold="80" enabled="1" /></automaticSchedulePattern></commonOpts></TMMsg_JobOption>')

				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '

					GOTO ERROR_EXIT

				END

				-- SubTask Options
				INSERT INTO TM_SubTaskOptions(subTaskID, optionID,type,value)


				VALUES

				( @l_subTaskId1		,100003		,15	,'6296592')

				,( @l_subTaskId1		,100004		,1	,'1000000000100100000000000000000100000000000000000010010000000000010')

				,( @l_subTaskId1		,100005		,15	,'4')

				,( @l_subTaskId1		,120013		,7	,'-1')

				,( @l_subTaskId1		,140015		,1	,'1000000000100100000000000000000100000000000000000010010000000000010')

				,( @l_subTaskId1		,283876525	,14	,'1')

				,( @l_subTaskId1		,312510015	,0	,'1')

				,( @l_subTaskId1		,328378600	,8	,'50')

				,( @l_subTaskId1		,458405394	,7	,'2')

				,( @l_subTaskId1		,649116404	,0	,'1')

				,( @l_subTaskId1		,684987670	,0	,'0')

				,( @l_subTaskId1		,697451464	,0	,'0')

				,( @l_subTaskId1		,703512134	,8	,'4')

				,( @l_subTaskId1		,745665684	,7	,'86400')

				,( @l_subTaskId1		,756999446	,7	,'1')

				,( @l_subTaskId1		,785298690	,0	,'1')

				,( @l_subTaskId1		,790809039	,8	,'80')

				,( @l_subTaskId1		,810711461	,0	,'1')

				,( @l_subTaskId1		,974354278	,0	,'0')

				,( @l_subTaskId1		,987417213	,8	,'80')

				,( @l_subTaskId1		,1004091438	,0	,'1')

				,( @l_subTaskId1		,1013376701	,0	,'0')

				,( @l_subTaskId1		,1018794440	,7	,'0')

				,( @l_subTaskId1		,1110217321	,8	,'15')

				,( @l_subTaskId1		,1197257326	,0	,'0')

				,( @l_subTaskId1		,1201433539	,0	,'0')

				,( @l_subTaskId1		,1299309857	,0	,'0')

				,( @l_subTaskId1		,1349608518	,14	,'1')

				,( @l_subTaskId1		,1384124987	,8	,'0')

				,( @l_subTaskId1		,1403273817	,0	,'1')

				,( @l_subTaskId1		,1510569066	,0	,'1')

				,( @l_subTaskId1		,1611532840	,8	,'0')

				,( @l_subTaskId1		,1735011734	,0	,'0')

				,( @l_subTaskId1		,1765126965	,7	,'7')

				,( @l_subTaskId1		,1817749836	,0	,'1')

				,( @l_subTaskId1		,2000217775	,7	,'7')

				,( @l_subTaskId1		,2055741185	,0	,'0')

				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log Schedule Policy -- Failed to insert in TM_SubTaskOptions'

					GOTO ERROR_EXIT

				END
				INSERT INTO TM_JobOptions SELECT 0, optionId, type, value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0


				FROM TM_SubTaskOptions WITH(READUNCOMMITTED) 

WHERE subTaskId = @l_subTaskId1 AND optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)

				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log Schedule Policy-- Failed to insert in TM_JobOptions'

					GOTO ERROR_EXIT

				END

				SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WITH(READUNCOMMITTED) WHERE subTaskId = @l_subTaskId1)
				INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


				SET @errCode = @@ERROR

				IF  @errCode <> 0

				BEGIN

					SET @errStr = 'ERROR: Log Schedule Policy-- Failed to insert in TM_JobXMLOptions'

					GOTO ERROR_EXIT

				END

				FETCH NEXT FROM Log_schedule_creation   

				INTO @planId, @planName

			END

			IF @isTranStarted = 1

			BEGIN

				COMMIT TRAN

			END

			CLOSE Log_schedule_creation;  

			DEALLOCATE Log_schedule_creation;		

	END TRY

	BEGIN CATCH

		IF @isTranStarted = 1

		BEGIN

			ROLLBACK TRANSACTION;

		END

	END CATCH

	ERROR_EXIT:

	IF @@TRANCOUNT > 0 AND @isTranStarted = 1

	BEGIN

		ROLLBACK TRANSACTION;

	END

	IF OBJECT_ID('tempdb.dbo.#TM_IDTable_Plan') IS NOT NULL

		DROP TABLE #TM_IDTable_Plan

	IF OBJECT_ID('tempdb.dbo.#PlanWithoutLog') IS NOT NULL

		DROP TABLE #PlanWithoutLog

	PRINT 'Errorcode = '+CAST(@errCode AS nvarchar(10)) + ' Error= ' + @errStr
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guidPlanLogPolicy, 'Adding Log schedule policy to overridden plan', 'Adding support for Log schedule policy when RPO on derived plan is overidden', @currentTime, 16, 0, (16 + 2))

END

