

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_SubTaskXMLOptions_LiveSync.script] ---------- 


SET QUOTED_IDENTIFIER OFF

set nocount on

SET ANSI_PADDING ON

GO

SET ARITHABORT ON

GO

SET QUOTED_IDENTIFIER ON

GO

IF NOT EXISTS (	SELECT	* FROM GXGlobalParam WITH(NOLOCK) WHERE name='EnableValidationOnLiveSync' and value=1)

BEGIN

BEGIN TRY

BEGIN TRAN

DECLARE @subTaskId  INT = 0

DECLARE @xmlValue XML

DECLARE subTaskReportCursor CURSOR FOR

SELECT subTaskId FROM TM_SubTask WHERE operationType=1007

OPEN subTaskReportCursor

FETCH FROM subTaskReportCursor INTO @subTaskId

WHILE @@FETCH_STATUS = 0

BEGIN

    --GET XML OPTIONS

    SELECT @xmlValue=xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @subTaskId

    --SET VALUE IN XML OPTION

    IF (@xmlValue.exist('//diskLevelVMRestoreOption[@powerOnVmAfterRestore="0"]')) = 1

    BEGIN

        SET @xmlValue.modify('replace value of (//diskLevelVMRestoreOption/@powerOnVmAfterRestore)[1] with "1"')

        --UPDATE THE XML OPTION

        UPDATE TM_SubTaskXMLOptions SET xmlValue=@xmlValue WHERE subTaskId=@subTaskId

        --UPDATE THE XML OPTION

        UPDATE TM_JobXMLOptions SET xmlValue=@xmlValue WHERE subTaskId=@subTaskId AND jobId = 0

        --SET SUBTASK OPTION        

        UPDATE TM_SubTaskOptions SET value = 1 WHERE optionId = 712784058 AND subTaskId = @subTaskId

        --SET JOB OPTION

        UPDATE TM_JobOptions SET value = 1 WHERE optionId = 712784058 AND subTaskId = @subTaskId AND jobId = 0

	END

    FETCH FROM subTaskReportCursor INTO @subTaskId

END

CLOSE subTaskReportCursor

DEALLOCATE subTaskReportCursor

    COMMIT TRAN

	DECLARE @nowTime int

	Set     @nowTime =  datediff(second, '01/01/1970', GetUTCdate())
	INSERT INTO GXGlobalParam (name, value, created, modified) VALUES('EnableValidationOnLiveSync', 1, @nowTime, @nowTime)


END TRY

BEGIN CATCH

    DECLARE @o_errorCode INT

    DECLARE @tmpErrorString NVARCHAR

    -- Call procedure to print error information.

    -- Call procedure to get error information.

    EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT

    PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

    --Close cursor

    IF ( CURSOR_STATUS('global', 'subTaskReportCursor') >= 0  /* cursor is open */ 

        OR CURSOR_STATUS('local', 'subTaskReportCursor') >= 0 ) 

    CLOSE subTaskReportCursor 

    IF ( CURSOR_STATUS('global','subTaskReportCursor') = -1  /* cursor is closed */ 

        OR CURSOR_STATUS('local','subTaskReportCursor') = -1 ) 

    DEALLOCATE subTaskReportCursor 

    -- Rollback any active or uncommittable transactions before

    -- inserting information in the ErrorLog

    IF XACT_STATE() <> 0

    BEGIN

    PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

        ROLLBACK TRANSACTION;

    END

 END CATCH;

END


