

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_SubTaskXMLOptions_IndexServer.script] ---------- 


SET QUOTED_IDENTIFIER OFF

--TM_SubTaskXMLOptions_IndexServer

set nocount on

SET ANSI_PADDING ON

GO

SET ARITHABORT ON

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @maToIndexServerUpgrade INT = 0

DECLARE @maToIndexServerVersion varchar(36) = 'E8D98049-2755-4F0E-9B33-58298BA80A70'

SELECT @maToIndexServerUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @maToIndexServerVersion

IF (@maToIndexServerUpgrade = 0)            -- not done, do the db upgrade

BEGIN   

BEGIN TRY

BEGIN TRAN

	--

	DECLARE @optionsTbl TABLE (t_optionId INT) 
	INSERT INTO @optionsTbl 


	VALUES (2101836446), --INDEXSERVER_CLIENT_ID

		(1230345038)	--INDEXSERVER_CLIENT_NAME

	IF OBJECT_ID('tempdb.dbo.#AnalyticsTask') IS NOT NULL DROP TABLE #AnalyticsTask

	CREATE TABLE #AnalyticsTask (t_taskId INT, t_subTaskId INT, t_indexSvrClientId INT DEFAULT 0, t_indexSvrClientName NVARCHAR(255) DEFAULT N'', t_xmlValue XML PRIMARY KEY (t_subTaskId))

	--GET ALL ANALYTICS SCHEDULES
	INSERT INTO #AnalyticsTask (t_taskId, t_subTaskId, t_xmlValue)


	SELECT taskId, S.subTaskId, ST.xmlValue

	FROM TM_SubTask S (NOLOCK)

	JOIN TM_SubTaskXMLOptions ST (NOLOCK) ON ST.subTaskId = S.subTaskId

	WHERE S.operationType =4022 AND ISNULL(ST.xmlValue.value('(/TMMsg_JobOption/adminOpts/contentIndexingOption/indexServer/@clientId)[1]', 'int'),0) =0

	--GET INDEX SERVER FOR ASSOCIATED MA

	UPDATE #AnalyticsTask

	SET t_indexSvrClientId = C.ID,

		t_indexSvrClientName = C.name

	FROM #AnalyticsTask

	JOIN TM_SubTaskOptions O (NOLOCK) ON t_subTaskId = O.subTaskId

	JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.ClientId = CAST (O.value AS INT) AND S.cloudType IN (1,4,5) --App::CloudServerType_AnalyticsEngine, SolrEmbeddedCloud, SolrClusterCloud

	JOIN DM2Cloud DC (NOLOCK) ON DC.cloudId =S.CloudId AND DC.cloudType IN (1,4,5) --App::CloudServerType_AnalyticsEngine, SolrEmbeddedCloud, SolrClusterCloud

	JOIN APP_Client C (NOLOCK) ON DC.pseudoClientId = C.id

	WHERE O.optionId = 1166985790  --CONTENTINDEXINGOPTION_MEDIAAGENT_MEDIA_AGENT_ID

	DECLARE @subTaskId INT

	DECLARE @indexSvrClientId INT

	DECLARE @indexSvrClientName NVARCHAR(255)

	DECLARE @indexServerXML XML

	-- Tbl script file should not have any function calls because they may not exist during upgrade

	DECLARE @now INT = datediff(second, '01/01/1970', getUTCDate())

	--UPDATE XML OPTION

	DECLARE subTaskAnalyticsCursor CURSOR FOR

		SELECT t_subTaskId, t_indexSvrClientId, t_indexSvrClientName FROM #AnalyticsTask WHERE t_indexSvrClientId != 0

	OPEN subTaskAnalyticsCursor

	FETCH FROM subTaskAnalyticsCursor INTO @subTaskId, @indexSvrClientId, @indexSvrClientName

	WHILE @@FETCH_STATUS = 0

	BEGIN

		--UPDATE XML OPTIONS		

		SET @indexServerXML ='<indexServer type="0" _type_="3"  clientId="'+ cast (@indexSvrClientId as varchar(10)) +'"' +' clientName="' + @indexSvrClientName +'"/>'

		UPDATE #AnalyticsTask

		SET t_xmlValue.modify('insert sql:variable ("@indexServerXML") into (/TMMsg_JobOption/adminOpts/contentIndexingOption)[1]')

		WHERE t_subTaskId = @subTaskId

		FETCH FROM subTaskAnalyticsCursor INTO  @subTaskId, @indexSvrClientId, @indexSvrClientName

	END

	CLOSE subTaskAnalyticsCursor

	DEALLOCATE subTaskAnalyticsCursor	

	--TM_SubTaskXMLOptions

	UPDATE TM_SubTaskXMLOptions 

	SET xmlValue= t_xmlValue

	FROM #AnalyticsTask

	WHERE subTaskId=t_subTaskId AND ISNULL(xmlValue.value('(/TMMsg_JobOption/adminOpts/contentIndexingOption/indexServer/@clientId)[1]', 'int'),0) =0

	--TM_JobXMLOptions

	UPDATE TM_JobXMLOptions 

	SET xmlValue=t_xmlValue 

	FROM #AnalyticsTask

	WHERE subTaskId=t_subTaskId AND jobId = 0 AND ISNULL(xmlValue.value('(/TMMsg_JobOption/adminOpts/contentIndexingOption/indexServer/@clientId)[1]', 'int'),0) =0

	--TM_SubTaskOptions       		
	INSERT INTO TM_SubTaskOptions ( subTaskId , optionId, type , value)


	SELECT t_subTaskId, t_optionId, (CASE WHEN t_optionId = 1230345038 THEN 1 ELSE 7 END),  (CASE WHEN t_optionId = 1230345038 THEN t_indexSvrClientName ELSE CAST (t_indexSvrClientId AS VARCHAR(10)) END)

	FROM #AnalyticsTask

	CROSS JOIN @optionsTbl

	WHERE NOT EXISTS (SELECT 1 FROM TM_SubTaskOptions (NOLOCK) WHERE optionId = t_optionId AND subTaskId = t_subTaskId)

	--TM_JobOptions
	INSERT INTO TM_JobOptions ( jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)


	SELECT 0, t_optionId, (CASE WHEN t_optionId = 1230345038 THEN 1 ELSE 7 END), 

			(CASE WHEN t_optionId = 1230345038 THEN t_indexSvrClientName ELSE CAST (t_indexSvrClientId AS VARCHAR(10)) END) , t_taskId, t_subTaskId,0, @now,0

	FROM #AnalyticsTask

	CROSS JOIN @optionsTbl

	WHERE NOT EXISTS (SELECT 1 FROM TM_JobOptions (NOLOCK) WHERE optionId = t_optionId AND subTaskId = t_subTaskId)

	--
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@maToIndexServerVersion, 'SCPMAtoIndexServerUpgrade', 'Change MA name to Index server', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN	

	END TRY

	BEGIN CATCH		

		--Close cursor

		IF ( CURSOR_STATUS('global', 'subTaskAnalyticsCursor') >= 0  /* cursor is open */ 

			OR CURSOR_STATUS('local', 'subTaskAnalyticsCursor') >= 0 ) 

		CLOSE subTaskAnalyticsCursor 

		IF ( CURSOR_STATUS('global','subTaskAnalyticsCursor') = -1  /* cursor is closed */ 

			OR CURSOR_STATUS('local','subTaskAnalyticsCursor') = -1 ) 

		DEALLOCATE subTaskAnalyticsCursor 

		-- Rollback any active or uncommittable transactions before

		-- inserting information in the ErrorLog

		IF XACT_STATE() <> 0

		BEGIN		

			ROLLBACK TRANSACTION;

		END

		DECLARE @errStr nvarchar(max)                   

        SET @errStr = N'Failed to upgrade analytics schedule to use index server. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')                    

        RAISERROR(@errStr, 16, 1)  

	 END CATCH;

END

