

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_SubTaskXMLOptions_CatalogPhase.script] ---------- 


SET QUOTED_IDENTIFIER OFF

--TM_SubTaskXMLOptions_CatalogPhase

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

DECLARE @currentTime INT = DATEDIFF(second, '01/01/1970', GETDATE())

DECLARE @STXOCatalogPhaseGuid    VARCHAR(40) = '833D580B-D592-4425-BFF4-13691D492B9E'

DECLARE @csV11InstallTime INT

DECLARE @csInstallTimeBeforeSP13 DATETIME

DECLARE @csInstallTimeBeforeSP13Unix INT

SELECT @csV11InstallTime = attrval FROM APP_ClientProp (NOLOCK) WHERE componentNameId = 2 AND attrName = 'Release 11' AND modified = 0

SET @csInstallTimeBeforeSP13 = ISNULL((SELECT TOP 1 MAX(optime) FROM PatchInstallHistory (NOLOCK) WHERE ClientID = 2 and OpTime > dbo.GetDateTime(@csV11InstallTime) AND HighestSP <= 12),dbo.GetDateTime(@csV11InstallTime))

SET @csInstallTimeBeforeSP13Unix = dbo.GetUnixTime(@csInstallTimeBeforeSP13)

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @STXOCatalogPhaseGuid)

BEGIN

BEGIN TRY

	BEGIN TRAN

    if object_id('tempdb.dbo.#subTasks') is not null

	DROP TABLE #subTasks

    CREATE TABLE #subTasks (

        subTaskId INT PRIMARY KEY,

		taskId INT,

        xmlValue XML )
    INSERT INTO #subTasks


    SELECT STXO.subTaskId, T.taskId, STXO.xmlValue FROM TM_SubTaskXMLOptions STXO

    INNER JOIN TM_Subtask ST ON ST.subTaskId = STXO.subTaskId

	INNER JOIN TM_Task T ON T.taskId = ST.taskId

	INNER JOIN TM_SubTaskOptions STO ON STO.subTaskId = ST.subTaskId

    WHERE STXO.xmlValue.exist('/TMMsg_JobOption[1]/backupOpts[1]/dataOpt') = 1

    AND ST.operationType = 2 --Backup

	AND ST.subTaskType = 2	 --Backup

    AND STXO.xmlValue.exist('/TMMsg_JobOption[1]/backupOpts[1]/dataOpt[1]/@skipCatalogPhaseForSnapBackup') <> 1

	AND STO.optionId = 458405394 --Backup Level

	AND STO.value <> '4' --synthetic Full

	AND T.created < @csInstallTimeBeforeSP13Unix

    UPDATE TM_SubTaskXMLOptions

    SET xmlValue.modify('insert (attribute skipCatalogPhaseForSnapBackup {0}) into (/TMMsg_JobOption[1]/backupOpts[1]/dataOpt)[1]')

    FROM TM_SubTaskXMLOptions

    INNER JOIN #subTasks ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

	 -- Age of job XML options

    UPDATE TM_JobXMLOptions 

    SET modified = @currentTime 

     FROM TM_JobXMLOptions

     INNER JOIN #subTasks ST ON 

     ST.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0
    INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


    SELECT 0,STXO.xmlValue,ST.taskId,ST.subTaskId,0,@currentTime, 0

      FROM #subTasks ST

      INNER JOIN TM_SubTaskXMLOptions STXO ON ST.subTaskId = STXO.subTaskId

    -- Age of job options

    UPDATE TM_JobOptions 

    SET modified = @currentTime

    FROM TM_JobOptions

    INNER JOIN #subTasks ST ON 

    ST.subTaskId = TM_JobOptions.subTaskId

    AND TM_JobOptions.optionID = 428058421 /*DATABKPOTION_SKIP_CATALOG_PHASE_FOR_SNAP_BACKUP*/

    AND TM_JobOptions.modified = 0

    AND TM_JobOptions.jobId = 0
    INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)


    SELECT 0,428058421/*DATABKPOTION_SKIP_CATALOG_PHASE_FOR_SNAP_BACKUP*/, 0, '0', T.taskId, ST.subTaskId,0,@currentTime,0

    FROM #subTasks ST    

    INNER JOIN TM_Subtask T ON ST.subTaskId = T.subTaskId
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@STXOCatalogPhaseGuid, 'Skip catalog phase for snap', 'Table script to upgrade backup schedules to have default skip catalog phase for snap', @currentTime,  16, 0, (16 + 2))

	COMMIT TRAN	

	END TRY

	BEGIN CATCH	

		-- Rollback any active or uncommittable transactions before

		-- inserting information in the ErrorLog

		IF XACT_STATE() <> 0

		BEGIN		

			ROLLBACK TRANSACTION;

		END

		DECLARE @errStr nvarchar(max)                   

        SET @errStr = N'Failed to upgrade schedules to skip catalog phase. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')                    

        RAISERROR(@errStr, 16, 1)  

	END CATCH;

	if object_id('tempdb.dbo.#subTasks') is not null

	DROP TABLE #subTasks

END

