

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_SubTaskXMLOptions.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

--TM_SubTaskXMLOptions

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

DECLARE @currentTime INT = DATEDIFF(second, '01/01/1970', GETDATE())

DECLARE @IncrementalWithLogsUpgrade    VARCHAR(40) = '2C15A0D3-28EB-4B0C-B879-48D533B320BB'

DECLARE @errStr nvarchar(max)                   

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @IncrementalWithLogsUpgrade)

BEGIN

BEGIN TRY

	BEGIN TRAN

    if object_id('tempdb.dbo.#IncrSubTasks') is not null

	DROP TABLE #IncrSubTasks

    CREATE TABLE #IncrSubTasks (

        subTaskId INT PRIMARY KEY,

		taskId INT,

        xmlValue XML )
    INSERT INTO #IncrSubTasks


    SELECT DISTINCT STXO.subTaskId, T.taskId, '' FROM TM_SubTaskXMLOptions STXO

    INNER JOIN TM_Subtask ST ON ST.subTaskId = STXO.subTaskId

	INNER JOIN TM_Task T ON T.taskId = ST.taskId

INNER JOIN App_PlanProp PP ON PP.attrVal = CAST(T.taskId AS NVARCHAR(2048)) AND PP.attrName = 'Schedule policy' AND PP.modified = 0

INNER JOIN App_Plan P ON P.id = PP.componentNameId AND P.subType = 33554437

	INNER JOIN TM_SubTaskOptions STO ON STO.subTaskId = ST.subTaskId

    WHERE STXO.xmlValue.exist('/TMMsg_JobOption[1]/backupOpts') = 1

    AND ST.operationType = 2 --Backup

	AND ST.subTaskType = 2	 --Backup

    AND STXO.xmlValue.exist('/TMMsg_JobOption[1]/backupOpts[1]/@incrementalDataWithLogs') <> 1

	AND STO.optionId = 458405394 --Backup Level

	AND STO.value = '2' --Incremental

	UPDATE incrSubTasks

	SET incrSubTasks.xmlValue = STXO.xmlValue

	FROM #incrSubTasks incrSubTasks INNER JOIN TM_SubTaskXMLOptions STXO ON STXO.subTaskId = incrSubTasks.subTaskId

    UPDATE TM_SubTaskXMLOptions

    SET xmlValue.modify('insert (attribute incrementalDataWithLogs {1}) into (/TMMsg_JobOption[1]/backupOpts)[1]')

    FROM TM_SubTaskXMLOptions

    INNER JOIN #IncrSubTasks ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

	UPDATE TM_SubTaskXMLOptions

    SET xmlValue.modify('replace value of (/TMMsg_JobOption[1]/backupOpts[1]/@runIncrementalBackup)[1] with "0"')

    FROM TM_SubTaskXMLOptions

    INNER JOIN #IncrSubTasks ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

	 -- Age of job XML options

    UPDATE TM_JobXMLOptions 

    SET modified = @currentTime 

     FROM TM_JobXMLOptions

     INNER JOIN #IncrSubTasks ST ON 

     ST.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0
    INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


    SELECT 0,STXO.xmlValue,ST.taskId,ST.subTaskId,0,@currentTime, 0

      FROM #IncrSubTasks ST

      INNER JOIN TM_SubTaskXMLOptions STXO ON ST.subTaskId = STXO.subTaskId

	--Subtask Options

	UPDATE TM_SubtaskOptions 

    SET value = '0'

    FROM TM_SubtaskOptions

    INNER JOIN #IncrSubTasks ST ON 

    ST.subTaskId = TM_SubtaskOptions.subTaskId

    AND TM_SubtaskOptions.optionID = 312510015 /*BACKUPOPTION_RUN_INCREMENTAL_BACKUP*/

    AND TM_SubtaskOptions.value = '1'

	--Insert into Subtask Options
	INSERT INTO TM_SubtaskOptions(subTaskId, optionId, type, value)


    SELECT ST.subTaskId,1505355145/*BACKUPOPTION_INCREMENTAL_DATA_WITH_LOGS*/, 0, '1'

    FROM #IncrSubTasks ST    

    INNER JOIN TM_Subtask T ON ST.subTaskId = T.subTaskId

    -- Age of job options

    UPDATE TM_JobOptions 

    SET modified = @currentTime

    FROM TM_JobOptions

    INNER JOIN #IncrSubTasks ST ON 

    ST.subTaskId = TM_JobOptions.subTaskId

    AND TM_JobOptions.optionID = 1505355145 /*BACKUPOPTION_INCREMENTAL_DATA_WITH_LOGS*/

    AND TM_JobOptions.modified = 0

    AND TM_JobOptions.jobId = 0

	UPDATE TM_JobOptions 

    SET modified = @currentTime

    FROM TM_JobOptions

    INNER JOIN #IncrSubTasks ST ON 

    ST.subTaskId = TM_JobOptions.subTaskId

    AND TM_JobOptions.optionID = 312510015 /*BACKUPOPTION_RUN_INCREMENTAL_BACKUP*/

    AND TM_JobOptions.modified = 0

    AND TM_JobOptions.jobId = 0
    INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)


    SELECT 0,312510015/*BACKUPOPTION_RUN_INCREMENTAL_BACKUP*/, 0, '0', ST.taskId, ST.subTaskId,0,@currentTime,0

    FROM #IncrSubTasks ST    

	UNION ALL

	SELECT 0,1505355145/*BACKUPOPTION_INCREMENTAL_DATA_WITH_LOGS*/, 0, '1', ST.taskId, ST.subTaskId,0,@currentTime,0

    FROM #IncrSubTasks ST    
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@IncrementalWithLogsUpgrade, 'Incremental data with logs option on schedules', 'Table script to upgrade incremental backup schedules to have incrementalDataWithLogs option', @currentTime,  16, 0, (16 + 2))

	COMMIT TRAN	

	END TRY

	BEGIN CATCH	

		-- Rollback any active or uncommittable transactions before

		-- inserting information in the ErrorLog

		IF XACT_STATE() <> 0

		BEGIN		

			ROLLBACK TRANSACTION;

		END

		SET @errStr = N'Failed to upgrade schedules to include incremental with logs option. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')                    

        RAISERROR(@errStr, 16, 1)  

	END CATCH;

	if object_id('tempdb.dbo.#IncrSubTasks') is not null

	DROP TABLE #IncrSubTasks

END

--Insert emailUSername,emailUserGroupName and externalEmailUSername,externalEmailUserGroupName

    IF OBJECT_ID('tempdb.dbo.#tempSubtaskXML') IS NOT NULL  DROP TABLE #tempSubtaskXML

    CREATE TABLE #tempSubtaskXML(subtaskid int,xmlStr xml)
    INSERT INTO #tempSubtaskXML


        SELECT results.subtaskid,results.xmlValue FROM TM_SubTaskXMLOptions results

        CROSS apply results.xmlValue.nodes('/TMMsg_JobOption/adminOpts/reportOption/commonOpt') AS csInfo(n)

        INNER JOIN  TM_SUBTASK TS ON TS.subtaskId = results.subtaskID 

        INNER JOIN  TM_Task TT ON TS.taskId = TT.taskID  

        WHERE results.xmlValue.exist('/TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailUsers') = 1 

              OR results.xmlValue.exist('/TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailUserGroups') = 1

              OR results.xmlValue.exist('/TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailExternalUsers') = 1

              OR results.xmlValue.exist('/TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailExternalUserGroups') = 1 

              and TT.deleted = 0 and TT.tasktype = 2

    IF OBJECT_ID('tempdb.dbo.#tempEmailUser') IS NOT NULL  DROP TABLE #tempEmailUser

    CREATE TABLE #tempEmailUser(subtaskid int,emailUsertype int,emailUserId int,emailUserName nvarchar(255),userType int) 

    --userType = 1 : external user,0:internal
    INSERT INTO #tempEmailUser(subtaskid,emailUsertype,emailUserId,emailUserName,userType)


        SELECT results.subtaskid,csInfo.n.value('@_type_','int'),csInfo.n.value('@userId','int'),-- as 'UserId',

        UM.login,0

        FROM #tempSubtaskXML results

        CROSS apply results.xmlStr.nodes('/TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailUsers') AS csInfo(n)

        INNER JOIN UMUsers UM on UM.id=csInfo.n.value('@userId','int')

        UNION

        SELECT results.subtaskid,extcsInfo.n.value('@_type_','int'),extcsInfo.n.value('@userId','int'),-- as 'UserId',

        UM.login,1

        FROM #tempSubtaskXML results

        CROSS apply results.xmlStr.nodes('/TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailExternalUsers') AS extcsInfo(n)

        INNER JOIN UMUsers UM on UM.id=extcsInfo.n.value('@userId','int')

    IF OBJECT_ID('tempdb.dbo.#tempEmailUserGroup') IS NOT NULL  DROP TABLE #tempEmailUserGroup

    --userGroupType = 1 : external usergroup,0:internal

    CREATE TABLE #tempEmailUserGroup(subtaskid int,emailUserGroupType int, emailUserGroupId int,emailUserGroupName nvarchar(255),userGroupType int)
        INSERT INTO #tempEmailUserGroup(subtaskid,emailUserGroupType,emailUserGroupId,emailUserGroupName,userGroupType)


            SELECT results.subtaskid,csInfo.n.value('@_type_','int'),csInfo.n.value('@userGroupId','int'), --as 'UserGroupId',

            UMg.name,0

            FROM #tempSubtaskXML results

            CROSS apply results.xmlStr.nodes('/TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailUserGroups') AS csInfo(n)

            INNER JOIN UMGroups UMg on UMg.id=csInfo.n.value('@userGroupId','int')

            UNION

            SELECT results.subtaskid,extcsInfo.n.value('@_type_','int'),extcsInfo.n.value('@userGroupId','int'), --as 'UserGroupId',

            UMg.name,1

            FROM #tempSubtaskXML results

            CROSS apply results.xmlStr.nodes('/TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailExternalUserGroups') AS extcsInfo(n)

            INNER JOIN UMGroups UMg on UMg.id=extcsInfo.n.value('@userGroupId','int')

    DECLARE @row INT = 0

    DECLARE @row_cnt INT = (SELECT COUNT(*) FROM #tempSubtaskXML)

    WHILE(@row < @row_cnt)

    BEGIN

        DECLARE @Id INT ,@xml xml;

        SELECT TOP 1 @id = subtaskId ,@xml = xmlStr FROM #tempSubtaskXML ORDER BY subtaskid

        --Add email username to the subtask XML

        SET @xml.modify('delete /TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailUsers')

        DECLARE @emailUsersNodeWithNames xml =(select emailUsertype as '@_type_',emailUserId as '@userId', emailUserName as '@userName' from #tempEmailUser where subtaskid=@Id and userType=0 for xml PATH('emailUsers'))

        SET @xml.modify('insert sql:variable("@emailUsersNodeWithNames") into (/TMMsg_JobOption/adminOpts/reportOption/commonOpt)[1]')

        --Add External email username to the subtask XML

        SET @xml.modify('delete /TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailExternalUsers')

        DECLARE @extEmailUsersNodeWithNames xml =(select emailUsertype as '@_type_',emailUserId as '@userId', emailUserName as '@userName' from #tempEmailUser where subtaskid=@Id and userType=1 for xml PATH('emailExternalUsers'))

        SET @xml.modify('insert sql:variable("@extEmailUsersNodeWithNames") into (/TMMsg_JobOption/adminOpts/reportOption/commonOpt)[1]')

        --Add email usergroupname to the subtask XML

        SET @xml.modify('delete /TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailUserGroups')

        DECLARE @emailUserGroupNodeWithNames xml =(select emailUserGroupType as '@_type_',emailUserGroupId as '@userGroupId', emailUserGroupName as '@userGroupName' from #tempEmailUserGroup where subtaskid=@Id and userGroupType=0 for xml PATH('emailUserGroups'))

        SET @xml.modify('insert sql:variable("@emailUserGroupNodeWithNames") into (/TMMsg_JobOption/adminOpts/reportOption/commonOpt)[1]')

        --Add External email usergroupname to the subtask XML

        SET @xml.modify('delete /TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailExternalUserGroups')

        DECLARE @extEmailUserGroupNodeWithNames xml =(select emailUserGroupType as '@_type_',emailUserGroupId as '@userGroupId', emailUserGroupName as '@userGroupName' from #tempEmailUserGroup where subtaskid=@Id and userGroupType=1 for xml PATH('emailExternalUserGroups'))

        SET @xml.modify('insert sql:variable("@extEmailUserGroupNodeWithNames") into (/TMMsg_JobOption/adminOpts/reportOption/commonOpt)[1]')

        DELETE FROM TM_SubtaskOptions WHERE subtaskid=@Id and optionid in (1974693722,518811795,1170165839,1065811864)

        UPDATE TM_JobOptions 

            SET modified = @currentTime

            FROM TM_JobOptions

            WHERE subtaskid=@Id AND optionid in (1974693722,518811795,1170165839,1065811864) AND modified = 0  AND jobId = 0

        --Add email username and userGroupName to subtask options
        INSERT INTO TM_SubtaskOptions(subtaskid,type,optionid,value)


            SELECT @id,0,1974693722,CAST(T.r.query('.') as nvarchar(max))

            FROM @emailUsersNodeWithNames.nodes('/emailUsers') T(r)

            UNION

            SELECT @id,0,518811795,CAST(T.r.query('.') as nvarchar(max))

            FROM @emailUserGroupNodeWithNames.nodes('/emailUserGroups') T(r)

            UNION 

            SELECT @id,0,1170165839,CAST(T.r.query('.') as nvarchar(max))

            FROM @extEmailUsersNodeWithNames.nodes('/emailExternalUsers') T(r)

            UNION

            SELECT @id,0,1065811864,CAST(T.r.query('.') as nvarchar(max))

            FROM @extEmailUserGroupNodeWithNames.nodes('/emailExternalUserGroups') T(r)
        INSERT INTO TM_JobOptions(jobId,optionId,type,value, taskId, subTaskId, lastJobId, created, modified)


            SELECT 0,1974693722,0,CAST(T.r.query('.') as nvarchar(max)),TS.taskId,@Id,0,@currentTime,0

            FROM @emailUsersNodeWithNames.nodes('/emailUsers') T(r)

            INNER JOIN TM_Subtask TS ON TS.subTaskId=@Id

            UNION

            SELECT 0,518811795,0,CAST(T.r.query('.') as nvarchar(max)),TS.taskId,@Id,0,@currentTime,0

            FROM @emailUserGroupNodeWithNames.nodes('/emailUserGroups') T(r)

            INNER JOIN TM_Subtask TS ON TS.subTaskId=@Id 

            UNION

            SELECT 0,1170165839,0,CAST(T.r.query('.') as nvarchar(max)),TS.taskId,@Id,0,@currentTime,0

            FROM @emailUserGroupNodeWithNames.nodes('/emailExternalUsers') T(r)

            INNER JOIN TM_Subtask TS ON TS.subTaskId=@Id 

            UNION

            SELECT 0,1065811864,0,CAST(T.r.query('.') as nvarchar(max)),TS.taskId,@Id,0,@currentTime,0

            FROM @emailUserGroupNodeWithNames.nodes('/emailExternalUserGroups') T(r)

            INNER JOIN TM_Subtask TS ON TS.subTaskId=@Id   

        UPDATE TM_SubTaskXMLOptions   SET xmlValue = @xml   WHERE subtaskid=@Id

        --Age of current xml job options and create new one like below

        UPDATE TM_JobXMLOptions 

            SET modified = @currentTime 

            FROM TM_JobXMLOptions

            WHERE TM_JobXMLOptions.subTaskId = @ID AND modified = 0
        INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


            SELECT 0,STXO.xmlValue,ST.taskId,ST.subTaskId,0,@currentTime, 0

            FROM TM_Subtask (NOLOCK) ST

            INNER JOIN TM_SubTaskXMLOptions (NOLOCK) STXO ON ST.subTaskId = STXO.subTaskId AND STXO.subTaskId=@Id

        DELETE FROM #tempSubtaskXML WHERE subtaskid= @Id

        SET @row = @row + 1

    END            

    DROP TABLE #tempSubtaskXML

    DROP TABLE #tempEmailUser

    DROP TABLE #tempEmailUserGroup

DECLARE @bigDataAppsSupport    VARCHAR(40) = 'BF66CE6A-8BE6-4551-8736-D0F9DEC7E7A2'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @bigDataAppsSupport)

BEGIN

BEGIN TRY

	BEGIN TRAN

	DECLARE @enable INT = 1

	DECLARE @disable INT = 0

    if object_id('tempdb.dbo.#IncrAutoLogSchedules') is not null

	DROP TABLE #IncrAutoLogSchedules

    CREATE TABLE #IncrAutoLogSchedules (

        subTaskId INT,

		taskId INT)
    INSERT INTO #IncrAutoLogSchedules


	SELECT DISTINCT ST.subTaskId, T.taskId

		FROM App_PlanProp PP WITH(NOLOCK) 

INNER JOIN TM_Task T ON PP.attrVal = CAST(T.taskId AS NVARCHAR(2048)) AND PP.attrName = 'Log schedule policy' AND PP.modified = 0

INNER JOIN App_Plan P ON P.id = PP.componentNameId AND P.subType = 33554437

	INNER JOIN TM_Subtask ST ON ST.taskId = T.taskId AND ST.operationType = 2 AND ST.subTaskType = 2	 --Backup

	INNER JOIN TM_PatternAssoc PA ON PA.subTaskId = ST.subTaskId

	INNER JOIN TM_Pattern PT ON PT.patternId = PA.patternId AND PT.freq_type = 1024 /*Automatic*/

	INNER JOIN TM_SubTaskOptions STO ON STO.subTaskId = ST.subTaskId AND STO.optionId = 458405394 AND STO.value = '2' --Incremental

	--Insert new tag

	UPDATE TM_SubTaskXMLOptions

		SET xmlValue.modify('insert <distAppsBackupOptions/> into (/TMMsg_JobOption[1]/backupOpts)[1]') 

	FROM TM_SubTaskXMLOptions

    INNER JOIN #IncrAutoLogSchedules ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

	WHERE xmlValue.exist('/TMMsg_JobOption[1]/backupOpts[1]/distAppsBackupOptions') = 0

	--Insert attribute runDataBkp=0

	UPDATE TM_SubTaskXMLOptions

    SET xmlValue.modify('insert attribute runDataBkp {sql:variable("@disable")} into (/TMMsg_JobOption[1]/backupOpts[1]/distAppsBackupOptions)[1]')

	FROM TM_SubTaskXMLOptions

    INNER JOIN #IncrAutoLogSchedules ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

	WHERE xmlValue.exist('/TMMsg_JobOption[1]/backupOpts[1]/distAppsBackupOptions[1]/@runDataBkp') = 0

	--Insert attribute runLogBkp=1

	UPDATE TM_SubTaskXMLOptions

    SET xmlValue.modify('insert attribute runLogBkp {sql:variable("@enable")} into (/TMMsg_JobOption[1]/backupOpts[1]/distAppsBackupOptions)[1]')

	FROM TM_SubTaskXMLOptions

    INNER JOIN #IncrAutoLogSchedules ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

	WHERE xmlValue.exist('/TMMsg_JobOption[1]/backupOpts[1]/distAppsBackupOptions[1]/@runLogBkp') = 0

	 -- Age of job XML options

    UPDATE TM_JobXMLOptions 

    SET modified = @currentTime 

     FROM TM_JobXMLOptions

     INNER JOIN #IncrAutoLogSchedules ST ON 

     ST.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0
    INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


    SELECT 0,STXO.xmlValue,ST.taskId,ST.subTaskId,0,@currentTime, 0

      FROM #IncrAutoLogSchedules ST

      INNER JOIN TM_SubTaskXMLOptions STXO ON ST.subTaskId = STXO.subTaskId

	--Insert into Subtask Options
	INSERT INTO TM_SubtaskOptions(subTaskId, optionId, type, value)


SELECT ST.subTaskId,1510569066, 0, '1'

    FROM #IncrAutoLogSchedules ST    

LEFT JOIN TM_SubtaskOptions STO ON STO.subTaskId = ST.subTaskId AND STO.optionId = 1510569066

	WHERE STO.optionId IS NULL
	INSERT INTO TM_SubtaskOptions(subTaskId, optionId, type, value)


SELECT ST.subTaskId,684987670, 0, '0'

    FROM #IncrAutoLogSchedules ST    

LEFT JOIN TM_SubtaskOptions STO ON STO.subTaskId = ST.subTaskId AND STO.optionId = 684987670

	WHERE STO.optionId IS NULL
    INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)


SELECT 0,1510569066, 0, '1', ST.taskId, ST.subTaskId,0,@currentTime,0

    FROM #IncrAutoLogSchedules ST 

LEFT JOIN TM_JobOptions JO ON JO.subTaskId = ST.subTaskId AND JO.optionID = 1510569066

	WHERE JO.optionID IS NULL

	UNION ALL

SELECT 0,684987670, 0, '0', ST.taskId, ST.subTaskId,0,@currentTime,0

    FROM #IncrAutoLogSchedules ST   

LEFT JOIN TM_JobOptions JO ON JO.subTaskId = ST.subTaskId AND JO.optionID = 684987670

	WHERE JO.optionID IS NULL
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@bigDataAppsSupport, 'DistributedAppsLogsSupport', 'Table script to upgrade incremental backup schedules to have distributed apps log backup option', @currentTime,  16, 0, (16 + 2))

	COMMIT TRAN	

	END TRY

	BEGIN CATCH	

		-- Rollback any active or uncommittable transactions before

		-- inserting information in the ErrorLog

		IF XACT_STATE() <> 0

		BEGIN		

			ROLLBACK TRANSACTION;

		END

		DECLARE @errString nvarchar(max)                   

        SET @errString = N'Failed to upgrade schedules to include distributed apps with logs option. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')                    

        RAISERROR(@errString, 16, 1)  

	END CATCH;

	if object_id('tempdb.dbo.#IncrAutoLogSchedules') is not null

	DROP TABLE #IncrAutoLogSchedules

END

DECLARE @guidForLiveSyncDestinationName uniqueidentifier = 'DCB7DA9D-616E-4303-BA1A-2F8EBA2E1E66'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @guidForLiveSyncDestinationName)

BEGIN

BEGIN TRY

	BEGIN TRAN

    if object_id('tempdb.dbo.#liveSyncSubTasks') is not null

		DROP TABLE #liveSyncSubTasks

    CREATE TABLE #liveSyncSubTasks (

        subTaskId INT PRIMARY KEY,

		taskId INT,

        destClientID INT)
    INSERT INTO #liveSyncSubTasks


    SELECT STXO.subTaskId, T.taskId, xmlValue.value('(/TMMsg_JobOption/restoreOptions/destination/destClient/@clientId)[1]','INT') FROM TM_SubTaskXMLOptions STXO

INNER JOIN TM_Subtask ST ON ST.subTaskId = STXO.subTaskId AND (ST.flags & 0x200000 )>0

	INNER JOIN TM_Task T ON T.taskId = ST.taskId AND T.deleted=0 	

	WHERE ST.operationType = 1007 --TaskOperationType_SITE_REPLICATION

	AND ST.subTaskType = 3	 --Restore

	/*

	<destination isLegalHold="0" restoreOnlyIfTargetExists="0" inPlace="1">

      <destClient clientId="8" _type_="3" />

      <destinationInstance clientId="8" _type_="5" instanceId="11" applicationId="81" />

    </destination>*/

    UPDATE TM_SubTaskXMLOptions

    SET xmlValue.modify('insert (attribute clientName {sql:column("App_client.name")}) into (/TMMsg_JobOption/restoreOptions/destination/destClient)[1]')

    FROM TM_SubTaskXMLOptions

    INNER JOIN #liveSyncSubTasks ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

	INNER JOIN App_Client (NOLOCK) ON App_Client.id = ST.destClientID

	AND xmlValue.exist('/TMMsg_JobOption/restoreOptions/destination/destClient/@clientName') = 0

	UPDATE TM_SubTaskXMLOptions

    SET xmlValue.modify('insert (attribute clientName {sql:column("App_client.name")}) into (/TMMsg_JobOption/restoreOptions/destination/destinationInstance)[1]')

    FROM TM_SubTaskXMLOptions

    INNER JOIN #liveSyncSubTasks ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

	INNER JOIN App_Client (NOLOCK) ON App_Client.id = ST.destClientID

	AND xmlValue.exist('/TMMsg_JobOption/restoreOptions/destination/destinationInstance/@clientName') = 0

	 -- Age of job XML options

    UPDATE TM_JobXMLOptions 

    SET modified = @currentTime 

     FROM TM_JobXMLOptions

     INNER JOIN #liveSyncSubTasks ST ON 

     ST.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0
    INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


    SELECT 0,STXO.xmlValue,ST.taskId,ST.subTaskId,0,@currentTime, 0

      FROM #liveSyncSubTasks ST

      INNER JOIN TM_SubTaskXMLOptions STXO ON ST.subTaskId = STXO.subTaskId

	DECLARE @destinationClientNameOptionIDs TABLE(optionID INT)
	INSERT INTO @destinationClientNameOptionIDs


	SELECT 1170928521/*DESTCLIENT_CLIENT_NAME*/

	UNION ALL

	SELECT 512960963/*DESTINATIONINSTANCE_CLIENT_NAME */

	--Insert into Subtask Options
	INSERT INTO TM_SubtaskOptions(subTaskId, optionId, type, value)


    SELECT ST.subTaskId,destinationClientNameOptionIDs.OptionId, 1, App_Client.name

    FROM #liveSyncSubTasks ST    

    INNER JOIN TM_Subtask T ON ST.subTaskId = T.subTaskId

	INNER JOIN App_Client (NOLOCK) ON App_Client.id = ST.destClientID

	CROSS JOIN @destinationClientNameOptionIDs destinationClientNameOptionIDs 

	LEFT JOIN TM_SubtaskOptions (NOLOCK) ON TM_SubtaskOptions.subtaskID = T.SubtaskId

	AND TM_SubtaskOptions.optionID = destinationClientNameOptionIDs.OptionId

	WHERE TM_SubtaskOptions.optionId IS NULL

    -- Age of job options

    UPDATE TM_JobOptions 

    SET modified = @currentTime

    FROM TM_JobOptions

    INNER JOIN #liveSyncSubTasks ST ON 

    ST.subTaskId = TM_JobOptions.subTaskId

    AND TM_JobOptions.optionID IN (1170928521,512960963)

    AND TM_JobOptions.modified = 0

    AND TM_JobOptions.jobId = 0
    INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)


    SELECT 0,STO.OptionID,1, STO.value, ST.taskId,ST.subTaskId,0,@currentTime, 0

    FROM #liveSyncSubTasks ST

    INNER JOIN TM_SubTaskOptions STO ON ST.subTaskId = STO.subTaskId

	AND STO.OptionID IN (1170928521,512960963)
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@guidForLiveSyncDestinationName, 'Update destination client name for CS live sync schedules', 'Table script to update subtask xml options with destination client name', @currentTime,  16, 0, (16 + 2))

	COMMIT TRAN	

	END TRY

	BEGIN CATCH	

		-- Rollback any active or uncommittable transactions before

		-- inserting information in the ErrorLog

		IF XACT_STATE() <> 0

		BEGIN		

			ROLLBACK TRANSACTION;

		END

		SET @errStr = N'Failed to update destination name for CS live sync schedules. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')

        RAISERROR(@errStr, 16, 1)  

	END CATCH;

	if object_id('tempdb.dbo.#liveSyncSubTasks') is not null

		DROP TABLE #liveSyncSubTasks

END

DECLARE @InsertMissingJobXMLOptionsOnClones    VARCHAR(40) = '6DB2B1CE-B72B-436C-99BC-94F34487F18F'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @InsertMissingJobXMLOptionsOnClones)

BEGIN

BEGIN TRY

	BEGIN TRAN
		INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified) 


		SELECT 0, STXO.xmlValue, T.taskId, ST.subtaskId, 0, T.created, 0

		FROM TM_Subtask ST(NOLOCK)

		     INNER JOIN TM_Task T(NOLOCK) ON ST.taskId = T.taskId

		                                     AND T.taskType = 4

		     INNER JOIN TM_SubtaskXMLOptions STXO(NOLOCK) ON ST.subtaskId = STXO.subtaskId

		     LEFT JOIN TM_JobXMLOptions JXO(NOLOCK) ON STXO.subtaskId = JXO.subTaskId

		                                               AND JXO.jobId = 0

		                                               AND JXO.modified = 0

		WHERE T.taskName LIKE '%Clone'

		      AND JXO.xmlValue IS NULL
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@InsertMissingJobXMLOptionsOnClones, 'Job XML options missing on schedules', 'Table script to insert missing job XML Options when schedule policy is cloned', @currentTime,  16, 0, (16 + 2))

	COMMIT TRAN	

	END TRY

	BEGIN CATCH	

		-- Rollback any active or uncommittable transactions before

		-- inserting information in the ErrorLog

		IF XACT_STATE() <> 0

		BEGIN		

			ROLLBACK TRANSACTION;

		END

		SET @errStr = N'Failed to insert Job XML options missing on cloned schedules . ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')                    

        RAISERROR(@errStr, 16, 1)  

	END CATCH;

END

