

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_SubTask.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/TM_SubTask.script,v $ $Id: TM_SubTask.script,v 1.5.32.6 2020/06/23 14:59:30 rengu Exp $";

DECLARE @currentTime INT = DATEDIFF(second, '01/01/1970', GETDATE())

IF not exists (select * from TM_SubTask where (subTaskName = 'Default' and defaultTask =1))

BEGIN

DECLARE @taskId INT

SET @taskId = (SELECT taskId FROM TM_Task WHERE defaultTask = 1 AND flags&0x10<>0)
insert into TM_SubTask(subTaskName,


				   taskId,

				   subTaskType	,	

				   operationType,	

				   flags		,	

				   subTaskOrder,

				   deleted,

 		 		   uninstalled,

				  defaultTask)

			values ('Default',

					@taskId,

					1,

					1,

					1,

					0,

					0,

					0,

					1)
END
IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'F855726E-C304-45DD-9912-D6C0FA90A8F0')

BEGIN

	--CONVERT EXISTING LIVE SYNC SCHEDULES FROM RESTORE OPERATION TO REPLICATION OPERATION

	--SINCE JOB MANAGER CHANGES ARE DONE TO SUPPORT REPLICATION JOB FOR ALL AGENTS

	UPDATE TM_SubTask

	SET operationType = 1007	--CHANGE TO REPLICATION OPERATON __SITE_REPLICATION

	WHERE subTaskId IN (

		--ONLY GET SCHEDULES WHICH ARE IN LIVE SYNC TABLE AND HAVE OPERATION TYPE AS RESTORE

		SELECT R.subTaskId

		FROM APP_LiveSyncReplication R

		JOIN TM_SubTask S ON S.subTaskId = R.subTaskId AND S.operationType = 1001	--BUT ARE MARKED AS RESTORE SCHEDULES

	)
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('F855726E-C304-45DD-9912-D6C0FA90A8F0', 'changeReplicationScheduleOperation', 'Change Replication Schedule Operation', @currentTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'C738C4A1-EE6F-4321-8716-468AAE5D05E1')

BEGIN

	DECLARE @autoCopyEnabled INT = 1

	UPDATE P

	  SET 

P.freq_type = 4096,

		  P.freq_interval = P.freq_subday_interval/60, 

		  P.description = CONCAT('Continuous Schedule After ',P.freq_subday_interval/60,' minutes'), 

		  P.freq_subday_interval = 0, 

		  P.active_end_time = 0,

		  P.tzId = 1000

	FROM TM_Pattern P

		 INNER JOIN TM_PatternAssoc PA ON PA.patternId = P.patternId

		 INNER JOIN TM_SubTask ST ON PA.subtaskId = ST.subTaskId

		 INNER JOIN TM_SubTaskXmlOptions STXO ON ST.subTaskId = STXO.subTaskId

WHERE ST.operationType = 4003

AND P.freq_type = 4

		  AND STXO.xmlValue.exist('/TMMsg_JobOption/backupOpts[1]/mediaOpt[1]/auxcopyJobOption[@autoCopy=sql:variable("@autoCopyEnabled")]') = 1

		  AND ST.deleted = 0

		  AND P.deleted = 0

		  AND P.active_end_time = 86340

		  AND P.freq_subday_interval > 0
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('C738C4A1-EE6F-4321-8716-468AAE5D05E1', 'AuxAutoCopyScheduleUpgrade', 'Upgrade Aux auto copy schedules to continuous pattern', @currentTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'D84028F4-6D34-4EBF-ADAE-1E9774750793')

BEGIN

	if object_id('tempdb.dbo.#subTasks') is not null

	DROP TABLE #subTasks

    CREATE TABLE #subTasks (

        subTaskId INT PRIMARY KEY,

		taskId INT,

		patternId INT,

        xmlValue XML )
    INSERT INTO #subTasks


    SELECT STXO.subTaskId, ST.taskId, P.patternId, STXO.xmlValue FROM TM_Pattern P

		INNER JOIN TM_PatternAssoc PA ON PA.patternId = P.patternId

		INNER JOIN TM_SubTask ST ON PA.subtaskId = ST.subTaskId

		INNER JOIN TM_SubTaskXmlOptions STXO ON ST.subTaskId = STXO.subTaskId

WHERE ST.operationType = 4028

AND P.freq_type = 4

		AND ST.deleted = 0

		AND P.deleted = 0

		AND P.active_end_time = 86340

		AND P.freq_subday_interval IN (14440, 14400)

		AND P.active_start_time = 3600 /* these checks will ensure upgrade is done only for plan created default schedule */

	--Updating the autocopy option on XML options

	UPDATE STXO

	SET xmlValue.modify('insert <mediaOpt><auxcopyJobOption autoCopy="1" /></mediaOpt> into (/TMMsg_JobOption[1]/backupOpts[1])[1]')

    FROM TM_SubTaskXmlOptions STXO

		INNER JOIN #subTasks ST ON ST.subTaskId = STXO.subTaskId

	WHERE ST.xmlValue.exist('/TMMsg_JobOption/backupOpts[1]/mediaOpt[1][1]') <> 1

	--Updating the pattern from daily to continuous

	UPDATE P

	  SET 

P.freq_type = 4096,

		  P.freq_interval = P.freq_subday_interval/60, 

		  P.description = CONCAT('Continuous Schedule After ',P.freq_subday_interval/60,' minutes'), 

		  P.freq_subday_interval = 0, 

		  P.active_end_time = 0

	FROM TM_Pattern P

		 INNER JOIN #subTasks ST ON P.patternId = ST.patternId

	 -- Age of job XML options

    UPDATE TM_JobXMLOptions 

    SET modified = @currentTime 

     FROM TM_JobXMLOptions

     INNER JOIN #subTasks ST ON 

     ST.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0
    INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


    SELECT 0,STXO.xmlValue,ST.taskId,ST.subTaskId,0,@currentTime, 0

      FROM #subTasks ST

      INNER JOIN TM_SubTaskXMLOptions STXO ON ST.subTaskId = STXO.subTaskId

	-- Insert into subtask options
    INSERT INTO TM_SubTaskOptions(subTaskID, optionID, type, value)


SELECT ST.subTaskId,489389116, 0, '1'

    FROM #subTasks ST   

	LEFT JOIN TM_SubTaskOptions STO ON ST.subTaskId = STO.subTaskId

AND STO.optionId = 489389116

	WHERE STO.optionId IS NULL 

    -- Age of job options

    UPDATE TM_JobOptions 

    SET modified = @currentTime

    FROM TM_JobOptions

    INNER JOIN #subTasks ST ON 

    ST.subTaskId = TM_JobOptions.subTaskId

AND TM_JobOptions.optionID = 489389116

    AND TM_JobOptions.modified = 0

    AND TM_JobOptions.jobId = 0
    INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)


SELECT 0,489389116, 0, STO.value, ST.taskId, ST.subTaskId,0,@currentTime,0

    FROM #subTasks ST  

	INNER JOIN TM_SubTaskOptions STO ON ST.subTaskId = STO.subTaskId  

WHERE STO.optionId = 489389116

	if object_id('tempdb.dbo.#subTasks') is not null

	DROP TABLE #subTasks
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('D84028F4-6D34-4EBF-ADAE-1E9774750793', 'BackupCopyScheduleUgrade', 'Upgrade Plan created backup copy schedules to continuous pattern and also include autocopy', @currentTime, 16, 0, (16 + 2))

END

