

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_ResetJobStartTimeContSchedulesPattern.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/TM_ResetJobStartTimeContSchedulesPattern.script,v $ $Id: TM_ResetJobStartTimeContSchedulesPattern.script,v 1.1.2.1 2018/11/30 13:39:39 mnatarajan Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @taskid INT = 0

	DECLARE @subTaskId INT = 0

    DECLARE @guidForResetPatternStartTime uniqueidentifier = 'DE3CEE88-60FC-4111-9673-6604BBD242C3'

    DECLARE @isResetPatternStartTimeDone INT = 0 

	SELECT @isResetPatternStartTimeDone = 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @guidForResetPatternStartTime

DECLARE @constAttrName_Policy_Schedule      NVARCHAR(32)    = 'Schedule policy'

	DECLARE @currentTime INTEGER

	SET @currentTime = DATEDIFF(second, '1970-01-01', GetUTCDate())

	IF (@isResetPatternStartTimeDone = 0)        -- Not done, update the pattern below

	BEGIN	

		-- Get all data schedule policies associated to plan and set active start time for those schedules in pattern to -1.

		BEGIN TRY

        BEGIN TRAN

			UPDATE TM_Pattern

			SET active_start_time = -1

			FROM TM_Pattern

			INNER JOIN TM_PatternAssoc ON TM_PatternAssoc.patternId = TM_Pattern.patternID

AND TM_Pattern.freq_type = 4096

INNER JOIN TM_subtask ON TM_PatternAssoc.subtaskID = TM_subtask.subtaskId AND (TM_subtask.flags & 0x10000 ) > 0

			INNER JOIN TM_task ON TM_subtask.taskID = TM_Task.taskID 

			AND TM_Task.deleted = 0

			INNER JOIN App_PlanProp (NOLOCK) PP ON PP.attrName = @constAttrName_Policy_Schedule 

			AND PP.attrval = CAST(TM_Task.TaskID AS NVARCHAR(10) )

				INNER JOIN App_Plan (NOLOCK) P ON P.id = PP.componentNameId

			WHERE  P.ownerId IS NOT NULL

AND (P.flag & 0x40000000) = 0 AND ( (P.flag & 0x00004) = 0)
			INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@guidForResetPatternStartTime, 'ContSchedulesResetStartTime', 'Reset start time for continuous schedules associated to plan', @currentTime,  16, 0, (16 + 2))

		COMMIT TRAN

        END TRY

        BEGIN CATCH

			DECLARE @o_errorCode INT

            DECLARE @tmpErrorString NVARCHAR

            -- Call procedure to print error information.

            -- Call procedure to get error information.

            EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT

            PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

            -- Rollback any active or uncommittable transactions before

            -- inserting information in the ErrorLog

            IF XACT_STATE() <> 0

            BEGIN

            PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

                ROLLBACK TRANSACTION;

            END

        END CATCH;

    END

GO

