

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_FixNextRunTimeForContSchedules.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/TM_FixNextRunTimeForContSchedules.script,v $ $Id: TM_FixNextRunTimeForContSchedules.script,v 1.1.2.2 2019/12/12 22:39:22 vdevassy Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @guid uniqueidentifier = '57B7AE6C-3DCA-4DC6-A53C-9A1972691C5F'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())

DECLARE @IsTranStarted INT = 0

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	BEGIN TRY

        IF @@TRANCOUNT=0

        BEGIN

            SET @IsTranStarted = 1

            BEGIN TRAN

        END

		-- Delete runtimes for continuous schedules. Before they were in CS timezone and it recently got converted to utc timezone in update form 69033. So deleting existing entries so that they are recomputed

		DELETE TM_RunTime

		FROM TM_RunTime

		INNER JOIN 

		(

			SELECT DISTINCT TM_RunTime.PatternId

			FROM TM_RunTime INNER JOIN TM_Pattern PT ON TM_RunTime.PatternId = PT.PatternId

			AND PT.deleted = 0

AND PT.freq_type = 4096

			AND PT.freq_interval != 0

			JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PT.patternId = PA.patternId 

			INNER JOIN TM_SubTask ST WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId

AND ST.operationType != 1007

			INNER JOIN TM_Task T WITH (NOLOCK) ON T.TaskId = ST.TaskId

			AND T.deleted = 0 AND T.TaskType = 4 -- schedule policy. We want to do this for schedule policy only. 			

		) RunTimes ON RunTimes.PatternId = TM_RunTime.PatternId 

		-- DATEADD(SECOND, @tzOffsetSecs,TM_Runtimeassoc.nextRunTime) converts CS time to time in UTC. Then we get its unix time by below

		-- DATEDIFF(second, '01/01/1970', DATEADD(SECOND, @tzOffsetSecs,TM_Runtimeassoc.nextRunTime) )
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'FixNextRunTimeForContSchedules', 'Update next run time in Runtime table for continuous schedules', @curUtcDateTime, 16, 0 , (16 + 2))

		IF (@IsTranStarted=1)

        BEGIN

            COMMIT TRAN

        END

	END TRY

	BEGIN CATCH 

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT 'Rolling back transaction'

		IF (@IsTranStarted=1)

		BEGIN

			ROLLBACK TRAN

		END

	END CATCH;	

END

GO

