

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_CreateTasksReviewSetMigration.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

--TM_CreateTasksReviewSetMigration.script

--Create Schedules for Review Set Migration

BEGIN TRAN

DECLARE @reviewSetMigrationUpgrade INT = 0

DECLARE @reviewSetMigrationVersion varchar(36) = '3971003D-B787-49BC-BB1F-DF6BBBA7B3D1'	 

SELECT @reviewSetMigrationUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @reviewSetMigrationVersion

IF (@reviewSetMigrationUpgrade = 0)            -- not done, do the db upgrade

BEGIN   

	BEGIN TRY	

		DECLARE @currentDate    DATETIME

		DECLARE @userId			INTEGER

		DECLARE @currentTime    INTEGER

		DECLARE @errCode		INTEGER = 0

		DECLARE @errStr			varchar(1024) ='Success'

		DECLARE @l_taskId1      INTEGER

		DECLARE @l_subTaskId1	INTEGER

		DECLARE @l_patternId1	INTEGER

		DECLARE @xmlText        XML

		DECLARE @xmlSubTaskOpts XML

		DECLARE @WFId			INTEGER

		DECLARE @WFEngId		INTEGER

		SET @userId = (SELECT TOP 1 id FROM UMUsers (NOLOCK) WHERE flags&0x40=0x40)

		SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())

		set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))

		--DELETE previously created schedule for review set migration workflow

IF EXISTS (SELECT TOP 1 1 FROM TM_Task (NOLOCK) WHERE (flags & 0x200) = 0x200)

		 BEGIN

				UPDATE TM_Task		

SET taskType = 5

WHERE  (flags & 0x200) = 0x200

				DELETE TM_Task		

WHERE  (flags & 0x200) = 0x200

		END

		-- Set the current releaseId instead of retrieving it from CS client. 

		Declare @releaseID int

set @releaseID = 16

		set @releaseID = @releaseID-1

		-- get the oldest ReleaseID (releaseID when client was freshly installed) from Licusagehistory table.

		DECLARE  @oldestReleaseID integer

		SET @oldestReleaseID = (SELECT MIN(LH.releaseID)

								FROM LicUsageHistory LH WITH (NOLOCK), APP_Client C WITH (NOLOCK)

									WHERE   C.id  = 2 AND  LH.CId = C.id 

									)

		--fresh CS: No need to create review set migration schedule

		IF(@oldestReleaseID > @releaseID)

		BEGIN			

			GOTO ERROR_EXIT	

		end

		--check if review set workflow exists

		IF EXISTS (SELECT TOP 1 1 from WF_Definition (NOLOCK) where Name = 'ReviewSet Migration')

		BEGIN

			SET @WFId = (SELECT TOP 1 WorkflowId from WF_Definition (NOLOCK) where Name = 'ReviewSet Migration')

		END

		ELSE

		BEGIN 			

			SET @errStr = 'ERROR: Workflow[ReviewSet Migration] does not exist'

			GOTO ERROR_EXIT	

		END

		IF EXISTS (SELECT ClientId FROM dbo.simInstalledPackages (NOLOCK) WHERE simPackageID = 808)

		BEGIN

			SET @WFEngId = (SELECT TOP 1 ClientId FROM dbo.simInstalledPackages (NOLOCK) WHERE simPackageID = 808)

		END

		ELSE

		BEGIN 

			--on upgrade, create reviewset migration schedule even if workflow is not installed.

			IF @oldestReleaseID <= @releaseID

				SET @WFEngId = 2 

			ELSE

			BEGIN

				SET @errStr = 'ERROR: Workflow Engine not installed'

				GOTO ERROR_EXIT	

			END

		END

		-- Create a unique local temp table for dbupgrade

		-- to avoid schema failures due to the same temp

		-- table name being in multiple tbl scripts

IF OBJECT_ID('TempDb..' +'#TM_IDTable_TaskRevSetMigration') IS NOT NULL	
  		DROP TABLE #TM_IDTable_TaskRevSetMigration ;		
  	CREATE TABLE #TM_IDTable_TaskRevSetMigration (			
  		[id]		INT,			
  		[type]		INT,			
  		PRIMARY KEY([type], [id])	
  	);

		--Schedule ReviewSet Migrations for expired storage

		--Create a Task in TM_Task

IF NOT EXISTS (SELECT  TOP 1 1 FROM TM_Task WHERE (flags & 0x200) = 0x200)

		BEGIN
			INSERT INTO TM_Task(taskName,


								taskType,

								flags,  

								status, 

								created,    

								modified,

								alertId,    

								ownerId,    

								runUserId,  

								initiatedFrom,  

								sequenceNumber,

								localeId,

								description,

								deleted,

								disabled,

								uninstalled,

								invalid,

								defaultTask,

								savedReport,

								serial,

								policyType,

								origCCId,

								GUID,

								isEZOperation,

								isAgentlessSRM,

								hidden)

OUTPUT  INSERTED.taskId , 1 INTO #TM_IDTable_TaskRevSetMigration

			VALUES

							(

'System Created for ReviewSet Migration',

2,

CAST(0x4 AS INT)| CAST(0x200 AS INT),

								0, 

								@currentTime,

								0,

								0,

								@userId,

								@userId,

3,

								0,

								0,

'System Created for ReviewSet Migration',

								0,

								0,

								0,

								0,

								1,

								0,

								0,

								0,

								DEFAULT,

								newid(),

								0,

								0,

								0

							)	

			SET @errCode = @@ERROR

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created ReviewSet Migration Schedule -- Failed to insert in TM_Task'

				GOTO ERROR_EXIT

			END

SET @l_taskId1 = (SELECT id FROM #TM_IDTable_TaskRevSetMigration WHERE type = 1)

			--Create a Sub Task
			INSERT INTO TM_SubTask (subTaskName,


									taskId,

									subTaskType ,   

									operationType,  

									flags       ,   

									subTaskOrder,

									deleted,

									uninstalled,

									defaultTask)

OUTPUT  INSERTED.subTaskId , 2 INTO #TM_IDTable_TaskRevSetMigration

VALUES                 ('System Created for ReviewSet Migration',	-- SubTask Name

									@l_taskId1,						-- Task ID

1,			-- SubTask Type

2001,	-- Operation Type

									0,								-- Flags

									0,								-- SubTask Order

									0,								-- Deleted

									0,								-- Uninstalled

									0)								-- Default Task ???

			SET @errCode = @@ERROR	

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created ReviewSet Migration Schedule -- Failed to insert in TM_SubTask'

				GOTO ERROR_EXIT

			END

SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable_TaskRevSetMigration WHERE type = 2)

			--Create a Pattern
			INSERT INTO TM_Pattern(name,


								   ownerId,

								   status,

								   flags,

								   freq_type,

								   freq_interval,

								   freq_relative_interval,

								   freq_recurrence_factor,

								   freq_subday_interval,

								   skipOccurence,

								   skipDayNumber,

								   active_start_date,

								   active_start_time,

								   active_end_date,

								   active_end_time,

								   active_end_occurence,

								   created,

								   modified,

								   tzId,

								   calendarId,

								   description,

								   local_start_date,

								   local_end_date,

								   disabled,

								   deleted,

								   scheduling,

								   freq_restart_interval)

OUTPUT  INSERTED.patternId , 3 INTO #TM_IDTable_TaskRevSetMigration

			VALUES                ('',                          											-- Name

								   @userId,                     											-- Owner ID

								   0,                           											-- Status

								   0,                           											-- Flags

0x8,              											-- Freq Type

								   127,                           											-- Freq Interval

								   0,                           											-- Freq Relative Interval

								   1,                           											-- Freq Recurrence Factor

								   7200,                           											-- Freq Subday Interval

								   0,                           											-- Skip Occurrence

								   0,                           											-- Skip Day Number

								   @currentDate,                											-- Active Start Date

								   28800,                       											-- Active Start Time

								   '1970-01-01 00:00:00',       											-- Active End Date  

								   86340,                           										-- Active End Time

								   0,                           											-- Active End Occurrence

								   0,                											-- Created

								   0,                           											-- Modified

								   1000,                   													-- Time Zone Id 

								   1,                           											-- Calendar Id

								   '',																		-- Description

								   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),						-- Local Start Date

								   0,                           											-- Local End Date

								   0,                           											-- Disabled

								   0,                           											-- Deleted

								   0,                           											-- Scheduling

								   0)                           											-- Freq Restart Interval

			SET @errCode = @@ERROR	

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created ReviewSet Migration Schedule -- Failed to insert in TM_Pattern '

				GOTO ERROR_EXIT

			END

SET @l_patternId1 = (SELECT id FROM #TM_IDTable_TaskRevSetMigration WHERE type = 3)

			-- Create Pattern Assoc        
			INSERT INTO TM_PatternAssoc(patternId,


										subTaskId,

										flags,

										disabled,

										deleted,

										scheduling)

			VALUES                     (@l_patternId1,              -- Pattern ID

										@l_subTaskId1,              -- SubTask ID

										0,                         	-- Flags

										0,                          -- Disabled

										0,                          -- Deleted

										0)                          -- Scheduling

			SET @errCode = @@ERROR	

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created ReviewSet Migration Schedule -- Failed to insert in TM_PatternAssoc '

				GOTO ERROR_EXIT

			END		

			--Create Sub Task XML Options	

			SET @xmlSubTaskOpts = '<TMMsg_JobOption workflowJobOptions="&lt;inputs&gt;&lt;/inputs&gt;"><backupOpts backupLevel="2" /></TMMsg_JobOption>'
			INSERT INTO TM_SubTaskXMLOptions(subTaskID,


											 xmlValue)

			VALUES                          (@l_subTaskId1,

											 @xmlSubTaskOpts)

			SET @errCode = @@ERROR	

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created ReviewSet Migration Schedule -- Failed to insert in TM_SubTaskXMLOptions '

				GOTO ERROR_EXIT

			END

			SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)

			--Create Job XML Options	
			INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


			SET @errCode = @@ERROR	

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created ReviewSet Migration Schedule -- Failed to insert in TM_JobXMLOptions'

				GOTO ERROR_EXIT

			END

			--Associations -- Dummy for AdminJob	
			INSERT INTO TM_AssocEntity(assocType,


									   taskId,

									   flags,

									   created,

									   clientGroupId,

									   clientId,

									   appTypeId,

									   instanceId,

									   backupsetId,

									   subclientId,

									   policyId,

									   copyId,

									   srmReportSet,

									   srmReportType,

									   exclude,

									   trackingPolicyId,

									   MediaagentId,

									   agentlessPolicyId,

									   workflowId,

									   sidbStoreId,

									   libraryId,

									   logMonitoringPolicyId

									   )

			VALUES                    (0,           -- assocTye

									   @l_taskId1,  -- Task ID

									   0,           -- Flags

									   @currentTime,-- Created

									   0,           -- ClientGroupID

									   @WFEngId,    -- ClientID

									   0,           -- AppTypeID

									   0,           -- InstanceID

									   0,           -- BackupSetID

									   0,           -- SubClient ID

									   0,           -- PolicyID

									   0,           -- Copy ID

									   0,           -- SRM Report Set

									   0,           -- SRM Report Type

									   0,           -- Exclude

									   0,           -- Trackung Policy ID

									   0,           -- Media Agent ID

									   0,           -- Agentless SRM ID

									   @WFId,       -- Workflow ID

									   0,           -- SIDB Store ID

									   0,           -- Library ID

									   0            -- Log Monitor Policy ID

									   )

			SET @errCode = @@ERROR	

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created Schedules-- Failed to insert in TM_AssocEntity'

				GOTO ERROR_EXIT

			END	

			--Create Sub Task Options
			INSERT INTO TM_SubTaskOptions(subTaskID,


											optionID,

											type,

											value)

			VALUES                        (@l_subTaskId1,

1165448454,

											1,

											'<inputs></inputs>')

			SET @errCode = @@ERROR	

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created ReviewSet Migration Schedule -- Failed to insert in TM_SubTaskOptions'

				GOTO ERROR_EXIT

			END
			INSERT INTO TM_SubTaskOptions(subTaskID,


											optionID,

											type,

											value)

			VALUES                        (@l_subTaskId1,

130006,

											15,

											2357352946777864)

			SET @errCode = @@ERROR

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created ReviewSet Migration Schedule -- Failed to insert in TM_SubTaskOptions'

				GOTO ERROR_EXIT

			END     
			INSERT INTO TM_SubTaskOptions(subTaskID,


											optionID,

											type,

											value)

			VALUES                        (@l_subTaskId1,

130005,

											1,

											000000000000000000)

			SET @errCode = @@ERROR	

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created ReviewSet Migration Schedule -- Failed to insert in TM_SubTaskOptions'

				GOTO ERROR_EXIT

			END  

			--Create Job Options	
			INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


			FROM TM_SubTaskOptions AS OPT

			INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

			WHERE subTaskId = @l_subTaskId1	

	ERROR_EXIT:
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@reviewSetMigrationVersion, 'SCPReviewSetMigrationUpgrade', 'Upgrade reviewset migration', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

IF OBJECT_ID('TempDb..' +'#TM_IDTable_TaskRevSetMigration') IS NOT NULL	
  		DROP TABLE #TM_IDTable_TaskRevSetMigration ;

		END		

	END TRY

	BEGIN CATCH

		SET @errCode = ERROR_NUMBER()

		SET @errStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Number [' + CONVERT(NVARCHAR(15), @errCode) + '] Error Line [' + CONVERT(NVARCHAR(15), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()				

	END CATCH	

END	

IF @errCode <> 0

BEGIN

	PRINT @errStr

	ROLLBACK TRAN

END

ELSE

		COMMIT  TRAN

