

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_CreatePushInstallTask.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/TM_CreatePushInstallTask.script,v $ $Id: TM_CreatePushInstallTask.script,v 1.1.2.7.8.1 2021/01/13 00:21:15 abilbrey Exp $";

BEGIN

-------------------------------------------------------------------------------------

	----------------------------------------------------------------------------

	--									Variables							  --

	----------------------------------------------------------------------------

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @l_taskId1		INTEGER

	DECLARE @l_subTaskId1	INTEGER

	DECLARE @l_patternId1	INTEGER

	DECLARE @currentDate	DATETIME

	DECLARE @userId 	INTEGER

	DECLARE @currentTime	INTEGER

	DECLARE @xmlText		XML

	-- Schedule for "Default Push Install for FS Addon"

DECLARE @freshInstall	INT = ISNULL((SELECT TOP 1 0 FROM DBUpgradeSteps WHERE Step = 'UpgradeType'), 1)

	SET @userId = (SELECT TOP 1 id FROM UMUsers WHERE flags&0x40=0x40)

	SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())

	set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))

	-- Create a unique local temp table for dbupgrade

	-- to avoid schema failures due to the same temp

	-- table name being in multiple tbl scripts

IF OBJECT_ID('TempDb..' +'#TM_IDTable_PushInstallTask') IS NOT NULL	
  		DROP TABLE #TM_IDTable_PushInstallTask ;		
  	CREATE TABLE #TM_IDTable_PushInstallTask (			
  		[id]		INT,			
  		[type]		INT,			
  		PRIMARY KEY([type], [id])	
  	);

	-----------------------------------------------------------------------------

	-- System Created Push Install 

IF NOT EXISTS (SELECT * FROM TM_Task WHERE flags & 0x4000= 0x4000)

	BEGIN

		-- Push Install	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

OUTPUT	INSERTED.taskId , 1 INTO #TM_IDTable_PushInstallTask

VALUES			   ('System Created Push Install',				-- Task Name

4,		-- Task Type

CAST(0x4 AS INT) | CAST(0x4000 AS INT),		-- Task Flags

							0,								-- Status

							0,								-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

'System Created schedule policy for Push Install',		-- Description

							0,								-- Deleted

							0,								-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							1,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

							0,								-- Policy Type

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							1)								-- hidden

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_Task'

			GOTO ERROR_EXIT

		END

SET @l_taskId1 = (SELECT id FROM #TM_IDTable_PushInstallTask WHERE type = 1)

		-- Schedule 1 :					
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

OUTPUT	INSERTED.subTaskId , 2 INTO #TM_IDTable_PushInstallTask

VALUES				   ('System Created Push Install',	-- SubTask Name

								@l_taskId1,					-- Task ID

1,		-- SubTask Type

4026,	-- Operation Type

0x20000, -- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END

SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable_PushInstallTask WHERE type = 2)

		-- Pattern 1:

		-- Automatic Schedule
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

OUTPUT	INSERTED.patternId , 3 INTO #TM_IDTable_PushInstallTask

VALUES				  ('Automatic Schedule',-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

1024,-- Freq Type

							   0,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   0,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,				-- Active Start Date

							   0,							-- Active Start Time

							   '1970-01-01 00:00:00',		-- Active End Date	

							   0,						    -- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,						-- Time Zone Id 

							   1,							-- Calendar Id

							   '',							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END

SET @l_patternId1 = (SELECT id FROM #TM_IDTable_PushInstallTask WHERE type = 3)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					   (@l_patternId1,				-- Pattern ID

									@l_subTaskId1,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId1,

										 '<TMMsg_JobOption><backupOpts backupLevel="2"><dataOpt autoCopy="0" /></backupOpts><adminOpts><updateOption /></adminOpts><restoreOptions><virtualServerRstOption isBlockLevelReplication="0" /></restoreOptions><commonOpts><automaticSchedulePattern maxBackupInterval="72" ignoreOpWindowPastMaxInterval="0" minBackupIntervalMinutes="15" maxBackupIntervalMinutes="0" minSyncInterval="0" minBackupInterval="0" minSyncIntervalMinutes="0"><stopIfOnBattery enabled="0" /><acPower enabled="0" /><specfificNetwork enabled="0" /><stopSleepIfBackUp enabled="0" /><emergencyBackup><emergencyBackup enabled="0" /></emergencyBackup><cpuUtilization enabled="0" /><dontUseMeteredNetwork enabled="1" /><newOrModifiedFile enabled="0" /><cpuUtilizationAbove enabled="0" /><wiredNetworkConnection enabled="0" /><minNetworkBandwidth enabled="0" /></automaticSchedulePattern></commonOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created  Push Install -- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- SubTask Options

		-- Automatic Schedule
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

130005,

									   1,

									   '000000000000000000')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

130006,

									   15,

									   2357352946777864)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

236666161,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

362764450,

									   8,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

416206437,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

421006454,

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

458405394,

									   7,

									   2)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

641463701,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

703512134,

									   8,

									   72)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

850125934,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1013376701,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1110217321,

									   8,

									   15)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1205284996,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1266111406,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1384124987,

									   8,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1515007811,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1545679425,

									   8,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1611532840,

									   8,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1641015063,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1667682014,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1712751984,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1811949757,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1915116957,

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Push Install -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

WHERE subTaskId = @l_subTaskId1 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)

	END

	ELSE

    BEGIN

UPDATE TM_Task SET taskType = 4 where flags & 0x4000 = 0x4000 AND taskType = 2

        SET @errCode = @@ERROR

        IF  @errCode <> 0

        BEGIN

SET @errStr = 'ERROR: System Created Push Install Schedule -- Failed to update tasktype for '+'System Created Push Install'+' schedule'

            GOTO ERROR_EXIT

        END

    END

------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------

END 

ERROR_EXIT:

IF OBJECT_ID('TempDb..' +'#TM_IDTable_PushInstallTask') IS NOT NULL	
  		DROP TABLE #TM_IDTable_PushInstallTask ;

PRINT 'Errorcode = '+CAST(@errCode AS nvarchar(10)) + ' Error= ' + @errStr

