

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_CreateDefaultTasks.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/TM_CreateDefaultTasks.script,v $ $Id: TM_CreateDefaultTasks.script,v 1.5.12.5.8.1 2021/01/13 00:21:23 abilbrey Exp $";

BEGIN

-------------------------------------------------------------------------------------

	----------------------------------------------------------------------------

	--									Variables							  --

	----------------------------------------------------------------------------

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @l_taskId1		INTEGER

	DECLARE @l_subTaskId1	INTEGER

	DECLARE @l_subTaskId2	INTEGER

	DECLARE @l_patternId1	INTEGER

	DECLARE @l_patternId2	INTEGER

	DECLARE @currentDate	DATETIME

	DECLARE @userId 	INTEGER

	DECLARE @currentTime	INTEGER

	DECLARE @xmlText		XML

	--MR142544 - Schedules for "Job Summary Report" and "Media Information Report" keep getting recreated by update install

DECLARE @freshInstall	INT = ISNULL((SELECT TOP 1 0 FROM DBUpgradeSteps WHERE Step = 'UpgradeType'), 1)

	SET @userId = (SELECT TOP 1 id FROM UMUsers WHERE flags&0x40=0x40)

	SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())

	set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))

	-- Create a unique local temp table for dbupgrade

	-- to avoid schema failures due to the same temp

	-- table name being in multiple tbl scripts

IF OBJECT_ID('TempDb..' +'#TM_IDTable_DefaultTasks') IS NOT NULL	
  		DROP TABLE #TM_IDTable_DefaultTasks ;		
  	CREATE TABLE #TM_IDTable_DefaultTasks (			
  		[id]		INT,			
  		[type]		INT,			
  		PRIMARY KEY([type], [id])	
  	);

	-----------------------------------------------------------------------------

	-- System Created Schedule Policy 

IF NOT EXISTS (SELECT * FROM TM_Task WHERE taskName = 'System Created (All  Agent Types)')

AND NOT EXISTS ( SELECT * FROM schedTemplate where name = 'System Created (All  Agent Types)')

	BEGIN

		-- Schedule Policy	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

OUTPUT	INSERTED.taskId , 1 INTO #TM_IDTable_DefaultTasks

VALUES			   ('System Created (All  Agent Types)',				-- Task Name

4,		-- Task Type

0x4,		-- Task Flags

							0,								-- Status

							0,								-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

'System created schedule policy for All Agent Types',		-- Description

							0,								-- Deleted

							0,								-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							1,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

							0,								-- Policy Type

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							0)								-- hidden

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_Task'

			GOTO ERROR_EXIT

		END

SET @l_taskId1 = (SELECT id FROM #TM_IDTable_DefaultTasks WHERE type = 1)

		-- Schedule 1 :

		-- Incremental Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

OUTPUT	INSERTED.subTaskId , 2 INTO #TM_IDTable_DefaultTasks

		VALUES				   ('',							-- SubTask Name

								@l_taskId1,					-- Task ID

2,		-- SubTask Type

2,	-- Operation Type

0x1,-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END

		-- Schedule 2 :

		-- Full Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

OUTPUT	INSERTED.subTaskId , 3 INTO #TM_IDTable_DefaultTasks

		VALUES				   ('',							-- SubTask Name

								@l_taskId1,					-- Task ID

2,		-- SubTask Type

2,	-- Operation Type

0x2,	-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END

SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable_DefaultTasks WHERE type = 2)

SET @l_subTaskId2 = (SELECT id FROM #TM_IDTable_DefaultTasks WHERE type = 3)

		-- Pattern 1:

		-- Weekly Monday to Thursday 6 pm
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

OUTPUT	INSERTED.patternId , 4 INTO #TM_IDTable_DefaultTasks

		VALUES				  ('',							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

0x8,				-- Freq Type

							   30,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,				-- Active Start Date

							   64800,						-- Active Start Time

							   '1970-01-01 00:00:00',		-- Active End Date	

							   0,						    -- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,					-- Time Zone Id 

							   1,							-- Calendar Id

							   '',							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END

		-- Pattern 2:

		-- Weekly Fridays 6 pm		 			   
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

OUTPUT	INSERTED.patternId , 5 INTO #TM_IDTable_DefaultTasks

		VALUES				  ('',							-- Name

							   @userId,							-- Owner ID

							   0,							-- Status

							   0,							-- Flags

0x8,				-- Freq Type

							   32,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,				-- Active Start Date

							   64800,						-- Active Start Time

							   '1970-01-01 00:00:00',		-- Active End Date	

							   0,						    -- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,					-- Time Zone Id 

							   1,							-- Calendar Id

							   '',							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END

SET @l_patternId1 = (SELECT id FROM #TM_IDTable_DefaultTasks WHERE type = 4)

SET @l_patternId2 = (SELECT id FROM #TM_IDTable_DefaultTasks WHERE type = 5)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					   (@l_patternId1,				-- Pattern ID

									@l_subTaskId1,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					   (@l_patternId2,				-- Pattern ID

									@l_subTaskId2,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId1,

										 '<TMMsg_JobOption><backupOpts runIncrementalBackup="1" collectMetaInfo="1" backupLevel="2" incLevel="1" sybaseSkipFullafterLogBkp="0" bkpLatestVersion="0" doNotTruncateLog="0" runSILOBackup="0"><oracleOptions cumulative="0" level="1"><deleteArchLogOptions backupArchiveLogCriteria="0" /><backupArchLogOptions backupArchiveLog="1" endLSN="1" backupArchiveLogCriteria="7" startLSN="1" /></oracleOptions><dataOpt startLogBackupAfterSuccessfullBackup="0" createNewIndex="0" followMountPoints="1" /></backupOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created  Schedule Policy-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId2,

										'<TMMsg_JobOption><backupOpts runIncrementalBackup="1" collectMetaInfo="1" backupLevel="1" incLevel="1" sybaseSkipFullafterLogBkp="0" bkpLatestVersion="0" doNotTruncateLog="0" runSILOBackup="0"><oracleOptions cumulative="0" level="1"><deleteArchLogOptions backupArchiveLogCriteria="0" /><backupArchLogOptions backupArchiveLog="1" endLSN="1" backupArchiveLogCriteria="7" startLSN="1" /></oracleOptions><dataOpt startLogBackupAfterSuccessfullBackup="0" createNewIndex="1" followMountPoints="1" /></backupOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId2)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- SubTask Options

		-- Incremental Schedule
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

312510015,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1816887603,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

458405394,

									   7,

									   2)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

756999446,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

560854980,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1004091438,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1349608518,

									   14,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

2000217775,

									   7,

									   7)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

283876525,

									   14,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

2045937773,

									   2,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1817749836,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

WHERE subTaskId = @l_subTaskId1 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)

		-- Full Backup
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

312510015,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

1816887603,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

458405394,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

756999446,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

560854980,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

1004091438,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

1349608518,

									   14,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

2000217775,

									   7,

									   7)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

283876525,

									   14,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

2045937773,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

1817749836,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

WHERE subTaskId = @l_subTaskId1 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)

	END

	ELSE

	BEGIN

UPDATE TM_Task SET flags = flags|0x4 WHERE taskName = 'System Created (All  Agent Types)'

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

SET @errStr = 'ERROR: System Created Schedules-- Failed to update flags for '+'System Created (All  Agent Types)'+' schedule'

			GOTO ERROR_EXIT

		END

	END

------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------

END 

ERROR_EXIT:

IF OBJECT_ID('TempDb..' +'#TM_IDTable_DefaultTasks') IS NOT NULL	
  		DROP TABLE #TM_IDTable_DefaultTasks ;

PRINT 'Errorcode = '+CAST(@errCode AS nvarchar(10)) + ' Error= ' + @errStr

