

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_CreateDefaultTaskForLoadBalanceIndexServers.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/TM_CreateDefaultTaskForLoadBalanceIndexServers.script,v $ $Id: TM_CreateDefaultTaskForLoadBalanceIndexServers.script,v 1.1.2.2.50.1 2021/01/13 00:21:25 abilbrey Exp $";

--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

--

--   Default analytics schedule which will be created for running da jobs on subclients associated to server plans whose clients are associated to DC plan.

--   OUTPUTS 

--

--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

DECLARE @errCode INTEGER

DECLARE @errStr  NVARCHAR(1024) = ''

BEGIN

-------------------------------------------------------------------------------------

	----------------------------------------------------------------------------

	--									Variables							  --

	----------------------------------------------------------------------------

	DECLARE @l_taskId1		INTEGER

	DECLARE @l_subTaskId1	INTEGER

	DECLARE @l_patternId1	INTEGER

	DECLARE @currentDate	DATETIME

	DECLARE @currentTime	INTEGER

DECLARE @userId			INT = (SELECT TOP 1 id FROM UMUsers WITH (NOLOCK) WHERE flags & 0x040 <> 0)

	SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())

	set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))

	DECLARE @xmlText		XML

	DECLARE @IsTranStarted INT = 0

	SET @errCode  = 0

	SET @errStr = ''

	DECLARE @workflowGUID NVARCHAR(36) = '69c1365d-dbce-4037-a31a-5cce827223c1'

	DECLARE @workflowId INT = (SELECT TOP 1 WorkflowId FROM WF_Definition WHERE uniqueGUID = @workflowGUID)

	BEGIN TRY

		-- Check if workflow exists

		IF @workflowId IS NULL

		BEGIN

			-- Workflow does not exist in user setup, can't create policy

			RETURN

		END 

		-- Earlier schedule policy was created with incorrect pattern. So if pattern is incorrect then mark existing schedule policy deleted. And create new. 

		SELECT @l_taskId1 = TM_Task.taskID FROM TM_Task (NOLOCK)

		INNER JOIN TM_Subtask (NOLOCK) ON TM_task.taskId = TM_subtask.taskId

		INNER JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.subTaskId = TM_subtask.subtaskId

		INNER JOIN TM_Pattern (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId

WHERE (TM_Task.flags & 0x20000)>0 AND TM_Task.DELETED=0

        IF @l_taskId1 > 0

        BEGIN

			-- Task is already created. Return

			RETURN

		END

		IF @@TRANCOUNT=0

		BEGIN

			SET @IsTranStarted = 1

			BEGIN TRAN

		END

		-- Update flags for existing task entry which is incorrectly created to 0 and deleted to 1. 

		UPDATE TM_Task

		SET flags = 0 , deleted = 1

		FROM TM_Task

		INNER JOIN TM_Subtask (NOLOCK) ON TM_task.taskId = TM_subtask.taskId

		LEFT JOIN TM_PatternAssoc (NOLOCK) ON TM_PatternAssoc.subTaskId = TM_subtask.subtaskId

		LEFT JOIN TM_Pattern (NOLOCK) ON TM_PatternAssoc.patternId = TM_Pattern.patternId

WHERE (TM_Task.flags & 0x20000)>0 AND TM_Task.DELETED=0

		AND TM_Pattern.patternID IS NULL

		-- Create a unique local temp table for dbupgrade

		-- to avoid schema failures due to the same temp

		-- table name being in multiple tbl scripts

IF OBJECT_ID('TempDb..' +'#TM_IDTable_DefTaskForLdBalIdxSvr') IS NOT NULL	
  		DROP TABLE #TM_IDTable_DefTaskForLdBalIdxSvr ;		
  	CREATE TABLE #TM_IDTable_DefTaskForLdBalIdxSvr (			
  		[id]		INT,			
  		[type]		INT,			
  		PRIMARY KEY([type], [id])	
  	);

		-------------------------------------------------------------------------

		-- System Created DA schedule

		-- Schedule Policy	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

OUTPUT	INSERTED.taskId , 1 INTO #TM_IDTable_DefTaskForLdBalIdxSvr

VALUES			   ( 'System created index cache load balancing',				-- Task Name

4,		-- Task Type

CAST(0x4 AS INT)| CAST(0x20000 AS INT),					-- Task Flags

							0,								-- Status

							0,								-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

'System created schedule policy for index cache load balancing',		-- Description

							0,								-- Deleted

							0,								-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							0,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

							13,								-- Policy Type : PolicyType::CONTENT_INDEX_SUBCLIENT

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							0)								-- hidden

SET @l_taskId1 = (SELECT id FROM #TM_IDTable_DefTaskForLdBalIdxSvr WHERE type = 1)

		-- Schedule 1 :

		-- TL Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

OUTPUT	INSERTED.subTaskId , 2 INTO #TM_IDTable_DefTaskForLdBalIdxSvr

VALUES				   ('System created index cache load balancing',							-- SubTask Name

								@l_taskId1,					-- Task ID

1,		-- SubTask Type

2001,	-- Operation Type

								0,							-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable_DefTaskForLdBalIdxSvr WHERE type = 2)

		---- Get CS Time Zone ID

		-- Pattern 1:

		-- Every 15 mins
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

OUTPUT	INSERTED.patternId , 4 INTO #TM_IDTable_DefTaskForLdBalIdxSvr

		VALUES				  ('Load Balance Index Servers',-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

0x20,			-- Freq Type

							   1,							-- Freq Interval

							   5,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval 

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,				-- Active Start Date

							   0,							-- Active Start Time

							   '1970-01-01 00:00:00',		-- Active End Date	

							   0,							-- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,						-- Time Zone Id 

							   1,							-- Calendar Id

							   'Every month on last Sunday at 12:00 AM',							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

SET @l_patternId1 = (SELECT id FROM #TM_IDTable_DefTaskForLdBalIdxSvr WHERE type = 4)
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		Values					    (@l_patternId1,				-- Pattern ID

									@l_subTaskId1,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)

		-- Subtask workflow assoc
		INSERT INTO TM_AssocWorkFlowEntity(assocType,


										   taskId,

										   flags,

										   created,

										   modified,

										   exclude,

										   workflowId,

										   clientId,

										   entityTitle,

										   workflowOption)

		VALUES 							  (0, 			-- assocType

										   @l_taskId1,	-- taskId

										   0,			-- flags

										   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate), -- created

										   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate), -- modified

										   0, 			-- exclude

										   @workflowId,	-- workflowId

										   0, 			-- clientId

										   'Load Balance Index Servers Workflow', 	-- entityTitle

										   '<inputs><storagePolicy/></inputs>')		-- workflowOption: run for all index servers

		-- SubTask XML Options

		SET @xmlText = '<TMMsg_JobOption><backupOpts backupLevel="2"><dataOpt autoCopy="0" /></backupOpts><adminOpts><contentIndexingOption fileAnalytics="0" subClientBasedAnalytics="0" reanalyze="0" /></adminOpts><restoreOptions><virtualServerRstOption isBlockLevelReplication="0" /></restoreOptions></TMMsg_JobOption>'
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,xmlValue)


		VALUES							(@l_subTaskId1,@xmlText)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		-- SubTask Options

		-- Incremental Schedule
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		Values						  (@l_subTaskId1,

130005,

									   1,

									   '000000000000000000'),

									  (@l_subTaskId1,

130006,

									   15,

									   '2357352946777864'),

									  (@l_subTaskId1,

300510029,

									   0,

									   '0'),

									  (@l_subTaskId1,

405755728,

									   0,

									   '0'),

									  (@l_subTaskId1,

458405394,

									   7,

									   '2'),

									  (@l_subTaskId1,

1013376701,

									   0,

									   '0')
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

WHERE subTaskId = @l_subTaskId1 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)

		IF (@IsTranStarted=1)

		BEGIN

			COMMIT TRAN

		END

	END TRY

	BEGIN CATCH	

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

        PRINT 'Rolling back transaction'

		IF (@IsTranStarted=1)

		BEGIN

			ROLLBACK TRAN

		END

	END CATCH;

ERROR_EXIT:

IF OBJECT_ID('TempDb..' +'#TM_IDTable_DefTaskForLdBalIdxSvr') IS NOT NULL	
  		DROP TABLE #TM_IDTable_DefTaskForLdBalIdxSvr ;

SELECT @errCode, @errStr

END 

