

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_CreateDefaultDDBTasks.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/TM_CreateDefaultDDBTasks.script,v $ $Id: TM_CreateDefaultDDBTasks.script,v 1.10.12.20.8.3 2021/05/03 04:15:05 mmansano Exp $";

SET QUOTED_IDENTIFIER ON

BEGIN

-------------------------------------------------------------------------------------

	----------------------------------------------------------------------------

	--									Variables							  --

	----------------------------------------------------------------------------

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	--DDB Backup--

	DECLARE @l_taskId1		INTEGER

	DECLARE @l_subTaskId1	INTEGER

	DECLARE @l_patternId1	INTEGER

	--Index Backup--

	DECLARE @l_taskId2		INTEGER

	DECLARE @l_subTaskId2	INTEGER

	DECLARE @l_patternId2	INTEGER

	--DV2 Job--

	DECLARE @l_taskId3		INTEGER

	DECLARE @l_subTaskId3	INTEGER

	DECLARE @l_patternId3	INTEGER

	DECLARE @currentDate	DATETIME

	DECLARE @userId 	INTEGER

	DECLARE @currentTime	INTEGER

	DECLARE @xmlText		XML

	--MR142544 - Schedules for "Job Summary Report" and "Media Information Report" keep getting recreated by update install

	DECLARE @freshInstall	INT = 0

	DECLARE @taskDisabled	INT = 0

	DECLARE @currentReleaseId INT = 0

	DECLARE @minReleaseId INT = 0

	DECLARE @upgradedSetup INT = 0

	SELECT TOP 1 @currentReleaseId = id FROM simAllGalaxyRel order by id desc

	SELECT @minReleaseId = MIN(ReleaseId) FROM LicUsageHistory WHERE CId=2

	IF @minReleaseId < @currentReleaseId

	BEGIN

		SET @upgradedSetup = 1

		SET @taskDisabled = 1

	END

IF NOT EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeType')

	BEGIN

		SET @freshInstall = 1

	END

	SET @userId = (SELECT TOP 1 id FROM UMUsers WHERE flags&0x40=0x40)

	SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())

	set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))

	DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

	-- Create a unique local temp table for dbupgrade

	-- to avoid schema failures due to the same temp

	-- table name being in multiple tbl scripts

IF OBJECT_ID('TempDb..' +'#TM_IDTable_DefaultDDBTasks') IS NOT NULL	
  		DROP TABLE #TM_IDTable_DefaultDDBTasks ;		
  	CREATE TABLE #TM_IDTable_DefaultDDBTasks (			
  		[id]		INT,			
  		[type]		INT,			
  		PRIMARY KEY([type], [id])	
  	);

	-----------------------------------------------------------------------------

	-- System Created DDB Schedule Policy 

IF NOT EXISTS (SELECT * FROM TM_Task WHERE (flags & 0x20)>0)

	BEGIN

		-- Schedule Policy	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

OUTPUT	INSERTED.taskId , 1 INTO #TM_IDTable_DefaultDDBTasks

VALUES			   ('System Created for DDB subclients',			-- Task Name

4,		-- Task Type

CAST(0x20 AS INT)|CAST(0x4 AS INT),					-- Task Flags

							0,								-- Status

							@currentTime,					-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

'System created schedule policy for DDB subclients',		-- Description

							0,								-- Deleted

							0,								-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							0,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

							0,								-- Policy Type

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							0)								-- hidden

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_Task'

			GOTO ERROR_EXIT

		END

SET @l_taskId1 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 1)

		-- Schedule 2 :

		-- Full Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

OUTPUT	INSERTED.subTaskId , 3 INTO #TM_IDTable_DefaultDDBTasks

		VALUES				   ('',							-- SubTask Name

								@l_taskId1,					-- Task ID

2,		-- SubTask Type

2,	-- Operation Type

0x200,			-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END

SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 3)

		-- Pattern 1:

		-- Weekly Monday to Thursday 12 am every 8 hours
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

OUTPUT	INSERTED.patternId , 4 INTO #TM_IDTable_DefaultDDBTasks

		VALUES				  ('',							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

0x8,				-- Freq Type

							   127,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   28800,						-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,				-- Active Start Date

							   0,							-- Active Start Time

							   '1970-01-01 00:00:00',		-- Active End Date	

							   86340,					    -- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,						-- Time Zone Id 

							   1,							-- Calendar Id

							   'Every week on Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday at 12:00 AM  and repeats every 8 hr(s) 0 min(s) until 11:59 PM',							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END

SET @l_patternId1 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 4)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					   (@l_patternId1,				-- Pattern ID

									@l_subTaskId1,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId1,

										'<TMMsg_JobOption><backupOpts runIncrementalBackup="1" collectMetaInfo="1" backupLevel="1" incLevel="1" sybaseSkipFullafterLogBkp="0" bkpLatestVersion="0" doNotTruncateLog="0" runSILOBackup="0"><oracleOptions cumulative="0" level="1"><deleteArchLogOptions backupArchiveLogCriteria="0" /><backupArchLogOptions backupArchiveLog="1" endLSN="1" backupArchiveLogCriteria="7" startLSN="1" /></oracleOptions><dataOpt startLogBackupAfterSuccessfullBackup="0" createNewIndex="1" followMountPoints="1" /></backupOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- Full Backup
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

312510015,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1816887603,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

458405394,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

756999446,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

560854980,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1004091438,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1349608518,

									   14,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

2000217775,

									   7,

									   7)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

283876525,

									   14,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

2045937773,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

1817749836,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DDB Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

WHERE subTaskId = @l_subTaskId1 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)

	END

	ELSE

	BEGIN

		-- It can happen that duplicate default DDB schedules are created. Since check above is based on = flag in previous revision. 

		-- So retaining only 1 default DDB schedule policy. 

UPDATE TM_Task SET flags = flags|0x4 WHERE (flags & 0x20)>0

		Update TM_Task

		set deleted = 1

where (flags & (0x20))= 0x20

		and taskId  not in		

		(

			select min(taskId) from TM_Task

where (flags & (0x20))= 0x20

		)

and taskType = 4

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

SET @errStr = 'ERROR: System Created Schedules-- Failed to update flags for '+'System Created for DDB subclients'+' schedule'

			GOTO ERROR_EXIT

		END

UPDATE TM_SubTask SET flags = flags|0x200 WHERE taskId in (SELECT taskId FROM TM_Task WHERE flags = 0x20)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

SET @errStr = 'ERROR: System Created Schedules-- Failed to update flags for '+'System Created for DDB subclients'+' schedule'

			GOTO ERROR_EXIT

		END

		IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '2379817e-564c-4f1b-b159-1a31f1aa8d4c')

        	BEGIN

		    -- we are executing below on v11 only so no additional version check is needed.

		    UPDATE TM_Pattern

		    SET freq_subday_interval = 86400,

		    active_start_time = 57600

		    WHERE patternId IN (SELECT PA.patternId 

						FROM TM_PatternAssoc PA WITH (NOLOCK) 

							INNER JOIN TM_SubTask ST WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId

							INNER JOIN TM_Task T WITH (NOLOCK) ON ST.taskId = T.taskId

WHERE (T.flags & 0x20) > 0 AND T.modified = 0)

		    AND freq_subday_interval = 28800

		    AND active_start_time = 0
		    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('2379817e-564c-4f1b-b159-1a31f1aa8d4c', 'ModifyDefaultDDBBackupScheduleScript', 'Update script to set the default DDB Backup schedule to run once in 24hrs', @nowTime, 16, 0, 17)

		END

		IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '45D2340B-8007-4C8C-9C10-F95A4D5AAC8B')

        BEGIN

		    IF EXISTS 

			(

				SELECT	1

				FROM	archGroupCopy AGC WITH (NOLOCK)

						INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AGC.archGroupId = AG.id

WHERE	(AG.flags & 33554432) > 0

			)

			BEGIN
				INSERT INTO TM_AssocEntity(assocType, taskId, flags, created, clientGroupId, clientId, appTypeId, instanceId,


											   backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude,

											   trackingPolicyId, MediaagentId, agentlessPolicyId, workflowId, sidbStoreId, libraryId, logMonitoringPolicyId)

SELECT		18,

							T.taskId,     	-- Task ID

							0,              -- Flags

							@nowTime,		-- Created

							0,              -- ClientGroupID

							0,              -- ClientID

							0,              -- AppTypeID

							0,              -- InstanceID

							0,              -- BackupSetID

							0,              -- SubClient ID

							AG.id,			-- PolicyID

							AGC.id,			-- Copy ID

							0,              -- SRM Report Set

							0,              -- SRM Report Type

							1,              -- Exclude

							0,              -- Trackung Policy ID

							0,              -- Media Agent ID

							0,              -- Agentless SRM ID

							0,              -- Workflow ID

							0,   			-- SIDB Store ID

							0,              -- Library ID

							0               -- Log Monitor Policy ID	

				FROM	TM_Task T WITH(READUNCOMMITTED), 

						archGroupCopy AGC WITH (NOLOCK)

						INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AGC.archGroupId = AG.id

WHERE 	T.flags & 0x800 > 0

AND (AG.flags & 33554432) > 0

						AND NOT EXISTS (SELECT  TE.taskId 

										FROM	TM_AssocEntity TE WITH(READUNCOMMITTED)

										WHERE	TE.taskId = T.taskId

												AND TE.copyId  = AGC.id 

												AND TE.policyId = AGC.archGroupId

												AND TE.sidbStoreId = 0)

			END
		    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('45D2340B-8007-4C8C-9C10-F95A4D5AAC8B', 'ExcludeScaleOutStoragePolicyCopiesFromDDBVerificationSchedule', 'Exclude system created DDB verificaiton schedule policy for Scale out storage policy copies', @nowTime, 16, 0, 17)

		END

	END

------------------------------------------------------------------------------------

	-- System Created IndexBackup Schedule Policy 

IF NOT EXISTS (SELECT * FROM TM_Task WHERE flags&0x80 = 0x80)

	BEGIN

		-- Schedule Policy	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

OUTPUT	INSERTED.taskId , 5 INTO #TM_IDTable_DefaultDDBTasks

VALUES			   ('System Created for Index Backups',		-- Task Name

4,		-- Task Type

CAST(0x80 AS INT)|CAST(0x4 AS INT),					-- Task Flags

							0,								-- Status

							@currentTime,					-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

'System created schedule policy for Index Backups',		-- Description

							0,								-- Deleted

							0,								-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							0,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

							0,								-- Policy Type

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							0)								-- hidden

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_Task'

			GOTO ERROR_EXIT

		END

SET @l_taskId2 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 5)

		-- Schedule 2 :

		-- Full Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

OUTPUT	INSERTED.subTaskId , 6 INTO #TM_IDTable_DefaultDDBTasks

		VALUES				   ('',							-- SubTask Name

								@l_taskId2,					-- Task ID

2,		-- SubTask Type

2,	-- Operation Type

0x800,	-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END

SET @l_subTaskId2 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 6)

		-- Pattern 1:

		-- Daily at 1 PM
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

OUTPUT	INSERTED.patternId , 7 INTO #TM_IDTable_DefaultDDBTasks

		VALUES				  ('',							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

0x4,			-- Freq Type

							   1,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,				-- Active Start Date

							   46800,						-- Active Start Time

							   '1970-01-01 00:00:00',		-- Active End Date	

							   86340,					    -- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,						-- Time Zone Id 

							   1,							-- Calendar Id

							   'Every Day at 1:00 PM',		-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END

SET @l_patternId2 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 7)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					   (@l_patternId2,				-- Pattern ID

									@l_subTaskId2,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId2,

										'<TMMsg_JobOption><backupOpts runIncrementalBackup="1" collectMetaInfo="1" backupLevel="1" incLevel="1" sybaseSkipFullafterLogBkp="0" bkpLatestVersion="0" doNotTruncateLog="0" runSILOBackup="0"><oracleOptions cumulative="0" level="1"><deleteArchLogOptions backupArchiveLogCriteria="0" /><backupArchLogOptions backupArchiveLog="1" endLSN="1" backupArchiveLogCriteria="7" startLSN="1" /></oracleOptions><dataOpt startLogBackupAfterSuccessfullBackup="0" createNewIndex="1" followMountPoints="1" /></backupOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId2)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId2, @l_subTaskId2, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- Full Backup
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

312510015,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

1816887603,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

458405394,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

756999446,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

560854980,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

1004091438,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

1349608518,

									   14,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

2000217775,

									   7,

									   7)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

283876525,

									   14,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

2045937773,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

1817749836,

									   2,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId2, @l_subTaskId2, 0, @currentTime, 0 


		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

WHERE subTaskId = @l_subTaskId2 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)

	END

	ELSE

	BEGIN

		IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '3C101FC2-5B52-4598-A583-ECBCC3F7FC23')

        BEGIN

		    UPDATE TM_Pattern

			SET freq_interval=1, freq_type = 4, freq_subday_interval = 0, active_start_time = 46800, description = 'Every day at 1:00 PM'

		    WHERE patternId IN (SELECT PA.patternId 

						FROM TM_PatternAssoc PA WITH (NOLOCK) 

							INNER JOIN TM_SubTask ST WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId

							INNER JOIN TM_Task T WITH (NOLOCK) ON ST.taskId = T.taskId

WHERE (T.flags & 0x80) > 0)

		    AND freq_subday_interval = 28800

		    AND active_start_time = 0
		    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('3C101FC2-5B52-4598-A583-ECBCC3F7FC23', 'ModifyDefaultDDBBackupScheduleScript', 'Update script to set the default Index Backup schedule to run once daily', @nowTime, 16, 0, 17)

		END

		-- Rename created schedule to "System Created for Index Backups"

IF NOT EXISTS (SELECT 1 FROM TM_Task WITH(NOLOCK) WHERE (flags & 0x80 = 0x80) AND taskType = 4 AND taskName = 'System Created for Index Backups')

		BEGIN

			UPDATE TM_Task 

SET taskName = 'System Created for Index Backups', description = 'System created schedule policy for Index Backups'

WHERE (flags & 0x80 = 0x80) AND taskType = 4

		END

	END

	-----------------------------------------------------------------------------

	-- System Created DV2 Schedule Policy 

IF NOT EXISTS (SELECT * FROM TM_Task WHERE (flags & 0x800)>0)

	BEGIN

		-- Schedule Policy	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

OUTPUT	INSERTED.taskId , 8 INTO #TM_IDTable_DefaultDDBTasks

VALUES			   ('System Created DDB Verification schedule policy',			-- Task Name

4,		-- Task Type

CAST(0x800 AS INT)|CAST(0x4 AS INT),					-- Task Flags

							0,								-- Status

							@currentTime,					-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

'System created schedule policy for DDB Verification',		-- Description

							0,								-- Deleted

							@taskDisabled,					-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							0,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

11,	-- Policy Type

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							0)								-- hidden

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_Task'

			GOTO ERROR_EXIT

		END

SET @l_taskId3 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 8)

		-- Associations

		--MR:166575 -  On upgraded setups, just create an exclusion for all the existing stores. Also make sure to create a row with associate all stores going forward (Abhishek Narulkar)

		--IF @upgradedSetup = 0

		BEGIN
			INSERT INTO TM_AssocEntity(assocType,


									   taskId,

									   flags,

									   created,

									   clientGroupId,

									   clientId,

									   appTypeId,

									   instanceId,

									   backupsetId,

									   subclientId,

									   policyId,

									   copyId,

									   srmReportSet,

									   srmReportType,

									   exclude,

									   trackingPolicyId,

									   MediaagentId,

									   agentlessPolicyId,

									   workflowId,

									   sidbStoreId,

									   libraryId,

									   logMonitoringPolicyId

									   )

VALUES					  (155,			-- assocTye		--ALL_SIDB_STORES_ENTITY

									   @l_taskId3,	-- Task ID

									   0,			-- Flags

									   0,			-- Created

									   0,			-- ClientGroupID

									   0,			-- ClientID

									   0,			-- AppTypeID

									   0,			-- InstanceID

									   0,			-- BackupSetID

									   0,			-- SubClient ID

									   0,			-- PolicyID

									   0,			-- Copy ID

									   0,			-- SRM Report Set

									   0,			-- SRM Report Type

									   0,			-- Exclude

									   0,			-- Trackung Policy ID

									   0,			-- Media Agent ID

									   0,			-- Agentless SRM ID

									   0,			-- Workflow ID

									   0,           -- SIDB Store ID

									   0,           -- Library ID

									   0            -- Log Monitor Policy ID

									   )

			SET @errCode = @@ERROR

			IF	@errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created DV2 Schedule Policy-- Failed to insert in TM_AssocEntity'

				GOTO ERROR_EXIT

			END

		END

		IF @upgradedSetup = 1

		BEGIN
			INSERT INTO TM_AssocEntity(assocType,


										taskId,

										flags,

										created,

										clientGroupId,

										clientId,

										appTypeId,

										instanceId,

										backupsetId,

										subclientId,

										policyId,

										copyId,

										srmReportSet,

										srmReportType,

										exclude,

										trackingPolicyId,

										MediaagentId,

										agentlessPolicyId,

										workflowId,

										sidbStoreId,

										libraryId,

										logMonitoringPolicyId

										)

			SELECT 

115,			-- assocTye		--_ENTITY_TYPE_SIDB_STORE_ENTITY

										@l_taskId3,	-- Task ID

										0,			-- Flags

										0,			-- Created

										0,			-- ClientGroupID

										0,			-- ClientID

										0,			-- AppTypeID

										0,			-- InstanceID

										0,			-- BackupSetID

										0,			-- SubClient ID

										AGC.archGroupId, -- PolicyID

										AGC.id,		-- Copy ID

										0,			-- SRM Report Set

										0,			-- SRM Report Type

										1,			-- Exclude

										0,			-- Trackung Policy ID

										0,			-- Media Agent ID

										0,			-- Agentless SRM ID

										0,			-- Workflow ID

										ACS.SIDBStoreId, -- SIDB Store ID

										0,			-- Library ID

										0			-- Log Monitor Policy ID

			FROM archGroupCopy AGC (READUNCOMMITTED), archCopySIDBStore ACS (READUNCOMMITTED)

WHERE AGC.dedupeFlags & 134217728 = 0

				AND AGC.id = ACS.CopyId

				AND ACS.SIDBStoreId > 0

		END

		-- Schedule 1 :
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

OUTPUT	INSERTED.subTaskId , 9 INTO #TM_IDTable_DefaultDDBTasks

		VALUES				   ('',							-- SubTask Name

								@l_taskId3,					-- Task ID

1,		-- SubTask Type

4007,	-- Operation Type

0x1000,			-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END

SET @l_subTaskId3 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 9)

		-- Pattern 1:

		-- Weekly Monday to Thursday 12 am every 8 hours
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

OUTPUT	INSERTED.patternId , 10 INTO #TM_IDTable_DefaultDDBTasks

		VALUES				  ('',							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

0x4,				-- Freq Type

							   1,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   86400,						-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,				-- Active Start Date

							   39600,						-- Active Start Time	--11A.M.

							   '1970-01-01 00:00:00',		-- Active End Date	

							   86340,					    -- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,						-- Time Zone Id 

							   1,							-- Calendar Id

							   'Every day at 11:00 AM and repeats every 24 hr(s) 0 min(s) until 12:00 AM',	-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END

SET @l_patternId3 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 10)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					   (@l_patternId3,				-- Pattern ID

									@l_subTaskId3,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options

		IF @freshInstall = 1

		BEGIN
			INSERT INTO TM_SubTaskXMLOptions(subTaskID,


											 xmlValue)

			VALUES							(@l_subTaskId3,

											'<TMMsg_JobOption><backupOpts><mediaOpt><auxcopyJobOption maxNumberOfStreams="0" useMaximumStreams="1" ></auxcopyJobOption></mediaOpt></backupOpts><adminOpts><archiveCheckOption allCopies="1" backupLevel="2" ddbVerificationLevel="1" jobsToVerify="0"></archiveCheckOption></adminOpts></TMMsg_JobOption>')

		END

		ELSE

		BEGIN
			INSERT INTO TM_SubTaskXMLOptions(subTaskID,


											 xmlValue)

			VALUES							(@l_subTaskId3,

											'<TMMsg_JobOption><backupOpts><mediaOpt><auxcopyJobOption maxNumberOfStreams="0" useMaximumStreams="1" ></auxcopyJobOption></mediaOpt></backupOpts><adminOpts><archiveCheckOption allCopies="1" backupLevel="2" ddbVerificationLevel="3" jobsToVerify="0"></archiveCheckOption></adminOpts></TMMsg_JobOption>')		

		END

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId3)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId3, @l_subTaskId3, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- Full Backup
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

2105046087,

									   7,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

1109628066,

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

243350436,

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

1492218294,

									   7,

									   2)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

1616894445,

									   7,

									   CASE WHEN @freshInstall = 1 THEN 1 ELSE 3 END)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

1296526582,

									   7,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId3, @l_subTaskId3, 0, @currentTime, 0 


		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

WHERE subTaskId = @l_subTaskId3 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)

	END

	ELSE   -- else part is needed for SP23 and Sp24 only as the correct verification level would be part of the tip on SP25 onwards and the hotfix won't be applied on top of the tip changes

	BEGIN

		IF @freshInstall = 1

		BEGIN

SET @l_taskId3 = (SELECT taskId FROM TM_Task WHERE  flags & (CAST(0x800 AS INT)|CAST(0x4 AS INT)) = CAST(0x800 AS INT)|CAST(0x4 AS INT))

			SET @l_subTaskId3 = (SELECT subTaskID FROM TM_SubTask WITH (READUNCOMMITTED) WHERE taskId = @l_taskId3)

			Update TM_SubTaskXMLOptions

			SET xmlValue = '<TMMsg_JobOption><backupOpts><mediaOpt><auxcopyJobOption maxNumberOfStreams="0" useMaximumStreams="1" ></auxcopyJobOption></mediaOpt></backupOpts><adminOpts><archiveCheckOption allCopies="1" backupLevel="2" ddbVerificationLevel="1" jobsToVerify="0"></archiveCheckOption></adminOpts></TMMsg_JobOption>'

			WHERE subTaskID = @l_subTaskId3

			Update TM_SubTaskOptions

			SET value = 1

			WHERE subTaskID = @l_subTaskId3

AND optionID =   1616894445

		END

	END

	-- Execute this script only once. And the entry on GXUniqueSQLScriptExecTracking should never be removed. So setting expired releaseid for this script as 100.

	declare @guid uniqueidentifier = '45FB9FA5-3B44-4208-B2DC-627202E0738B'

	DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

	DECLARE @cloudSidbStoreRemoveAssocExec INT = 0

	SELECT @cloudSidbStoreRemoveAssocExec = 1

	FROM

		GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

	WHERE

		gp.SqlScriptGUID = @guid

	IF (@cloudSidbStoreRemoveAssocExec = 0)        -- not done, Add the cloud sidb stores to excluded list. 

	BEGIN
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'CloudSidbStoreRemoveAssociation', 'Remove association of cloud sidb stores from system created dv2 schedule policy', @curUtcDateTime, 16, 0 , 100) -- setting expired release id to 100

		-- For the system created DV2 policy, exclude stores which have cloud paths. 

		declare @sidbStoresToExclude table

		(

			sidbStoreId int,

			spid int,

			copyid int

		)
		Insert into @sidbStoresToExclude


		SELECT distinct CS.SIDBStoreId storeId,AC.archGroupId,ac.id

		FROM archGroupCopy AC WITH (NOLOCK)

INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON CS.copyID = AC.id AND ((CS.Flags & 4) > 0)

										INNER JOIN MMDataPath M WITH (NOLOCK) ON AC.id = M.CopyId

										INNER JOIN MMDrivePool D WITH (NOLOCK) ON M.DrivePoolId = D.DrivePoolId

										INNER JOIN MMMountPath P WITH (NOLOCK) ON D.MasterPoolId = P.MasterPoolId

						WHERE P.MountPathTypeId = 7                -- MOUNT_PATH_EXTERNAL_REMOTE_HOST

AND (AC.dedupeFlags & 134217728) = 0

						AND CS.SIDBStoreId>0

		declare @taskIdDv2 int = 0

		select @taskIdDv2 = taskid

from TM_Task WHERE (flags & 0x800)>0

		if @taskIdDv2=0

		begin

			return

		end

		delete sidbStoresToExclude

		from @sidbStoresToExclude sidbStoresToExclude

		inner join TM_AssocEntity on 

		(TM_AssocEntity.sidbStoreId=sidbStoresToExclude.sidbStoreId OR TM_AssocEntity.sidbStoreId=0)

		and TM_AssocEntity.policyId=sidbStoresToExclude.spid 

		and (TM_AssocEntity.copyId=sidbStoresToExclude.copyId or TM_AssocEntity.copyId=0)

		and TM_AssocEntity.taskId=@taskIdDv2	
		INSERT INTO TM_AssocEntity(assocType,


											   taskId,

											   flags,

											   created,

											   clientGroupId,

											   clientId,

											   appTypeId,

											   instanceId,

											   backupsetId,

											   subclientId,

											   policyId,

											   copyId,

											   srmReportSet,

											   srmReportType,

											   exclude,

											   trackingPolicyId,

											   MediaagentId,

											   agentlessPolicyId,

											   workflowId,

											   sidbStoreId,

											   libraryId,

											   logMonitoringPolicyId

											   )

		select 115, --SIDB_STORE_ENTITY

				@taskIdDv2,	-- Task ID

				0,			-- Flags

				@curUtcDateTime,	-- Created

				0,			-- ClientGroupID

				0,			-- ClientID

				0,			-- AppTypeID

				0,			-- InstanceID

				0,			-- BackupSetID

				0,			-- SubClient ID

				spid,			-- PolicyID

				copyid,			-- Copy ID

				0,			-- SRM Report Set

				0,			-- SRM Report Type

				1,			-- Exclude

				0,			-- Trackung Policy ID

				0,			-- Media Agent ID

				0,			-- Agentless SRM ID

				0,			-- Workflow ID

				sidbStoreId, -- SIDB Store ID

				0,           -- Library ID

				0            -- Log Monitor Policy ID

		from @sidbStoresToExclude

	end

------------------------------------------------------------------------------------

	-----------------------------------------------------------------------------

	-- System Created DV2 Space Reclamation Schedule Policy 

IF NOT EXISTS (SELECT * FROM TM_Task WHERE (flags & 0x40000)>0)

	BEGIN

		DECLARE @DefragIsDisabledOnMMThread INT = 0

		IF EXISTS (SELECT 1 FROM MMConfigs WHERE (name = 'MM_CONFIG_CHECKTWEAK_MPDEFRAGJOBSUBMIT_INTERVAL_MINS') AND VALUE = 0)

			SET @DefragIsDisabledOnMMThread = 1

		DELETE FROM MMConfigs

		WHERE name = 'MM_CONFIG_CHECKTWEAK_MPDEFRAGJOBSUBMIT_INTERVAL_MINS'

		-- Schedule Policy	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

OUTPUT	INSERTED.taskId , 11 INTO #TM_IDTable_DefaultDDBTasks

VALUES			   ('System Created DDB Space Reclamation schedule policy',	-- Task Name

4,		-- Task Type

CAST(0x40000 AS INT)|CAST(0x4 AS INT),					-- Task Flags

							0,								-- Status

							@currentTime,					-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

'System created schedule policy for DDB Space Reclamation',		-- Description

							0,								-- Deleted

							(@taskDisabled | @DefragIsDisabledOnMMThread),					-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							0,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

16,	-- Policy Type

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							0)								-- hidden

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_Task'

			GOTO ERROR_EXIT

		END

SET @l_taskId3 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 11)

		BEGIN
			INSERT INTO TM_AssocEntity(assocType,


									   taskId,

									   flags,

									   created,

									   clientGroupId,

									   clientId,

									   appTypeId,

									   instanceId,

									   backupsetId,

									   subclientId,

									   policyId,

									   copyId,

									   srmReportSet,

									   srmReportType,

									   exclude,

									   trackingPolicyId,

									   MediaagentId,

									   agentlessPolicyId,

									   workflowId,

									   sidbStoreId,

									   libraryId,

									   logMonitoringPolicyId

									   )

VALUES					  (155,			-- assocTye		--ALL_SIDB_STORES_ENTITY

									   @l_taskId3,	-- Task ID

									   0,			-- Flags

									   0,			-- Created

									   0,			-- ClientGroupID

									   0,			-- ClientID

									   0,			-- AppTypeID

									   0,			-- InstanceID

									   0,			-- BackupSetID

									   0,			-- SubClient ID

									   0,			-- PolicyID

									   0,			-- Copy ID

									   0,			-- SRM Report Set

									   0,			-- SRM Report Type

									   0,			-- Exclude

									   0,			-- Trackung Policy ID

									   0,			-- Media Agent ID

									   0,			-- Agentless SRM ID

									   0,			-- Workflow ID

									   0,           -- SIDB Store ID

									   0,           -- Library ID

									   0            -- Log Monitor Policy ID

									   )

			SET @errCode = @@ERROR

			IF	@errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy-- Failed to insert in TM_AssocEntity'

				GOTO ERROR_EXIT

			END

		END

		-- Schedule 1 :
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

OUTPUT	INSERTED.subTaskId , 12 INTO #TM_IDTable_DefaultDDBTasks

		VALUES				   ('',							-- SubTask Name

								@l_taskId3,					-- Task ID

1,		-- SubTask Type

4007,	-- Operation Type

0x1000000,			-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END

SET @l_subTaskId3 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 12)

		-- Pattern 1:

		-- Every day 8 am
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

OUTPUT	INSERTED.patternId , 13 INTO #TM_IDTable_DefaultDDBTasks

		VALUES				  ('',							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

0x4,			-- Freq Type

							   1,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,				-- Active Start Date

							   39600,						-- Active Start Time	--11A.M.

							   '1970-01-01 00:00:00',		-- Active End Date	

							   0,							-- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,						-- Time Zone Id 

							   1,							-- Calendar Id

							   'Every day at 11:00 AM and repeats every 24 hr(s) 0 min(s) until 12:00 AM',	-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END

SET @l_patternId3 = (SELECT id FROM #TM_IDTable_DefaultDDBTasks WHERE type = 13)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					   (@l_patternId3,				-- Pattern ID

									@l_subTaskId3,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId3,

										'<TMMsg_JobOption><backupOpts backupLevel="2"><dataOpt autoCopy="0" /><mediaOpt><auxcopyJobOption maxNumberOfStreams="0" allCopies="1" useMaximumStreams="1" autoCopy="0" useScallableResourceManagement="0"><mediaAgent mediaAgentId="0" _type_="11" mediaAgentName="" /></auxcopyJobOption></mediaOpt></backupOpts><adminOpts><contentIndexingOption subClientBasedAnalytics="0" /><archiveCheckOption ddbVerificationLevel="4" jobsToVerify="0" allCopies="1" defragmentationPercentage="40" backupLevel="1" /></adminOpts><restoreOptions><commonOptions syncRestore="0" /></restoreOptions><commonOpts jobDescription="" /></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId3)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId3, @l_subTaskId3, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- Full Backup
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

2105046087,

									   7,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

1109628066,

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

243350436,

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

1492218294,

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

1616894445,

									   7,

									   4)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

1807503022,

									   7,

									   40)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

1296526582,

									   7,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DV2 Space Reclamation Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId3, @l_subTaskId3, 0, @currentTime, 0 


		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

WHERE subTaskId = @l_subTaskId3 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)

		IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '492BB7BB-4621-45E8-8159-8F6BB2F8CDE6')

		BEGIN
		    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('492BB7BB-4621-45E8-8159-8F6BB2F8CDE6', 'ModifyDefaultDDBDefragLevel', 'Update script to set the default DDB Defrag schedule to run in full on New create', @nowTime, 16, 0, 17)

		END

	END

	ELSE

	BEGIN

		-- Convert system created defrag schedule to full schedule once

		IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '492BB7BB-4621-45E8-8159-8F6BB2F8CDE6')

        BEGIN

			SELECT @l_taskId3 = taskId 

			FROM TM_Task 

WHERE (flags & (CAST(0x40000 AS INT)|CAST(0x4 AS INT))) = (CAST(0x40000 AS INT)|CAST(0x4 AS INT))

			SELECT  TOP 1 @l_subTaskId3 = subTaskId

			FROM	TM_SubTask

			WHERE	taskId = @l_taskId3

			UPDATE	TM_SubTaskOptions

			SET		value = 1

			WHERE	subTaskId = @l_subTaskId3

AND optionID = 1492218294

					AND type = 7

					AND value != 1

			DECLARE @value INT = 1

			UPDATE TM_SubTaskXMLOptions

			SET		xmlValue.modify('replace value of (/TMMsg_JobOption/adminOpts/archiveCheckOption/@backupLevel)[1] with sql:variable("@value")')

			FROM	TM_SubTaskXMLOptions

			WHERE	subTaskId = @l_subTaskId3

					AND TM_SubTaskXMLOptions.xmlValue.exist('/TMMsg_JobOption/adminOpts/archiveCheckOption/@backupLevel') = 1
		    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('492BB7BB-4621-45E8-8159-8F6BB2F8CDE6', 'ModifyDefaultDDBDefragLevel', 'Update script to set the default DDB Defrag schedule to run in full', @nowTime, 16, 0, 17)

		END

	END

	-- Update policy type of defrag schedules from Data Verification to DDB Space Reclamation

	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '83BFAE13-5CDA-4A38-B175-73735F09383B')

	BEGIN	

		UPDATE TM_Task

SET policyType = 16

		FROM TM_task T

		WHERE  NOT EXISTS (

							 SELECT 1

							 FROM  TM_SubTaskOptions STO WITH (READUNCOMMITTED),  TM_SubTask ST WITH (READUNCOMMITTED)

							 WHERE T.taskId = ST.taskId AND STO.subTaskId = ST.SubtaskId AND STO.value <> 4 

AND STO.optionID = 1616894445

							)

AND T.policyType = 11
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('83BFAE13-5CDA-4A38-B175-73735F09383B', 'UpdatePolicyTypeForDefragSchedules', 'Update script to set the policy type of defrag schedules to DDB Space Reclamation', @nowTime, 16, 0, 17)

	END

------------------------------------------------------------------------------------

END 

ERROR_EXIT:

IF OBJECT_ID('TempDb..' +'#TM_IDTable_DefaultDDBTasks') IS NOT NULL	
  		DROP TABLE #TM_IDTable_DefaultDDBTasks ;

PRINT 'Errorcode = '+CAST(@errCode AS nvarchar(10)) + ' Error= ' + @errStr

