

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_CreateDBMaintenance.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

--Create Schedules for DBMaintenance

BEGIN

DECLARE @errCode		INTEGER

DECLARE @errStr			varchar(1024)

DECLARE @currentDate    DATETIME

DECLARE @userId			INTEGER

DECLARE @currentTime    INTEGER

DECLARE @l_taskId1      INTEGER = 0

DECLARE @l_subTaskId1	INTEGER

DECLARE @l_patternId1	INTEGER

DECLARE @xmlText        XML

DECLARE @xmlSubTaskOpts XML

DECLARE @WFId			INTEGER = 0

DECLARE @WFEngId		INTEGER = 0

DECLARE @freshInstall	INT = ISNULL((SELECT TOP 1 0 FROM DBUpgradeSteps WHERE Step = 'UpgradeType'), 1)

DECLARE @disabled		INT = 0

IF @freshInstall = 0

	SET @disabled = 1

SET @userId = (SELECT TOP 1 id FROM UMUsers WHERE flags&0x40=0x40)

SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())

set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))

SET @WFId = (SELECT WorkflowId FROM WF_Definition WHERE Name = 'DBMaintenance')

IF @WFId IS NULL OR @WFId = 0

BEGIN 

	SET @errStr = 'ERROR: Workflow[DBMaintenance] does not exist'

	GOTO ERROR_EXIT	

END

SELECT TOP 1 @WFEngId=ClientId FROM simInstalledPackages WHERE simPackageID =  808

--IF @WFEngId = 0

--BEGIN 

	--SET @errStr = 'ERROR: Workflow Engine not installed'

	--GOTO ERROR_EXIT	

--END

SET @xmlSubTaskOpts = '<TMMsg_JobOption workflowJobOptions="&lt;inputs&gt;&lt;type&gt;recommended&lt;/type&gt;&lt;/inputs&gt;"><backupOpts backupLevel="2"><dataOpt autoCopy="0" /></backupOpts></TMMsg_JobOption>'

-- Create a unique local temp table for dbupgrade

	-- to avoid schema failures due to the same temp

	-- table name being in multiple tbl scripts

IF OBJECT_ID('TempDb..' +'#TM_IDTable_DbMaintenance') IS NOT NULL	
  		DROP TABLE #TM_IDTable_DbMaintenance ;		
  	CREATE TABLE #TM_IDTable_DbMaintenance (			
  		[id]		INT,			
  		[type]		INT,			
  		PRIMARY KEY([type], [id])	
  	);

IF OBJECT_ID('tempdb.dbo.#optionsTable') IS NOT NULL

	DROP TABLE #optionsTable

CREATE TABLE #optionsTable (optionID BIGINT, type INT, value NVARCHAR(2048))

--Schedule DBMaintenance for expired storage

--Create a Task in TM_Task

IF NOT EXISTS (SELECT * FROM TM_SubTask WHERE flags & 0x8000 = 0x8000)

  BEGIN
	INSERT INTO TM_Task(taskName,


						taskType,

						flags,  

						status, 

						created,    

						modified,

						alertId,    

						ownerId,    

						runUserId,  

						initiatedFrom,  

						sequenceNumber,

						localeId,

						description,

						deleted,

						disabled,

						uninstalled,

						invalid,

						defaultTask,

						savedReport,

						serial,

						policyType,

						origCCId,

						GUID,

						isEZOperation,

						isAgentlessSRM,

						hidden)

OUTPUT  INSERTED.taskId , 1 INTO #TM_IDTable_DbMaintenance

	VALUES

						(

							'',

2,

CAST(0x4 AS INT),

							0, 

							@currentTime,

							0,

							0,

							@userId,

							@userId,

3,

							0,

							0,

'System Created DBMaintenance schedule',

							0,

							@disabled,

							0,

							0,

							1,

							0,

							0,

							0,

							DEFAULT,

							newid(),

							0,

							0,

							0

						)	

	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to insert in TM_Task'

		GOTO ERROR_EXIT

	END

SET @l_taskId1 = (SELECT id FROM #TM_IDTable_DbMaintenance WHERE type = 1)

	--Create a Sub Task
	INSERT INTO TM_SubTask (subTaskName,


							taskId,

							subTaskType ,   

							operationType,  

							flags       ,   

							subTaskOrder,

							deleted,

							uninstalled,

							defaultTask)

OUTPUT  INSERTED.subTaskId , 2 INTO #TM_IDTable_DbMaintenance

VALUES                 ('System Created DBMaintenance schedule',	-- SubTask Name

							@l_taskId1,						-- Task ID

1,			-- SubTask Type

2001,	-- Operation Type

0x8000,	-- Flags

							0,								-- SubTask Order

							0,								-- Deleted

							0,								-- Uninstalled

							0)								-- Default Task ???

	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to insert in TM_SubTask'

		GOTO ERROR_EXIT

	END

SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable_DbMaintenance WHERE type = 2)

	--Create a Pattern
	INSERT INTO TM_Pattern(name,


						   ownerId,

						   status,

						   flags,

						   freq_type,

						   freq_interval,

						   freq_relative_interval,

						   freq_recurrence_factor,

						   freq_subday_interval,

						   skipOccurence,

						   skipDayNumber,

						   active_start_date,

						   active_start_time,

						   active_end_date,

						   active_end_time,

						   active_end_occurence,

						   created,

						   modified,

						   tzId,

						   calendarId,

						   description,

						   local_start_date,

						   local_end_date,

						   disabled,

						   deleted,

						   scheduling,

						   freq_restart_interval)

OUTPUT  INSERTED.patternId , 3 INTO #TM_IDTable_DbMaintenance

	VALUES                ('',                          											-- Name

						   @userId,                     											-- Owner ID

						   0,                           											-- Status

						   0,                           											-- Flags

0x8,              											-- Freq Type

						   1,                           											-- Freq Interval

						   0,                           											-- Freq Relative Interval

						   2,                           											-- Freq Recurrence Factor

						   0,                           											-- Freq Subday Interval

						   0,                           											-- Skip Occurrence

						   0,                           											-- Skip Day Number

						   @currentDate,                											-- Active Start Date

						   54000,                       											-- Active Start Time

						   '1970-01-01 00:00:00',       											-- Active End Date  

						   0,                           											-- Active End Time

						   0,                           											-- Active End Occurrence

						   @currentTime,                											-- Created

						   0,                           											-- Modified

						   1000,                   													-- Time Zone Id 

						   1,                           											-- Calendar Id

						   'Every 2 weeks on Sunday at 3:00 PM',									-- Description

						   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),						-- Local Start Date

						   0,                           											-- Local End Date

						   0,                           											-- Disabled

						   0,                           											-- Deleted

						   0,                           											-- Scheduling

						   0)                           											-- Freq Restart Interval

	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to insert in TM_Pattern '

		GOTO ERROR_EXIT

	END

SET @l_patternId1 = (SELECT id FROM #TM_IDTable_DbMaintenance WHERE type = 3)

    -- Create Pattern Assoc        
	INSERT INTO TM_PatternAssoc(patternId,


								subTaskId,

								flags,

								disabled,

								deleted,

								scheduling)

	VALUES                     (@l_patternId1,              -- Pattern ID

								@l_subTaskId1,              -- SubTask ID

								0,                         	-- Flags

								0,                          -- Disabled

								0,                          -- Deleted

								0)                          -- Scheduling

	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to insert in TM_PatternAssoc '

		GOTO ERROR_EXIT

	END		

	--Create Sub Task XML Options	
	INSERT INTO TM_SubTaskXMLOptions(subTaskID,


									 xmlValue)

	VALUES                          (@l_subTaskId1,

									 @xmlSubTaskOpts)

	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to insert in TM_SubTaskXMLOptions '

		GOTO ERROR_EXIT

	END

	SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)

	--Create Job XML Options	
	INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to insert in TM_JobXMLOptions'

		GOTO ERROR_EXIT

	END

	--Associations 
	INSERT INTO TM_AssocEntity(assocType,


							   taskId,

							   flags,

							   created,

							   clientGroupId,

							   clientId,

							   appTypeId,

							   instanceId,

							   backupsetId,

							   subclientId,

							   policyId,

							   copyId,

							   srmReportSet,

							   srmReportType,

							   exclude,

							   trackingPolicyId,

							   MediaagentId,

							   agentlessPolicyId,

							   workflowId,

							   sidbStoreId,

							   libraryId,

							   logMonitoringPolicyId

							   )

	VALUES                    (0,           -- assocTye

							   @l_taskId1,  -- Task ID

							   0,           -- Flags

							   @currentTime,-- Created

							   0,           -- ClientGroupID

							   @WFEngId,    -- ClientID

							   0,           -- AppTypeID

							   0,           -- InstanceID

							   0,           -- BackupSetID

							   0,           -- SubClient ID

							   0,           -- PolicyID

							   0,           -- Copy ID

							   0,           -- SRM Report Set

							   0,           -- SRM Report Type

							   0,           -- Exclude

							   0,           -- Trackung Policy ID

							   0,           -- Media Agent ID

							   0,           -- Agentless SRM ID

							   @WFId,       -- Workflow ID

							   0,           -- SIDB Store ID

							   0,           -- Library ID

							   0            -- Log Monitor Policy ID

							   )

	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created Schedules-- Failed to insert in TM_AssocEntity'

		GOTO ERROR_EXIT

	END	

	--Create Sub Task Options
	INSERT INTO TM_SubTaskOptions(subTaskID,


									optionID,

									type,

									value)

	VALUES                        (@l_subTaskId1,

1165448454,

									1,

									'<inputs><type>recommended</type></inputs>')

	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to insert in TM_SubTaskOptions'

		GOTO ERROR_EXIT

	END
	INSERT INTO TM_SubTaskOptions(subTaskID,


									optionID,

									type,

									value)

	VALUES                        (@l_subTaskId1,

130006,

									15,

									2357352946777864)

	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to insert in TM_SubTaskOptions'

		GOTO ERROR_EXIT

	END     
	INSERT INTO TM_SubTaskOptions(subTaskID,


									optionID,

									type,

									value)

	VALUES                        (@l_subTaskId1,

130005,

									1,

									000000000000000000)

	SET @errCode = @@ERROR

	IF  @errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to insert in TM_SubTaskOptions'

		GOTO ERROR_EXIT

	END  

	--Create Job Options	
	INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


	FROM TM_SubTaskOptions AS OPT

	INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

	WHERE subTaskId = @l_subTaskId1	

  END	

  ELSE

	SELECT @l_taskId1 = S.taskId, @l_subTaskId1 = S.subTaskId FROM TM_SubTask S

	JOIN TM_Task T ON T.taskId = S.taskId

WHERE S.flags & 0x8000 = 0x8000 AND modified = 0

	IF @l_taskId1 > 0

	BEGIN

		UPDATE TM_Task Set disabled = @disabled WHERE taskId = @l_taskId1

		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created DBMaintenance Schedule -- Failed to update Task status'

			GOTO ERROR_EXIT

		END  

		--NEW INSTALL USES TEMPLABTE DATA WHICH HAS SCHEDULE ENTRY WITHOUT THE ASSOCIATION

		IF NOT EXISTS(SELECT 1 FROM TM_AssocEntity WHERE taskId = @l_taskId1)

		BEGIN

			--Associations 
			INSERT INTO TM_AssocEntity(assocType,


									   taskId,

									   flags,

									   created,

									   clientGroupId,

									   clientId,

									   appTypeId,

									   instanceId,

									   backupsetId,

									   subclientId,

									   policyId,

									   copyId,

									   srmReportSet,

									   srmReportType,

									   exclude,

									   trackingPolicyId,

									   MediaagentId,

									   agentlessPolicyId,

									   workflowId,

									   sidbStoreId,

									   libraryId,

									   logMonitoringPolicyId

									   )

			VALUES                    (0,           -- assocTye

									   @l_taskId1,  -- Task ID

									   0,           -- Flags

									   @currentTime,-- Created

									   0,           -- ClientGroupID

									   @WFEngId,    -- ClientID

									   0,           -- AppTypeID

									   0,           -- InstanceID

									   0,           -- BackupSetID

									   0,           -- SubClient ID

									   0,           -- PolicyID

									   0,           -- Copy ID

									   0,           -- SRM Report Set

									   0,           -- SRM Report Type

									   0,           -- Exclude

									   0,           -- Trackung Policy ID

									   0,           -- Media Agent ID

									   0,           -- Agentless SRM ID

									   @WFId,       -- Workflow ID

									   0,           -- SIDB Store ID

									   0,           -- Library ID

									   0            -- Log Monitor Policy ID

									   )

			SET @errCode = @@ERROR

			IF  @errCode <> 0

			BEGIN

				SET @errStr = 'ERROR: System Created Schedules-- Failed to insert in TM_AssocEntity'

				GOTO ERROR_EXIT

			END	

		END
		INSERT INTO #optionsTable(


								optionID,

								type,

								value)

		VALUES															

(1165448454,1,'<inputs><type>recommended</type></inputs>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedules -- Failed to insert in TM_SubTaskOptions for System Created DBMaintenance Schedule'

			GOTO ERROR_EXIT

		END

		MERGE TM_SubTaskOptions AS SO

		USING

		(

			SELECT @l_subTaskId1 stId, optionId, type, value 

			FROM #optionsTable

		) AS O ON SO.subTaskId = O.stId AND SO.optionId = O.optionId

		WHEN MATCHED THEN

			UPDATE SET value = O.value,

			type = O.type

		WHEN NOT MATCHED THEN

			INSERT (subTaskID, optionID, type, value)

			VALUES (@l_subTaskId1, O.optionId, O.type, O.value);

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedules-- Failed to update JOBOPTION_WORKFLOW_JOB_OPTIONS option in TM_SubTaskOptions for System Created DBMaintenance Schedule'

			GOTO ERROR_EXIT

		END

		MERGE TM_JobOptions AS JO

		USING

		(

			SELECT @l_subTaskId1 stId, optionId, type, value FROM #optionsTable

		) AS O ON JO.subTaskId = O.stId AND JO.optionId = O.optionId

		WHEN MATCHED THEN

			UPDATE SET value = O.value,

			type = O.type

		WHEN NOT MATCHED THEN

			INSERT (jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)

			VALUES (0, O.optionId, O.type, O.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0);

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedules-- Failed to update TM_JobOptions for Job Summary report schedule'

			GOTO ERROR_EXIT

		END

		UPDATE TM_SubTaskXMLOptions SET xmlValue = @xmlSubTaskOpts WHERE subTaskId = @l_subTaskId1

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedules-- Failed to update TM_SubTaskXMLOptions for System Created DBMaintenance Schedule'

			GOTO ERROR_EXIT

		END

		UPDATE TM_JobXMLOptions SET xmlValue = @xmlSubTaskOpts WHERE subTaskId = @l_subTaskId1 AND jobId = 0

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedules-- Failed to update TM_JobXMLOptions for System Created DBMaintenance Schedule'

			GOTO ERROR_EXIT

		END

	END

END

ERROR_EXIT:

	IF OBJECT_ID('tempdb.dbo.#optionsTable') IS NOT NULL

		DROP TABLE #optionsTable

IF OBJECT_ID('TempDb..' +'#TM_IDTable_DbMaintenance') IS NOT NULL	
  		DROP TABLE #TM_IDTable_DbMaintenance ;

PRINT 'Errorcode = '+CAST(@errCode AS nvarchar(10)) + ' Error= ' + @errStr

