

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/TM_CommcellReadinessCheck.script] ---------- 


SET QUOTED_IDENTIFIER OFF

--delete existing Schedules for Client Check Readiness Workflow

BEGIN

BEGIN TRANSACTION DeleteClientWFSchedule

BEGIN TRY  

	DECLARE @errCode		INTEGER

	DECLARE @errStr			varchar(1024)

	DECLARE @l_taskId1      INTEGER = 0

	DECLARE @l_subTaskId1	INTEGER

	DECLARE @l_patternId1	INTEGER

	--Delete Schedule

IF EXISTS (SELECT * FROM TM_SubTask WITH (NOLOCK) WHERE flags & 0x800000 = 0x800000)

	BEGIN

		SELECT @l_taskId1 = S.taskId, @l_subTaskId1 = S.subTaskId FROM TM_SubTask S

				JOIN TM_Task T WITH (NOLOCK)  ON T.taskId = S.taskId

WHERE S.flags & 0x800000 = 0x800000

		SELECT @l_patternId1= patternId FROM   TM_PatternAssoc WHERE subTaskId = @l_subTaskId1

		UPDATE TM_Task SET Flags = 0 where taskId  = @l_taskId1

		SET @errCode = @@ERROR

		IF  @errCode <> 0

			SET @errStr = 'ERROR: System Created Schedules-- Failed to update from TM_Task'

		DELETE FROM TM_Task where taskId  = @l_taskId1

			SET @errCode = @@ERROR

			IF  @errCode <> 0

				SET @errStr = 'ERROR: System Created Schedules-- Failed to delete from TM_Task'

		DELETE from  TM_Pattern where patternId = @l_patternId1

		SET @errCode = @@ERROR

			IF  @errCode <> 0

				SET @errStr = 'ERROR: System Created Schedules-- Failed to delete from TM_Pattern'

		DELETE from TM_JobXMLOptions where subTaskId =  @l_subTaskId1

		SET @errCode = @@ERROR

			IF  @errCode <> 0

				SET @errStr = 'ERROR: System Created Schedules-- Failed to delete from TM_JobXMLOptions'

		DELETE from TM_JobOptions where subTaskId =  @l_subTaskId1  

		SET @errCode = @@ERROR

			IF  @errCode <> 0

				SET @errStr = 'ERROR: System Created Schedules-- Failed to delete from TM_JobOptions'

	END

END TRY

BEGIN CATCH

    SET @errCode = ERROR_NUMBER()

    SET @errStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Number [' + CONVERT(NVARCHAR(15), @errCode) + '] Error Line [' + CONVERT(NVARCHAR(15), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()               

END CATCH   

IF @errCode <> 0

BEGIN

    PRINT @errStr

    ROLLBACK TRANSACTION DeleteClientWFSchedule

END

ELSE

        COMMIT  TRANSACTION DeleteClientWFSchedule

END
