

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/Syslog_CreateDefaultDBMonitoringPolicies.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

SET NOCOUNT ON

GO

DECLARE @SyslogDBPoliciesScriptExec INT = 0

SELECT

    @SyslogDBPoliciesScriptExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = '8D09FED0-95BA-4EC3-B6B9-B2652B394E02'

IF (@SyslogDBPoliciesScriptExec = 0)        -- not done, create the monitoring policies for syslog

BEGIN

	DECLARE @curUtcDateTime BIGINT

	DECLARE @templateId INT

	DECLARE @monitoringPolicyId INT

	DECLARE @monitoringPOlicyName NVARCHAR(max)

	DECLARE @templateName NVARCHAR(max)

	DECLARE @errorCode int = 0

	DECLARE @errorString NVARCHAR(1024) = ''

	DECLARE @monitoringPolicyDescription NVARCHAR(1024) = ''

	DECLARE @content NVARCHAR(1024) = ''

	-- populate Alert, Audit Trail, Event Viewer templates if they are not present in DB.

	-- LMPopulateTemplate SP is used to populate 3 templates in App_Template table: Alert, Event Viewer and Audit Trail

	-- LMPopulateTemplate SP will take care if any template is already present in App_Template table and it will insert the templates which are not present in App_Template table.

	IF NOT EXISTS (SELECT 1 FROM APP_Template  WITH (NOLOCK) WHERE templateName = 'Alert' AND templateForMonitoringtype = 5 AND status <> 3) OR NOT EXISTS(SELECT 1 FROM APP_Template  WITH (NOLOCK) WHERE templateName = 'Audit Trail' AND templateForMonitoringtype = 5 AND status <> 3) OR NOT EXISTS(SELECT 1 FROM APP_Template  WITH (NOLOCK) WHERE templateName = 'Event Viewer' AND templateForMonitoringtype = 5 AND status <> 3)

	BEGIN

		exec LMPopulateTemplate ''

	END

	SET @curUtcDateTime =  datediff(second, '01/01/1970', GETUTCDATE())

	BEGIN TRY

		BEGIN TRANSACTION CreateMPForSyslogTran

			--1st monitoring policy : Syslog - Alert Policy

			BEGIN

				SET @monitoringPOlicyName = 'Syslog Alerts - System Created Policy'

				SET @monitoringPolicyDescription = 'System created default alert policy for Syslog'

				SET @templateName = 'Alert'

				SET @templateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND templateForMonitoringtype = 5 AND status <> 3)

				--creating monitoring policy

				IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy MP, APP_MonitoringPolicyProp MPProp WITH (NOLOCK) WHERE MP.monitorPolicyId = MPProp.monitorPolicyId AND MPProp.attrName = 'Send to Syslog' AND MPProp.attrVal = 'Alerts' and MP.status <> 3)

				BEGIN
					INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPOlicyName,@curUtcDateTime,@curUtcDateTime,@monitoringPolicyDescription,1)


					SET @monitoringPolicyId =  IDENT_CURRENT('APP_MonitoringPolicy')
					INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,180,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as attachment',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as ftp',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture entire file',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines after match',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines before match',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture log file header',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Continuous monitoring',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,1,@curUtcDateTime,@curUtcDateTime)    

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Discover Event',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable geo loc detection',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index all lines',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index start time',7,@curUtcDateTime,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Last Index Id Time',7,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Last Update Time For DB Policy',7,@curUtcDateTime,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,5,@curUtcDateTime,@curUtcDateTime)				

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'SubClient Id',7,0,@curUtcDateTime,@curUtcDateTime)					

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Send to Syslog',1,'Alerts',@curUtcDateTime,@curUtcDateTime)


				END

			END

			--2nd monitoring policy : Syslog - Audit Trail Policy

			BEGIN

				SET @monitoringPOlicyName = 'Syslog Audit Trail - System Created Policy'

				SET @monitoringPolicyDescription = 'System created default audit trail policy for Syslog'

				SET @templateName = 'Audit Trail'

				SET @templateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND templateForMonitoringtype = 5 AND status <> 3)

				--creating monitoring policy

				IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy MP, APP_MonitoringPolicyProp MPProp WITH (NOLOCK) WHERE MP.monitorPolicyId = MPProp.monitorPolicyId AND MPProp.attrName = 'Send to Syslog' AND MPProp.attrVal = 'Audit' and MP.status <> 3)

				BEGIN
					INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPOlicyName,@curUtcDateTime,@curUtcDateTime,@monitoringPolicyDescription,1)


					SET @monitoringPolicyId =  IDENT_CURRENT('APP_MonitoringPolicy')
					INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,180,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as attachment',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as ftp',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture entire file',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines after match',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines before match',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture log file header',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Continuous monitoring',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,1,@curUtcDateTime,@curUtcDateTime)  

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Discover Event',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable geo loc detection',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index all lines',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index start time',7,@curUtcDateTime,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Last Index Id Time',7,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Last Update Time For DB Policy',7,@curUtcDateTime,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Locale Id',7,0,@curUtcDateTime,@curUtcDateTime)					

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,5,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'SubClient Id',7,0,@curUtcDateTime,@curUtcDateTime)					

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Send to Syslog',1,'Audit',@curUtcDateTime,@curUtcDateTime)


				END

			END

			--3rd monitoring policy : Syslog - Event Viewer Policy

			BEGIN

				SET @monitoringPOlicyName = 'Syslog Event Viewer - System Created Policy'

				SET @monitoringPolicyDescription = 'System created default event viewer policy for Syslog'

				SET @templateName = 'Event Viewer'

				SET @templateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND templateForMonitoringtype = 5 AND status <> 3)

				--creating monitoring policy

				IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy MP, APP_MonitoringPolicyProp MPProp WITH (NOLOCK) WHERE MP.monitorPolicyId = MPProp.monitorPolicyId AND MPProp.attrName = 'Send to Syslog' AND MPProp.attrVal = 'Events' and MP.status <> 3)

				BEGIN
					INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPOlicyName,@curUtcDateTime,@curUtcDateTime,@monitoringPolicyDescription,1)


					SET @monitoringPolicyId =  IDENT_CURRENT('APP_MonitoringPolicy')
					INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,180,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as attachment',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as ftp',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture entire file',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines after match',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines before match',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture log file header',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Continuous monitoring',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,1,@curUtcDateTime,@curUtcDateTime)  

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Discover Event',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable geo loc detection',2,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index all lines',2,1,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index start time',7,@curUtcDateTime,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Last Index Id Time',7,0,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Last Update Time For DB Policy',7,@curUtcDateTime,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Locale Id',7,0,@curUtcDateTime,@curUtcDateTime)					

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,5,@curUtcDateTime,@curUtcDateTime)

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'SubClient Id',7,0,@curUtcDateTime,@curUtcDateTime)					

					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Send to Syslog',1,'Events',@curUtcDateTime,@curUtcDateTime)


				END

			END
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('8D09FED0-95BA-4EC3-B6B9-B2652B394E02', 'SyslogDBPoliciesScriptExec', 'Create DB Monitoring Policies for Syslog', @curUtcDateTime, 16, 0 , (16 + 1))

		COMMIT TRANSACTION CreateMPForSyslogTran

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT N'Rolling back Transactions.'

		ROLLBACK TRANSACTION CreateMPForSyslogTran

	END CATCH

END

SET NOCOUNT OFF

GO

