

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SwapLaptopProxyTopoGroups.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ---------------------------------------------------------------------------------------------------

-- Script : SwapLaptopProxyTopoGroups

-- Purpose : To swap the laptop group with the infrastructure group in all laptop via-proxy topologies and also update routes and useWildcardProxy option accordingly.

-- ---------------------------------------------------------------------------------------------------

DECLARE @SwapLaptopProxyTopoGroups INT = 0

DECLARE @uniqueScriptID uniqueidentifier = '6FF1B519-3F92-433A-9124-79C692D1DACE'

SELECT @SwapLaptopProxyTopoGroups = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

IF @SwapLaptopProxyTopoGroups = 0

BEGIN

	BEGIN TRY

		BEGIN TRANSACTION

		SET NOCOUNT ON

		-- Update FirewallOptions

		IF OBJECT_ID('tempdb..#Topology') IS NOT NULL

			DROP TABLE #Topology

		CREATE TABLE #Topology

		(

			topologyId INT,

			topologyName NVARCHAR(512),

			topologyType INT,

			flag INT,

			clientType INT,

			useWildcardProxy INT

		);
		INSERT INTO #topology


		SELECT AFT.topologyId, AFT.topologyName, AFT.topologyType, AFT.flag, ISNULL(prop.value('./@displayType','int'),0) clientType, ISNULL(Eprops.p.value('./@useWildcardProxy','int'),0) useWildcardProxy FROM APP_FirewallTopology AFT CROSS APPLY extendedProperties.nodes('App_TopologyExtendedProperties') EP(prop)

		INNER JOIN APP_FirewallTopologyAssoc AFTA ON AFT.topologyId = AFTA.topologyId AND AFTA.fwGroupType = 2

		INNER JOIN APP_FirewallOptions AFO ON AFTA.groupId = AFO.clientGroupId

		CROSS APPLY AFO.extendedProperties.nodes('App_FirewallExtendedProperties') EProps(p)

		-- Remove useWildcardProxy option on the external group [fwGroupType = 2]

		UPDATE Options

		SET extendedProperties.modify('replace value of (/App_FirewallExtendedProperties/@useWildcardProxy)[1] with 0')

		FROM APP_FirewallTopologyAssoc TopoAssoc INNER JOIN App_FirewallOptions Options ON Options.clientGroupId = TopoAssoc.groupId

		INNER JOIN #topology AFT ON AFT.topologyId = TopoAssoc.topologyId AND AFT.topologyType = 1

		WHERE TopoAssoc.fwGroupType = 2 

		AND AFT.clientType = 1

		-- Update value of useWildcardProxy in extendedProperties XML

		UPDATE Options

		SET extendedProperties.modify('replace value of (/App_FirewallExtendedProperties/@useWildcardProxy)[1] with sql:column("AFT.useWildcardProxy")')

		FROM APP_FirewallTopologyAssoc TopoAssoc INNER JOIN APP_FirewallOptions Options ON Options.clientGroupId = TopoAssoc.groupId

		INNER JOIN #topology AFT ON AFT.topologyId = TopoAssoc.topologyId AND AFT.topologyType = 1

		WHERE TopoAssoc.fwGroupType = 1 

		AND AFT.clientType = 1

		AND Options.extendedProperties.exist('App_FirewallExtendedProperties/@useWildcardProxy') = 1

		-- Insert useWildcardProxy into extendedProperties XML if it doesn't exist

		UPDATE Options

		SET extendedProperties.modify('insert attribute useWildcardProxy {sql:column("AFT.useWildcardProxy")} into (/App_FirewallExtendedProperties)[1]')

		FROM APP_FirewallTopologyAssoc TopoAssoc INNER JOIN APP_FirewallOptions Options ON Options.clientGroupId = TopoAssoc.groupId

		INNER JOIN #topology AFT ON AFT.topologyId = TopoAssoc.topologyId AND AFT.topologyType = 1

		WHERE 

		TopoAssoc.fwGroupType = 1 AND

		AFT.clientType = 1 AND

		Options.extendedProperties.exist('App_FirewallExtendedProperties/@useWildcardProxy') <> 1

		-- Update Firewall Routes

		DECLARE @cgId INT

		UPDATE AppFirewall 

		SET @cgId = clientGroupId,

			clientGroupId = forClientGroupId,

			forClientGroupId = @cgId

		FROM APP_FirewallTopologyAssoc AFTA1 INNER JOIN APP_FirewallTopologyAssoc AFTA2 ON AFTA1.topologyId = AFTA2.topologyId

		INNER JOIN APP_Firewall AppFirewall ON AFTA1.groupId = AppFirewall.clientGroupId AND AFTA2.groupId = AppFirewall.forClientGroupId

		INNER JOIN #Topology Topology ON Topology.clientType = 1 AND Topology.topologyId = AFTA1.topologyId

		WHERE AFTA1.fwGroupType = 2 AND AFTA2.fwGroupType = 1

		-- Finally swap the groups in the topologies

		UPDATE TopologyAssoc

		SET fwGroupType = CASE fwGroupType WHEN 1 THEN 2 WHEN 2 THEN 1 END

		FROM APP_FirewallTopologyAssoc TopologyAssoc

		INNER JOIN

		(SELECT AFT.*,clientType.value('./@displayType','int') clientType FROM APP_FirewallTopology AFT CROSS APPLY extendedProperties.nodes('App_TopologyExtendedProperties') EP(clientType)

		)Topology 

		ON Topology.topologyId = TopologyAssoc.topologyId AND Topology.clientType = 1

		WHERE Topology.topologyType = 1 AND TopologyAssoc.fwGroupType IN (1,2)

		IF OBJECT_ID('tempdb..#Topology') IS NOT NULL

			DROP TABLE #Topology
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@uniqueScriptID, 'SwapLaptopProxyTopoGroupsExec', 'To swap the laptop group with the infrastructure group in all laptop via-proxy topologies and also update routes and useWildcardProxy option accordingly.', DATEDIFF(second,'01/01/1970',CURRENT_TIMESTAMP) , 16, 0, (16 + 1))

		SET NOCOUNT OFF

		COMMIT TRANSACTION

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT 'Rolling back transaction'

		ROLLBACK TRANSACTION

	END CATCH

END
