

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SqlDatabaseInfo.script] ---------- 


SET QUOTED_IDENTIFIER OFF

 -- ALLOW_COMMENTS_BELOW_HERE:

 -- ----------------------------------------------------------------------

 --                                                                      

 --           Copyright (c) 1998  CommVault Systems, Inc.                

 --                  All rights reserved.                                

 --                                                                      

 --                                                                   

 --        This is unpublished proprietary source code of CommVault  

 --        Systems, Inc. The copyright notice above does not evidence 

 --        any actual or intended publication of such source code. 

 -- ----------------------------------------------------------------------*/

 -- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SqlDatabaseInfo.script,v $ $Id: SqlDatabaseInfo.script,v 1.1.4.3 2018/11/13 15:57:20 shussain Exp $";

GO

-- Global values.

DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))

DECLARE @unixTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

-- Populate database information.

DECLARE @PopulateDatabaseInfo    VARCHAR(40) = '9A37FFED-5AC2-484C-A13B-15AC7C4518F1'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @PopulateDatabaseInfo)

BEGIN

	;WITH SqlLastBkps(instanceId, dbId, appId, bkptime, jobid, id, type, rn) AS

		(SELECT SDB.instanceId, SDB.sqlNameId, SDB.appId, SDB.backup_finish_Date, SDB.jobId, SDB.id, SDB.type,

			ROW_NUMBER() OVER(PARTITION BY SDB.instanceId, SDB.sqlNameId ORDER BY SDB.backup_finish_Date DESC) 

			FROM sqlDbBackupInfo SDB JOIN APP_InstanceName AP ON SDB.instanceId = AP.id)
	INSERT INTO SqlDatabaseInfo


		SELECT SF.instanceId, SF.dbId, SF.appId, SN2.name, SF.bkptime, SF.bkptime, SF.jobid, SF.id, 

			CASE WHEN SD.RM IS NOT NULL THEN 1 ELSE 3 END as RM, 1 as LastStatus, N'' Reserved

		FROM SqlLastBkps SF JOIN sqlNames SN ON SF.dbId = SN.id AND SN.type = 1

			JOIN sqlNames2 SN2 ON SN2.id = SN.sqlId AND SN2.type = 1

			-- FOR recovery model.

			LEFT JOIN (SELECT DISTINCT SDB.instanceId, SDB.sqlNameid, N'FULL'  as RM

				FROM sqlDbBackupInfo SDB WHERE SDB.type = 'L') SD 

				ON SD.sqlNameId = SF.dbId AND SD.instanceId = SF.instanceId

		-- Get latest entry for each DB.

		-- Insert entries those not found in the table.

		WHERE rn = 1 AND NOT EXISTS (SELECT * FROM SqlDatabaseInfo SDI  

											WHERE SF.instanceId = SDI.instanceId AND SF.dbId = SDI.databaseId) 

	 -- Get All user groups for which we don't have direct association present but there reference does exist in App_PlanProp Table.
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@PopulateDatabaseInfo, 'InitialPopulateDatabaseInfo', 'Initial script to populate database information.', @currentTime,  16, 0, (16 + 2))

END

