

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SqlCreateTempdbMonitorJob.script] ---------- 


SET QUOTED_IDENTIFIER OFF

BEGIN TRANSACTION

DECLARE @ReturnCode INT = 0

DECLARE @SqlDBName NVARCHAR(1024) = DB_NAME()

DECLARE @SqlUserName NVARCHAR(1024) = SUSER_NAME()

/****** Object:  JobCategory [[Uncategorized (Local)]]    Script Date: 6/27/2017 4:40:51 PM ******/

IF NOT EXISTS (

		SELECT NAME

		FROM msdb.dbo.syscategories

		WHERE NAME = N'[Uncategorized (Local)]'

			AND category_class = 1

		)

BEGIN

	EXEC @ReturnCode = msdb.dbo.sp_add_category @class = N'JOB'

		,@type = N'LOCAL'

		,@name = N'[Uncategorized (Local)]'

	IF (

			@@ERROR <> 0

			OR @ReturnCode <> 0

			)

		GOTO QuitWithRollback

END

DECLARE @jobId BINARY (16)

SELECT @jobId = job_id

FROM msdb.dbo.sysjobs

WHERE (NAME = N'Monitor_TempDB')

IF (@jobId IS NOT NULL)

BEGIN

	EXEC msdb.dbo.sp_delete_job @jobId

END

SET @jobId = NULL

EXEC @ReturnCode = msdb.dbo.sp_add_job @job_name = N'Monitor_TempDB'

	,@enabled = 1

	,@notify_level_eventlog = 0

	,@notify_level_email = 0

	,@notify_level_netsend = 0

	,@notify_level_page = 0

	,@delete_level = 0

	,@description = N'No description available.'

	,@category_name = N'[Uncategorized (Local)]'

	,@owner_login_name = @SqlUserName

	,@job_id = @jobId OUTPUT

IF (

		@@ERROR <> 0

		OR @ReturnCode <> 0

		)

	GOTO QuitWithRollback

/****** Object:  Step [Create Event]    Script Date: 6/27/2017 4:40:52 PM ******/

DECLARE @GrowthEventCommand NVARCHAR(MAX) = 'Exec ' + @SqlDBName + '.dbo.CreateTempDbGrowthEvent'

EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id = @jobId

	,@step_name = N'Create Event'

	,@step_id = 1

	,@cmdexec_success_code = 0

	,@on_success_action = 3

	,@on_success_step_id = 0

	,@on_fail_action = 2

	,@on_fail_step_id = 0

	,@retry_attempts = 0

	,@retry_interval = 0

	,@os_run_priority = 0

	,@subsystem = N'TSQL'

	,@command = @GrowthEventCommand

    ,@database_name = @SqlDBName

	,@flags = 0

IF (

		@@ERROR <> 0

		OR @ReturnCode <> 0

		)

	GOTO QuitWithRollback

/****** Object:  Step [Execute Additional Tempdb Trace]    Script Date: 6/27/2017 4:40:52 PM ******/

DECLARE @TempdbDetailsCommand NVARCHAR(MAX) = 'Exec ' + @SqlDBName + '.dbo.CaptureTempdbDetails'

EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id = @jobId

	,@step_name = N'Execute Additional Tempdb Trace'

	,@step_id = 2

	,@cmdexec_success_code = 0

	,@on_success_action = 1

	,@on_success_step_id = 0

	,@on_fail_action = 2

	,@on_fail_step_id = 0

	,@retry_attempts = 0

	,@retry_interval = 0

	,@os_run_priority = 0

	,@subsystem = N'TSQL'

	,@command = @TempdbDetailsCommand

    ,@database_name = @SqlDBName

	,@flags = 0

IF (

		@@ERROR <> 0

		OR @ReturnCode <> 0

		)

	GOTO QuitWithRollback

EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId

	,@start_step_id = 1

IF (

		@@ERROR <> 0

		OR @ReturnCode <> 0

		)

	GOTO QuitWithRollback

EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId

	,@server_name = N'(local)'

IF (

		@@ERROR <> 0

		OR @ReturnCode <> 0

		)

	GOTO QuitWithRollback

COMMIT TRANSACTION

GOTO EndSave

QuitWithRollback:

IF (@@TRANCOUNT > 0)

	ROLLBACK TRANSACTION

EndSave:

/****** Object:  Alert [Insufficient Disk Space 1101]    ******/

DECLARE @alertId INT = 0

SELECT @alertId = id

FROM msdb.dbo.sysalerts

WHERE (NAME = N'Insufficient Disk Space 1101')

IF (@alertId <> 0)

BEGIN

	EXEC msdb.dbo.sp_delete_alert N'Insufficient Disk Space 1101'

END

IF NOT EXISTS (SELECT 1 FROM msdb.dbo.sysalerts WHERE message_id = 1101)

BEGIN

	EXEC msdb.dbo.sp_add_alert @name = N'Insufficient Disk Space 1101'

		,@message_id = 1101

		,@severity = 0

		,@enabled = 1

		,@delay_between_responses = 1800

		,@include_event_description_in = 1

		,@event_description_keyword = N'Insufficient Disk Space 1101'

		,@category_name = N'[Uncategorized]'

		,@job_id = @jobId

END

/****** Object:  Alert [Insufficient Disk Space 1105]    ******/

SET @alertId = 0

SELECT @alertId = id

FROM msdb.dbo.sysalerts

WHERE (NAME = N'Insufficient Disk Space 1105')

IF (@alertId <> 0)

BEGIN

	EXEC msdb.dbo.sp_delete_alert N'Insufficient Disk Space 1105'

END

IF NOT EXISTS (SELECT 1 FROM msdb.dbo.sysalerts WHERE message_id = 1105)

BEGIN

	EXEC msdb.dbo.sp_add_alert @name = N'Insufficient Disk Space 1105'

		,@message_id = 1105

		,@severity = 0

		,@enabled = 1

		,@delay_between_responses = 1800

		,@include_event_description_in = 1

		,@category_name = N'[Uncategorized]'

		,@job_id = @jobId

END

/****** Object:  Alert [Insufficient Disk Space 9002]   ******/

SET @alertId = 0

SELECT @alertId = id

FROM msdb.dbo.sysalerts

WHERE (NAME = N'Insufficient Disk Space 9002')

IF (@alertId <> 0)

BEGIN

	EXEC msdb.dbo.sp_delete_alert N'Insufficient Disk Space 9002'

END

IF NOT EXISTS (SELECT 1 FROM msdb.dbo.sysalerts WHERE message_id = 9002)

BEGIN

	EXEC msdb.dbo.sp_add_alert @name = N'Insufficient Disk Space 9002'

		,@message_id = 9002

		,@severity = 0

		,@enabled = 1

		,@delay_between_responses = 1800

		,@include_event_description_in = 1

		,@event_description_keyword = N'Insufficient Disk Space 9002'

		,@category_name = N'[Uncategorized]'

		,@job_id = @jobId

END

/****** Object:  Alert [Transaction log is over 80% for TempDB]    ******/

SET @alertId = 0

SELECT @alertId = id

FROM msdb.dbo.sysalerts

WHERE (NAME = N'Transaction log is over 80% for TempDB')

IF (@alertId <> 0)

BEGIN

	EXEC msdb.dbo.sp_delete_alert N'Transaction log is over 80% for TempDB'

END

IF EXISTS

(SELECT 1 FROM sys.dm_os_performance_counters 

WHERE object_name LIKE '%Databases%'

AND counter_name = 'Percent Log Used'

AND instance_name = 'tempdb')

BEGIN

	IF NOT EXISTS (SELECT 1 FROM msdb.dbo.sysalerts WHERE performance_condition = N'Databases|Percent Log Used|tempdb|>|80')

	BEGIN

		EXEC msdb.dbo.sp_add_alert @name = N'Transaction log is over 80% for TempDB'

			,@message_id = 0

			,@severity = 0

			,@enabled = 1

			,@delay_between_responses = 600

			,@include_event_description_in = 1

			,@category_name = N'[Uncategorized]'

			,@performance_condition = N'Databases|Percent Log Used|tempdb|>|80'

			,@job_id = @jobId

	END

	--Remove Stale Alert if exists

	DECLARE @StaleAlert int = 0

	SELECT TOP 1 @StaleAlert = id 

	FROM msdb.dbo.sysalerts 

	WHERE performance_condition = N'Databases|Percent Log Used|tempdb|>|98' 

	AND name = 'Transaction log is over 98% for TempDB'

	IF @StaleAlert > 0

	BEGIN

		DELETE FROM msdb.dbo.sysalerts 

		WHERE id = @StaleAlert

	END	

END

/*******************************************/

