

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SetInstallationCompanyId.script] ---------- 


SET QUOTED_IDENTIFIER OFF

--  +==============================================================================+

--  |		Name: SetInstallationCompanyId

--	|		Description: Script to set Installation Company Id property for missing clients. 

--	|			  

--  |		Author: jswaminathan

--  +==============================================================================+

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

BEGIN TRY

DECLARE @sqlScriptGUID VARCHAR(128) = '260E2F2D-4AEB-403A-A6A3-D6743C69ADFA'

IF NOT EXISTS (SELECT TOP 1 sqlScriptGUID

			   FROM GXUniqueSQLScriptExecTracking

			   WHERE

					sqlScriptGUID = @sqlScriptGUID)

BEGIN

	DECLARE @nowTime INT = dbo.getUnixTime(GETUTCDATE())

	-- This is the Final table that will be used to update Client Properties table. 

	-- Contains only one row per client and it's company Id. 

	IF OBJECT_ID('tempdb.dbo.#ClientsTblFinal') IS NOT NULL

		DROP TABLE #ClientsTblFinal

	CREATE TABLE #ClientsTblFinal

	(

		clientId INT PRIMARY KEY,

		companyId INT DEFAULT 0		-- Setting default for cases when client does not even belong to any company client group. 

	)

	-- This is a temp table used in computations. Some clients might belong to multiple company client groups. 

	-- This table can have multiple entries per client. 

	IF OBJECT_ID('tempdb.dbo.#ClientsTblTemp') IS NOT NULL

		DROP TABLE #ClientsTblTemp

	CREATE TABLE #ClientsTblTemp

	(

		clientId INT,

		companyId INT	

	)
	CREATE CLUSTERED INDEX clientsTblTemp_Idx1 ON #ClientsTblTemp (clientId)
	-- Get clients without Installation company Id property. 
	INSERT INTO #ClientsTblFinal (clientId)


		SELECT C.id   

		FROM APP_Client C

			LEFT JOIN APP_ClientProp CP

				ON C.id = CP.componentNameId

AND CP.attrName = 'Installation Company ID'

				AND CP.modified = 0		

		WHERE

			C.id > 1

			AND CP.componentNameId IS NULL

	IF @@ROWCOUNT = 0

	BEGIN

		PRINT 'No client has Installation Company Id property missing. Skipping the script.'

		GOTO INSERT_SQL_GUID

	END

	-- Get the company from their associated company smart client group. 
	INSERT INTO #ClientsTblTemp


		SELECT CTF.clientId, CP.componentNameId 

		FROM #ClientsTblFinal CTF

			INNER JOIN APP_ClientGroupAssoc CGA

				ON CTF.clientId = CGA.clientId 

			INNER JOIN APP_CompanyProp CP

ON CP.attrName = 'Associated Smart Client Group'

				AND CP.attrVal = CAST(CGA.clientGroupId AS VARCHAR(10))

				AND CP.modified = 0

	IF @@ROWCOUNT = 0

	BEGIN

		PRINT 'No client belongs to any company client group. Inserting Installation Company Id as 0 for all the clients missing this property.'

		GOTO INSERT_CLIENT_PROP

	END

	-- Set the correct company Id. 

	-- a. If client belong to only one company, then set that company Id. 

	UPDATE #ClientsTblFinal

	SET companyId = Tbl.companyId

	FROM (

			SELECT clientId AS clientId, 

					MAX(companyId) AS companyId

			FROM #ClientsTblTemp

			GROUP BY clientId 

			HAVING COUNT(companyId) = 1

		)Tbl 

	WHERE

		Tbl.clientId = #ClientsTblFinal.clientId 

	-- b. If client belongs to multiple companies, check if they are parent - child companies.

	-- If not, set 0. 

	-- If so, set the oldest company. (reseller configuration)

	DELETE 

	FROM #ClientsTblTemp 

	WHERE

		clientId IN (

						-- This means that client belongs to mutually exclusive companies.

						-- We can delete them from being processed further as final table already

						-- has a default 0. 

						SELECT CT.clientId 

						FROM #ClientsTblTemp CT

							INNER JOIN UMDSProviders P	

								ON CT.companyId = P.id 

								AND P.ownerCompany = 0

						GROUP BY CT.clientId 

						HAVING COUNT(companyId) > 1

					)

	-- This will be a rarity. There will not be too many entries here. 

	-- Writing a Cursor to process this, as we need to create CTEs and table variables inside. 

	DECLARE tempCursor CURSOR FOR 

		SELECT clientId 	

		FROM #ClientsTblTemp

		GROUP BY clientId 

		HAVING COUNT(companyId) > 1

	DECLARE @clientId INT 

	OPEN tempCursor 

	FETCH NEXT FROM tempCursor INTO @clientId 

	WHILE @@FETCH_STATUS = 0

	BEGIN

		-- This table contains the multiple companies that this client belongs to. 

		DECLARE @companyIds TABLE

		(

			companyId INT PRIMARY KEY

		)

		DELETE FROM @companyIds 
		INSERT INTO @companyIds


			SELECT companyId 				

			FROM #ClientsTblTemp			

			WHERE

				clientId = @clientId

		-- Get the highest company (that is the most child of all). Check that the companies this client belongs to, are all its parent companies. 

		DECLARE @childCompanyId INT

		SELECT @childCompanyId = MAX(companyId)

		FROM #ClientsTblTemp 

		WHERE

			clientID = @clientId 	

		DECLARE @parentCompanies TABLE 

		(

			companyId INT PRIMARY KEY

		)

		DELETE FROM @parentCompanies

		; WITH CTEParentCompanies (companyId) 

		AS

		(

			SELECT ownerCompany AS companyId

			FROM UMDSProviders 

			WHERE

				id = @childCompanyId

				AND ownerCompany <> 0

			UNION ALL 

			SELECT ownerCompany  

			FROM UMDSProviders P 

				INNER JOIN CTEParentCompanies C

					ON P.id = C.companyId 

					AND P.ownerCompany <> 0

		)
		INSERT INTO @parentCompanies


			SELECT companyId 

			FROM CTEParentCompanies

			UNION

			SELECT @childCompanyId

		IF NOT EXISTS (SELECT TOP 1 C.companyId 

					   FROM @companyIds C

							LEFT OUTER JOIN @parentCompanies PC

								ON C.companyId = PC.companyId 

					   WHERE

							PC.companyId IS NULL)

		BEGIN

			-- This means, all the companies that client belongs to, is the parent company of the highest company.

			UPDATE #ClientsTblFinal

			SET companyId = Tbl.companyId

			FROM (

					SELECT MIN(companyId) AS companyId

					FROM @companyIds				

				)Tbl 

			WHERE #ClientsTblFinal.clientId = @clientId				

		END					

		FETCH NEXT FROM tempCursor INTO @clientId 

	END

	CLOSE tempCursor 

	DEALLOCATE tempCursor 

	INSERT_CLIENT_PROP:
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)


SELECT clientId, 'Installation Company ID', 7, CAST(companyId AS VARCHAR(10)), @nowTime, 0

		FROM #ClientsTblFinal 

	INSERT_SQL_GUID:
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@sqlScriptGUID, 'SetInstallationCompanyId', 'Set Installation Company Id property', @nowTime, 16, 0, (16 + 2))

END	

END TRY

BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

			ERROR MESSAGE: ' + ERROR_MESSAGE() + '

			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

END CATCH

