

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SecurityFixes.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- 

-- ----------------------------------------------------------------------

--                                                                      

--  SecurityFixes script will contain the one time changes that will 

--	be made over different Service packs. Fixes like "one-time-script-for-

--	existing-setups" will go into this file. 

--

--  Author: jswaminathan

-- ----------------------------------------------------------------------*/

SET NOCOUNT ON

DECLARE @nowTime INTEGER

SET @nowTime =  DATEDIFF(SECOND, '01/01/1970', GETUTCDATE()) 

-- 1. SP15: Upgrade script to give rights to edit plan entities for users and groups with edit plan permission.

-- Code is already there to do this implicitly for new plans created going forward, this is for existing setups only. 

DECLARE @planUsersSecurityFixGUID VARCHAR(40) = '9471F802-A90E-4D89-B30E-BBFA2991533C'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @planUsersSecurityFixGUID)

BEGIN

	BEGIN TRY

		-- 1. Get users with edit plan rights. 

		IF OBJECT_ID('tempdb.dbo.#planInfo') IS NOT NULL

			DROP TABLE #planInfo 

		CREATE TABLE #planInfo 

		(

			planId INT,        

			isUser INT,

			userOrGroupId INT

		)
		CREATE CLUSTERED INDEX planInfo_Idx1 ON #planInfo (planId, isUser, userOrGroupId)		INSERT INTO #planInfo 


			SELECT entityId1, isUser, userOrGroupId 

			FROM UMSecurityAssociations (NOLOCK)

			WHERE

entityType1 = 158			-- 158

AND permissionId = 157

			UNION

			SELECT entityId1, isUser, userOrGroupId

			FROM UMSecurityAssociations Sec (NOLOCK)

				INNER JOIN UMRolesWithPermissionsExpanded RPE (NOLOCK)

					ON Sec.roleId > 0 AND Sec.roleId = RPE.roleId

			WHERE

entityType1 = 158			-- 158

AND RPE.permissionId = 157

DECLARE @planSuperSetRole INT = ISNULL((SELECT id FROM UMRoles (NOLOCK)	WHERE flags & 1024 <> 0), 0)			-- 1024

		IF @planSuperSetRole <> 0

		BEGIN               

				-- 2. Assign them with plan superset role on their respective plans. 

				-- This role has permissions to edit storage policies, schedule policies, subclient policies, etc.

				-- Security framework code will take care of delegating this role to all the associated policies of a plan. 
				INSERT INTO UMSecurityAssociations (isUser, userOrGroupId, roleId, entityType1, entityId1, authorId)


					SELECT DISTINCT Tbl.isUser, 

									Tbl.userOrGroupId, 

									@planSuperSetRole, 

158,                            -- 158

									planId,

									1

					FROM #planInfo Tbl 

					WHERE NOT EXISTS 

					(

						SELECT 1

						FROM UMSecurityAssociations Sec 

						WHERE

							Sec.isUser = Tbl.isUser 

							AND Sec.userOrGroupId = Tbl.userOrGroupID 

							AND Sec.roleId = @planSuperSetRole

AND Sec.entityType1 = 158           -- 158

							AND Sec.entityId1 = Tbl.planID 

					)

		END
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@planUsersSecurityFixGUID, 'planUsersSecurityFix', 'Upgrade script to give rights to edit plan entities for users and groups with edit plan permission', @nowTime,  16, 0, (16 + 2))

	END TRY

	BEGIN CATCH		

    	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

				ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

				ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

				ERROR MESSAGE: ' + ERROR_MESSAGE() + '

				ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

				ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		RAISERROR('Security Fixes script failed', 16, 1)

	END CATCH 	

END

SET NOCOUNT OFF

