

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SchedTimeZone.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

 -- ----------------------------------------------------------------------

 --                                                                      

 --           Copyright (c) 1998  CommVault Systems, Inc.                

 --                  All rights reserved.                                

 --                                                                      

 --                                                                   

 --        This is unpublished proprietary source code of CommVault  

 --        Systems, Inc. The copyright notice above does not evidence 

 --        any actual or intended publication of such source code. 

 -- ----------------------------------------------------------------------*/

 -- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SchedTimeZone.script,v $ $Id: SchedTimeZone.script,v 1.1.4.2 2020/12/16 19:58:02 mnatarajan Exp $";

-- Run this script once for Linux CS. 

IF (dbo.IsOSOnCSWindows()=1)

BEGIN

	RETURN

END

DECLARE @guid uniqueidentifier = 'C00B9B60-DB0D-4906-A98D-87DD76C8184D'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamExec INT = 0

SELECT @globalParamExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamExec = 0)        -- not done, update it for linux

BEGIN	

	IF object_id('tempdb.dbo.#schedTimezoneTemp') is not null

    		DROP TABLE #schedTimezoneTemp

	-- Copying schema from SchedTimezone table to temp table. 

	SELECT * INTO #schedTimezoneTemp FROM SchedTimezone	

	WHERE 1 = 0 

	-- Update flags as 1 for windows timezones but dont remove them since we may need them later for mapping to unix timezones

	UPDATE SchedTimeZone

	SET flags = Flags | 1
	INSERT INTO #schedTimezoneTemp ([TimeZoneID], [TimeZoneStdName],[TimeZoneName], [WindowsTimeZoneStdName], [DSTFlag], [Bias], [STDBias], [STDMonth], [STDDayOfWeek], [STDDay], [STDSeconds], [DSTBias], [DSTMonth], [DSTDayOfWeek], [DSTDay], [DSTSeconds], [Flags]) 


	VALUES

	(1,'Pacific/Niue','Pacific/Niue','UTC-11',0,-39600,0,0,0,0,0,0,0,0,0,0,0),

	(2,'Pacific/Pago_Pago','Pacific/Pago_Pago','UTC-11',0,-39600,0,0,0,0,0,0,0,0,0,0,0),

	(3,'Pacific/Midway','Pacific/Midway','UTC-11',0,-39600,0,0,0,0,0,0,0,0,0,0,0),

	(4,'Pacific/Rarotonga','Pacific/Rarotonga','Hawaiian Standard Time',0,-36000,0,0,0,0,0,0,0,0,0,0,0),

	(5,'Pacific/Honolulu','Pacific/Honolulu','Hawaiian Standard Time',0,-36000,0,0,0,0,0,0,0,0,0,0,0),

	(6,'America/Adak','America/Adak','Aleutian Standard Time',1,-36000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(7,'Pacific/Tahiti','Pacific/Tahiti','Hawaiian Standard Time',0,-36000,0,0,0,0,0,0,0,0,0,0,0),

	(8,'Pacific/Marquesas','Pacific/Marquesas','Marquesas Standard Time',0,-34200,0,0,0,0,0,0,0,0,0,0,0),

	(9,'America/Yakutat','America/Yakutat','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(10,'America/Sitka','America/Sitka','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(11,'America/Metlakatla','America/Metlakatla','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(12,'America/Juneau','America/Juneau','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(13,'America/Nome','America/Nome','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(14,'America/Anchorage','America/Anchorage','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(15,'Pacific/Gambier','Pacific/Gambier','UTC-09',0,-32400,0,0,0,0,0,0,0,0,0,0,0),

	(16,'America/Tijuana','America/Tijuana','Pacific Standard Time (Mexico)',1,-28800,0,11,0,1,7199,3600,3,0,1,7200,0),

	(17,'America/Vancouver','America/Vancouver','Pacific Standard Time',1,-28800,0,11,0,1,7199,3600,3,0,1,7200,0),

	(18,'America/Los_Angeles','America/Los_Angeles','Pacific Standard Time',1,-28800,0,11,0,1,7199,3600,3,0,1,7200,0),

	(19,'Pacific/Pitcairn','Pacific/Pitcairn','UTC-08',0,-28800,0,0,0,0,0,0,0,0,0,0,0),

	(20,'America/Chihuahua','America/Chihuahua','Mountain Standard Time (Mexico)',1,-25200,0,10,0,1,7199,3600,4,0,1,7200,0),

	(21,'America/Mazatlan','America/Mazatlan','Mountain Standard Time (Mexico)',1,-25200,0,10,0,1,7199,3600,4,0,1,7200,0),

	(22,'America/Hermosillo','America/Hermosillo','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),

	(23,'America/Denver','America/Denver','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),

	(24,'America/Cambridge_Bay','America/Cambridge_Bay','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),

	(25,'America/Edmonton','America/Edmonton','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),

	(26,'America/Yellowknife','America/Yellowknife','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),

	(27,'America/Phoenix','America/Phoenix','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),

	(28,'America/Fort_Nelson','America/Fort_Nelson','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),

	(29,'America/Dawson_Creek','America/Dawson_Creek','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),

	(30,'America/Creston','America/Creston','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),

	(31,'America/Ojinaga','America/Ojinaga','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),

	(32,'America/Boise','America/Boise','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),

	(33,'America/Inuvik','America/Inuvik','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),

	(34,'America/Dawson','America/Dawson','Pacific Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),

	(35,'America/Whitehorse','America/Whitehorse','Pacific Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),

	(36,'America/Costa_Rica','America/Costa_Rica','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(37,'America/Belize','America/Belize','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(38,'America/Monterrey','America/Monterrey','Central Standard Time (Mexico)',1,-21600,0,10,0,1,7199,3600,4,0,1,7200,0),

	(39,'America/Mexico_City','America/Mexico_City','Central Standard Time (Mexico)',1,-21600,0,10,0,1,7199,3600,4,0,1,7200,0),

	(40,'America/Winnipeg','America/Winnipeg','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(41,'America/Rainy_River','America/Rainy_River','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(42,'America/Resolute','America/Resolute','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(43,'America/Rankin_Inlet','America/Rankin_Inlet','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(44,'America/Regina','America/Regina','Canada Central Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(45,'America/Swift_Current','America/Swift_Current','Canada Central Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(46,'America/Matamoros','America/Matamoros','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(47,'America/Chicago','America/Chicago','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(48,'America/Merida','America/Merida','Central Standard Time (Mexico)',1,-21600,0,10,0,1,7199,3600,4,0,1,7200,0),

	(49,'America/Guatemala','America/Guatemala','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(50,'America/Tegucigalpa','America/Tegucigalpa','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(51,'America/El_Salvador','America/El_Salvador','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(52,'America/Indiana/Knox','America/Indiana/Knox','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(53,'America/Indiana/Tell_City','America/Indiana/Tell_City','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(54,'America/Menominee','America/Menominee','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(55,'America/Managua','America/Managua','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(56,'America/Bahia_Banderas','America/Bahia_Banderas','Central Standard Time (Mexico)',1,-21600,0,10,0,1,7199,3600,4,0,1,7200,0),

	(57,'America/North_Dakota/Beulah','America/North_Dakota/Beulah','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(58,'America/North_Dakota/Center','America/North_Dakota/Center','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(59,'America/North_Dakota/New_Salem','America/North_Dakota/New_Salem','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(60,'Pacific/Easter','Pacific/Easter','Easter Island Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(61,'Pacific/Galapagos','Pacific/Galapagos','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),

	(62,'America/Rio_Branco','America/Rio_Branco','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(63,'America/Eirunepe','America/Eirunepe','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(64,'America/Bogota','America/Bogota','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(65,'America/Havana','America/Havana','Cuba Standard Time',1,-18000,0,11,0,1,3599,3600,3,0,1,0,0),

	(66,'America/Kentucky/Monticello','America/Kentucky/Monticello','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(67,'America/Iqaluit','America/Iqaluit','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(68,'America/Thunder_Bay','America/Thunder_Bay','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(69,'America/Nipigon','America/Nipigon','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(70,'America/Toronto','America/Toronto','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(71,'America/Port-au-Prince','America/Port-au-Prince','Haiti Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(72,'America/Indiana/Petersburg','America/Indiana/Petersburg','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(73,'America/Indiana/Vevay','America/Indiana/Vevay','US Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(74,'America/Indiana/Vincennes','America/Indiana/Vincennes','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(75,'America/Panama','America/Panama','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(76,'America/Kentucky/Louisville','America/Kentucky/Louisville','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(77,'America/Jamaica','America/Jamaica','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(78,'America/Indiana/Indianapolis','America/Indiana/Indianapolis','US Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(79,'America/Nassau','America/Nassau','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(80,'America/Indiana/Marengo','America/Indiana/Marengo','US Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(81,'America/Indiana/Winamac','America/Indiana/Winamac','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(82,'America/Detroit','America/Detroit','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(83,'America/Grand_Turk','America/Grand_Turk','Turks And Caicos Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(84,'America/New_York','America/New_York','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(85,'America/Cancun','America/Cancun','Eastern Standard Time (Mexico)',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(86,'America/Cayman','America/Cayman','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(87,'America/Pangnirtung','America/Pangnirtung','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),

	(88,'America/Atikokan','America/Atikokan','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(89,'America/Guayaquil','America/Guayaquil','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(90,'America/Lima','America/Lima','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),

	(91,'America/Manaus','America/Manaus','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(92,'America/Boa_Vista','America/Boa_Vista','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(93,'America/Porto_Velho','America/Porto_Velho','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(94,'America/Cuiaba','America/Cuiaba','Central Brazilian Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(95,'America/Campo_Grande','America/Campo_Grande','Central Brazilian Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(96,'America/Port_of_Spain','America/Port_of_Spain','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(97,'America/Thule','America/Thule','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(98,'America/Grenada','America/Grenada','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(99,'America/Dominica','America/Dominica','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(100,'America/Lower_Princes','America/Lower_Princes','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(101,'America/Santo_Domingo','America/Santo_Domingo','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(102,'America/St_Lucia','America/St_Lucia','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(103,'America/St_Kitts','America/St_Kitts','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(104,'America/Puerto_Rico','America/Puerto_Rico','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(105,'America/Curacao','America/Curacao','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(106,'America/Moncton','America/Moncton','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(107,'America/Goose_Bay','America/Goose_Bay','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(108,'America/St_Thomas','America/St_Thomas','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(109,'America/Tortola','America/Tortola','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(110,'America/Antigua','America/Antigua','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(111,'America/Anguilla','America/Anguilla','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(112,'America/Martinique','America/Martinique','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(113,'America/St_Vincent','America/St_Vincent','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(114,'America/Montserrat','America/Montserrat','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(115,'America/Marigot','America/Marigot','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(116,'America/Blanc-Sablon','America/Blanc-Sablon','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(117,'America/Aruba','America/Aruba','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(118,'America/Barbados','America/Barbados','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(119,'America/St_Barthelemy','America/St_Barthelemy','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(120,'Atlantic/Bermuda','Atlantic/Bermuda','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(121,'America/Kralendijk','America/Kralendijk','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(122,'America/Guadeloupe','America/Guadeloupe','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(123,'America/Glace_Bay','America/Glace_Bay','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(124,'America/Halifax','America/Halifax','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),

	(125,'America/La_Paz','America/La_Paz','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(126,'America/Santiago','America/Santiago','Pacific SA Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(127,'America/Guyana','America/Guyana','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(128,'America/Asuncion','America/Asuncion','Paraguay Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(129,'America/Caracas','America/Caracas','Venezuela Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),

	(130,'America/St_Johns','America/St_Johns','Newfoundland Standard Time',1,-12600,0,11,0,1,7199,3600,3,0,1,7200,0),

	(131,'America/Argentina/Jujuy','America/Argentina/Jujuy','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(132,'America/Argentina/Buenos_Aires','America/Argentina/Buenos_Aires','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(133,'America/Argentina/Cordoba','America/Argentina/Cordoba','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(134,'America/Argentina/Salta','America/Argentina/Salta','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(135,'America/Argentina/Tucuman','America/Argentina/Tucuman','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(136,'America/Argentina/Catamarca','America/Argentina/Catamarca','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(137,'America/Argentina/La_Rioja','America/Argentina/La_Rioja','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(138,'America/Argentina/Mendoza','America/Argentina/Mendoza','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(139,'America/Argentina/Rio_Gallegos','America/Argentina/Rio_Gallegos','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(140,'America/Argentina/Ushuaia','America/Argentina/Ushuaia','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(141,'America/Argentina/San_Juan','America/Argentina/San_Juan','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(142,'America/Araguaina','America/Araguaina','Tocantins Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(143,'America/Recife','America/Recife','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(144,'America/Maceio','America/Maceio','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(145,'America/Fortaleza','America/Fortaleza','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(146,'America/Santarem','America/Santarem','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(147,'America/Belem','America/Belem','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(148,'America/Bahia','America/Bahia','Bahia Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(149,'America/Sao_Paulo','America/Sao_Paulo','E. South America Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(150,'Atlantic/Stanley','Atlantic/Stanley','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(151,'America/Cayenne','America/Cayenne','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(152,'America/Punta_Arenas','America/Punta_Arenas','Magallanes Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(153,'Antarctica/Palmer','Antarctica/Palmer','Magallanes Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(154,'Antarctica/Rothera','Antarctica/Rothera','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(155,'America/Miquelon','America/Miquelon','Saint Pierre Standard Time',1,-10800,0,11,0,1,7199,3600,3,0,1,7200,0),

	(156,'America/Paramaribo','America/Paramaribo','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(157,'America/Montevideo','America/Montevideo','Montevideo Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(158,'America/Argentina/San_Luis','America/Argentina/San_Luis','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),

	(159,'America/Noronha','America/Noronha','UTC-02',0,-7200,0,0,0,0,0,0,0,0,0,0,0),

	(160,'Atlantic/South_Georgia','Atlantic/South_Georgia','UTC-02',0,-7200,0,0,0,0,0,0,0,0,0,0,0),

	(161,'Atlantic/Azores','Atlantic/Azores','Azores Standard Time',1,-3600,0,10,0,1,3599,3600,3,0,1,0,0),

	(162,'Atlantic/Cape_Verde','Atlantic/Cape_Verde','Cape Verde Standard Time',0,-3600,0,0,0,0,0,0,0,0,0,0,0),

	(163,'America/Scoresbysund','America/Scoresbysund','Azores Standard Time',1,-3600,0,10,0,1,3599,3600,3,0,1,0,0),

	(164,'Africa/El_Aaiun','Africa/El_Aaiun','Morocco Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(165,'Africa/Casablanca','Africa/Casablanca','Morocco Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(166,'Europe/Dublin','Europe/Dublin','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),

	(167,'Africa/Nouakchott','Africa/Nouakchott','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(168,'Atlantic/Reykjavik','Atlantic/Reykjavik','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(169,'Africa/Bissau','Africa/Bissau','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(170,'Africa/Monrovia','Africa/Monrovia','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(171,'Atlantic/St_Helena','Atlantic/St_Helena','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(172,'Europe/Isle_of_Man','Europe/Isle_of_Man','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),

	(173,'Europe/Jersey','Europe/Jersey','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),

	(174,'Africa/Bamako','Africa/Bamako','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(175,'Africa/Conakry','Africa/Conakry','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(176,'Africa/Banjul','Africa/Banjul','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(177,'America/Danmarkshavn','America/Danmarkshavn','UTC',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(178,'Africa/Sao_Tome','Africa/Sao_Tome','Sao Tome Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(179,'Africa/Lome','Africa/Lome','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(180,'Africa/Accra','Africa/Accra','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(181,'Europe/Guernsey','Europe/Guernsey','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),

	(182,'Africa/Dakar','Africa/Dakar','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(183,'Africa/Abidjan','Africa/Abidjan','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(184,'Africa/Freetown','Africa/Freetown','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(185,'Africa/Ouagadougou','Africa/Ouagadougou','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),

	(186,'Europe/London','Europe/London','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),

	(187,'Atlantic/Canary','Atlantic/Canary','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),

	(188,'Europe/Lisbon','Europe/Lisbon','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),

	(189,'Atlantic/Faroe','Atlantic/Faroe','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),

	(190,'Atlantic/Madeira','Atlantic/Madeira','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),

	(191,'Europe/Brussels','Europe/Brussels','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(192,'Europe/Luxembourg','Europe/Luxembourg','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(193,'Europe/Sarajevo','Europe/Sarajevo','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(194,'Europe/Vaduz','Europe/Vaduz','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(195,'Europe/Vienna','Europe/Vienna','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(196,'Europe/Zurich','Europe/Zurich','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(197,'Europe/Monaco','Europe/Monaco','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(198,'Europe/Malta','Europe/Malta','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(199,'Europe/Podgorica','Europe/Podgorica','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(200,'Europe/Skopje','Europe/Skopje','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(201,'Africa/Tunis','Africa/Tunis','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(202,'Europe/Vatican','Europe/Vatican','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(203,'Europe/Tirane','Europe/Tirane','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(204,'Europe/Prague','Europe/Prague','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(205,'Europe/Berlin','Europe/Berlin','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(206,'Europe/Amsterdam','Europe/Amsterdam','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(207,'Europe/Oslo','Europe/Oslo','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(208,'Europe/Busingen','Europe/Busingen','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(209,'Europe/Stockholm','Europe/Stockholm','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(210,'Europe/Gibraltar','Europe/Gibraltar','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(211,'Europe/Zagreb','Europe/Zagreb','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(212,'Europe/Ljubljana','Europe/Ljubljana','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(213,'Europe/Budapest','Europe/Budapest','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(214,'Europe/Belgrade','Europe/Belgrade','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(215,'Europe/Paris','Europe/Paris','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(216,'Arctic/Longyearbyen','Arctic/Longyearbyen','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(217,'Europe/San_Marino','Europe/San_Marino','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(218,'Europe/Rome','Europe/Rome','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(219,'Europe/Bratislava','Europe/Bratislava','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(220,'Europe/Andorra','Europe/Andorra','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(221,'Africa/Ceuta','Africa/Ceuta','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(222,'Europe/Copenhagen','Europe/Copenhagen','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(223,'Africa/Algiers','Africa/Algiers','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(224,'Europe/Madrid','Europe/Madrid','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(225,'Europe/Warsaw','Europe/Warsaw','Central European Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),

	(226,'Africa/Luanda','Africa/Luanda','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(227,'Africa/Lagos','Africa/Lagos','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(228,'Africa/Niamey','Africa/Niamey','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(229,'Africa/Ndjamena','Africa/Ndjamena','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(230,'Africa/Douala','Africa/Douala','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(231,'Africa/Porto-Novo','Africa/Porto-Novo','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(232,'Africa/Kinshasa','Africa/Kinshasa','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(233,'Africa/Malabo','Africa/Malabo','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(234,'Africa/Bangui','Africa/Bangui','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(235,'Africa/Brazzaville','Africa/Brazzaville','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(236,'Africa/Libreville','Africa/Libreville','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),

	(237,'Africa/Blantyre','Africa/Blantyre','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(238,'Africa/Kigali','Africa/Kigali','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(239,'Africa/Maputo','Africa/Maputo','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(240,'Africa/Khartoum','Africa/Khartoum','Sudan Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(241,'Africa/Windhoek','Africa/Windhoek','Namibia Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(242,'Africa/Harare','Africa/Harare','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(243,'Africa/Bujumbura','Africa/Bujumbura','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(244,'Africa/Lusaka','Africa/Lusaka','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(245,'Africa/Gaborone','Africa/Gaborone','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(246,'Africa/Lubumbashi','Africa/Lubumbashi','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(247,'Europe/Kaliningrad','Europe/Kaliningrad','Kaliningrad Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(248,'Europe/Sofia','Europe/Sofia','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(249,'Europe/Athens','Europe/Athens','GTB Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(250,'Europe/Helsinki','Europe/Helsinki','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(251,'Asia/Amman','Asia/Amman','Jordan Standard Time',1,7200,0,10,0,1,3599,3600,3,0,1,0,0),

	(252,'Asia/Hebron','Asia/Hebron','West Bank Standard Time',1,7200,0,10,0,1,3599,3600,3,0,1,0,0),

	(253,'Asia/Gaza','Asia/Gaza','West Bank Standard Time',1,7200,0,10,0,1,3599,3600,3,0,1,0,0),

	(254,'Africa/Cairo','Africa/Cairo','Egypt Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(255,'Europe/Mariehamn','Europe/Mariehamn','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(256,'Asia/Beirut','Asia/Beirut','Middle East Standard Time',1,7200,0,10,0,1,86399,3600,3,0,1,0,0),

	(257,'Asia/Damascus','Asia/Damascus','Syria Standard Time',1,7200,0,10,0,1,86399,3600,3,0,1,0,0),

	(258,'Europe/Tallinn','Europe/Tallinn','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(259,'Europe/Vilnius','Europe/Vilnius','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(260,'Europe/Kiev','Europe/Kiev','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(261,'Europe/Uzhgorod','Europe/Uzhgorod','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(262,'Europe/Zaporozhye','Europe/Zaporozhye','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(263,'Asia/Nicosia','Asia/Nicosia','GTB Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(264,'Europe/Bucharest','Europe/Bucharest','GTB Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(265,'Africa/Tripoli','Africa/Tripoli','Libya Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(266,'Europe/Riga','Europe/Riga','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(267,'Europe/Chisinau','Europe/Chisinau','E. Europe Standard Time',1,7200,0,10,0,1,10799,3600,3,0,1,7200,0),

	(268,'Asia/Famagusta','Asia/Famagusta','GTB Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),

	(269,'Asia/Jerusalem','Asia/Jerusalem','Israel Standard Time',1,7200,0,10,0,1,7199,3600,3,0,1,7200,0),

	(270,'Africa/Maseru','Africa/Maseru','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(271,'Africa/Johannesburg','Africa/Johannesburg','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(272,'Africa/Mbabane','Africa/Mbabane','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),

	(273,'Asia/Qatar','Asia/Qatar','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(274,'Asia/Baghdad','Asia/Baghdad','Arabic Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(275,'Asia/Kuwait','Asia/Kuwait','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(276,'Asia/Riyadh','Asia/Riyadh','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(277,'Asia/Bahrain','Asia/Bahrain','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(278,'Asia/Aden','Asia/Aden','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(279,'Africa/Addis_Ababa','Africa/Addis_Ababa','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(280,'Africa/Mogadishu','Africa/Mogadishu','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(281,'Africa/Juba','Africa/Juba','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(282,'Africa/Asmara','Africa/Asmara','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(283,'Africa/Djibouti','Africa/Djibouti','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(284,'Africa/Kampala','Africa/Kampala','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(285,'Africa/Nairobi','Africa/Nairobi','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(286,'Africa/Dar_es_Salaam','Africa/Dar_es_Salaam','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(287,'Indian/Comoro','Indian/Comoro','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(288,'Indian/Mayotte','Indian/Mayotte','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(289,'Indian/Antananarivo','Indian/Antananarivo','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(290,'Europe/Kirov','Europe/Kirov','Russian Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(291,'Europe/Minsk','Europe/Minsk','Belarus Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(292,'Europe/Simferopol','Europe/Simferopol','Russian Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(293,'Europe/Moscow','Europe/Moscow','Russian Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(294,'Antarctica/Syowa','Antarctica/Syowa','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(295,'Europe/Istanbul','Europe/Istanbul','Turkey Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),

	(296,'Asia/Tehran','Asia/Tehran','Iran Standard Time',1,12600,0,9,0,1,86399,3600,3,0,1,0,0),

	(297,'Asia/Yerevan','Asia/Yerevan','Caucasus Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(298,'Asia/Baku','Asia/Baku','Azerbaijan Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(299,'Europe/Saratov','Europe/Saratov','Saratov Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(300,'Europe/Ulyanovsk','Europe/Ulyanovsk','Astrakhan Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(301,'Europe/Astrakhan','Europe/Astrakhan','Astrakhan Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(302,'Asia/Tbilisi','Asia/Tbilisi','Georgian Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(303,'Asia/Dubai','Asia/Dubai','Arabian Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(304,'Asia/Muscat','Asia/Muscat','Arabian Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(305,'Indian/Mauritius','Indian/Mauritius','Mauritius Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(306,'Indian/Reunion','Indian/Reunion','Mauritius Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(307,'Europe/Samara','Europe/Samara','Russia Time Zone 3',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(308,'Indian/Mahe','Indian/Mahe','Mauritius Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(309,'Europe/Volgograd','Europe/Volgograd','Volgograd Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),

	(310,'Asia/Kabul','Asia/Kabul','Afghanistan Standard Time',0,16200,0,0,0,0,0,0,0,0,0,0,0),

	(311,'Indian/Kerguelen','Indian/Kerguelen','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(312,'Indian/Maldives','Indian/Maldives','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(313,'Antarctica/Mawson','Antarctica/Mawson','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(314,'Asia/Karachi','Asia/Karachi','Pakistan Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(315,'Asia/Dushanbe','Asia/Dushanbe','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(316,'Asia/Ashgabat','Asia/Ashgabat','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(317,'Asia/Tashkent','Asia/Tashkent','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(318,'Asia/Samarkand','Asia/Samarkand','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(319,'Asia/Oral','Asia/Oral','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(320,'Asia/Atyrau','Asia/Atyrau','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(321,'Asia/Aqtau','Asia/Aqtau','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(322,'Asia/Aqtobe','Asia/Aqtobe','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(323,'Asia/Qyzylorda','Asia/Qyzylorda','Qyzylorda Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(324,'Asia/Yekaterinburg','Asia/Yekaterinburg','Ekaterinburg Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),

	(325,'Asia/Colombo','Asia/Colombo','Sri Lanka Standard Time',0,19800,0,0,0,0,0,0,0,0,0,0,0),

	(326,'Asia/Kolkata','Asia/Kolkata','India Standard Time',0,19800,0,0,0,0,0,0,0,0,0,0,0),

	(327,'Asia/Kathmandu','Asia/Kathmandu','Nepal Standard Time',0,20700,0,0,0,0,0,0,0,0,0,0,0),

	(328,'Asia/Dhaka','Asia/Dhaka','Bangladesh Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),

	(329,'Asia/Thimphu','Asia/Thimphu','Bangladesh Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),

	(330,'Asia/Almaty','Asia/Almaty','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),

	(331,'Asia/Qostanay','Asia/Qostanay','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),

	(332,'Indian/Chagos','Indian/Chagos','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),

	(333,'Asia/Bishkek','Asia/Bishkek','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),

	(334,'Asia/Omsk','Asia/Omsk','Omsk Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),

	(335,'Asia/Urumqi','Asia/Urumqi','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),

	(336,'Antarctica/Vostok','Antarctica/Vostok','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),

	(337,'Indian/Cocos','Indian/Cocos','Myanmar Standard Time',0,23400,0,0,0,0,0,0,0,0,0,0,0),

	(338,'Asia/Yangon','Asia/Yangon','Myanmar Standard Time',0,23400,0,0,0,0,0,0,0,0,0,0,0),

	(339,'Indian/Christmas','Indian/Christmas','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(340,'Antarctica/Davis','Antarctica/Davis','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(341,'Asia/Barnaul','Asia/Barnaul','Altai Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(342,'Asia/Tomsk','Asia/Tomsk','Tomsk Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(343,'Asia/Hovd','Asia/Hovd','W. Mongolia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(344,'Asia/Bangkok','Asia/Bangkok','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(345,'Asia/Phnom_Penh','Asia/Phnom_Penh','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(346,'Asia/Ho_Chi_Minh','Asia/Ho_Chi_Minh','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(347,'Asia/Vientiane','Asia/Vientiane','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(348,'Asia/Krasnoyarsk','Asia/Krasnoyarsk','North Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(349,'Asia/Novokuznetsk','Asia/Novokuznetsk','North Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(350,'Asia/Novosibirsk','Asia/Novosibirsk','N. Central Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(351,'Asia/Jakarta','Asia/Jakarta','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(352,'Asia/Pontianak','Asia/Pontianak','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),

	(353,'Antarctica/Casey','Antarctica/Casey','W. Australia Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(354,'Australia/Perth','Australia/Perth','W. Australia Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(355,'Asia/Brunei','Asia/Brunei','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(356,'Asia/Makassar','Asia/Makassar','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(357,'Asia/Shanghai','Asia/Shanghai','China Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(358,'Asia/Macau','Asia/Macau','China Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(359,'Asia/Choibalsan','Asia/Choibalsan','Ulaanbaatar Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(360,'Asia/Hong_Kong','Asia/Hong_Kong','China Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(361,'Asia/Irkutsk','Asia/Irkutsk','North Asia East Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(362,'Asia/Kuala_Lumpur','Asia/Kuala_Lumpur','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(363,'Asia/Kuching','Asia/Kuching','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(364,'Asia/Manila','Asia/Manila','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(365,'Asia/Singapore','Asia/Singapore','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(366,'Asia/Taipei','Asia/Taipei','Taipei Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(367,'Asia/Ulaanbaatar','Asia/Ulaanbaatar','Ulaanbaatar Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),

	(368,'Australia/Eucla','Australia/Eucla','Aus Central W. Standard Time',0,31500,0,0,0,0,0,0,0,0,0,0,0),

	(369,'Asia/Dili','Asia/Dili','Tokyo Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),

	(370,'Asia/Jayapura','Asia/Jayapura','Tokyo Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),

	(371,'Asia/Tokyo','Asia/Tokyo','Tokyo Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),

	(372,'Asia/Seoul','Asia/Seoul','Korea Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),

	(373,'Asia/Pyongyang','Asia/Pyongyang','North Korea Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),

	(374,'Pacific/Palau','Pacific/Palau','Tokyo Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),

	(375,'Asia/Yakutsk','Asia/Yakutsk','Yakutsk Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),

	(376,'Asia/Chita','Asia/Chita','Transbaikal Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),

	(377,'Asia/Khandyga','Asia/Khandyga','Yakutsk Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),

	(378,'Australia/Broken_Hill','Australia/Broken_Hill','Cen. Australia Standard Time',0,34200,0,0,0,0,0,0,0,0,0,0,0),

	(379,'Australia/Adelaide','Australia/Adelaide','Cen. Australia Standard Time',0,34200,0,0,0,0,0,0,0,0,0,0,0),

	(380,'Australia/Darwin','Australia/Darwin','AUS Central Standard Time',0,34200,0,0,0,0,0,0,0,0,0,0,0),

	(381,'Australia/Hobart','Australia/Hobart','Tasmania Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(382,'Australia/Currie','Australia/Currie','Tasmania Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(383,'Australia/Sydney','Australia/Sydney','AUS Eastern Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(384,'Australia/Brisbane','Australia/Brisbane','E. Australia Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(385,'Australia/Lindeman','Australia/Lindeman','E. Australia Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(386,'Australia/Melbourne','Australia/Melbourne','AUS Eastern Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(387,'Pacific/Saipan','Pacific/Saipan','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(388,'Pacific/Guam','Pacific/Guam','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(389,'Pacific/Chuuk','Pacific/Chuuk','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(390,'Antarctica/DumontDUrville','Antarctica/DumontDUrville','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(391,'Pacific/Port_Moresby','Pacific/Port_Moresby','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(392,'Asia/Ust-Nera','Asia/Ust-Nera','Vladivostok Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(393,'Asia/Vladivostok','Asia/Vladivostok','Vladivostok Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),

	(394,'Australia/Lord_Howe','Australia/Lord_Howe','Lord Howe Standard Time',0,37800,0,0,0,0,0,0,0,0,0,0,0),

	(395,'Asia/Srednekolymsk','Asia/Srednekolymsk','Russia Time Zone 10',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(396,'Pacific/Bougainville','Pacific/Bougainville','Bougainville Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(397,'Pacific/Kosrae','Pacific/Kosrae','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(398,'Antarctica/Macquarie','Antarctica/Macquarie','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(399,'Asia/Magadan','Asia/Magadan','Magadan Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(400,'Pacific/Noumea','Pacific/Noumea','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(401,'Pacific/Norfolk','Pacific/Norfolk','Norfolk Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(402,'Pacific/Pohnpei','Pacific/Pohnpei','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(403,'Asia/Sakhalin','Asia/Sakhalin','Sakhalin Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(404,'Pacific/Guadalcanal','Pacific/Guadalcanal','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(405,'Pacific/Efate','Pacific/Efate','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),

	(406,'Asia/Anadyr','Asia/Anadyr','Russia Time Zone 11',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(407,'Pacific/Fiji','Pacific/Fiji','Fiji Standard Time',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(408,'Pacific/Tarawa','Pacific/Tarawa','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(409,'Pacific/Kwajalein','Pacific/Kwajalein','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(410,'Pacific/Majuro','Pacific/Majuro','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(411,'Pacific/Nauru','Pacific/Nauru','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(412,'Pacific/Auckland','Pacific/Auckland','New Zealand Standard Time',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(413,'Antarctica/McMurdo','Antarctica/McMurdo','New Zealand Standard Time',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(414,'Asia/Kamchatka','Asia/Kamchatka','Russia Time Zone 11',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(415,'Pacific/Funafuti','Pacific/Funafuti','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(416,'Pacific/Wake','Pacific/Wake','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(417,'Pacific/Wallis','Pacific/Wallis','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),

	(418,'Pacific/Chatham','Pacific/Chatham','Chatham Islands Standard Time',0,45900,0,0,0,0,0,0,0,0,0,0,0),

	(419,'Pacific/Apia','Pacific/Apia','Samoa Standard Time',0,46800,0,0,0,0,0,0,0,0,0,0,0),

	(420,'Pacific/Enderbury','Pacific/Enderbury','UTC+13',0,46800,0,0,0,0,0,0,0,0,0,0,0),

	(421,'Pacific/Fakaofo','Pacific/Fakaofo','UTC+13',0,46800,0,0,0,0,0,0,0,0,0,0,0),

	(422,'Pacific/Tongatapu','Pacific/Tongatapu','Tonga Standard Time',0,46800,0,0,0,0,0,0,0,0,0,0,0),

	(423,'Pacific/Kiritimati','Pacific/Kiritimati','Line Islands Standard Time',0,50400,0,0,0,0,0,0,0,0,0,0,0)

	DECLARE @maxTzID INT = 0

	SELECT @maxTzID = MAX(TimeZoneID) FROM SchedTimeZone (NOLOCK)

	IF @maxTzID IS NULL

	BEGIN

		SET @maxTzID = 0

	END
	INSERT INTO SchedTimeZone ([TimeZoneID], [TimeZoneStdName],[TimeZoneName], [WindowsTimeZoneStdName], [DSTFlag], [Bias], [STDBias], [STDMonth], [STDDayOfWeek], [STDDay], [STDSeconds], [DSTBias], [DSTMonth], [DSTDayOfWeek], [DSTDay], [DSTSeconds], [Flags]) 


	SELECT @maxTzID + [TimeZoneID], [TimeZoneStdName],[TimeZoneName], [WindowsTimeZoneStdName], [DSTFlag], [Bias], [STDBias], [STDMonth], [STDDayOfWeek], [STDDay], [STDSeconds], [DSTBias], [DSTMonth], [DSTDayOfWeek], [DSTDay], [DSTSeconds], [Flags]

	FROM #SchedtimezoneTemp

	IF object_id('tempdb.dbo.#schedTimezoneTemp') is not null

    		DROP TABLE #schedTimezoneTemp
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'UpdateSchedtimezoneLinux', 'Update schedtimezone for linux CS', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET NOCOUNT OFF

GO

