

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SM_CreateDefaultMonitoringPolicies.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- SM_CreateDefaultMonitoringPolicies.script 

-- ALLOW_COMMENTS_BELOW_HERE:

-- ---------------------------------------------------------------------- 

-- 

--           Copyright (c) 2011  CommVault Systems, Inc. 

--                  All rights reserved. 

-- 

-- 

--        This is unpublished proprietary source code of CommVault 

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

SET NOCOUNT ON

BEGIN TRY

BEGIN TRANSACTION LMCreateMpTran

DECLARE @guid uniqueidentifier = '237D197D-9B66-491C-A216-632952DB6056'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())    

DECLARE @smCreateMonitoringPolicyExec INT = 0

SELECT @smCreateMonitoringPolicyExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF @smCreateMonitoringPolicyExec = 0

BEGIN

DECLARE @monitoringPolicyId INTEGER ,@monitoringPolicyName NVARCHAR(255),@cloudId INTEGER = 0 , @cloudName NVARCHAR(MAX) = '',@templateId INTEGER

	IF EXISTS(SELECT 1 FROM DM2SearchServerCoreInfo SC WITH(NOLOCK) INNER JOIN DM2CloudCoreRole CR WITH(NOLOCK) ON SC.CloudId = CR.CloudId INNER JOIN Dm2cloud C WITH(NOLOCK) ON SC.CloudId = C.cloudid WHERE roleid = 3)

	BEGIN

		SELECT TOP 1 @cloudId = C.cloudId , @cloudName = C.name

		FROM DM2SearchServerCoreInfo SC WITH(NOLOCK) 

		INNER JOIN DM2CloudCoreRole CR WITH(NOLOCK)

		ON SC.CloudId = CR.CloudId 

		INNER JOIN Dm2cloud C WITH(NOLOCK) 

		ON SC.CloudId = C.cloudid

		WHERE roleid = 3

	END

	-- Creating 1st policy.

	SET @monitoringPolicyName = 'DiskIO Statistics - System Created Policy'

	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)

	BEGIN
		INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'system created default monitoring policy',1)


		SET @monitoringPolicyId =  (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)

									WHERE MonitorPolicyName = @monitoringPolicyName

									ORDER BY monitorPolicyId DESC)

		-- we dont want to associate any clients for now.

		-- INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)

		SET @templateId = (

							SELECT templateId FROM APP_Template

							WHERE templateName = 'Disk IO Statistics' AND status = 0 -- system defined.

							)
		INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

		INSERT INTO APP_MonitoringPolicyProp 


		VALUES

		(@monitoringPolicyId,2,'age ci data after days',7,'180',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as attachment',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as ftp',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture entire file',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture Entire folder',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines after match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines before match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture log file header',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Content',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_SysMonContentList flushInterval="15" collectionInterval="15" flushEventCount="10" />',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Continuous monitoring',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Creater User Id',7,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Discover Event',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor entries older than days',7,'7',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor old data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Enable CI',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable ci data ageing',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable geo loc detection',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Except these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Exclude these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Internet Gateway',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Proxy Client Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'index all lines',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'is NetApp Filler Content',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Type',7,'6',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of line after match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of lines before match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Policy Expiry Time',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Search in subfolders',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Store captured data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'SubClient Id',7,'0',@curUtcDateTime,@curUtcDateTime)

		IF @cloudId <> 0

		BEGIN
			INSERT INTO APP_MonitoringPolicyProp 


			VALUES

			(@monitoringPolicyId,2,'Cloud Id',7,CONVERT(NVARCHAR(MAX),@cloudId),@curUtcDateTime,@curUtcDateTime),

			(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    

		END

	END

	--Creating 1st policy end

	--Creating 2nd policy

	SET @monitoringPolicyName = 'HBA Statistics - System Created Policy'

	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)

	BEGIN
		INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'system created default monitoring policy',1)


		SET @monitoringPolicyId =  (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)

									WHERE MonitorPolicyName = @monitoringPolicyName

									ORDER BY monitorPolicyId DESC)

		-- we dont want to associate any clients for now.

		-- INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)

		SET @templateId = (

							SELECT templateId FROM APP_Template

							WHERE templateName = 'HBA Statistics' AND status = 0 -- system defined.

							)
		INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

		INSERT INTO APP_MonitoringPolicyProp 


		VALUES

		(@monitoringPolicyId,2,'age ci data after days',7,'180',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as attachment',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as ftp',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture entire file',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture Entire folder',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines after match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines before match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture log file header',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Content',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_SysMonContentList flushInterval="15" collectionInterval="15" flushEventCount="10" />',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Continuous monitoring',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Creater User Id',7,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Discover Event',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor entries older than days',7,'7',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor old data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Enable CI',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable ci data ageing',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable geo loc detection',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Except these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Exclude these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Internet Gateway',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Proxy Client Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'index all lines',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'is NetApp Filler Content',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Type',7,'6',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of line after match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of lines before match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Policy Expiry Time',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Search in subfolders',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Store captured data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'SubClient Id',7,'0',@curUtcDateTime,@curUtcDateTime)

		IF @cloudId <> 0

		BEGIN
			INSERT INTO APP_MonitoringPolicyProp 


			VALUES

			(@monitoringPolicyId,2,'Cloud Id',7,CONVERT(NVARCHAR(MAX),@cloudId),@curUtcDateTime,@curUtcDateTime),

			(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    

		END

	END

	--Creating 2nd policy end

	--Creating 3rd policy

	SET @monitoringPolicyName = 'Network Statistics - System Created Policy'

	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)

	BEGIN
		INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'system created default monitoring policy',1)


		SET @monitoringPolicyId =  (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)

									WHERE MonitorPolicyName = @monitoringPolicyName

									ORDER BY monitorPolicyId DESC)

		-- we dont want to associate any clients for now.

		-- INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)

		SET @templateId = (

							SELECT templateId FROM APP_Template

							WHERE templateName = 'Network Statistics' AND status = 0 -- system defined.

							)
		INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

		INSERT INTO APP_MonitoringPolicyProp 


		VALUES

		(@monitoringPolicyId,2,'age ci data after days',7,'180',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as attachment',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as ftp',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture entire file',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture Entire folder',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines after match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines before match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture log file header',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Content',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_SysMonContentList flushInterval="15" collectionInterval="15" flushEventCount="10" />',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Continuous monitoring',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Creater User Id',7,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Discover Event',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor entries older than days',7,'7',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor old data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Enable CI',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable ci data ageing',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable geo loc detection',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Except these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Exclude these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Internet Gateway',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Proxy Client Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'index all lines',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'is NetApp Filler Content',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Type',7,'6',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of line after match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of lines before match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Policy Expiry Time',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Search in subfolders',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Store captured data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'SubClient Id',7,'0',@curUtcDateTime,@curUtcDateTime)

		IF @cloudId <> 0

		BEGIN
			INSERT INTO APP_MonitoringPolicyProp 


			VALUES

			(@monitoringPolicyId,2,'Cloud Id',7,CONVERT(NVARCHAR(MAX),@cloudId),@curUtcDateTime,@curUtcDateTime),

			(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    

		END

	END

	--Creating 3rd policy end

	--Creating 4th policy

	SET @monitoringPolicyName = 'Process Statistics - System Created Policy'

	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)

	BEGIN
		INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'system created default monitoring policy',1)


		SET @monitoringPolicyId =  (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)

									WHERE MonitorPolicyName = @monitoringPolicyName

									ORDER BY monitorPolicyId DESC)

		-- we dont want to associate any clients for now.

		-- INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)

		SET @templateId = (

							SELECT templateId FROM APP_Template

							WHERE templateName = 'Processes Statistics' AND status = 0 -- system defined.

							)
		INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

		INSERT INTO APP_MonitoringPolicyProp 


		VALUES

		(@monitoringPolicyId,2,'age ci data after days',7,'180',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as attachment',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as ftp',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture entire file',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture Entire folder',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines after match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines before match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture log file header',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Content',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_SysMonContentList flushInterval="15" collectionInterval="15" flushEventCount="10" />',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Continuous monitoring',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Creater User Id',7,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Discover Event',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor entries older than days',7,'7',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor old data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Enable CI',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable ci data ageing',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable geo loc detection',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Except these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Exclude these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Internet Gateway',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Proxy Client Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'index all lines',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'is NetApp Filler Content',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Type',7,'6',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of line after match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of lines before match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Policy Expiry Time',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Search in subfolders',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Store captured data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'SubClient Id',7,'0',@curUtcDateTime,@curUtcDateTime)

		IF @cloudId <> 0

		BEGIN
			INSERT INTO APP_MonitoringPolicyProp 


			VALUES

			(@monitoringPolicyId,2,'Cloud Id',7,CONVERT(NVARCHAR(MAX),@cloudId),@curUtcDateTime,@curUtcDateTime),

			(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    

		END

	END

	--Creating 4th policy end		

	--Creating 5th policy

	SET @monitoringPolicyName = 'Stream Reader Statistics - System Created Policy'

	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)

	BEGIN
		INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'system created default monitoring policy',1)


		SET @monitoringPolicyId =  (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)

									WHERE MonitorPolicyName = @monitoringPolicyName

									ORDER BY monitorPolicyId DESC)

		-- we dont want to associate any clients for now.

		-- INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)

		SET @templateId = (

							SELECT templateId FROM APP_Template

							WHERE templateName = 'Stream Reader Statistics' AND status = 0 -- system defined.

							)
		INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

		INSERT INTO APP_MonitoringPolicyProp 


		VALUES

		(@monitoringPolicyId,2,'age ci data after days',7,'180',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as attachment',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as ftp',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture entire file',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture Entire folder',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines after match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines before match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture log file header',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Content',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_SysMonContentList flushInterval="15" collectionInterval="15" flushEventCount="10" />',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Continuous monitoring',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Creater User Id',7,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Discover Event',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor entries older than days',7,'7',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor old data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Enable CI',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable ci data ageing',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable geo loc detection',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Except these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Exclude these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Internet Gateway',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Proxy Client Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'index all lines',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'is NetApp Filler Content',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Type',7,'6',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of line after match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of lines before match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Policy Expiry Time',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Search in subfolders',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Store captured data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'SubClient Id',7,'0',@curUtcDateTime,@curUtcDateTime)

		IF @cloudId <> 0

		BEGIN
			INSERT INTO APP_MonitoringPolicyProp 


			VALUES

			(@monitoringPolicyId,2,'Cloud Id',7,CONVERT(NVARCHAR(MAX),@cloudId),@curUtcDateTime,@curUtcDateTime),

			(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    

		END

	END

	--Creating 5th policy end		

	--Creating 6th policy

	SET @monitoringPolicyName = 'Stream Statistics - System Created Policy'

	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)

	BEGIN
		INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'system created default monitoring policy',1)


		SET @monitoringPolicyId =  (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)

									WHERE MonitorPolicyName = @monitoringPolicyName

									ORDER BY monitorPolicyId DESC)

		-- we dont want to associate any clients for now.

		-- INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)

		SET @templateId = (

							SELECT templateId FROM APP_Template

							WHERE templateName = 'Stream Statistics' AND status = 0 -- system defined.

							)
		INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

		INSERT INTO APP_MonitoringPolicyProp 


		VALUES

		(@monitoringPolicyId,2,'age ci data after days',7,'180',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as attachment',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as ftp',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture entire file',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture Entire folder',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines after match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines before match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture log file header',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Content',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_SysMonContentList flushInterval="15" collectionInterval="15" flushEventCount="10" />',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Continuous monitoring',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Creater User Id',7,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Discover Event',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor entries older than days',7,'7',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor old data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Enable CI',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable ci data ageing',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable geo loc detection',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Except these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Exclude these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Internet Gateway',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Proxy Client Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'index all lines',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'is NetApp Filler Content',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Type',7,'6',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of line after match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of lines before match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Policy Expiry Time',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Search in subfolders',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Store captured data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'SubClient Id',7,'0',@curUtcDateTime,@curUtcDateTime)

		IF @cloudId <> 0

		BEGIN
			INSERT INTO APP_MonitoringPolicyProp 


			VALUES

			(@monitoringPolicyId,2,'Cloud Id',7,CONVERT(NVARCHAR(MAX),@cloudId),@curUtcDateTime,@curUtcDateTime),

			(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    

		END

	END

	--Creating 6th policy end	

	--Creating 7th policy

	SET @monitoringPolicyName = 'Stream Writer Statistics - System Created Policy'

	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)

	BEGIN
		INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'system created default monitoring policy',1)


		SET @monitoringPolicyId =  (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)

									WHERE MonitorPolicyName = @monitoringPolicyName

									ORDER BY monitorPolicyId DESC)

		-- we dont want to associate any clients for now.

		-- INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)

		SET @templateId = (

							SELECT templateId FROM APP_Template

							WHERE templateName = 'Stream Writer Statistics' AND status = 0 -- system defined.

							)
		INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

		INSERT INTO APP_MonitoringPolicyProp 


		VALUES

		(@monitoringPolicyId,2,'age ci data after days',7,'180',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as attachment',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as ftp',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture entire file',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture Entire folder',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines after match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines before match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture log file header',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Content',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_SysMonContentList flushInterval="15" collectionInterval="15" flushEventCount="10" />',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Continuous monitoring',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Creater User Id',7,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Discover Event',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor entries older than days',7,'7',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor old data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Enable CI',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable ci data ageing',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable geo loc detection',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Except these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Exclude these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Internet Gateway',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Proxy Client Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'index all lines',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'is NetApp Filler Content',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Type',7,'6',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of line after match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of lines before match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Policy Expiry Time',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Search in subfolders',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Store captured data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'SubClient Id',7,'0',@curUtcDateTime,@curUtcDateTime)

		IF @cloudId <> 0

		BEGIN
			INSERT INTO APP_MonitoringPolicyProp 


			VALUES

			(@monitoringPolicyId,2,'Cloud Id',7,CONVERT(NVARCHAR(MAX),@cloudId),@curUtcDateTime,@curUtcDateTime),

			(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    

		END

	END

	--Creating 7th policy end

	--Creating 8th policy

	SET @monitoringPolicyName = 'System Statistics - System Created Policy'

	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)

	BEGIN
		INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'system created default monitoring policy',1)


		SET @monitoringPolicyId =  (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)

									WHERE MonitorPolicyName = @monitoringPolicyName

									ORDER BY monitorPolicyId DESC)

		-- we dont want to associate any clients for now.

		-- INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)

		SET @templateId = (

							SELECT templateId FROM APP_Template

							WHERE templateName = 'System Statistics' AND status = 0 -- system defined.

							)
		INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

		INSERT INTO APP_MonitoringPolicyProp 


		VALUES

		(@monitoringPolicyId,2,'age ci data after days',7,'180',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as attachment',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'capture as ftp',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture entire file',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture Entire folder',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines after match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture lines before match',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Capture log file header',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Content',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_SysMonContentList flushInterval="15" collectionInterval="15" flushEventCount="10" />',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Continuous monitoring',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Creater User Id',7,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Discover Event',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor entries older than days',7,'7',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor old data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Enable CI',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable ci data ageing',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'enable geo loc detection',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Except these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Exclude these',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Internet Gateway',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Proxy Client Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Id',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'index all lines',2,'1',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'is NetApp Filler Content',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Monitoring Type',7,'6',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of line after match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Number of lines before match',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Policy Expiry Time',7,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Search in subfolders',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'Store captured data',2,'0',@curUtcDateTime,@curUtcDateTime),

		(@monitoringPolicyId,2,'SubClient Id',7,'0',@curUtcDateTime,@curUtcDateTime)

		IF @cloudId <> 0

		BEGIN
			INSERT INTO APP_MonitoringPolicyProp 


			VALUES

			(@monitoringPolicyId,2,'Cloud Id',7,CONVERT(NVARCHAR(MAX),@cloudId),@curUtcDateTime,@curUtcDateTime),

			(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    

		END

	END

	--Creating 8th policy end
	 INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'SM_CreateDefaultMonitoringPolicies', 'Creating default monitoring policy for system monitoring', @curUtcDateTime, 16, 0 , (16 + 2))

END

COMMIT TRANSACTION LMCreateMpTran

END TRY

BEGIN CATCH

	PRINT N'Error occured. At Line(' + CAST(ERROR_LINE() AS NVARCHAR) + N') ErrorNo(' + CAST(ERROR_NUMBER() AS NVARCHAR) + N') ErrorMsg(' + ERROR_MESSAGE() + N').'

    PRINT N'So Rolling back Transactions.'

    ROLLBACK TRANSACTION LMCreateMpTran

END CATCH

SET NOCOUNT OFF

