

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SMSnapToDatasetMap.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- Add entries in SMSnapToDatasetMap from SMMetaData entries

SET QUOTED_IDENTIFIER ON

DECLARE @ExtDSMetaDataTypeDelim NVARCHAR(10) = '#28|::|'

DECLARE @columnDelim NVARCHAR(10) = '|::|'

DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF OBJECT_ID('tempdb.dbo.#tblSnapDSMap') IS NOT NULL DROP TABLE #tblSnapDSMap

CREATE TABLE #tblSnapDSMap (SMSnapId INT, AppId INT, DataSetId INT, ExtDataSetId NVARCHAR(512))

BEGIN TRY

	-- Use GXUniqueSQLScriptExecTracking to insert just once

	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '2CB4829C-F5D3-43B5-9986-BF1BC482D118')

    BEGIN
		INSERT	INTO #tblSnapDSMap (SMSnapId, DataSetId, AppId, ExtDataSetId)


		SELECT	DISTINCT S.SMSnapId, 0, 0, SUBSTRING(MD.MetaData, (CHARINDEX(@ExtDSMetaDataTypeDelim, MD.MetaData) + LEN(@ExtDSMetaDataTypeDelim)), 

				((CHARINDEX(@columnDelim,  MD.MetaData, CHARINDEX(@ExtDSMetaDataTypeDelim, MD.MetaData) + LEN(@ExtDSMetaDataTypeDelim))) 

				- (CHARINDEX(@ExtDSMetaDataTypeDelim, MD.MetaData) + LEN(@ExtDSMetaDataTypeDelim))))

		FROM	SMMetaData MD WITH (NOLOCK) 

				INNER JOIN SMSnap S WITH (NOLOCK)

ON MD.PruneFlags = 4 AND MD.RefId = S.SMSnapId AND MD.RefType = 2

AND S.SnapShotEngineId = 3 AND CHARINDEX(@ExtDSMetaDataTypeDelim, MD.MetaData) > 0

        UPDATE	TMP

        SET		TMP.DatasetID = Ds.DataSetId

        FROM	#tblSnapDSMap TMP, SMDataSet DS (NOLOCK)

        WHERE	DS.ExtDataSetId = TMP.ExtDataSetId

		-- Find AppId for LREP primary and non-LREP, non-replica secondary snaps

		UPDATE	TMP

		SET		TMP.AppId = VOL.AppId

		FROM	#tblSnapDSMap TMP

				INNER JOIN SMVolSnapMap MAP (NOLOCK) ON TMP.SMSnapId = MAP.SMSnapId

				INNER JOIN SMVolume VOL (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId

				INNER JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = VOL.CopyId 

				INNER JOIN archGroup AG (NOLOCK) ON AGC.archGroupId = AG.id 

				INNER JOIN ArchGroupControlHost AGCH (NOLOCK) ON AG.id = AGCH.ArchGroupId

		WHERE   AGC.isSnapCopy = 1 

AND ( (AGC.id <> AG.defaultSnapCopy AND (AGC.extendedFlags & 256 <> 256))

				OR (AGCH.SMReplicationProtocolType = 1 AND AGC.id = AG.defaultSnapCopy ) )

		DELETE FROM #tblSnapDSMap

		WHERE AppId = 0 OR DatasetID = 0

		BEGIN TRANSACTION SnapToDSMapTran
		INSERT	INTO SMSnapToDatasetMap


		SELECT	SMSnapId, AppId, DatasetId

		FROM	#tblSnapDSMap
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('2CB4829C-F5D3-43B5-9986-BF1BC482D118', 'SMSnapToDatasetMapUpgradeScript', 'Upgrade script to populate SMSnapToDatasetMap table from snap metadata.', @nowTime, 16, 0, (16 + 2))

		COMMIT TRANSACTION SnapToDSMapTran

		IF OBJECT_ID('tempdb.dbo.#tblSnapDSMap') IS NOT NULL DROP TABLE #tblSnapDSMap

	END

END TRY

BEGIN CATCH

	IF @@TRANCOUNT > 0

		ROLLBACK TRANSACTION SnapToDSMapTran

	IF OBJECT_ID('tempdb.dbo.#tblSnapDSMap') IS NOT NULL DROP TABLE #tblSnapDSMap

	DECLARE @errStr nvarchar(max)           

    SET @errStr = N'Failed to insert Snap to Dataset mapping in SMSnapToDatasetMap. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')      

	RAISERROR(@errStr, 15, 1)

END CATCH

