

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SMMetaData.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SMMetaData.script,v $ $Id: SMMetaData.script,v 1.5.12.3 2019/05/15 14:51:07 kkumar Exp $";
-- TABLENAME SMMetaData

print '... inserting Table: SMMetaData'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME SMMetaData

SET QUOTED_IDENTIFIER ON

DECLARE @errStr nvarchar(max)     

DECLARE @SM_PACK_METADATA_ROW_DELIM_DB nvarchar(5) = '|..|'

DECLARE @SM_PACK_METADATA_COL_DELIM_DB nvarchar(5) = '|::|'

DECLARE @SM_PACK_METADATA_DATA_BITS_DELIM_DB nvarchar(5) = '#'

DECLARE @SM_PACK_METADATA_ROW_COUNT_DELIM_DB nvarchar(5) = '#'

BEGIN TRY

	BEGIN TRANSACTION SetArrayMetadataTran

	DELETE	SMMetaData

	WHERE	RefType = 5
	INSERT  INTO SMMetaData (MetaDataType, RefType, RefId, PruneFlags, MetaData) 


SELECT  49, 5, ControlHostId, 0, ''

	FROM    SMControlHost

	WHERE   SnapShotEngineName = 'NetApp'

			AND NOT EXISTS (SELECT  RefId 

							FROM    SMMetaData 

WHERE   MetaDataType = 49

AND RefType = 5

									AND RefId = ControlHostId)

	AND		SMHostFlags & 1 = 0

	IF EXISTS (SELECT 1 FROM SMMetaData (NOLOCK) WHERE PruneFlags = 1)

	BEGIN

		UPDATE	SMMetaData

		SET		PruneFlags = 4  /*SM_METADATA_PACKED_DB*/

		WHERE	PruneFlags = 1

				AND RefId > 0 AND RefType > 0

		RETURN

	END

	COMMIT TRANSACTION SetArrayMetadataTran

END TRY

BEGIN CATCH

	IF @@TRANCOUNT > 0

		ROLLBACK TRANSACTION SetArrayMetadataTran

    SET @errStr = N'Failed to pack SMMetaData rows. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')      

	RAISERROR(@errStr, 15, 1)

END CATCH

IF NOT EXISTS (SELECT 1 FROM SMMetaData 

				WHERE RefType > 0 AND RefId > 0 AND MetaDataId > 0 

AND PruneFlags <> 4

AND RefType NOT IN (10, 11, 12))

	RETURN

IF OBJECT_ID('SMMetaData_Old') IS NOT NULL

	DROP TABLE SMMetaData_Old

CREATE TABLE SMMetaData_Old (

	MetaDataId			INTEGER NOT NULL,

	MetaDataType		integer	NOT NULL,

	RefType				integer	NOT NULL,

	RefId				integer	NOT NULL,

	PruneFlags			integer	NOT NULL,

	MetaData			NVARCHAR(MAX),

	OrigCCId			integer	DEFAULT	2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1		integer default 0	NOT NULL,

	ReserveField2		integer default 0	NOT NULL,

	ReserveFieldStr		NVARCHAR(255) default '' NOT NULL,

	Flags				BIGINT	default 0 NOT NULL,

	PRIMARY KEY(MetaDataId)

)

CREATE NONCLUSTERED INDEX SMMetaData_Old_PruneFlags_RefId_RefType_MetaDataId_idx ON SMMetaData_Old (PruneFlags, RefId, RefType, MetaDataId)
INSERT INTO SMMetaData_Old


SELECT * FROM SMMetaData

IF OBJECT_ID('tempdb.dbo.#tblMetaDataGrp') IS NOT NULL

	DROP TABLE #tblMetaDataGrp

CREATE TABLE #tblMetaDataGrp (

	RefType INT, 

	RefId INT, 

	MdCount INT, 

	OrigCCId INT,

	PRIMARY KEY(RefId, RefType)

)

IF OBJECT_ID('tempdb.dbo.#tblMetaDataRowFlags') IS NOT NULL

	DROP TABLE #tblMetaDataRowFlags

CREATE TABLE #tblMetaDataRowFlags (

	MetadataId INT PRIMARY KEY, 

	Flags INT

)
INSERT	INTO #tblMetaDataGrp


SELECT	RefType, RefId, COUNT(*), MIN(OrigCCId)

FROM	SMMetadata_Old (NOLOCK)

WHERE	PruneFlags <> 4 AND RefID > 0 AND RefType > 0

AND RefType NOT IN (10, 11, 12)

GROUP BY RefType, RefID
INSERT	INTO #tblMetaDataRowFlags


SELECT	MetadataId, 

CASE WHEN (ReserveFieldStr <> '') THEN 16 ELSE 0 END |

CASE WHEN (ReserveField2 <> 0) THEN 8 ELSE 0 END |

CASE WHEN (ReserveField1 <> 0) THEN 4 ELSE 0 END |

1 | 2

FROM	SMMetadata_Old MD (NOLOCK)

WHERE	PruneFlags <> 4 AND RefID > 0 AND RefType > 0

AND RefType NOT IN (10, 11, 12)

		AND MetadataID > 0

BEGIN TRY

	BEGIN TRAN PackMetadata

	DELETE	SMMetaData

WHERE	PruneFlags <> 4 AND RefId > 0 AND RefType > 0 AND RefType NOT IN (10, 11, 12)

			AND MetaDataId > 0 
	INSERT	INTO SMMetaData (RefType, RefId, MetaDataType, MetaData, PruneFlags, OrigCCId, GUID)


	SELECT 	TMP.RefType, TMP.RefId, 0,

			CONVERT(NVARCHAR(10), TMP.MdCount) + @SM_PACK_METADATA_ROW_COUNT_DELIM_DB + CONSOLIDATED.MetadataConsolidated,

4, TMP.OrigCCId, NEWID()

	FROM	#tblMetaDataGrp TMP

			INNER JOIN

				(SELECT RefId, RefType, 

					(SELECT		CONVERT(NVARCHAR(10), FLAG.Flags) + @SM_PACK_METADATA_DATA_BITS_DELIM_DB + 

								CONVERT(NVARCHAR(10), T.MetadataType) + @SM_PACK_METADATA_COL_DELIM_DB + 

								CONVERT(NVARCHAR(MAX), T.Metadata) + @SM_PACK_METADATA_COL_DELIM_DB +

								CASE WHEN T.ReserveField1 > 0 THEN CONVERT(NVARCHAR(10), T.ReserveField1) + @SM_PACK_METADATA_COL_DELIM_DB ELSE '' END +

								CASE WHEN T.ReserveField2 > 0 THEN CONVERT(NVARCHAR(10), T.ReserveField2) + @SM_PACK_METADATA_COL_DELIM_DB ELSE '' END +

								CASE WHEN T.ReserveFieldStr <> '' THEN T.ReserveFieldStr + @SM_PACK_METADATA_COL_DELIM_DB ELSE '' END +

								@SM_PACK_METADATA_ROW_DELIM_DB

						FROM    SMMetaData_Old T (NOLOCK)

								INNER JOIN #tblMetaDataRowFlags FLAG ON T.MetaDataId = FLAG.MetadataId

						WHERE   T.RefType = M.RefType AND T.RefID = M.RefID 

						ORDER BY MetadataType

						FOR XML PATH('')) AS MetadataConsolidated

					FROM SMMetaData_Old M (NOLOCK)

WHERE PruneFlags <> 4 AND M.RefID > 0 AND M.RefType > 0

AND RefType NOT IN (10, 11, 12)

					GROUP BY RefId, RefType) CONSOLIDATED 

	ON TMP.RefId = CONSOLIDATED.RefId AND TMP.RefType = CONSOLIDATED.RefType

	COMMIT TRAN PackMetadata

END TRY

BEGIN CATCH 

	IF @@TRANCOUNT > 0

	ROLLBACK TRAN PackMetadata

	IF OBJECT_ID('SMMetaData_Old') IS NOT NULL

		DROP TABLE SMMetaData_Old

    SET @errStr = N'Failed to pack SMMetaData rows. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')      

	RAISERROR(@errStr, 15, 1)

END CATCH

    -- check and remove any transient metadata present in the table 

	BEGIN TRAN TransientMetadata

	DELETE  SMMetaData

WHERE   MetaDataType in ( 125 /*SM_MDT_EXTEND_ACTION_FLAG*/, 134 /*SM_MDT_IS_SOURCE_COPY_PRIMARY_SNAP_COPY*/, 135 /*SM_MDT_SOURCE_COPY_TYPE*/) and RefType = 4 /*SM_MRT_VOLSNAP*/ and RefId = 0

	COMMIT TRAN TransientMetadata

IF OBJECT_ID('SMMetaData_Old') IS NOT NULL

	DROP TABLE SMMetaData_Old

IF OBJECT_ID('tempdb.dbo.#tblMetaDataRowFlags') IS NOT NULL

	DROP TABLE #tblMetaDataRowFlags

IF OBJECT_ID('tempdb.dbo.#tblMetaDataGrp') IS NOT NULL

	DROP TABLE #tblMetaDataGrp

