

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SMHostAlias.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- Add the SMArrayId for all the arrays in the SMHostAlias table, if they do not exist already

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[splitString_HostAliasTblScript]') and OBJECTPROPERTY(id, N'IsInlineFunction') = 0)

drop function [dbo].[splitString_HostAliasTblScript]

GO

CREATE FUNCTION dbo.splitString_HostAliasTblScript

(

	@IDsList nvarchar(MAX),

	@token  char(1)

)

RETURNS 

@ParsedList table

(

_ID nvarchar(MAX)

)

AS

BEGIN

	DECLARE @_ID nvarchar(MAX), @Pos int

	SET @IDsList = LTRIM(RTRIM(@IDsList))+ @token

	SET @Pos = CHARINDEX(@token, @IDsList, 1)

	IF REPLACE(@IDsList,@token, '') <> ''

	BEGIN

		WHILE @Pos > 0

		BEGIN

			SET @_ID = LTRIM(RTRIM(LEFT(@IDsList, @Pos - 1)))

			IF @_ID <> ''

			BEGIN
				INSERT INTO @ParsedList (_ID) 


				VALUES (@_ID) --Use Appropriate conversion

			END

			SET @IDsList = RIGHT(@IDsList, LEN(@IDsList) - @Pos)

			SET @Pos = CHARINDEX(@token, @IDsList, 1)

		END

	END 

	RETURN

END

GO

DECLARE @tblAlias           TABLE(arrayId INT, alias NVARCHAR(1024))

DECLARE @tblMetaData        TABLE	(arrayId INT, 

									metaDataId INT,

									metaDataType INT,

									RefType INT,

									metaData NVARCHAR(4000))

DECLARE @arrayAliasDelim    	NVARCHAR(2) = N'|'

DECLARE @openCurFlag		INT = 0
INSERT INTO @tblMetaData 


SELECT RefId, MetaDataId, MetaDataType, RefType, CONVERT(NVARCHAR(4000), MetaData)

FROM   SMMetaData (NOLOCK) WHERE MetaDataType = 32
INSERT	INTO @tblAlias 


SELECT	arrayId, _ID 

FROM	@tblMetadata

		CROSS APPLY splitString_HostAliasTblScript(metaData, @arrayAliasDelim)

BEGIN TRY

	BEGIN TRANSACTION HostAliasTran
	INSERT	INTO SMHostAlias


	SELECT	5, AN.arrayId, 0, 0, AN.alias, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''

	FROM    (SELECT min(arrayId) AS arrayId, alias FROM @tblAlias GROUP BY alias) AN 

				LEFT OUTER JOIN SMHostAlias HA (NOLOCK) 

				ON AN.alias = HA.AliasName WHERE HA.AliasName IS NULL 

	UPDATE	MD

SET		MetaDataType = 54,

RefType = 13

	FROM	SMMetaData MD 

			INNER JOIN @tblMetadata TMP 

			ON MD.MetaDataId = TMP.metaDataId

			AND MD.MetaDataType = TMP.metaDataType

			AND MD.RefId = TMP.arrayId

			AND MD.RefType = TMP.refType
	INSERT INTO SMHostAlias (RefType, RefId, Status, Flags, AliasName)


SELECT	5/*SM_MRT_ARRAY*/, CTRL.ControlHostId, 0, 0, CTRL.SMArrayId

	FROM	SMControlHost CTRL (NOLOCK) 

			LEFT JOIN SMHostAlias ALIAS (NOLOCK) ON CTRL.SMArrayId= ALIAS.AliasName

	WHERE	ALIAS.AliasName IS NULL

			AND CTRL.ControlHostId > 0

	COMMIT TRANSACTION HostAliasTran

END TRY

BEGIN CATCH

	IF @@TRANCOUNT > 0

	ROLLBACK TRANSACTION HostAliasTran

	DECLARE @errStr nvarchar(max)           

    SET @errStr = N'Failed to insert array aliases in SMHostAlias. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')      

	RAISERROR(@errStr, 15, 1)

END CATCH

DROP FUNCTION dbo.splitString_HostAliasTblScript

