

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SMControlHost.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SMControlHost.script,v $ $Id: SMControlHost.script,v 1.2.66.17 2020/12/23 21:57:27 mmani Exp $";
-- TABLENAME SMControlHost

print '... inserting Table: SMControlHost'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME SMControlHost

DECLARE @nowTime	INT

SET     @nowTime =  DATEDIFF(SECOND, '01/01/1970', GetUTCdate())

UPDATE SMControlHost SET ClientId = client.id

FROM APP_Client AS client

	INNER JOIN SMControlHost AS ctrlHost

	ON (ctrlHost.SMArrayId = client.name OR ctrlHost.SMArrayId = client.net_hostname)

	AND ctrlHost.SnapShotEngineName <> '' 

	AND (ctrlHost.SMHostFlags & 1) <> 1

	AND ctrlHost.ClientId <=1 -- Do not change the array-client association if it exists already

UPDATE SMControlHost SET SnapVendorName = SnapShotEngineName WHERE ControlHostId > 0 AND datalength(SnapVendorName) = 0 AND datalength(SnapShotEngineName) > 0

UPDATE SMControlHost SET SMHostStatus = 1 where ControlHostId > 0

-- Rename 'LSI' to 'NetApp E-series' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'LSI')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'NetApp E-series / LSI',

SnapShotEngineName = 'NetApp E-series / LSI'

	WHERE   SnapVendorName = 'LSI'

END

-- Rename 'NEC iStorage' to 'NEC Storage' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'NEC iStorage')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'NEC Storage'

	WHERE   SnapVendorName = 'NEC iStorage'

END

IF EXISTS (SELECT 1 FROM SMControlHost (NOLOCK) WHERE SnapVendorName = 'Dell EMC Unity' AND SMHostName = '')

BEGIN

	UPDATE	SMControlHost

	SET		SMHostName = SMArrayId

WHERE	SnapVendorName = 'Dell EMC Unity' AND SMHostName = ''

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'C8C6FC09-452E-4E42-8132-BC9A6645DDFE')

BEGIN

IF EXISTS (SELECT 1 FROM SMControlHost (NOLOCK) WHERE SnapVendorName = 'HPE Nimble Storage' )

	BEGIN

		UPDATE	SMControlHost

		SET		SMHostName = LTRIM(RTRIM(SMHostName)),

				SMHostUserName = LTRIM(RTRIM(SMHostUserName)),

				SMArrayId = LTRIM(RTRIM(SMArrayId))

WHERE	SnapVendorName = 'HPE Nimble Storage'

				AND ( DATALENGTH (SMArrayId) <> DATALENGTH ( LTRIM(RTRIM(SMArrayId)))

					OR DATALENGTH (SMHostName) <> DATALENGTH ( LTRIM(RTRIM(SMHostName)))

					OR DATALENGTH (SMHostUserName) <> DATALENGTH ( LTRIM(RTRIM(SMHostUserName))) )

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('C8C6FC09-452E-4E42-8132-BC9A6645DDFE', 'SetConfigParamForNimbleUpgradeToRemoveSpace', 'Update script to remove white spaces for Nimbe Array Management entries', @nowTime, 16, 0, 18)

END

IF NOT EXISTS (SELECT 1 FROM SMControlHost WHERE ControlHostId = 0)

BEGIN
	SET IDENTITY_INSERT SMControlHost ON
set @tblRetCode = @@error 
if (@tblRetCode <> 0)
BEGIN
	set @tblRetCode = @@error;
	print 'RETVAL: 99 Table [SMControlHost]'
END
-----------------------------------------------------
	INSERT INTO SMControlHost(ControlHostId, SnapShotEngineId, SnapVendorName, SMArrayId, SMHostIP, SMHostName, SMHostPortNumber, SMHostUserName, SMHostPassword, SMHostFlags, SMHostStatus,SMHostOption)


	values (0, 0, 'N/A', 'N/A', 'N/A', 'N/A', 0, 'N/A', 'N/A', 0, 0 ,0)
	SET IDENTITY_INSERT SMControlHost OFF
set @tblRetCode = @@error 
if (@tblRetCode <> 0)
BEGIN
	set @tblRetCode = @@error;
	print 'RETVAL: 99 Table [SMControlHost]'
END
-----------------------------------------------------

END

-- Rename 'Dell Compellent' to 'Dell Storage Center (Deprecated)' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'Dell Compellent')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell Storage Center (Deprecated)'

	WHERE   SnapVendorName = 'Dell Compellent'

END

-- Rename 'Dell EMC Compellent (DSM)' to 'Dell EMC Storage Center (DSM)' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'Dell EMC Compellent (DSM)')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell EMC Storage Center (DSM)'

	WHERE   SnapVendorName = 'Dell EMC Compellent (DSM)'

END

-- Rename 'Dell Equallogic' to 'Dell EqualLogic' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'Dell Equallogic')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell EqualLogic'

	WHERE   SnapVendorName = 'Dell Equallogic'

END

-- Rename 'EMC Isilon' to 'Dell EMC Isilon' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'EMC Isilon')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell EMC Isilon'

	WHERE   SnapVendorName = 'EMC Isilon'

END

-- Rename 'EMC Unity' to 'Dell EMC Unity' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'EMC Unity')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell EMC Unity'

	WHERE   SnapVendorName = 'EMC Unity'

END

-- Rename 'EMC VMAX / Symmetrix' to 'Dell EMC VMAX / Symmetrix' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'EMC VMAX / Symmetrix')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell EMC VMAX / Symmetrix'

	WHERE   SnapVendorName = 'EMC VMAX / Symmetrix'

END

-- Rename 'EMC VNX / Celerra' to 'Dell EMC VNX / Celerra' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'EMC VNX / Celerra')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell EMC VNX / Celerra'

	WHERE   SnapVendorName = 'EMC VNX / Celerra'

END

-- Rename 'EMC VNX / CLARiiON' to 'Dell EMC VNX / CLARiiON' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'EMC VNX / CLARiiON')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell EMC VNX / CLARiiON'

	WHERE   SnapVendorName = 'EMC VNX / CLARiiON'

END

-- Rename 'EMC VPLEX' to 'Dell EMC VPLEX' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'EMC VPLEX')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell EMC VPLEX'

	WHERE   SnapVendorName = 'EMC VPLEX'

END

-- Rename 'EMC XtremIO' to 'Dell EMC XtremIO' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'EMC XtremIO')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Dell EMC XtremIO'

	WHERE   SnapVendorName = 'EMC XtremIO'

END

-- Rename 'Fujitsu ETERNUS DX' to 'Fujitsu ETERNUS AF / DX' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'Fujitsu ETERNUS DX')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Fujitsu ETERNUS AF / DX'

	WHERE   SnapVendorName = 'Fujitsu ETERNUS DX'

END

-- Rename 'HDS' to 'Hitachi Vantara' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'HDS')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Hitachi Vantara'

	WHERE   SnapVendorName = 'HDS'

END

-- Rename 'HP 3PAR' to 'HPE 3PAR StoreServ' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'HP 3PAR')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'HPE 3PAR StoreServ'

	WHERE   SnapVendorName = 'HP 3PAR'

END

-- Rename 'HP EVA' to 'HPE EVA' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'HP EVA')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'HPE EVA'

	WHERE   SnapVendorName = 'HP EVA'

END

-- Rename 'Nimble Storage' to 'HPE Nimble Storage' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'Nimble Storage')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'HPE Nimble Storage'

	WHERE   SnapVendorName = 'Nimble Storage'

END

-- Rename 'PURE Storage' to 'Pure Storage FlashArray' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'PURE Storage')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Pure Storage FlashArray'

	WHERE   SnapVendorName = 'PURE Storage'

END

-- Rename 'SolidFire' to 'NetApp SolidFire' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'SolidFire')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'NetApp SolidFire'

	WHERE   SnapVendorName = 'SolidFire'

END

-- Rename 'Tegile' to 'Western Digital IntelliFlash' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(NOLOCK) WHERE SnapVendorName = 'Tegile')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Western Digital IntelliFlash'

	WHERE   SnapVendorName = 'Tegile'

END

IF EXISTS (SELECT 1 FROM SMControlHost WITH(READUNCOMMITTED) WHERE SnapVendorName = 'IBM SVC')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'IBM FlashSystem'

	WHERE   SnapVendorName = 'IBM SVC'

END

-- Rename engine name from 'Google GCP Snap' to 'Google Cloud Platform Snap' in SMControlHost

IF EXISTS (SELECT 1 FROM SMControlHost WITH(READUNCOMMITTED) WHERE SnapVendorName = 'Google Cloud Platform')

BEGIN

	UPDATE  SMControlHost

SET     SnapShotEngineName = 'Google Cloud Platform Snap'

WHERE   SnapVendorName = 'Google Cloud Platform'

END

IF EXISTS (SELECT 1 FROM SMControlHost WITH(READUNCOMMITTED) WHERE SnapVendorName = 'Kaminario')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Silk'

	WHERE   SnapVendorName = 'Kaminario'

END

IF EXISTS (SELECT 1 FROM SMControlHost WITH(READUNCOMMITTED) WHERE SnapVendorName = 'Hedvig')

BEGIN

	UPDATE  SMControlHost

SET     SnapVendorName = 'Commvault Distributed Storage'

	WHERE   SnapVendorName = 'Hedvig'

END
