

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SMConfigs.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SMConfigs.script,v $ $Id: SMConfigs.script,v 1.9.2.16 2020/12/29 15:57:16 rksingh Exp $";
-- TABLENAME SMConfigs

print '... inserting Table: SMConfigs'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME SMConfigs

SET NOCOUNT ON

DECLARE @nowTime                      int

Set     @nowTime                      =  datediff(second, '01/01/1970', GetUTCdate()) 

-- SQL for moving v9 array data to the array configs framework - START

DECLARE @array  TABLE (

    ControlHostId       INTEGER,

    SMArrayId           NVARCHAR(1024),     -- MMS2_HOSTNAMELEN

    DeviceGroupName     NVARCHAR(1024),

    SMHostOption        INTEGER,

    SnapVendorId        INTEGER,

    SnapVendorName      NVARCHAR(128)       -- MM_SM_ENGINE_VENDORNAME_LEN

)

-- Gather vendor info about each existing array
INSERT  INTO @array


SELECT  CH.ControlHostId, CH.SMArrayId, CH.DeviceGroupName, CH.SMHostOption, VEN.Id, CH.SnapVendorName

FROM    SMControlHost CH WITH (NOLOCK), SMVendor VEN WITH (NOLOCK)

WHERE   CH.SnapShotEngineName = VEN.Name

AND     CH.ControlHostId > 0

-- Copy 'Device Group' from SMControlHost
INSERT  INTO    SMConfigs ( MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, 


                            EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId, 

                            GUID, ReserveFieldInt1, ReserveFieldInt2, ReserveFieldInt3, ReserveFieldInt4, ReserveFieldStr)

SELECT  MC.Id, ARR.ControlHostId, ARR.ControlHostId, 3, 1, 1, 0, MC.DefaultInt, MC.DefaultLL, ARR.DeviceGroupName, @nowTime, 0, 2, newid(), 0, 0, 0, 0, N''

FROM    SMMasterConfigs MC WITH (NOLOCK), @array ARR 

WHERE   MC.VendorId = ARR.SnapVendorId

AND     ARR.ControlHostId > 0

AND     MC.Id IN    (   SELECT Id 

                        FROM SMMasterConfigs WITH (NOLOCK) 

                        WHERE KeyName IN ('SMCONFIG_NAME_HOST_DEVICE_GROUP', 'SMCONFIG_NAME_STORAGE_DEVICE_GROUP')

                    )

AND     NOT EXISTS  (   SELECT * 

                        FROM SMConfigs SC WITH (NOLOCK)

                        WHERE  SC.MasterConfigId = MC.Id

                        AND    SC.ArrayId = ARR.ControlHostId

                    )

-- Copy 'Use devices only from this group' from SMControlHost
INSERT  INTO    SMConfigs ( MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, 


                            EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId, 

                            GUID, ReserveFieldInt1, ReserveFieldInt2, ReserveFieldInt3, ReserveFieldInt4, ReserveFieldStr)

SELECT  MC.Id, ARR.ControlHostId, ARR.ControlHostId, 3, 1, 1, 0, ARR.SMHostOption, MC.DefaultLL, MC.DefaultStr, @nowTime, 0, 2, newid(), 0, 0, 0, 0, N''

FROM    SMMasterConfigs MC WITH (NOLOCK), @array ARR 

WHERE   MC.VendorId = ARR.SnapVendorId

AND     ARR.ControlHostId > 0

AND     MC.Id IN    (   SELECT Id 

                        FROM SMMasterConfigs WITH (NOLOCK) 

                        WHERE KeyName IN ('SMCONFIG_NAME_USE_DEVICES_ONLY_FROM_THIS_GROUP', 'SMCONFIG_NAME_USE_UNGROUPED_DEVICES')

                    )

AND     NOT EXISTS  (   SELECT * 

                        FROM SMConfigs SC WITH (NOLOCK)

                        WHERE  SC.MasterConfigId = MC.Id

                        AND    SC.ArrayId = ARR.ControlHostId

                    )

-- SQL for moving v9 array data to the array configs framework - END

IF EXISTS (SELECT * FROM MMConfigs WHERE name = 'MMCONFIG_SNAP_SMART_CLONE_OP' AND value > 0)

BEGIN
    INSERT  INTO    SMConfigs ( MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, 


                            EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId, 

                            GUID, ReserveFieldInt1, ReserveFieldInt2, ReserveFieldInt3, ReserveFieldInt4, ReserveFieldStr)

SELECT  MC.Id, ARR.ControlHostId, ARR.ControlHostId, 3, 1, 1, 0, 1, MC.DefaultLL, MC.DefaultStr, @nowTime, 0, 2, newid(), 0, 0, 0, 0, N''

    FROM    SMMasterConfigs MC WITH (NOLOCK), @array ARR 

    WHERE   MC.VendorId = ARR.SnapVendorId

    AND     ARR.ControlHostId > 0

AND     MC.Id = 134

    AND     NOT EXISTS  (   SELECT * 

                            FROM SMConfigs SC WITH (NOLOCK)

                            WHERE  SC.MasterConfigId = MC.Id

                            AND    SC.ArrayId = ARR.ControlHostId

                        )

END

-- This SQL below will add the SMConfig entries for all the array configs for the arrays that are already existing.

BEGIN
    INSERT  INTO    SMConfigs ( MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, 


                                EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId, 

                                GUID, ReserveFieldInt1, ReserveFieldInt2, ReserveFieldInt3, ReserveFieldInt4, ReserveFieldStr)

SELECT  MC.Id, ARR.ControlHostId, ARR.ControlHostId, 3, 1, 1, 0, MC.DefaultInt, MC.DefaultLL, MC.DefaultStr, @nowTime, 0, 2, newid(), 0, 0, 0, 0, N''

    FROM    SMMasterConfigs MC WITH (NOLOCK), 

            (   SELECT      CH.ControlHostId, CH.SMArrayId,VEN.Id SnapVendorId, CH.SnapVendorName

                FROM        SMControlHost CH WITH (NOLOCK), SMVendor VEN WITH (NOLOCK)

                WHERE       CH.SnapVendorName = VEN.Name

                            AND     CH.ControlHostId > 0) ARR 

    WHERE   MC.VendorId = ARR.SnapVendorId

AND     MC.Type <> 10

    AND     ARR.ControlHostId > 0

    AND     NOT EXISTS  (   SELECT  * 

                            FROM    SMConfigs SC WITH (NOLOCK)

                            WHERE   SC.MasterConfigId = MC.Id

                            AND     SC.ArrayId = ARR.ControlHostId )

END

-- SolidFire - Changing default value for SMCONFIG_SOLIDFIRE_NAME_MOUNT_RETRY_INTERVAL_IN_SEC from SP3 to SP4

BEGIN

    UPDATE  SMConfigs 

    SET     ValueInt = 60

WHERE   MasterConfigId = 150

            AND ValueInt = 300 

AND AssocType = 3

END

-- PowerMax - Changing default value of configs SMCONFIG_EMC_SYMMETRIX_NAME_USE_SMART_REVERT and SMCONFIG_SMIS_CONNECTION_TIMEOUT_IN_SECS_VMAX_ID

BEGIN

    UPDATE  SMConfigs 

    SET     ValueInt = 1

WHERE   MasterConfigId = 39

            AND ValueInt = 0 

AND AssocType = 3

END

BEGIN

    UPDATE  SMConfigs 

    SET     ValueInt = 1800

WHERE   MasterConfigId = 242

            AND ValueInt = 300

AND AssocType = 3

END

--Steps for upgrade handling for configs hidden at various levels

--If config is hidden at copy,

--  Copy to subclient if not overridden (and visible at SC).

--If config is hidden at array,

--  Copy to SP copy if not overridden (and visible at SP copy)

--  Copy to client if not overridden (if visible at client) and not visible at SP copy

--  Copy to subclient if not overridden (and visible at SC) and not visible at SP copy and client

DECLARE @ArrayCfgs TABLE(

    MasterConfigId      INT,

    ControlHostId       INT,

    ShowInGUIAtArray    INT,

    CopyId              INT,

    ShowInGUIAtCopy     INT,

    ClientId            INT,

    ShowInGUIAtClient   INT,

    AppId               INT,

    ShowInGUIAtSubClient INT

)

-- Get all the configs that are hidden at various levels

-- Get all the arrays for the above vendors.

-- Also, get the associated client, subclient and copy details
INSERT INTO @ArrayCfgs


SELECT  DISTINCT MC.id, 

CTRL.ControlHostId, CASE WHEN MC.ShowInGUI & 2 /*SM_MASTERCONFIGS_HIDE_IN_GUI_AT_ARRAY*/ = 2 THEN 0 ELSE 1 END,

AG.defaultSnapCopy,CASE WHEN MC.ShowInGUI & 4 /*SM_MASTERCONFIGS_HIDE_IN_GUI_AT_COPY*/ = 4 THEN 0 ELSE 1 END,

APP.clientId, CASE WHEN MC.ShowInGUI & 8 /*SM_MASTERCONFIGS_HIDE_IN_GUI_AT_CLIENT*/ = 8 THEN 0 ELSE 1 END,

APP.id, CASE WHEN MC.ShowInGUI & 16 /*SM_MASTERCONFIGS_HIDE_IN_GUI_AT_SUBCLIENT*/ = 16 THEN 0 ELSE 1 END

FROM    SMMasterConfigs (NOLOCK) MC

        INNER JOIN SMVendor VEN (NOLOCK) ON VEN.Id = MC.VendorId

        INNER JOIN SMControlHost CTRL (NOLOCK) ON VEN.Name = CTRL.SnapVendorName

        INNER JOIN SMSnap SNAP WITH (NOLOCK) ON SNAP.ControlHostId = CTRL.ControlHostId

        INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId

        INNER JOIN SMVolume VOL (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId

        INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = VOL.AppId

        INNER JOIN archGroup AG (NOLOCK) ON APP.dataArchGrpID = AG.id

WHERE   CTRL.ControlHostId > 0

        AND MC.ShowInGUI > 1

AND MC.id NOT IN (131, 132, 139, 140)

AND MC.flags & 1 <> 1

--Steps for upgrade handling for configs hidden at various levels

--If config is hidden at copy,

--  Copy to subclient if not overridden (and visible at SC).

--If config is hidden at array,

--  Visible at SP copy? 

--      Copy to SP copy if not overridden already

--  Visible at Client? 

--      Copy to client if not overridden already & not visible at SP copy

--  Visible at Subclient?

--      Copy to subclient if not overridden already & not visible at copy and client.

--**Above steps are good if existing V10 configs are always visible at SC in V11.

IF EXISTS (SELECT * FROM @ArrayCfgs WHERE ShowInGUIAtCopy = 0)

BEGIN
    INSERT  INTO SMConfigs (MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId)


SELECT  DISTINCT A.MasterConfigId, A.ControlHostId, A.AppId, 9/*MMSM_AT_SUBCLIENT*/, 1, 1, 0, CFG.ValueInt, CFG.ValueLL, CFG.ValueStr, 0, 0, 2

    FROM    @ArrayCfgs A

            INNER JOIN SMConfigs CFG (NOLOCK) ON A.MasterConfigId = CFG.MasterConfigId

            LEFT JOIN (SELECT   CFG1.AssocId, AC.ControlHostId

                    FROM    @ArrayCfgs AC

                            INNER JOIN SMConfigs CFG1 (NOLOCK) ON CFG1.MasterConfigId = AC.MasterConfigId

                    WHERE   CFG1.ArrayId = AC.ControlHostId

                            AND CFG1.AssocId = AC.AppId

AND CFG1.AssocType = 9 /*MMSM_AT_SUBCLIENT*/ ) B ON B.ControlHostId = A.ControlHostId AND A.AppId = B.AssocId

    WHERE   A.ShowInGUIAtSubClient = 1

            AND A.ShowInGUIAtCopy = 0

            AND CFG.ArrayId = A.ControlHostId

            AND CFG.AssocId = A.CopyId

AND CFG.AssocType = 6 /*MMSM_AT_COPY*/

            AND B.ControlHostId IS NULL

END

IF EXISTS (SELECT * FROM @ArrayCfgs WHERE ShowInGUIAtArray = 0)

BEGIN 
    INSERT  INTO SMConfigs (MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId)


SELECT  DISTINCT A.MasterConfigId, A.ControlHostId, A.CopyId, 6/*MMSM_AT_COPY*/, 1, 1, 0, CFG.ValueInt, CFG.ValueLL, CFG.ValueStr, 0, 0, 2

    FROM    @ArrayCfgs A

            INNER JOIN SMConfigs CFG (NOLOCK) ON A.MasterConfigId = CFG.MasterConfigId

            LEFT JOIN (

                    SELECT  CFG1.AssocId, AC.ControlHostId

                    FROM    @ArrayCfgs AC

                            INNER JOIN SMConfigs CFG1 (NOLOCK) ON CFG1.MasterConfigId = AC.MasterConfigId

                    WHERE   CFG1.ArrayId = AC.ControlHostId

                            AND CFG1.AssocId = AC.CopyId

AND CFG1.AssocType = 6 /*MMSM_AT_COPY*/ ) B ON B.ControlHostId = A.ControlHostId AND A.CopyId = B.AssocId

    WHERE   A.ShowInGUIAtCopy = 1

            AND A.ShowInGUIAtArray = 0

            AND CFG.ArrayId = A.ControlHostId

            AND CFG.AssocId = A.ControlHostId

AND CFG.AssocType = 3 /*MMSM_AT_ARRAY*/

            AND B.ControlHostId IS NULL
    INSERT  INTO SMConfigs (MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId)


SELECT  DISTINCT A.MasterConfigId, A.ControlHostId, A.ClientId, 8 /*MMSM_AT_CLIENT*/, 1, 1, 0, CFG.ValueInt, CFG.ValueLL, CFG.ValueStr, 0, 0, 2

    FROM    @ArrayCfgs A

            INNER JOIN SMConfigs CFG (NOLOCK) ON A.MasterConfigId = CFG.MasterConfigId

            LEFT JOIN (

                    SELECT  CFG1.AssocId, AC.ControlHostId

                    FROM    @ArrayCfgs AC

                            INNER JOIN SMConfigs CFG1 (NOLOCK) ON CFG1.MasterConfigId = AC.MasterConfigId

                    WHERE   CFG1.ArrayId = AC.ControlHostId

                            AND CFG1.AssocId = AC.ClientId

AND CFG1.AssocType = 8 /*MMSM_AT_CLIENT*/ ) B ON  B.ControlHostId = A.ControlHostId AND A.ClientId = B.AssocId

    WHERE   A.ShowInGUIAtClient = 1

            AND A.ShowInGUIAtArray = 0

            AND A.ShowInGUIAtCopy = 0

            AND CFG.ArrayId = A.ControlHostId

            AND CFG.AssocId = A.ControlHostId

AND CFG.AssocType = 3 /*MMSM_AT_ARRAY*/

            AND B.ControlHostId IS NULL
    INSERT  INTO SMConfigs (MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId)


SELECT  DISTINCT A.MasterConfigId, A.ControlHostId, A.AppId, 9/*MMSM_AT_SUBCLIENT*/, 1, 1, 0, CFG.ValueInt, CFG.ValueLL, CFG.ValueStr, 0, 0, 2

    FROM    @ArrayCfgs A

            INNER JOIN SMConfigs CFG (NOLOCK) ON A.MasterConfigId = CFG.MasterConfigId

            LEFT JOIN (

                    SELECT  CFG1.AssocId, AC.ControlHostId

                    FROM    @ArrayCfgs AC

                            INNER JOIN SMConfigs CFG1 (NOLOCK) ON CFG1.MasterConfigId = AC.MasterConfigId

                    WHERE   CFG1.ArrayId = AC.ControlHostId

                            AND CFG1.AssocId = AC.AppId

AND CFG1.AssocType = 9 /*MMSM_AT_SUBCLIENT*/ ) B ON B.ControlHostId = A.ControlHostId AND A.AppId = B.AssocId

    WHERE   A.ShowInGUIAtSubClient = 1

            AND A.ShowInGUIAtArray = 0

            AND A.ShowInGUIAtClient = 0 

            AND A.ShowInGUIAtCopy = 0

            AND CFG.ArrayId = A.ControlHostId

            AND CFG.AssocId = A.ControlHostId

AND CFG.AssocType = 3 /*MMSM_AT_ARRAY*/

            AND B.ControlHostId IS NULL

END

-- Update the upgrade flag for the master configs

-- For the configs hidden at different levels and the script to copy the values is run, update the flags

UPDATE SMMasterConfigs 

SET Flags = Flags | 1 /*SM_MASTERCONFIGS_FLAGS_UPGRADE_RUN_DB*/

WHERE id IN (SELECT MasterConfigId FROM @ArrayCfgs)

SET NOCOUNT OFF

