

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SEProperty.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |       Table:  SEProperty

--  |

--  | Description:  Contains information about datasource property

--  |

--  |                                                                    

--  |        Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SEProperty.script,v $ $Id: SEProperty.script,v 1.4.2.53 2020/10/20 03:57:05 canand Exp $";

--below are for Attribute column column

-----------Script to add/update new property for SEProperty----------

--type

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '3D0D3279-2A63-45FA-99C4-700902EE947B')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, 


			SeaPropertyName, PropertyType, Description, DSTypeAttribute)

	SELECT '3D0D3279-2A63-45FA-99C4-700902EE947B' , 'type' , ' Datasource type',

			'type', 'string', 'Type of datasource like jdbc, csv, web or so', -1

END

--name

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'C84FC94D-D26E-4006-A9CE-D6971734CB81')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, 


			SeaPropertyName, PropertyType, Description, DSTypeAttribute)

	SELECT 'C84FC94D-D26E-4006-A9CE-D6971734CB81' , 'name' , 'Datasource Name',

			'name', 'string', 'Name of the datasource', -1

END

--operationtype

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'F6ED64A0-3AA2-4C7D-B749-8A2760076962')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, 


			SeaPropertyName, PropertyType, Description, DSTypeAttribute)

	SELECT 'F6ED64A0-3AA2-4C7D-B749-8A2760076962' , 'operationtype' , 'Operation Type',

			'operationtype', 'string', 'Type of the operation viz, CREATE, MODIFY, DELETE', -1

END

--corename

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'F415C850-F808-4334-9EC8-81E7C989CD8D')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, 


			SeaPropertyName, PropertyType, Description, DSTypeAttribute)

	SELECT 'F415C850-F808-4334-9EC8-81E7C989CD8D' , 'corename' , 'Collection name',

			'corename', 'string', 'Collection name for which datasource is associated', -1

END

--id

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B903D9B7-712B-4243-BB74-3C1443FE5B5E')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, 


			SeaPropertyName, PropertyType, Description, DSTypeAttribute)

	SELECT 'B903D9B7-712B-4243-BB74-3C1443FE5B5E' , 'id' , 'Datasource Id',

			'id', 'long', 'Datasource id', -1

END

--username

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)	--attribute 1 implies property belong to SEConnectionProperty


	SELECT '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839' , 'username' , 'UserName','username', 'string', 'User name', -1, 1

END

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839'														
END															
GO

--password

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '61077318-E089-4105-AC78-13306674F2DF')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)


SELECT '61077318-E089-4105-AC78-13306674F2DF' , 'password' , 'User Password','password', 'string', 'User password used for crawling. db and web', -1,1|8

END

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '61077318-E089-4105-AC78-13306674F2DF' AND ((Attribute & 8) = 8))			
BEGIN																																						
	UPDATE SEProperty SET Attribute = Attribute | 8 WHERE PropertyGuid = '61077318-E089-4105-AC78-13306674F2DF'														
END															
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '61077318-E089-4105-AC78-13306674F2DF' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '61077318-E089-4105-AC78-13306674F2DF'														
END															
GO

--domain

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '8A97E073-BEEA-4D89-B580-42E31FDAD6AC')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)


SELECT '8A97E073-BEEA-4D89-B580-42E31FDAD6AC' , 'domain' , 'Domain','domain', 'string', 'User domain', 0, 1

END

--url

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '89BF3F94-0254-46CC-84FC-2D7C15386742')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)


	SELECT '89BF3F94-0254-46CC-84FC-2D7C15386742' , 'url' , 'Connection URL','url', 'string', 'JDBC Connection URL', 0, 1

END

--driver

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '7C5063D4-7A0B-46E9-9364-1D0DD3F5C1DA')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '7C5063D4-7A0B-46E9-9364-1D0DD3F5C1DA' , 'driver' , 'JDBC driver','driver', 'string', 'JDBC driver that will be used for crawling like SQL, MySQL', 0

END

--delta_sql_query

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B277A3A2-C5F0-4242-A4AF-45BFB52E7D2C')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT 'B277A3A2-C5F0-4242-A4AF-45BFB52E7D2C' , 'delta_sql_query' , 'Delta Query','delta_sql_query', 'string', 'Delta query that returns primary key', 0

END

--delta_import_sql_query

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '43A7EEFF-B0E9-4086-8EF1-AB47D4591B92')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '43A7EEFF-B0E9-4086-8EF1-AB47D4591B92' , 'delta_import_sql_query' , 'Delta import query','delta_import_sql_query', 'string', 'Delta query that imports the data based on primary key retrieved from delta_import_query', 0

END

--primary_key

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '0050FEB0-C418-491A-A6D6-87BAADE2609A')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '0050FEB0-C418-491A-A6D6-87BAADE2609A' , 'primary_key' , 'Primary Key','primary_key', 'string', 'The primary key for the entity. It is optional and only needed when using delta-imports. It has no relation to the uniqueKey defined in schema.xml but they both can be the same', 0

END

--sql_select_statement

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '00B9FA45-A2CC-46B2-BB2C-4A7B300FE246')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '00B9FA45-A2CC-46B2-BB2C-4A7B300FE246' , 'sql_select_statement' , 'Sql statement ','sql_select_statement', 'string', 'The sql string using which to query the db', 0

END

--root_entity_fields

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'A0FA9C66-6A7D-4B1E-8D2E-01FE34F0F08B')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT 'A0FA9C66-6A7D-4B1E-8D2E-01FE34F0F08B' , 'root_entity_fields' , 'Root entity Fields','root_entity_fields', 'json', 'Split certain column based on some delimiter. eg:[{"column": "Update_Forms", "splitBy": ";"},{"column": "testcolumn", "splitBy": "-;-"}]', 0

END

--always_incremental

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '4BC14B49-2CF8-47ED-9071-7FD72754A0B4')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT  '4BC14B49-2CF8-47ED-9071-7FD72754A0B4' , 'always_incremental' , 'Always Incremental','always_incremental', 'bool', 'Indicated all upcoming crawling are incremental crawling instead of full crawl', 0

END

--urls

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '14F8D771-9A0C-4C05-ABDC-DEE82CA04016')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '14F8D771-9A0C-4C05-ABDC-DEE82CA04016' , 'urls' , 'Web URLs','urls', 'list', 'list of seed urls for crawling', 0

END

--crawlDepth

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '3D7BF7FF-C78A-4E0F-BC6E-46CBDDEA0119')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '3D7BF7FF-C78A-4E0F-BC6E-46CBDDEA0119' , 'crawlDepth' , 'Crawl depth','crawlDepth', 'int', 'Crawling depth', 0

END

--excludePaths

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '21CD5B4F-A8E3-4A8F-8C64-687EA45F0A8F')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT  '21CD5B4F-A8E3-4A8F-8C64-687EA45F0A8F' , 'excludePaths' , 'Exclude Paths','excludePaths', 'list', 'Paths to be excluded during web crawling', 0

END

--includePaths

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '304BEA7C-1473-49FC-A131-0DFF366FCBBC')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '304BEA7C-1473-49FC-A131-0DFF366FCBBC' , 'includePaths' , 'Include Path','includePaths', 'list', 'Include path filter', 0

END

--emptydatasource

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '8A78AC06-0569-42CE-950A-01D5C9C06EAF')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '8A78AC06-0569-42CE-950A-01D5C9C06EAF' , 'emptydatasource' , 'Empty datasource','emptydatasource', 'bool', 'for csv datasource, we may need to create initially emtpy datasource , so validation will be skipped', 0

END

--filePaths

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'CEA52A3D-FB69-4BEB-A5D6-13F4A0ABC8B6')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT 'CEA52A3D-FB69-4BEB-A5D6-13F4A0ABC8B6' , 'filePaths' , 'File Paths','filePaths', 'list', 

		'List of paths that needs to be considered for crawling', 0

END

--separator

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '36846D4A-12F7-4802-A039-67FA72A73C84')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '36846D4A-12F7-4802-A039-67FA72A73C84' , 'separator' , 'Separator','separator', 'string', 

		'CSV separator between fields', 0

END

--header

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'AAC10CA3-C8CE-4D77-BF9A-0E7ED3037AE3')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT 'AAC10CA3-C8CE-4D77-BF9A-0E7ED3037AE3' , 'header' , 'First row as header','header', 'bool', 

		'Specifies if first row is header', 0

END

--fieldnames

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'F75FAE43-8E33-490D-9450-F6DA0EAE4DBB')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT 'F75FAE43-8E33-490D-9450-F6DA0EAE4DBB' , 'fieldnames' , 'Field names','fieldnames', 'bool', 

		'Comma separated list of column names', 0

END

--skip

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '33AC207F-CA57-411C-BECD-200273FF2788')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '33AC207F-CA57-411C-BECD-200273FF2788' , 'skip' , 'Skip fields','skip', 'list', 

		'Comma separated list of column names to be skipped', 0

END

--skipLines

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '547ED8A7-9431-4EBD-B316-042BC92436E5')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '547ED8A7-9431-4EBD-B316-042BC92436E5' , 'skipLines' , 'Skip lines','skipLines', 'int', 

		'Number of lines to be skipped', 0

END

--encapsulator

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'AA83C1BF-B1E4-4417-85E7-D25ECC36EB10')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT 'AA83C1BF-B1E4-4417-85E7-D25ECC36EB10' , 'encapsulator' , 'Encapsulator','encapsulator', 'character', 

		'Encapsulator ', 0

END

--escape

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B94A5831-073B-43D1-AB9F-073541893DC0')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT 'B94A5831-073B-43D1-AB9F-073541893DC0' , 'escape' , 'Escape','escape', 'character', 

		'Escape character', 0

END

--literal

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'DBD80FE5-63C2-43F7-982A-423FA42A1479')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT 'DBD80FE5-63C2-43F7-982A-423FA42A1479' , 'literal' , 'Literal','literal', 'map', 

		'list of literal eg: [literal.field=value]', 0

END

--trim

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '20D330DA-F0BC-4507-B519-5BEFF6D9C944')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '20D330DA-F0BC-4507-B519-5BEFF6D9C944' , 'trim' , 'Trim','trim', 'boolean', 

		'Trim fields', 0

END

--field_datatype

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '53082FD5-1418-436A-9DD1-29503DE9FFD0')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT '53082FD5-1418-436A-9DD1-29503DE9FFD0' , 'field_datatype' , 'Field datatype','field_datatype', 'Map', 

		'Map containing field name and its datatype', 0

END

--field_new_name

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '8DD6811F-ED04-4F17-87FF-1BA69AE77938')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName	, PropertyType, Description, DSTypeAttribute)


	SELECT '8DD6811F-ED04-4F17-87FF-1BA69AE77938' , 'field_new_name' , 'Field New Name','field_new_name', 'list', 

		'Alias name for existing field name', 0

END

--folder

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'E35A983B-C294-45F3-A270-74C09DC8A468')

BEGIN
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute)


	SELECT 'E35A983B-C294-45F3-A270-74C09DC8A468' , 'folder' , 'Folder name','folder', 'string', 

		'Folder path that will be pulled during run time', 0

END

--executable

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '171DE5C6-B88B-4393-9322-AFD3D145D1AF')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '171DE5C6-B88B-4393-9322-AFD3D145D1AF', 'executable', 'Executable path', 'executable', 'string', 'Executable path to run', 0, 0            
END																																								
GO

--working_directory

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '4E559EA9-DEE5-4DDF-9994-644488218F77')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '4E559EA9-DEE5-4DDF-9994-644488218F77', 'working_dir', 'working directory ', 'working_dir', 'string', 'Working directory', 0, 0            
END																																								
GO

--arguments

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'D9DA5910-695D-4C83-813B-BA35F56AEDD6')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'D9DA5910-695D-4C83-813B-BA35F56AEDD6', 'args', 'Arguments', 'args', 'string', 'Arguments to be passed for executable', 0, 0            
END																																								
GO

--environment

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '2D9C8F86-FEF1-43A1-B10B-8E9A7BEF0DBB')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '2D9C8F86-FEF1-43A1-B10B-8E9A7BEF0DBB', 'environment', 'Environment variable', 'environment', 'string', 'Any Environment variable to be set before running executable', 0, 0            
END																																								
GO

--computers

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'BF1738D2-AC5E-446C-A9BD-737CDD0D5106')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'BF1738D2-AC5E-446C-A9BD-737CDD0D5106', 'computers', 'Remote computers', 'computers', 'list', 'Remote computers to where the executable to be run', 0, 0            
END																																								
GO

--copyExe

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'C4CC0E6D-9BAD-4AED-A121-BD47B748E8F7')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'C4CC0E6D-9BAD-4AED-A121-BD47B748E8F7', 'copyExe', 'Copy Exe', 'copyExe', 'boolean', 'copyExe flag when enabled copies the executable to provided remote computers and executes', 0, 0            
END																																								
GO

--language

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '943205A9-F4CB-47CF-AD13-A659ACA8CA01')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '943205A9-F4CB-47CF-AD13-A659ACA8CA01', 'language', 'Language', 'language', 'string', 'language like java, python, perl. so that we can prefix the command', 0, 0            
END																																								
GO

--prefix_command

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'C2C7D390-C8AF-4A78-A6F2-01B540C23A29')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'C2C7D390-C8AF-4A78-A6F2-01B540C23A29', 'prefix_command', 'Prefix Command', 'prefix_command', 'string', 'Command that can be prefixed before executable. when prefix_command is not provided we check language', 0, 0            
END																																								
GO

--companyname

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'D57ECAAF-B706-40C8-BCDE-7F8C51FF7EDA')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'D57ECAAF-B706-40C8-BCDE-7F8C51FF7EDA', 'companyname', 'Company name', 'companyname', 'string', 'similar to domain, companyname is also used.', 0, 0            
END																																								
GO

--tablename

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B9299A84-2662-4BD4-BB2D-496EA3C828BF')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'B9299A84-2662-4BD4-BB2D-496EA3C828BF', 'tablename', 'Table name', 'tablename', 'string', 'tablename is also used.', 0, 0            
END																																								
GO

--columns

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'F84674C6-62CB-4D2F-A2FD-9F7BCDD20D4B')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'F84674C6-62CB-4D2F-A2FD-9F7BCDD20D4B', 'columns', 'Column name and datatype map', 'columns', 'map', 'Map containing column name and its datatype', 0, 0            
END																																								
GO

--includedirectoriespath

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'E3572BC2-4ECA-4D90-9D94-5EC2822ED2F9')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'E3572BC2-4ECA-4D90-9D94-5EC2822ED2F9', 'includedirectoriespath', 'Include paths', 'includedirectoriespath', 'String', 'Comma separated paths', -1, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'E3572BC2-4ECA-4D90-9D94-5EC2822ED2F9' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = 'E3572BC2-4ECA-4D90-9D94-5EC2822ED2F9'														
END															
GO

--maxindexingthreads

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '8AEBC0B6-1175-4C53-BEBD-1771F580497D')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '8AEBC0B6-1175-4C53-BEBD-1771F580497D', 'maxindexingthreads', 'Max parallel threads', 'maxindexingthreads', 'int', 'Maximun number of threads to spawn in parallel', 0, 0            
END																																								
GO

--clientid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '0278A00E-317A-451E-B1EF-97F1BA610C38')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '0278A00E-317A-451E-B1EF-97F1BA610C38', 'clientid', '', 'clientid', 'int', '', -1, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '0278A00E-317A-451E-B1EF-97F1BA610C38' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '0278A00E-317A-451E-B1EF-97F1BA610C38'														
END															
GO

--retainallversions

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'D1F982CC-BF10-4705-A761-944A17226337')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'D1F982CC-BF10-4705-A761-944A17226337', 'retainallversions', 'Retain all versions', 'retainallversions', 'boolean', 'Indicate whether we need to retain all versions of same document, if not present only one versions will exists', 0, 0            
END																																								
GO

-- doincrementalscan

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '28020419-D8F9-4FAA-AA2A-81363F504456')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '28020419-D8F9-4FAA-AA2A-81363F504456', 'doincrementalscan', 'Incremental scan', 'doincrementalscan', 'boolean', 'Flag indicating perform incremental or full crawl.', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '28020419-D8F9-4FAA-AA2A-81363F504456' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '28020419-D8F9-4FAA-AA2A-81363F504456'														
END															
GO

--pushonlymetadata

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B79286F1-9B73-47CC-A5FA-2B187FF22084')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'B79286F1-9B73-47CC-A5FA-2B187FF22084', 'pushonlymetadata', 'Push only metadata', 'pushonlymetadata', 'boolean', 'Flag to indicate if data also to be pushed or only meta data to be pushed.', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B79286F1-9B73-47CC-A5FA-2B187FF22084' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = 'B79286F1-9B73-47CC-A5FA-2B187FF22084'														
END															
GO

--includefilters

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '39484127-E0AD-4DF8-83C2-ECB2A3BC75A4')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '39484127-E0AD-4DF8-83C2-ECB2A3BC75A4', 'includefilters', 'Filters to include', 'includefilters', 'String', 'Comma separated filters to be included for crawling (eg: c,cpp,txt,pdf,ini)', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '39484127-E0AD-4DF8-83C2-ECB2A3BC75A4' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '39484127-E0AD-4DF8-83C2-ECB2A3BC75A4'														
END															
GO

--excludefilters

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '8BCAC22C-DFEF-4EB3-892F-15B54C3115FB')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '8BCAC22C-DFEF-4EB3-892F-15B54C3115FB', 'excludefilters', 'Filters to exclude', 'excludefilters', 'String', 'Comma separated filters to be excluded, this takes higher precedence than include', -1, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '8BCAC22C-DFEF-4EB3-892F-15B54C3115FB' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '8BCAC22C-DFEF-4EB3-892F-15B54C3115FB'														
END															
GO

--minumumdocumentsize

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '66016BE5-2712-435A-8114-4425D8C006E2')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '66016BE5-2712-435A-8114-4425D8C006E2', 'minumumdocumentsize', 'Minimum document size ', 'minumumdocumentsize', 'int', 'Minimum document size to be considered for crawling', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '66016BE5-2712-435A-8114-4425D8C006E2' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '66016BE5-2712-435A-8114-4425D8C006E2'														
END															
GO

--maximumdocumentsize

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '9C4543CC-0A6B-434C-BCA8-72851E2BD724')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '9C4543CC-0A6B-434C-BCA8-72851E2BD724', 'maximumdocumentsize', 'Maximun document size', 'maximumdocumentsize', 'int', 'Docs whose Size greater than specified value will be skipped', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '9C4543CC-0A6B-434C-BCA8-72851E2BD724' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '9C4543CC-0A6B-434C-BCA8-72851E2BD724'														
END															
GO

--suffixprimarykey

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'F9F0E1B8-0080-417C-84AB-3DDE48095A40')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'F9F0E1B8-0080-417C-84AB-3DDE48095A40', 'suffixprimarykey', 'Suffix string with primary key', 'suffixprimarykey', 'string', 'If primary_key have to be suffixed with any custom string, this field will be used ', 0, 0            
END																																								
GO

--securityToken

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '7A774ABC-5A1D-4449-8AA3-CAFA10AE021C')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '7A774ABC-5A1D-4449-8AA3-CAFA10AE021C', 'securityToken', 'Security Token', 'securityToken', 'string', 'securityToken for the salesforce', 0, 8            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '7A774ABC-5A1D-4449-8AA3-CAFA10AE021C' AND ((Attribute & 8) = 8))			
BEGIN																																						
	UPDATE SEProperty SET Attribute = Attribute | 8 WHERE PropertyGuid = '7A774ABC-5A1D-4449-8AA3-CAFA10AE021C'														
END															
GO

--isDrillEnabled		

IF EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '6BF32CA9-2FD1-43D6-AEC6-09FBADE521FD' AND DSTypeAttribute = 0)

BEGIN

    UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '6BF32CA9-2FD1-43D6-AEC6-09FBADE521FD'

END

ELSE 

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '6BF32CA9-2FD1-43D6-AEC6-09FBADE521FD')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '6BF32CA9-2FD1-43D6-AEC6-09FBADE521FD', 'isDrillEnabled', 'Drill Enabled', 'isDrillEnabled', 'boolean', 'flag to get the drill configuration status', -1, 2	-- indicates that the property can be updated separatly            
END																																								
GO

--searchbaselist

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '1D85B1F2-6D25-41BF-BED6-CC32D66E977C')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '1D85B1F2-6D25-41BF-BED6-CC32D66E977C', 'searchbaselist', 'Search base list', 'searchbaselist', 'json', 'Search base list for the ldap', 0, 0            
END																																								
GO

--webUrl

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'BA8A3771-98BA-4216-880F-47520449CB25')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'BA8A3771-98BA-4216-880F-47520449CB25', 'webUrl', 'web url', 'webUrl', 'string', 'web url for http', 0, 0            
END																																								
GO

--split

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'C762F99A-2E18-4405-AD68-EEEAD1AA38D2')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'C762F99A-2E18-4405-AD68-EEEAD1AA38D2', 'split', 'split', 'split', 'string', 'json array split ', 0, 0            
END																																								
GO

--requestType

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '419C2D59-F45F-4C24-879A-FF593706DB52')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '419C2D59-F45F-4C24-879A-FF593706DB52', 'reqType', 'requestType', 'requestType', 'string', 'Request type for url', 0, 0            
END																																								
GO

--acceptType

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '43371650-4E7C-4E14-BCDA-CA5E83D3509A')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '43371650-4E7C-4E14-BCDA-CA5E83D3509A', 'acceptType', 'acceptType', 'acceptType', 'string', 'Accept type for url', 0, 0            
END																																								
GO

--headers

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '03099C03-4DE6-4E3E-A584-E2C356EF2375')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '03099C03-4DE6-4E3E-A584-E2C356EF2375', 'headers', 'headers', 'headers', 'map', 'headers for url', 0, 0            
END																																								
GO

--payload

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'C0B42AEA-CCB3-4ECC-9588-FAC3ED985364')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'C0B42AEA-CCB3-4ECC-9588-FAC3ED985364', 'payload', 'payload', 'payload', 'string', 'payload for url on post', 0, 0            
END																																								
GO

--fields

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '2527521A-577B-46F4-B041-5288DAFA8C81')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '2527521A-577B-46F4-B041-5288DAFA8C81', 'fields', 'fields', 'fields', 'list', 'fields which is parsed', 0, 0            
END																																								
GO

--start

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'ED8DDEC7-1B5F-4FD8-9AA6-C00EC56F543D')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'ED8DDEC7-1B5F-4FD8-9AA6-C00EC56F543D', 'start', 'start', 'start', 'long', 'start for url to loop', 0, 0            
END																																								
GO

--offset

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '0F100386-FB2B-4B95-9D5A-112E819C7C95')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '0F100386-FB2B-4B95-9D5A-112E819C7C95', 'offset', 'offset', 'offset', 'long', 'offset for url to loop', 0, 0            
END																																								
GO

--totalNumPath

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '985AEE33-D0B1-4784-8F06-EAF0CF1FD4C7')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '985AEE33-D0B1-4784-8F06-EAF0CF1FD4C7', 'totalNumPath', 'totalNumPath', 'totalNumPath', 'string', 'numfound expression for url to loop', 0, 0            
END																																								
GO

--appId

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'E58F9CAE-302D-4240-8632-48D487812004')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'E58F9CAE-302D-4240-8632-48D487812004', 'appId', 'Application Id', 'Application Id', 'string', 'Application Id for connectors', 0, 0            
END																																								
GO

--appSecret

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '6FA55E7A-A818-4531-8699-234FA29D5DF1')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '6FA55E7A-A818-4531-8699-234FA29D5DF1', 'appSecret', 'Application Secret', 'Application Secret', 'string', 'Application Secret for connectors', 0, 8            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '6FA55E7A-A818-4531-8699-234FA29D5DF1' AND ((Attribute & 8) = 8))			
BEGIN																																						
	UPDATE SEProperty SET Attribute = Attribute | 8 WHERE PropertyGuid = '6FA55E7A-A818-4531-8699-234FA29D5DF1'														
END															
GO

--accessToken

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'E9DAFC6E-771C-4556-AA7F-7CB06C5D02AE')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'E9DAFC6E-771C-4556-AA7F-7CB06C5D02AE', 'accessToken', 'Access Token', 'Access Token', 'string', 'Access token after oAuth', 0, 8            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'E9DAFC6E-771C-4556-AA7F-7CB06C5D02AE' AND ((Attribute & 8) = 8))			
BEGIN																																						
	UPDATE SEProperty SET Attribute = Attribute | 8 WHERE PropertyGuid = 'E9DAFC6E-771C-4556-AA7F-7CB06C5D02AE'														
END															
GO

--accessTokenSecret

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '221FE61F-42B7-4C26-B856-56AB9192179F')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '221FE61F-42B7-4C26-B856-56AB9192179F', 'accessTokenSecret', 'Access Token Secret', 'Access Token Secret', 'string', 'Access token secret after oAuth', 0, 8            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '221FE61F-42B7-4C26-B856-56AB9192179F' AND ((Attribute & 8) = 8))			
BEGIN																																						
	UPDATE SEProperty SET Attribute = Attribute | 8 WHERE PropertyGuid = '221FE61F-42B7-4C26-B856-56AB9192179F'														
END															
GO

--fbId

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '4ada971f-fd52-4a31-8e75-1b1140dba837')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '4ada971f-fd52-4a31-8e75-1b1140dba837', 'fbId', 'Facebook Id of User or Page', 'Facebook Id of User or Page', 'string', 'Facebook Id of User or Page supplied for crawling', 0, 0            
END																																								
GO

--fbCrawlSelections

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'f99a2339-1977-4c72-94d6-828246510492')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'f99a2339-1977-4c72-94d6-828246510492', 'fbCrawlSelections', 'Facebook Crawl Selections', 'Facebook Crawl Selections', 'string', 'Comma seperated list of items to be crawled', 0, 0            
END																																								
GO

--lookupparams

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '537A47C2-3075-4523-9FB2-9ABBE24BC85E')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '537A47C2-3075-4523-9FB2-9ABBE24BC85E', 'lookupparams', 'Lookup transformer params', 'lookupparams', 'string', 'json array object', -1, 0            
END																																								
GO

--isPaginate

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'F0A2E022-2591-48CA-9D56-24F959CADFBC')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'F0A2E022-2591-48CA-9D56-24F959CADFBC', 'isPaginate', 'isPaginate', 'isPaginate', 'boolean', 'Pagination for http rest api', 0, 0            
END																																								
GO

--startParamName

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '00CCB9AA-152E-4CB5-949B-E406BB09124C')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '00CCB9AA-152E-4CB5-949B-E406BB09124C', 'startParamName', 'startParamName', 'startParamName', 'string', 'start page parameter name', 0, 0            
END																																								
GO

--startParamValue

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '12AFE84A-666C-4AE5-9AF0-D738736BD5FA')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '12AFE84A-666C-4AE5-9AF0-D738736BD5FA', 'startParamValue', 'startParamValue', 'startParamValue', 'long', 'start page parameter value', 0, 0            
END																																								
GO

--incrementalParamName

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'BDC415FC-A2AC-4322-9A16-5811A6E7A4A2')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'BDC415FC-A2AC-4322-9A16-5811A6E7A4A2', 'incrementalParamName', 'incrementalParamName', 'incrementalParamName', 'string', 'incremental page parameter name', 0, 0            
END																																								
GO

--incrementalParamValue

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'C54CA100-9042-4C8C-9523-24287CDA6003')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'C54CA100-9042-4C8C-9523-24287CDA6003', 'incrementalParamValue', 'incrementalParamValue', 'incrementalParamValue', 'long', 'incremental page parameter value', 0, 0            
END																																								
GO

--incrementalType

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B1DE1EBD-B58D-4AD9-9BD5-BA798867DD46')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'B1DE1EBD-B58D-4AD9-9BD5-BA798867DD46', 'incrementalType', 'incrementalType', 'incrementalType', 'string', 'incremental page parameter type', 0, 0            
END																																								
GO

--totalLoopType

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '581CD1C1-DD33-42C1-9E4D-5CCE2AB49D64')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '581CD1C1-DD33-42C1-9E4D-5CCE2AB49D64', 'totalLoopType', 'totalLoopType', 'totalLoopType', 'string', 'total Loop Type', 0, 0            
END																																								
GO

--totalLoopValue

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '4693070D-C7CD-4157-86AC-F3D7E3E084CC')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '4693070D-C7CD-4157-86AC-F3D7E3E084CC', 'totalLoopValue', 'totalLoopValue', 'totalLoopValue', 'string', 'incremental page parameter type', 0, 0            
END																																								
GO

--httpAuthConfig

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B3A80C5A-1F13-4A5A-A719-F3818FF0AB11')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'B3A80C5A-1F13-4A5A-A719-F3818FF0AB11', 'httpAuthConfig', 'httpAuthConfig', 'httpAuthConfig', 'string', 'Authentication config for HTTP DS', 0, 0            
END																																								
GO

--additionalinfo

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '99C75100-8EAC-40DB-B80A-399A7889FC5F')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '99C75100-8EAC-40DB-B80A-399A7889FC5F', 'additionalinfo', 'additionalinfo', 'additionalinfo', 'json string', 'Additional Info', -1, 0            
END																																								
GO

--commcellId

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'CB5922E7-23F8-45DF-B18C-1093DCEA64C3')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'CB5922E7-23F8-45DF-B18C-1093DCEA64C3', 'commcellId', 'commcellId', 'commcellId', 'int', 'commcell id for database', 0, 0            
END																																								
GO

--isDBView 

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B1DEDC94-C002-4E5F-9788-4BFB0144F795')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'B1DEDC94-C002-4E5F-9788-4BFB0144F795', 'isDBView', 'isDBView', 'tableName or viewName in db connector', 'bool', 'isDBView', 0, 0            
END																																								
GO

--iscaenabled

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '5B354BFC-8A1D-42EB-9BBD-88459E8DBFAE')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '5B354BFC-8A1D-42EB-9BBD-88459E8DBFAE', 'iscaenabled', 'iscaenabled', 'iscaenabled', 'boolean', 'CA enabled parameter', -1, 0            
END																																								
GO

--caconfig

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '5B402675-78C8-4F36-BAF2-B82CB2091F10')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '5B402675-78C8-4F36-BAF2-B82CB2091F10', 'caconfig', 'caconfig', 'caconfig', 'string', 'json array object', -1, 0            
END																																								
GO

--cacloudid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '90C8C355-F250-4A31-B431-D1534E7F4A74')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '90C8C355-F250-4A31-B431-D1534E7F4A74', 'cacloudid', 'cacloudid', 'cacloudid', 'int', 'CA Cloud Id', -1, 0            
END																																								
GO

--catargeturl

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '14243C68-55A0-4920-B978-619A141664DA')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '14243C68-55A0-4920-B978-619A141664DA', 'catargeturl', 'catargeturl', 'catargeturl', 'string', 'CA Cloud Target Url', -1, 0            
END																																								
GO

--isLive

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '15F25A60-6072-4808-B7B7-AE49447C9B61')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '15F25A60-6072-4808-B7B7-AE49447C9B61', 'isLive', 'isLive', 'isLive', 'bool', 'Live twitter crawling', 0, 0            
END																																								
GO

--streamingKeyword

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '9E175A9C-6753-4301-B3C3-34B476CE7213')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '9E175A9C-6753-4301-B3C3-34B476CE7213', 'streamingKeyword', 'streamingKeyword', 'streamingKeyword', 'string', 'Keyword for Live twitter crawling', 0, 0            
END																																								
GO

--userScreenName

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B3A80C5A-1F13-4A5A-A719-F3818FF0AB16')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'B3A80C5A-1F13-4A5A-A719-F3818FF0AB16', 'userScreenName', 'userScreenName', 'userScreenName', 'string', 'User Screen Name for Live twitter crawling', 0, 0            
END																																								
GO

--hashTags

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '15ADEC5D-FC37-429B-A2B7-4081ED03A786')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '15ADEC5D-FC37-429B-A2B7-4081ED03A786', 'hashTags', 'hashTags', 'hashTags', 'list', 'search on basis of specific hastags', 0, 0            
END																																								
GO

--fromDate

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'AA607A69-62FE-4B8F-89AB-530526B0E92E')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'AA607A69-62FE-4B8F-89AB-530526B0E92E', 'fromDate', 'fromDate', 'fromDate', 'string', 'from date twitter tweets', 0, 0            
END																																								
GO

--toDate

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'E2666BB9-4BA8-42F3-A353-05A8A83CCDDF')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'E2666BB9-4BA8-42F3-A353-05A8A83CCDDF', 'toDate', 'toDate', 'toDate', 'string', 'to date twitter tweets', 0, 0            
END																																								
GO

--consumerKey

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '17AEB830-30E3-4CF1-A2B6-08918AA27181')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '17AEB830-30E3-4CF1-A2B6-08918AA27181', 'consumerKey', 'consumerKey', 'consumerKey', 'string', 'consumer key for twitter', 0, 8            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '17AEB830-30E3-4CF1-A2B6-08918AA27181' AND ((Attribute & 8) = 8))			
BEGIN																																						
	UPDATE SEProperty SET Attribute = Attribute | 8 WHERE PropertyGuid = '17AEB830-30E3-4CF1-A2B6-08918AA27181'														
END															
GO

--consumerSecret

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '81AA223E-9F24-4426-821F-37E0F7E83DB5')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '81AA223E-9F24-4426-821F-37E0F7E83DB5', 'consumerSecret', 'consumerSecret', 'consumerSecret', 'string', 'consumer secret for twitter', 0, 8            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '81AA223E-9F24-4426-821F-37E0F7E83DB5' AND ((Attribute & 8) = 8))			
BEGIN																																						
	UPDATE SEProperty SET Attribute = Attribute | 8 WHERE PropertyGuid = '81AA223E-9F24-4426-821F-37E0F7E83DB5'														
END															
GO

--accessToken

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'FFCAFA68-2444-416B-AADA-0F7845F9653C')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'FFCAFA68-2444-416B-AADA-0F7845F9653C', 'accessToken', 'accessToken', 'accessToken', 'string', 'access token for twitter', 0, 8            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'FFCAFA68-2444-416B-AADA-0F7845F9653C' AND ((Attribute & 8) = 8))			
BEGIN																																						
	UPDATE SEProperty SET Attribute = Attribute | 8 WHERE PropertyGuid = 'FFCAFA68-2444-416B-AADA-0F7845F9653C'														
END															
GO

--accessTokenSecret

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B0B200B9-F485-4DAD-B09A-3C50B525B3DE')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'B0B200B9-F485-4DAD-B09A-3C50B525B3DE', 'accessTokenSecret', 'accessTokenSecret', 'accessTokenSecret', 'string', 'access token secret for twitter', 0, 8            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B0B200B9-F485-4DAD-B09A-3C50B525B3DE' AND ((Attribute & 8) = 8))			
BEGIN																																						
	UPDATE SEProperty SET Attribute = Attribute | 8 WHERE PropertyGuid = 'B0B200B9-F485-4DAD-B09A-3C50B525B3DE'														
END															
GO

--isSecuredLdap

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '96C3759F-AF65-4512-B40C-B084DC8D1596')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '96C3759F-AF65-4512-B40C-B084DC8D1596', 'isSecuredLdap', 'isSecuredLdap', 'isSecuredLdap', 'bool', 'Flag to say if current configuration is secured or not', 0, 0            
END																																								
GO

--versioninfo

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'E6FE8288-FE16-470F-AD60-EDD21AFF46C0')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'E6FE8288-FE16-470F-AD60-EDD21AFF46C0', 'versioninfo', 'versioninfo', 'versioninfo', 'json string', 'Contains the version info of datasource, used in cloudmode', -1, 2	-- indicates that the property can be updated separatly            
END																																								
GO

--sourcetype

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '617BB3EF-65A9-49C1-BC60-8F3820149236')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '617BB3EF-65A9-49C1-BC60-8F3820149236', 'sourcetype', 'sourcetype', 'sourcetype', 'string', 'Contains the sourcetype of datasource, used in cloudmode', -1, 0            
END																																								
GO

--subsourcetype

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'F3C96257-7468-41CD-B40D-CF6D0D945DD3')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'F3C96257-7468-41CD-B40D-CF6D0D945DD3', 'subsourcetype', 'subsourcetype', 'subsourcetype', 'string', 'Contains the subsourcetype of datasource, used in cloudmode', -1, 0            
END																																								
GO

--literalproperties

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'f090c1e7-0f2c-458b-95ff-e8050bb198ee')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'f090c1e7-0f2c-458b-95ff-e8050bb198ee', 'literalproperties', 'literalproperties', 'literalproperties', 'json string', 'Contains literal properties to be pushed while crawl', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'f090c1e7-0f2c-458b-95ff-e8050bb198ee' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = 'f090c1e7-0f2c-458b-95ff-e8050bb198ee'														
END															
GO

--ediscoveryproperty

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'd215e7ec-014c-4e98-a22d-9c1f384abeda')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'd215e7ec-014c-4e98-a22d-9c1f384abeda', 'ediscoveryproperty', 'ediscoveryproperty', 'ediscoveryproperty', 'json string', 'Json representation of properties for pushing data to inventory core ', 0, 0            
END																																								
GO

--statusinfo

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '47AD360E-E732-4D96-A215-5E284CC5F99C')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '47AD360E-E732-4D96-A215-5E284CC5F99C', 'statusinfo', 'statusinfo', 'statusinfo', 'xml string', 'Contains the status of the datasource', -1, 2	-- indicates that the property can be updated separatly            
END																																								
GO

--dswebhookconfig

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'bc30440d-55d3-4e09-96cf-88b9a2836d0a')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'bc30440d-55d3-4e09-96cf-88b9a2836d0a', 'dswebhookconfig', 'Webhook configuration', 'dswebhookconfig', 'string', 'Contains the webhook entries for a datasource', -1, 0            
END																																								
GO

--backupsetguid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'A7B87E15-49B7-4090-A068-22B6CC6A9B5F')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'A7B87E15-49B7-4090-A068-22B6CC6A9B5F', 'backupsetguid', 'Backupset guid', 'backupsetguid', 'string', 'Contains the backupset guid, currently used by exchange datasource', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'A7B87E15-49B7-4090-A068-22B6CC6A9B5F' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = 'A7B87E15-49B7-4090-A068-22B6CC6A9B5F'														
END															
GO

--roletypename

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '51DFD2BD-93CE-4683-8C89-20848A066A84')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '51DFD2BD-93CE-4683-8C89-20848A066A84', 'roletypename', 'RoleType Name', 'roletypename', 'string', 'Contains roletype that current datasource belong, used in cloudmode', -1, 0            
END																																								
GO

--pseudoclientid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '9D174CA5-95AB-4EF6-A15B-5E190F87317F')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '9D174CA5-95AB-4EF6-A15B-5E190F87317F', 'pseudoclientid', 'Pseudoclient Id', 'pseudoclientid', 'int', 'Contains pseudoclient id of the file datasource', -1, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '9D174CA5-95AB-4EF6-A15B-5E190F87317F' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '9D174CA5-95AB-4EF6-A15B-5E190F87317F'														
END															
GO

--subclientid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '45A663C4-BA63-4287-A163-971182F484FC')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '45A663C4-BA63-4287-A163-971182F484FC', 'subclientid', 'Subclient Id', 'subclientid', 'int', 'Contains subclient id of the file datasource', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '45A663C4-BA63-4287-A163-971182F484FC' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '45A663C4-BA63-4287-A163-971182F484FC'														
END															
GO

--appname

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '4526224E-BB52-4870-84D1-21D12FDC41AB')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '4526224E-BB52-4870-84D1-21D12FDC41AB', 'appname', 'Application Name', 'appname', 'string', 'Contains application name from where the data source was created', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '4526224E-BB52-4870-84D1-21D12FDC41AB' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '4526224E-BB52-4870-84D1-21D12FDC41AB'														
END															
GO

--candelete

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '9DD750DD-DFDB-4BE2-A240-9141C36AB53F')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '9DD750DD-DFDB-4BE2-A240-9141C36AB53F', 'candelete', 'Can Delete', 'candelete', 'string', 'Can the data source be deleted', 0, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '9DD750DD-DFDB-4BE2-A240-9141C36AB53F' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '9DD750DD-DFDB-4BE2-A240-9141C36AB53F'														
END															
GO

--dcplanid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '9DE33247-4068-46F3-BB4D-8D7F1A48534E')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '9DE33247-4068-46F3-BB4D-8D7F1A48534E', 'dcplanid', 'DC Plan ID', 'dcplanid', 'int', 'Contains Data Classification Plan Id associated with the datasource for Entity Extraction', -1, 0            
END																																								
GO

--createclient

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '0D317445-9118-4D73-8265-85DC7DA1A16F')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '0D317445-9118-4D73-8265-85DC7DA1A16F', 'createclient', 'CreateClient Type', 'createclient', 'string', 'Contains client type to create', -1, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '0D317445-9118-4D73-8265-85DC7DA1A16F' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = '0D317445-9118-4D73-8265-85DC7DA1A16F'														
END															
GO

--accessnodeclientid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'A72DD025-BE6C-4D27-93FA-256D7DF5E801')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'A72DD025-BE6C-4D27-93FA-256D7DF5E801', 'accessnodeclientid', 'AccessNodeClientId', 'accessnodeclientid', 'int', 'Contains accessnode clientid id for file datasource', -1, 0            
END																																								
GO

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'A72DD025-BE6C-4D27-93FA-256D7DF5E801' AND ((DSTypeAttribute & -1) = -1))			
BEGIN																																						
	UPDATE SEProperty SET DSTypeAttribute = -1 WHERE PropertyGuid = 'A72DD025-BE6C-4D27-93FA-256D7DF5E801'														
END															
GO

--roletypename

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '51DFD2BD-93CE-4683-8C89-20848A066A84')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '51DFD2BD-93CE-4683-8C89-20848A066A84', 'roletypename', 'RoleType Name', 'roletypename', 'string', 'Contains roletype that current datasource belong, used in cloudmode', -1, 0            
END																																								
GO

--importSettings

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'AC855170-5945-4F49-939A-0914C54E8AC4')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'AC855170-5945-4F49-939A-0914C54E8AC4', 'importSettings', 'Import Settings', 'importSettings', 'json string', 'Contains the import configuration setting and status', -1, 2	-- indicates that the property can be updated separatly            
END																																								
GO

--mlinfo

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '5A0B311C-A873-41C8-8B14-E8F98A6A5D51')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '5A0B311C-A873-41C8-8B14-E8F98A6A5D51', 'mlinfo', 'Machine learning information', 'mlinfo', 'xml', 'Contains machine learning information, currently used by exchange datasource', 0, 0            
END																																								
GO

--crawltype

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'D1459ABE-5BEB-47F7-9293-7F35D3CF9063')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'D1459ABE-5BEB-47F7-9293-7F35D3CF9063', 'crawltype', 'Crawl Type', 'crawltype', 'int', 'Indicate crawling method of the datasource: live crawl, launching CI job, or importing index', -1, 0            
END																																								
GO

--backedupsubclientids

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '8765F182-72D7-4E6A-86FC-600B568830CE')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '8765F182-72D7-4E6A-86FC-600B568830CE', 'backedupsubclientids', 'SubclientIds List', 'backedupsubclientids', 'string', 'List of Backed up Subclient Ids from a specific client which are used to create the datasource, separated by comma', -1, 0            
END																																								
GO

--datasourceSubType

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '589FECD0-1BD1-42C9-A0D8-F2638990379A')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '589FECD0-1BD1-42C9-A0D8-F2638990379A', 'datasourceSubType', 'Data Source subtype', 'datasourceSubType', 'string', 'contains subtype for the data source', -1, 0            
END																																								
GO

--enableEntityExtraction

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'D6045EE0-F206-4B03-B96B-CDA6193D35DC')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'D6045EE0-F206-4B03-B96B-CDA6193D35DC', 'enableImageExtraction', 'Enable Image Extraction', 'enableImageExtraction', 'boolean', 'Enable Image Extraction for the document', -1, 0            
END																																								
GO

 --dbinstanceid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '6E667895-E8F3-4616-A582-8612E205B8CF')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '6E667895-E8F3-4616-A582-8612E205B8CF', 'dbinstanceid', 'DBInstanceID', 'dbinstanceid', 'int', 'Contains Instance id for database instance.', -1, 0            
END																																								
GO

--hostname

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'A58E1DB4-DABF-4036-A852-7E1CEDC73297')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'A58E1DB4-DABF-4036-A852-7E1CEDC73297', 'hostname', 'Hostname', 'hostname', 'string', 'Hostname of client.', -1, 0            
END																																								
GO

--ostype

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'D3C2C992-F64E-458C-9A50-AA55ACC39DD8')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'D3C2C992-F64E-458C-9A50-AA55ACC39DD8', 'ostype', 'OS type', 'ostype', 'string', 'OS type of client.', -1, 0            
END																																								
GO

--enablemonitoring

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '35CDF5D5-3C7E-4197-B21A-0C7C9A0AFE3B')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '35CDF5D5-3C7E-4197-B21A-0C7C9A0AFE3B', 'enablemonitoring', 'EnableMonitoring', 'enablemonitoring', 'bool', 'Flag indicates whether to show user access monitoring panel or not', -1, 0            
END																																								
GO

--auditserverinfo

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '660F60C8-5A40-41C5-ADF0-AC9C1FFA28DE')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '660F60C8-5A40-41C5-ADF0-AC9C1FFA28DE', 'auditserverinfo', 'Server Details For Audit Information', 'auditserverinfo', 'xml', 'Contains analytics engine details for audit', 0, 0            
END																																								
GO

--jobids

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'D0A80779-1391-42CD-A4CE-2651A97524C8')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'D0A80779-1391-42CD-A4CE-2651A97524C8', 'jobids', 'JobIds', 'jobids', 'string', 'Comma separated list of job ids associated to a data source', -1, 2	-- indicates that the property can be updated separatly            
END																																								
GO

--routinginfo

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'A5465548-D1BD-4292-BF90-89B95885BD73')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'A5465548-D1BD-4292-BF90-89B95885BD73', 'routinginfo', 'Routing Inofrmation', 'routinginfo', 'xml', 'Contains information about the sharded data sources under multinode federated data source', -1, 0            
END																																								
GO

--multinodefederatedid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'B2A95D3F-73F1-42DB-8419-382C2241ABAC', 'multinodefederatedid', 'Multinode Federated Id', 'multinodefederatedid', 'int', 'Stores the data source id for the multinode federated datasource it is associated with', -1, 0            
END																																								
GO

--clientdisplayname

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '5B16A538-A41F-4FDA-A418-D821611737CD')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '5B16A538-A41F-4FDA-A418-D821611737CD', 'clientdisplayname', 'Client Display Name', 'clientdisplayname', 'int', 'Stores the client display name', -1, 0            
END																																								
GO

--clientgroupid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'D2B497D5-BF19-4A4B-8DAE-D1E660C6AF23')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'D2B497D5-BF19-4A4B-8DAE-D1E660C6AF23', 'clientgroupid', 'Client Group Id', 'clientgroupid', 'int', 'Stores the client group id', -1, 0            
END																																								
GO

-- Exchange metadata props

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '1B15DDC5-1CEF-41E6-A520-9A2EAACBB79B')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '1B15DDC5-1CEF-41E6-A520-9A2EAACBB79B', 'metaidxinfo', 'Meta Index Info', 'metaidxinfo', 'xml', 'Contains the dbprops used for index server playback', -1, 2	-- indicates that the property can be updated separatly            
END																																								
GO

--schema version

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'C973E447-14F9-46C4-A987-CB98398023FC')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'C973E447-14F9-46C4-A987-CB98398023FC', 'schemaversion', 'Schema Version', 'schemaversion', 'string', 'Contains Schema Version', -1, 0            
END																																								
GO

--backupsetguidXML

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '850A1F41-96DF-4A6A-8062-2813E11DBE1A')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '850A1F41-96DF-4A6A-8062-2813E11DBE1A', 'backupsetguidxml', 'Backupset guid XML', 'backupsetguidxml', 'xml', 'Contains the backupset guid in xml format, currently used by exchange datasource', -1, 0            
END																																								
GO

--AppVersion

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'BB51A1D2-7440-42be-89D4-DC208A86EC01')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT 'BB51A1D2-7440-42be-89D4-DC208A86EC01', 'AppVersion', 'Application collection Version', 'AppVersion', 'string', 'Contains application collection Version', -1, 0            
END																																								
GO

--indexscalingjobid

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '83661EB7-3E3B-4C69-A07F-7103714AE221')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '83661EB7-3E3B-4C69-A07F-7103714AE221', 'indexscalingjobid', 'Index scaling job id', 'indexscalingjobid', 'long', 'Contains the job id for the index scaling operation', -1, 0            
END																																								
GO

--indexscalingcorestatus

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '50C23A5D-70EA-4BB7-81D6-22027BD82E16')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '50C23A5D-70EA-4BB7-81D6-22027BD82E16', 'indexscalingcorestatus', 'Index scaling core status', 'indexscalingcorestatus', 'int', 'Status of the core i.e completed/failed for the index scaling job', -1, 0            
END																																								
GO

--indexscalingperformedat

IF NOT EXISTS( SELECT TOP 1 * FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = '1BC7C40D-1E4F-4809-8A85-E8786A93CB73')                                                              
BEGIN                                                                                                                                                         
	INSERT INTO SEProperty(PropertyGuid, PropertyName, PropertyDisplayName, SeaPropertyName, PropertyType, Description, DSTypeAttribute, Attribute)           
	SELECT '1BC7C40D-1E4F-4809-8A85-E8786A93CB73', 'indexscalingperformedat', 'Index scaling performed at', 'indexscalingperformedat', 'long', 'The time at which the index scaling job was performed', -1, 0            
END																																								
GO
