

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SEDataSourceTypePropertyMap.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |       Table:  SEDataSourceTypePropertyMap

--  |

--  | Description:  Contains mapping between supported  datasource type and its property

--  |

--  |                                                                    

--  |        Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SEDataSourceTypePropertyMap.script,v $ $Id: SEDataSourceTypePropertyMap.script,v 1.2.2.27.50.1 2021/04/05 22:05:16 canand Exp $";

GO

--jdbc

-- JDBC, username

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, password

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', '61077318-E089-4105-AC78-13306674F2DF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, domain

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', '8A97E073-BEEA-4D89-B580-42E31FDAD6AC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, url

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', '89BF3F94-0254-46CC-84FC-2D7C15386742', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, driver

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', '7C5063D4-7A0B-46E9-9364-1D0DD3F5C1DA', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, delta_sql_query

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', 'B277A3A2-C5F0-4242-A4AF-45BFB52E7D2C', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, delta_import_sql_query

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', '43A7EEFF-B0E9-4086-8EF1-AB47D4591B92', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, primary_key

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', '0050FEB0-C418-491A-A6D6-87BAADE2609A', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, sql_select_statement

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', '00B9FA45-A2CC-46B2-BB2C-4A7B300FE246', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, root_entity_fields

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', 'A0FA9C66-6A7D-4B1E-8D2E-01FE34F0F08B', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, always_incremental

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', '4BC14B49-2CF8-47ED-9071-7FD72754A0B4', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, suffixprimarykey

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', 'F9F0E1B8-0080-417C-84AB-3DDE48095A40', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, commcellId

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', 'CB5922E7-23F8-45DF-B18C-1093DCEA64C3', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, tablename

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', 'B9299A84-2662-4BD4-BB2D-496EA3C828BF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, isDBView

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', 'B1DEDC94-C002-4E5F-9788-4BFB0144F795', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- JDBC, ediscoveryproperty

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', 'd215e7ec-014c-4e98-a22d-9c1f384abeda', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- WEB, username

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '9B5F220D-018E-4463-9E1D-39AAD31B0417', '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- WEB, password

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '9B5F220D-018E-4463-9E1D-39AAD31B0417', '61077318-E089-4105-AC78-13306674F2DF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- WEB, domain

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '9B5F220D-018E-4463-9E1D-39AAD31B0417', '8A97E073-BEEA-4D89-B580-42E31FDAD6AC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- WEB, urls

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '9B5F220D-018E-4463-9E1D-39AAD31B0417', '14F8D771-9A0C-4C05-ABDC-DEE82CA04016', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- WEB, crawlDepth

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '9B5F220D-018E-4463-9E1D-39AAD31B0417', '3D7BF7FF-C78A-4E0F-BC6E-46CBDDEA0119', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- WEB, excludePaths

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '9B5F220D-018E-4463-9E1D-39AAD31B0417', '21CD5B4F-A8E3-4A8F-8C64-687EA45F0A8F', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- WEB, includePaths

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '9B5F220D-018E-4463-9E1D-39AAD31B0417', '304BEA7C-1473-49FC-A131-0DFF366FCBBC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, username

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, password

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '61077318-E089-4105-AC78-13306674F2DF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, domain

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '8A97E073-BEEA-4D89-B580-42E31FDAD6AC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, primary_key

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '0050FEB0-C418-491A-A6D6-87BAADE2609A', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, always_incremental

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '4BC14B49-2CF8-47ED-9071-7FD72754A0B4', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, emptydatasource

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '8A78AC06-0569-42CE-950A-01D5C9C06EAF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, filePaths

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', 'CEA52A3D-FB69-4BEB-A5D6-13F4A0ABC8B6', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, separator

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '36846D4A-12F7-4802-A039-67FA72A73C84', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, header

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', 'AAC10CA3-C8CE-4D77-BF9A-0E7ED3037AE3', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, fieldnames

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', 'F75FAE43-8E33-490D-9450-F6DA0EAE4DBB', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, skip

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '33AC207F-CA57-411C-BECD-200273FF2788', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, skipLines

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '547ED8A7-9431-4EBD-B316-042BC92436E5', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, encapsulator

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', 'AA83C1BF-B1E4-4417-85E7-D25ECC36EB10', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, escape

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', 'B94A5831-073B-43D1-AB9F-073541893DC0', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, literal

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', 'DBD80FE5-63C2-43F7-982A-423FA42A1479', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, trim

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '20D330DA-F0BC-4507-B519-5BEFF6D9C944', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, field_datatype

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '53082FD5-1418-436A-9DD1-29503DE9FFD0', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, field_new_name

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', '8DD6811F-ED04-4F17-87FF-1BA69AE77938', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- CSV, folder

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', 'E35A983B-C294-45F3-A270-74C09DC8A468', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- EXE, executable

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', '171DE5C6-B88B-4393-9322-AFD3D145D1AF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- EXE, working_dir

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', '4E559EA9-DEE5-4DDF-9994-644488218F77', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- EXE, args

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', 'D9DA5910-695D-4C83-813B-BA35F56AEDD6', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- EXE, environment

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', '2D9C8F86-FEF1-43A1-B10B-8E9A7BEF0DBB', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- EXE, computers

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', 'BF1738D2-AC5E-446C-A9BD-737CDD0D5106', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- EXE, copyExe

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', 'C4CC0E6D-9BAD-4AED-A121-BD47B748E8F7', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- EXE, language

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', '943205A9-F4CB-47CF-AD13-A659ACA8CA01', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- EXE, prefix_command

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', 'C2C7D390-C8AF-4A78-A6F2-01B540C23A29', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- EXE, username

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- exe, password

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', '61077318-E089-4105-AC78-13306674F2DF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- eloqua, username

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F', '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- eloqua, password

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F', '61077318-E089-4105-AC78-13306674F2DF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- eloqua, primary_key

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F', '0050FEB0-C418-491A-A6D6-87BAADE2609A', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- eloqua, always_incremental

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F', '4BC14B49-2CF8-47ED-9071-7FD72754A0B4', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- eloqua, companyname

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F', 'D57ECAAF-B706-40C8-BCDE-7F8C51FF7EDA', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- eloqua, tablename

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F', 'B9299A84-2662-4BD4-BB2D-496EA3C828BF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- eloqua, columns

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F', 'F84674C6-62CB-4D2F-A2FD-9F7BCDD20D4B', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--blank, ediscoveryproperty

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '6E3BFBA3-C963-4CF3-8F0D-41813CFDF953', 'd215e7ec-014c-4e98-a22d-9c1f384abeda', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS, includedirectoriespath

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', 'E3572BC2-4ECA-4D90-9D94-5EC2822ED2F9', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS, maxindexingthreads

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '8AEBC0B6-1175-4C53-BEBD-1771F580497D', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS, clientid

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '0278A00E-317A-451E-B1EF-97F1BA610C38', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS, retainallversions

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', 'D1F982CC-BF10-4705-A761-944A17226337', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS,  doincrementalscan

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '28020419-D8F9-4FAA-AA2A-81363F504456', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS, pushonlymetadata

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', 'B79286F1-9B73-47CC-A5FA-2B187FF22084', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS, includefilters

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '39484127-E0AD-4DF8-83C2-ECB2A3BC75A4', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS, excludefilters

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '8BCAC22C-DFEF-4EB3-892F-15B54C3115FB', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS, minumumdocumentsize

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '66016BE5-2712-435A-8114-4425D8C006E2', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--FS, maximumdocumentsize

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '9C4543CC-0A6B-434C-BCA8-72851E2BD724', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, username

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, password

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '61077318-E089-4105-AC78-13306674F2DF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, domain

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '8A97E073-BEEA-4D89-B580-42E31FDAD6AC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, literalproperties

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', 'f090c1e7-0f2c-458b-95ff-e8050bb198ee', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, pseudoclientid

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '9D174CA5-95AB-4EF6-A15B-5E190F87317F', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, subclientid

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '45A663C4-BA63-4287-A163-971182F484FC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, appname

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '4526224E-BB52-4870-84D1-21D12FDC41AB', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, candelete

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '9DD750DD-DFDB-4BE2-A240-9141C36AB53F', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, createclient

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '0D317445-9118-4D73-8265-85DC7DA1A16F', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, accessnodeclientid

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', 'A72DD025-BE6C-4D27-93FA-256D7DF5E801', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS, ediscoveryproperty

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', 'd215e7ec-014c-4e98-a22d-9c1f384abeda', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- SF, username

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D6239FB2-0787-458F-8F36-017199C8E9D6', '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- SF, password

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D6239FB2-0787-458F-8F36-017199C8E9D6', '61077318-E089-4105-AC78-13306674F2DF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- SF, primary_key

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D6239FB2-0787-458F-8F36-017199C8E9D6', '0050FEB0-C418-491A-A6D6-87BAADE2609A', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- SF, always_incremental

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D6239FB2-0787-458F-8F36-017199C8E9D6', '4BC14B49-2CF8-47ED-9071-7FD72754A0B4', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- SF, security Token

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D6239FB2-0787-458F-8F36-017199C8E9D6', '7A774ABC-5A1D-4449-8AA3-CAFA10AE021C', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- SF, tablename

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D6239FB2-0787-458F-8F36-017199C8E9D6', 'B9299A84-2662-4BD4-BB2D-496EA3C828BF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- SF, columns

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D6239FB2-0787-458F-8F36-017199C8E9D6', 'F84674C6-62CB-4D2F-A2FD-9F7BCDD20D4B', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- LDAP, username

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '7F85B3A4-96F1-40D3-A3A1-94665108F27C', '1789DE40-FE5C-4DE3-A7B3-A9169C6A6839', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- LDAP, password

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '7F85B3A4-96F1-40D3-A3A1-94665108F27C', '61077318-E089-4105-AC78-13306674F2DF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- LDAP, domain

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '7F85B3A4-96F1-40D3-A3A1-94665108F27C', '8A97E073-BEEA-4D89-B580-42E31FDAD6AC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- LDAP, searchbaselist

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '7F85B3A4-96F1-40D3-A3A1-94665108F27C', '1D85B1F2-6D25-41BF-BED6-CC32D66E977C', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- LDAP, isSecuredLdap

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '7F85B3A4-96F1-40D3-A3A1-94665108F27C', '96C3759F-AF65-4512-B40C-B084DC8D1596', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- LDAP, ediscoveryproperty

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '7F85B3A4-96F1-40D3-A3A1-94665108F27C', 'd215e7ec-014c-4e98-a22d-9c1f384abeda', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, webUrl

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'BA8A3771-98BA-4216-880F-47520449CB25', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, split

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'C762F99A-2E18-4405-AD68-EEEAD1AA38D2', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, reqType

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '419C2D59-F45F-4C24-879A-FF593706DB52', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, acceptType

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '43371650-4E7C-4E14-BCDA-CA5E83D3509A', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, headers

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '03099C03-4DE6-4E3E-A584-E2C356EF2375', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, PAYLOAD

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'C0B42AEA-CCB3-4ECC-9588-FAC3ED985364', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, fields

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '2527521A-577B-46F4-B041-5288DAFA8C81', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, start

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'ED8DDEC7-1B5F-4FD8-9AA6-C00EC56F543D', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, offset

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '0F100386-FB2B-4B95-9D5A-112E819C7C95', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, totalNumPath

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '985AEE33-D0B1-4784-8F06-EAF0CF1FD4C7', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, always_incremental

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '4BC14B49-2CF8-47ED-9071-7FD72754A0B4', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- Facebook, appId

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '83339068-4FFC-4C66-BED4-E69A22E41669', 'E58F9CAE-302D-4240-8632-48D487812004', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- Facebook, appSecret

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '83339068-4FFC-4C66-BED4-E69A22E41669', '6FA55E7A-A818-4531-8699-234FA29D5DF1', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- Facebook, accessToken

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '83339068-4FFC-4C66-BED4-E69A22E41669', 'E9DAFC6E-771C-4556-AA7F-7CB06C5D02AE', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- Facebook, fbId

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '83339068-4FFC-4C66-BED4-E69A22E41669', '4ada971f-fd52-4a31-8e75-1b1140dba837', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- Facebook, fbCrawlSelections

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '83339068-4FFC-4C66-BED4-E69A22E41669', 'f99a2339-1977-4c72-94d6-828246510492', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, isPaginate

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'F0A2E022-2591-48CA-9D56-24F959CADFBC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, startParamName

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '00CCB9AA-152E-4CB5-949B-E406BB09124C', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, startParamValue

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '12AFE84A-666C-4AE5-9AF0-D738736BD5FA', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, incrementalParamName

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'BDC415FC-A2AC-4322-9A16-5811A6E7A4A2', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, incrementalParamValue

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'C54CA100-9042-4C8C-9523-24287CDA6003', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, incrementalType

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'B1DE1EBD-B58D-4AD9-9BD5-BA798867DD46', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, totalLoopType

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '581CD1C1-DD33-42C1-9E4D-5CCE2AB49D64', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, primary_key

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '0050FEB0-C418-491A-A6D6-87BAADE2609A', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, delta_sql_query

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'B277A3A2-C5F0-4242-A4AF-45BFB52E7D2C', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP, totalLoopValue

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', '4693070D-C7CD-4157-86AC-F3D7E3E084CC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- HTTP httpAuthConfig

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'B3A80C5A-1F13-4A5A-A719-F3818FF0AB11', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, isLive

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', '15F25A60-6072-4808-B7B7-AE49447C9B61', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, streamingKeyword

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', '9E175A9C-6753-4301-B3C3-34B476CE7213', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, userScreenName

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', 'B3A80C5A-1F13-4A5A-A719-F3818FF0AB16', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, hashTags

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', '15ADEC5D-FC37-429B-A2B7-4081ED03A786', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, fromDate

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', 'AA607A69-62FE-4B8F-89AB-530526B0E92E', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, toDate

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', 'E2666BB9-4BA8-42F3-A353-05A8A83CCDDF', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, consumerKey

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', '17AEB830-30E3-4CF1-A2B6-08918AA27181', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, consumerSecret

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', '81AA223E-9F24-4426-821F-37E0F7E83DB5', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, accessToken

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', 'FFCAFA68-2444-416B-AADA-0F7845F9653C', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, accessTokenSecret

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', 'B0B200B9-F485-4DAD-B09A-3C50B525B3DE', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- twitter, always_incremental

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', '4BC14B49-2CF8-47ED-9071-7FD72754A0B4', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--exchange,backupsetguid

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'DCD89D31-5971-4C10-8D9E-4D65AF4577EF', 'A7B87E15-49B7-4090-A068-22B6CC6A9B5F', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--exchange,mlinfo

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'DCD89D31-5971-4C10-8D9E-4D65AF4577EF', '5A0B311C-A873-41C8-8B14-E8F98A6A5D51', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

--exchange,appname

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'DCD89D31-5971-4C10-8D9E-4D65AF4577EF', '4526224E-BB52-4870-84D1-21D12FDC41AB', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- Onedrive, pseudoclientid

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D66C6B14-209A-4136-BA42-25A9C261F6B4', '9D174CA5-95AB-4EF6-A15B-5E190F87317F', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- Onedrive, createclient

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D66C6B14-209A-4136-BA42-25A9C261F6B4', '0D317445-9118-4D73-8265-85DC7DA1A16F', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- Onedrive, accessnodeclientid

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'D66C6B14-209A-4136-BA42-25A9C261F6B4', 'A72DD025-BE6C-4D27-93FA-256D7DF5E801', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- sharepoint, pseudoclientid

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'E195A69E-E9F7-4116-B06A-2945C038E30B', '9D174CA5-95AB-4EF6-A15B-5E190F87317F', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- sharepoint, createclient

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'E195A69E-E9F7-4116-B06A-2945C038E30B', '0D317445-9118-4D73-8265-85DC7DA1A16F', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- sharepoint, accessnodeclientid

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'E195A69E-E9F7-4116-B06A-2945C038E30B', 'A72DD025-BE6C-4D27-93FA-256D7DF5E801', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS,	enableEntityExtraction

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', 'D6045EE0-F206-4B03-B96B-CDA6193D35DC', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);

-- FS,	auditServerInfo

MERGE SEDataSourceTypePropertyMap AS target                                                                
    USING (SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', '660F60C8-5A40-41C5-ADF0-AC9C1FFA28DE', 0) AS source (TypeGuid,PropertyGuid, Attribute)          
    ON (target.TypeGuid = source.TypeGuid  AND target.PropertyGuid = source.PropertyGuid)                  
    WHEN MATCHED AND target.Attribute != source.Attribute THEN                                             
        UPDATE SET Attribute = source.Attribute, ModifiedTime = GETUTCDATE()                               
	WHEN NOT MATCHED THEN                                                                                  
		INSERT (TypeGuid, PropertyGuid, Attribute)			                                               
		VALUES (source.TypeGuid, source.PropertyGuid, source.Attribute);
