

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SEDataSourceType.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |       Table:  SEDataSourceType

--  |

--  | Description:  Contains list of datasource type and its information

--  |

--  |                                                                    

--  |        Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SEDataSourceType.script,v $ $Id: SEDataSourceType.script,v 1.2.2.31 2020/11/03 01:27:41 anguyen Exp $";

GO

/*

README:

		-------------------+++++++++++++DONT INSERT IN MIDDLE, ALWAYS ADD AT END+++++++++++++-------------------

		- when updating any value, increment revision. otherwise value will not be updated		

*/

--below are for status column

--below are for Attribute column column

-- format:  (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)

--0.Empty datasource

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '94AF1E34-F108-449D-9DC3-15FBB254D0F8')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '94AF1E34-F108-449D-9DC3-15FBB254D0F8', 'None', 'None', 'No entry', '', 1, 4, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '94AF1E34-F108-449D-9DC3-15FBB254D0F8' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'None', TypeDisplayName = 'None', Description = 'No entry' ,											
		ParentTypeGuid = '', Status = 1 , Attribute = 4, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '94AF1E34-F108-449D-9DC3-15FBB254D0F8'																												
END

--1.jdbc

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '30DE5831-B8D3-4999-B38E-AAC6A586FAF7')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '30DE5831-B8D3-4999-B38E-AAC6A586FAF7', 'jdbc', 'jdbc', 'Any jdbc datasource', '', 0, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '30DE5831-B8D3-4999-B38E-AAC6A586FAF7' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'jdbc', TypeDisplayName = 'jdbc', Description = 'Any jdbc datasource' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '30DE5831-B8D3-4999-B38E-AAC6A586FAF7'																												
END

--2.web

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '9B5F220D-018E-4463-9E1D-39AAD31B0417')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '9B5F220D-018E-4463-9E1D-39AAD31B0417', 'web', 'web', 'Website datasource', '', 0, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '9B5F220D-018E-4463-9E1D-39AAD31B0417' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'web', TypeDisplayName = 'web', Description = 'Website datasource' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '9B5F220D-018E-4463-9E1D-39AAD31B0417'																												
END

--3.exe

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '1AC7EAE5-948A-4191-AC52-1B5B8734C472')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '1AC7EAE5-948A-4191-AC52-1B5B8734C472', 'exe', 'exe', 'Executable datasource', '', 0, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '1AC7EAE5-948A-4191-AC52-1B5B8734C472' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'exe', TypeDisplayName = 'exe', Description = 'Executable datasource' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '1AC7EAE5-948A-4191-AC52-1B5B8734C472'																												
END

--4.CSV

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '528DCBA1-D4AF-498A-A37C-070FEBCF1472')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '528DCBA1-D4AF-498A-A37C-070FEBCF1472', 'csv', 'csv', 'CSV datasource', '', 0, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '528DCBA1-D4AF-498A-A37C-070FEBCF1472' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'csv', TypeDisplayName = 'csv', Description = 'CSV datasource' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '528DCBA1-D4AF-498A-A37C-070FEBCF1472'																												
END

--5.file

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', 'file', 'file', 'File crawling', '', 0, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'file', TypeDisplayName = 'file', Description = 'File crawling' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769'																												
END

--6.nas

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '2FD58D24-ACE8-4EF8-A3B6-C80BE2128456')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '2FD58D24-ACE8-4EF8-A3B6-C80BE2128456', 'nas', 'nas', 'NAS', '', 2|16|32 | 64, 0, 4					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '2FD58D24-ACE8-4EF8-A3B6-C80BE2128456' AND Revision < 4)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'nas', TypeDisplayName = 'nas', Description = 'NAS' ,											
		ParentTypeGuid = '', Status = 2|16|32 | 64 , Attribute = 0, Revision = 4, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '2FD58D24-ACE8-4EF8-A3B6-C80BE2128456'																												
END

--7.eloqua

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F', 'eloqua', 'eloqua', 'eloqua crawling', '', 0, 0, 3					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F' AND Revision < 3)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'eloqua', TypeDisplayName = 'eloqua', Description = 'eloqua crawling' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 3, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '1AFC9CCE-F3D2-42A0-85AE-EFB89894C59F'																												
END

--8.salesforce

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'D6239FB2-0787-458F-8F36-017199C8E9D6')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'D6239FB2-0787-458F-8F36-017199C8E9D6', 'salesforce', 'salesforce', 'salesforce crawling', '', 0, 0, 3					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'D6239FB2-0787-458F-8F36-017199C8E9D6' AND Revision < 3)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'salesforce', TypeDisplayName = 'salesforce', Description = 'salesforce crawling' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 3, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'D6239FB2-0787-458F-8F36-017199C8E9D6'																												
END

--9.ldap

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '7F85B3A4-96F1-40D3-A3A1-94665108F27C')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '7F85B3A4-96F1-40D3-A3A1-94665108F27C', 'ldap', 'ldap', 'ldap active directory', '', 0, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '7F85B3A4-96F1-40D3-A3A1-94665108F27C' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'ldap', TypeDisplayName = 'ldap', Description = 'ldap active directory' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '7F85B3A4-96F1-40D3-A3A1-94665108F27C'																												
END

--10.federated

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'DB8BA53E-5342-4147-9AE0-059F894588A5')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'DB8BA53E-5342-4147-9AE0-059F894588A5', 'federated', 'federated', 'Federated search', '', 2|4, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'DB8BA53E-5342-4147-9AE0-059F894588A5' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'federated', TypeDisplayName = 'federated', Description = 'Federated search' ,											
		ParentTypeGuid = '', Status = 2|4 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'DB8BA53E-5342-4147-9AE0-059F894588A5'																												
END

--11.Blank

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '6E3BFBA3-C963-4CF3-8F0D-41813CFDF953')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '6E3BFBA3-C963-4CF3-8F0D-41813CFDF953', 'blank', 'blank', 'blank datasource', '', 0, 0, 4					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '6E3BFBA3-C963-4CF3-8F0D-41813CFDF953' AND Revision < 4)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'blank', TypeDisplayName = 'blank', Description = 'blank datasource' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 4, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '6E3BFBA3-C963-4CF3-8F0D-41813CFDF953'																												
END

--12.Http

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8', 'http', 'http', 'http datasource', '', 0, 0, 5					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8' AND Revision < 5)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'http', TypeDisplayName = 'http', Description = 'http datasource' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 5, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'B56D3D0F-1E32-4AB6-A0F3-2A4288C797A8'																												
END

--13.camel

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'BFB4202D-5905-4E4C-90A9-5A541798AFCD')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'BFB4202D-5905-4E4C-90A9-5A541798AFCD', 'camel', 'camel', 'Camel datasource', '', 0, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'BFB4202D-5905-4E4C-90A9-5A541798AFCD' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'camel', TypeDisplayName = 'camel', Description = 'Camel datasource' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'BFB4202D-5905-4E4C-90A9-5A541798AFCD'																												
END

--14.facebook

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '83339068-4FFC-4C66-BED4-E69A22E41669')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '83339068-4FFC-4C66-BED4-E69A22E41669', 'facebook', 'facebook', 'Facebook datasource', 'BFB4202D-5905-4E4C-90A9-5A541798AFCD', 0, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '83339068-4FFC-4C66-BED4-E69A22E41669' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'facebook', TypeDisplayName = 'facebook', Description = 'Facebook datasource' ,											
		ParentTypeGuid = 'BFB4202D-5905-4E4C-90A9-5A541798AFCD', Status = 0 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '83339068-4FFC-4C66-BED4-E69A22E41669'																												
END

--15.edge

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'E9300554-A441-4017-A718-EE0C608008EB')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'E9300554-A441-4017-A718-EE0C608008EB', 'edge', 'edge', 'EDGE', '', 2|16|32|64, 0, 4					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'E9300554-A441-4017-A718-EE0C608008EB' AND Revision < 4)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'edge', TypeDisplayName = 'edge', Description = 'EDGE' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 4, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'E9300554-A441-4017-A718-EE0C608008EB'																												
END

--16.fla

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '44208AD3-529C-43BA-8DA6-C6C5307B5040')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '44208AD3-529C-43BA-8DA6-C6C5307B5040', 'fla', 'fla', 'FLA', '', 2|16|32|64, 0, 4					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '44208AD3-529C-43BA-8DA6-C6C5307B5040' AND Revision < 4)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'fla', TypeDisplayName = 'fla', Description = 'FLA' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 4, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '44208AD3-529C-43BA-8DA6-C6C5307B5040'																												
END

--17.ReviewSet

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '93AD5CBD-5B1B-4784-8D83-409BA24E16D0')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '93AD5CBD-5B1B-4784-8D83-409BA24E16D0', 'reviewset', 'Review Set', 'Review Set', '', 2|16|32|64, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '93AD5CBD-5B1B-4784-8D83-409BA24E16D0' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'reviewset', TypeDisplayName = 'Review Set', Description = 'Review Set' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '93AD5CBD-5B1B-4784-8D83-409BA24E16D0'																												
END

--18.twitter

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '59EC4756-808F-4348-992D-228B7E0F78C6')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '59EC4756-808F-4348-992D-228B7E0F78C6', 'twitter', 'twitter', 'twitter', 'BFB4202D-5905-4E4C-90A9-5A541798AFCD', 0, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '59EC4756-808F-4348-992D-228B7E0F78C6' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'twitter', TypeDisplayName = 'twitter', Description = 'twitter' ,											
		ParentTypeGuid = 'BFB4202D-5905-4E4C-90A9-5A541798AFCD', Status = 0 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '59EC4756-808F-4348-992D-228B7E0F78C6'																												
END

--19.ComplianceAudit

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '48A46B7C-7414-4FDE-B7D1-C4E025CF216C')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '48A46B7C-7414-4FDE-B7D1-C4E025CF216C', 'complianceaudit', 'Compliance Audit', 'Compliance Audit', '', 2|16|32|64|256, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '48A46B7C-7414-4FDE-B7D1-C4E025CF216C' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'complianceaudit', TypeDisplayName = 'Compliance Audit', Description = 'Compliance Audit' ,											
		ParentTypeGuid = '', Status = 2|16|32|64|256 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '48A46B7C-7414-4FDE-B7D1-C4E025CF216C'																												
END

--20.exchange

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'DCD89D31-5971-4C10-8D9E-4D65AF4577EF')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'DCD89D31-5971-4C10-8D9E-4D65AF4577EF', 'exchange', 'exchange', 'Exchange', '', 2|16|32|64, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'DCD89D31-5971-4C10-8D9E-4D65AF4577EF' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'exchange', TypeDisplayName = 'exchange', Description = 'Exchange' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'DCD89D31-5971-4C10-8D9E-4D65AF4577EF'																												
END

--21.nfs

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '1AD1DB3A-5017-4568-A151-72203972DD6E')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '1AD1DB3A-5017-4568-A151-72203972DD6E', 'nfs', 'nfs', 'nfs', '', 2|16|32|64, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '1AD1DB3A-5017-4568-A151-72203972DD6E' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'nfs', TypeDisplayName = 'nfs', Description = 'nfs' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '1AD1DB3A-5017-4568-A151-72203972DD6E'																												
END

--22.cloudoracle

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '264B4ACD-5F7F-48B1-ABFD-DA7F99C7CCE7')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '264B4ACD-5F7F-48B1-ABFD-DA7F99C7CCE7', 'cloudoracle', 'cloudoracle', 'cloudoracle', '', 2|16|32|64, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '264B4ACD-5F7F-48B1-ABFD-DA7F99C7CCE7' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'cloudoracle', TypeDisplayName = 'cloudoracle', Description = 'cloudoracle' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '264B4ACD-5F7F-48B1-ABFD-DA7F99C7CCE7'																												
END

--23.systemdefault

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '3F051C59-36A5-4876-984E-ADD97B4768D9')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '3F051C59-36A5-4876-984E-ADD97B4768D9', 'systemdefault', 'systemdefault', 'systemdefault', '', 2|16|32|64, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '3F051C59-36A5-4876-984E-ADD97B4768D9' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'systemdefault', TypeDisplayName = 'systemdefault', Description = 'systemdefault' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '3F051C59-36A5-4876-984E-ADD97B4768D9'																												
END

--24.DownloadCenterAudit

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'FAC8DF4C-C102-477B-BE75-43A171DFCFDB')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'FAC8DF4C-C102-477B-BE75-43A171DFCFDB', 'downloadcenteraudit', 'DownloadCenter Audit', 'DownloadCenter Audit', '', 2|16|32|64|256, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'FAC8DF4C-C102-477B-BE75-43A171DFCFDB' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'downloadcenteraudit', TypeDisplayName = 'DownloadCenter Audit', Description = 'DownloadCenter Audit' ,											
		ParentTypeGuid = '', Status = 2|16|32|64|256 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'FAC8DF4C-C102-477B-BE75-43A171DFCFDB'																												
END

--25.vm [virtual machine]

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'BD7B9A6B-A824-47D5-AD9D-41CA34659D92')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'BD7B9A6B-A824-47D5-AD9D-41CA34659D92', 'vm', 'Virtual Machine', 'Virtual Machine', '', 2|16|32|64, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'BD7B9A6B-A824-47D5-AD9D-41CA34659D92' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'vm', TypeDisplayName = 'Virtual Machine', Description = 'Virtual Machine' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'BD7B9A6B-A824-47D5-AD9D-41CA34659D92'																												
END

--26.Onedrive

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'D66C6B14-209A-4136-BA42-25A9C261F6B4')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'D66C6B14-209A-4136-BA42-25A9C261F6B4', 'onedrive', 'onedrive', 'One drive', '', 0, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'D66C6B14-209A-4136-BA42-25A9C261F6B4' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'onedrive', TypeDisplayName = 'onedrive', Description = 'One drive' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'D66C6B14-209A-4136-BA42-25A9C261F6B4'																												
END

--27.Sharepoint

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'E195A69E-E9F7-4116-B06A-2945C038E30B')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'E195A69E-E9F7-4116-B06A-2945C038E30B', 'sharepoint', 'sharepoint', 'Share point', '', 0, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'E195A69E-E9F7-4116-B06A-2945C038E30B' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'sharepoint', TypeDisplayName = 'sharepoint', Description = 'Share point' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'E195A69E-E9F7-4116-B06A-2945C038E30B'																												
END

--28.Email

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '8ADAFEAF-0684-47B4-82D9-7EE9CFA00889')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '8ADAFEAF-0684-47B4-82D9-7EE9CFA00889', 'email', 'email', 'Email', '', 0, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '8ADAFEAF-0684-47B4-82D9-7EE9CFA00889' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'email', TypeDisplayName = 'email', Description = 'Email' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '8ADAFEAF-0684-47B4-82D9-7EE9CFA00889'																												
END

--29.DB Analysis

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'F52AA95C-E00D-4A19-A900-82D319C680E2')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'F52AA95C-E00D-4A19-A900-82D319C680E2', 'dbanalysis', 'dbanalysis', 'DB Analysis', '', 0, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'F52AA95C-E00D-4A19-A900-82D319C680E2' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'dbanalysis', TypeDisplayName = 'dbanalysis', Description = 'DB Analysis' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'F52AA95C-E00D-4A19-A900-82D319C680E2'																												
END

--30.Cloud PaaS

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'A3B9C496-AF2F-48C6-B254-CD202F89F4EF')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'A3B9C496-AF2F-48C6-B254-CD202F89F4EF', 'cloudpaas', 'cloudpaas', 'Cloud PaaS Index', '', 0, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'A3B9C496-AF2F-48C6-B254-CD202F89F4EF' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'cloudpaas', TypeDisplayName = 'cloudpaas', Description = 'Cloud PaaS Index' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'A3B9C496-AF2F-48C6-B254-CD202F89F4EF'																												
END

--31.Google drive

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '938649F5-71EC-4DB9-B169-C3EC30947FB3')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '938649F5-71EC-4DB9-B169-C3EC30947FB3', 'googledrive', 'googledrive', 'Google drive Index', 'D66C6B14-209A-4136-BA42-25A9C261F6B4', 8, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '938649F5-71EC-4DB9-B169-C3EC30947FB3' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'googledrive', TypeDisplayName = 'googledrive', Description = 'Google drive Index' ,											
		ParentTypeGuid = 'D66C6B14-209A-4136-BA42-25A9C261F6B4', Status = 8 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '938649F5-71EC-4DB9-B169-C3EC30947FB3'																												
END

--32.Gmail App

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '1C8227B8-BB5D-4126-9A92-3FBAD2749D3A')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '1C8227B8-BB5D-4126-9A92-3FBAD2749D3A', 'gmail', 'gmail', 'Gmail app Index', '8ADAFEAF-0684-47B4-82D9-7EE9CFA00889', 8, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '1C8227B8-BB5D-4126-9A92-3FBAD2749D3A' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'gmail', TypeDisplayName = 'gmail', Description = 'Gmail app Index' ,											
		ParentTypeGuid = '8ADAFEAF-0684-47B4-82D9-7EE9CFA00889', Status = 8 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '1C8227B8-BB5D-4126-9A92-3FBAD2749D3A'																												
END

--33.Active Directory

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '8375903A-FBBB-4763-A8D0-5581CC743D33')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '8375903A-FBBB-4763-A8D0-5581CC743D33', 'activedirectory', 'activedirectory', 'Active Directory Index', '', 2|16|32|64, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '8375903A-FBBB-4763-A8D0-5581CC743D33' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'activedirectory', TypeDisplayName = 'activedirectory', Description = 'Active Directory Index' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '8375903A-FBBB-4763-A8D0-5581CC743D33'																												
END

--34.Onedrive Index

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'FD60EB2B-9B53-4BC4-BC4B-14E5B6D705F6')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'FD60EB2B-9B53-4BC4-BC4B-14E5B6D705F6', 'onedriveindex', 'onedriveindex', 'OneDrive Index', '', 0, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'FD60EB2B-9B53-4BC4-BC4B-14E5B6D705F6' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'onedriveindex', TypeDisplayName = 'onedriveindex', Description = 'OneDrive Index' ,											
		ParentTypeGuid = '', Status = 0 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'FD60EB2B-9B53-4BC4-BC4B-14E5B6D705F6'																												
END

--35.Multinode Federated

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '04854E90-76E5-47D2-8C7F-28026DAABCC6')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '04854E90-76E5-47D2-8C7F-28026DAABCC6', 'multinodefederated', 'multinodefederated', 'Multinode Federated', '', 2|16|32|4, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '04854E90-76E5-47D2-8C7F-28026DAABCC6' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'multinodefederated', TypeDisplayName = 'multinodefederated', Description = 'Multinode Federated' ,											
		ParentTypeGuid = '', Status = 2|16|32|4 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '04854E90-76E5-47D2-8C7F-28026DAABCC6'																												
END

--36.FS Index

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '0BC3CD9F-5B02-4A47-97FE-125A83BA13FC')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '0BC3CD9F-5B02-4A47-97FE-125A83BA13FC', 'fsindex', 'fsindex', 'File system backup index', '', 2, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '0BC3CD9F-5B02-4A47-97FE-125A83BA13FC' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'fsindex', TypeDisplayName = 'fsindex', Description = 'File system backup index' ,											
		ParentTypeGuid = '', Status = 2 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '0BC3CD9F-5B02-4A47-97FE-125A83BA13FC'																												
END

--37.Dynamic365 Index

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'AB09EE67-C2B1-409f-84A5-C399D80C0354')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT 'AB09EE67-C2B1-409f-84A5-C399D80C0354', 'dynamic365', 'dynamic365', 'Dynamic365 Index', '', 2|16|32|64, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = 'AB09EE67-C2B1-409f-84A5-C399D80C0354' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'dynamic365', TypeDisplayName = 'dynamic365', Description = 'Dynamic365 Index' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = 'AB09EE67-C2B1-409f-84A5-C399D80C0354'																												
END

--38.Idxlogs Index

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '287B4A6D-5EF1-45EE-8CF6-6A69C5C4DFF1')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '287B4A6D-5EF1-45EE-8CF6-6A69C5C4DFF1', 'idxlogs', 'idxlogs', 'Index Action Logs', '', 2|16|32|64, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '287B4A6D-5EF1-45EE-8CF6-6A69C5C4DFF1' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'idxlogs', TypeDisplayName = 'idxlogs', Description = 'Index Action Logs' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '287B4A6D-5EF1-45EE-8CF6-6A69C5C4DFF1'																												
END

--39.Teams Index

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '7F55B52D-928B-4CBC-869C-436DD837E72E')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '7F55B52D-928B-4CBC-869C-436DD837E72E', 'teams', 'teamsindex', 'Teams Index', '', 2|16|32|64, 0, 1					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '7F55B52D-928B-4CBC-869C-436DD837E72E' AND Revision < 1)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'teams', TypeDisplayName = 'teamsindex', Description = 'Teams Index' ,											
		ParentTypeGuid = '', Status = 2|16|32|64 , Attribute = 0, Revision = 1, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '7F55B52D-928B-4CBC-869C-436DD837E72E'																												
END

--40.Cloud Storage

IF NOT EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '89EFDDE0-B74F-4849-A6E1-57FA7233E0E9')															
BEGIN																																		
	INSERT INTO SEDataSourceType (TypeGuid, TypeName, TypeDisplayName, Description, ParentTypeGuid, Status, Attribute, Revision)			
	SELECT '89EFDDE0-B74F-4849-A6E1-57FA7233E0E9', 'cloudstorage', 'cloudstorage', 'Cloud Storage', 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', 8, 0, 2					
END																																			
ELSE IF EXISTS (SELECT TOP 1 TypeGuid FROM SEDataSourceType where TypeGuid = '89EFDDE0-B74F-4849-A6E1-57FA7233E0E9' AND Revision < 2)									
BEGIN																																		
	UPDATE SEDataSourceType SET 																											
		TypeName = 'cloudstorage', TypeDisplayName = 'cloudstorage', Description = 'Cloud Storage' ,											
		ParentTypeGuid = 'A32C5C37-FEDE-4849-BF3E-6FCEFD46D769', Status = 8 , Attribute = 0, Revision = 2, ModifiedTime = GETUTCDATE()	
	WHERE TypeGuid = '89EFDDE0-B74F-4849-A6E1-57FA7233E0E9'																												
END

