

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SEDataSourceProperty.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |       Table:  SEDataSourceProperty

--  |

--  | Description:  Contains list of datasource type and its information

--  |

--  |                                                                    

--  |        Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SEDataSourceProperty.script,v $ $Id: SEDataSourceProperty.script,v 1.1.2.1 2020/03/25 09:15:08 canand Exp $";

DECLARE @MissingRolePropertyScript VARCHAR(512) = 'F289C3EC-FEF3-4B1F-A5B3-DA542B9D5AF8'

IF NOT EXISTS (SELECT TOP 1 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @MissingRolePropertyScript)

BEGIN

	DECLARE @RolePropertyId INT = 0

	DECLARE @curDate datetime 

	DECLARE @ccsNowTime INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

	SELECT @curDate = getutcdate(), @RolePropertyId = PropertyId FROM SEProperty WHERE PropertyName = 'roletypename'
	INSERT INTO SEDataSourceProperty ( DataSourceId,PropertyId,PropertyValue,ModifiedTime )


	SELECT b.DataSourceId, @RolePropertyId PropertyId, 'Data Analytics' PropertyValue, @curDate ModifiedTime 

	FROM SECollectionInfo A, SEDataSource B

	WHERE A.CoreId = B.CoreId and A.ActualCoreName COLLATE Latin1_General_CS_AS like 'DC_%'

	AND NOT EXISTS (SELECT 1 FROM SEDataSourceProperty S WHERE S.DataSourceId = B.DataSourceId AND S.PropertyId = @RolePropertyId)

	GROUP BY b.DataSourceId
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@MissingRolePropertyScript, 'MissingRoleDataSourcePropertyScript', 'Script to populate roletypename property for those data sources for which it is missing', @ccsNowTime, 16, 0, (16 + 2))

END
