

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/SEDataSource.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |       Table:  ActionDefinition

--  |

--  | Description:  Contains information about datasource property

--  |

--  |                                                                    

--  |        Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/SEDataSource.script,v $ $Id: SEDataSource.script,v 1.1.2.9.8.1 2021/02/20 01:09:06 pankajkumar Exp $";

-- filter datasources from GDPR app, since names to be displayed in GDPR app are stored in Description instead of DataSourceName

UPDATE SEDataSource SET DisplayName = Description	
WHERE 	(DisplayName IS NULL OR DisplayName = '')	
		AND DataSourceId 	IN 	(	SELECT DISTINCT DataSourceId	
									FROM SEDataSourceProperty AS DSP	
										INNER JOIN SEProperty AS P 
									ON P.PropertyId = DSP.PropertyId 	
										AND P.PropertyGuid = N'4526224E-BB52-4870-84D1-21D12FDC41AB'	
									WHERE DSP.PropertyValue = 'GDPR'	
								)	
		AND (Description IS NOT NULL AND Description <> '')	
		


-- all other datasources, copy DataSourceName -> DisplayName

UPDATE SEDataSource SET DisplayName = DataSourceName	
WHERE DisplayName IS NULL OR DisplayName = ''	



--Enable CvSolr for existing standalone index server based on GxGlobalParam

--By default enable for mailbox 

--UpgradeToCvCloud values

	--1 = mailbox

	--2 = journal

	--3 = All

DECLARE @UpgradeToCvCloud INT = 1  -- mailbox

SET @UpgradeToCvCloud = ISNULL((SELECT TOP 1 CAST (value AS INT) FROM GxGlobalParam (NOLOCK) WHERE name = 'UpgradeToCvCloud' AND modified =0),1)

IF @UpgradeToCvCloud IN (1, 2, 3)

BEGIN

	DECLARE @upgradeExchangeCollectionInfoVersion varchar(36) = 'A5C0DC66-D2DA-4935-ABC4-D3E58566822B'

	DECLARE @upgradeExchangeCollectionInfo INT = 0

	SELECT @upgradeExchangeCollectionInfo = 1

	FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

	WHERE GS.SqlScriptGUID = @upgradeExchangeCollectionInfoVersion

	IF (@upgradeExchangeCollectionInfo =0)           -- not done, do the db upgrade

	BEGIN   

		DECLARE @o_ErrorCode INT

		DECLARE  @o_ErrorMessage NVARCHAR(2048) 

		EXEC AppIndexCloudToCvCloud 0, '', @o_ErrorCode OUTPUT, @o_ErrorMessage OUTPUT

		IF @o_ErrorCode = 0
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@upgradeExchangeCollectionInfoVersion, 'upgradeExchangeCollectionInfo', 'Upgrade exchange role collection for existing standalone index server', datediff(second, '01/01/1970', GETDATE()), 16, 0 , 16 + 1)

	END

END	

DECLARE @upgradeDataSourceAttributeGUID varchar(36) = 'F36DF1C4-F803-4105-8E51-7D2AD5C7E12F'

DECLARE @upgradeDataSourceAttribute INT = 0

SELECT @upgradeDataSourceAttribute = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @upgradeDataSourceAttributeGUID

IF (@upgradeDataSourceAttribute = 0) -- not done, do the db upgrade

BEGIN

	--

	-- Update the Attribute column for the SEDataSource table to distinguish the various kind of datasources

	-- Attribute = 8, signifies stand alone datasource

	-- Attribute = 16, signifies cvcloud shard datasource

	-- Attribute = 32, signifies cvcloud collection datasource

	-- Attribute = 64, signifies cvcloud datasource

	-- Attribute = 128, signifies solr cloud datasource

	--

	DECLARE @multinodePropertyId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC')

	UPDATE SED

	SET SED.Attribute = SED.Attribute |

(CASE WHEN DMC.CloudType = 5 THEN 128

WHEN DMC.CloudType = 1 AND SED.DataSourceId = SEDRS.DataSourceId THEN 16

WHEN DMC.CloudType = 1 AND SED.DataSourceId = SEFD.FederatedDataSourceId THEN 32

WHEN DMC.CloudType = 1 AND ISNULL(SEDP.PropertyValue, 0) <> 0 THEN 64

WHEN DMC.CloudType = 1 THEN 8

		  ELSE 0 END)

	FROM SEDataSource AS SED

	INNER JOIN SECollectionInfo SEC WITH(NOLOCK) ON SED.CoreId = SEC.CoreId

	INNER JOIN DM2Cloud DMC WITH(NOLOCK) ON SEC.CloudID = DMC.cloudId

	LEFT JOIN SEDataSourceProperty SEDP WITH(NOLOCK) ON SED.DataSourceId = SEDP.DataSourceId AND SEDP.PropertyId = @multinodePropertyId

	LEFT JOIN SEDataSourceRoute SEDRS WITH(NOLOCK) ON (SEDRS.DataSourceId = SED.DataSourceId)

	LEFT JOIN (SELECT DISTINCT FederatedDataSourceId FROM SEDataSourceRoute SEDRC WITH(NOLOCK)) AS SEFD ON (SEFD.FederatedDataSourceId = SED.DataSourceId)
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@upgradeDataSourceAttributeGUID, 'upgradeDataSourceAttribute', 'Update Attribute column of the SEDatasource table entries to distinguish the type of index server they belong to', datediff(second, '01/01/1970', GETDATE()), 16, 0 , 16 + 1)

END

