

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/RptTileVersionAndServicePack.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/RptTileVersionAndServicePack.script,v $ $Id: RptTileVersionAndServicePack.script,v 1.1.2.13 2020/10/04 00:54:25 abilbrey Exp $";

GO
-- TABLENAME RptTiles

print '... inserting Table: RptTiles'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME RptTiles

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @id INT

DECLARE @name NVARCHAR(512)

DECLARE @messageId INT

DECLARE @description nvarchar(MAX)

DECLARE @tileCategoryId INT

DECLARE @status INT

DECLARE @flags INT

DECLARE @revision nvarchar(255)

DECLARE @guid nvarchar(256)

DECLARE @CollectionQuery NVARCHAR(MAX)

SET @id = 1

SET @name = 'Version and Service Pack'

SET @messageId = (3656 | (CAST(POWER(2, 24) AS BIGINT) * 61))

SET @description = ''

SET @tileCategoryId = 1

SET @status = 0

--Bit 0 of flags for height of tile

SET @flags = 1 

SET @revision = '$Revision: 1.1.2.13 $'

SET @guid = 'B78EA6BC-0675-47B6-82BF-976BEC1BD1D7'

SET @CollectionQuery = 

'SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON 

DECLARE @tileId INT = 1

DECLARE @tileName NVARCHAR(512) = ''Version and Service Pack''

DECLARE @tileMsgid BIGINT = (3656 | (CAST(POWER(2, 24) AS BIGINT) * 61))

DECLARE @categoryId INT = 1

DECLARE @categoryName NVARCHAR(512) = ''Configuration''

DECLARE @categoryMsgId BIGINT = (3672 | (CAST(POWER(2, 24) AS BIGINT) * 61))

DECLARE @severity INT										--enum TileSeverity       

DECLARE @severityThresholds TABLE(msgId BIGINT, threshold NVARCHAR(MAX))

DECLARE @outcome TABLE(keyMsgId BIGINT, keyMsgParams XML, outcomeKey NVARCHAR(MAX), outcomeValue NVARCHAR(MAX), outcomeType INT, fixWFMsgId BIGINT, fixWFName NVARCHAR(MAX), fixWFGUID NVARCHAR(512))

DECLARE @recommendation TABLE(msgId BIGINT, recommendation NVARCHAR(MAX))

DECLARE @alarmCriteria TABLE(criteriaId INT, msgId BIGINT, alarm NVARCHAR(MAX), alarmValue NVARCHAR(MAX), defaultComparator NVARCHAR(10) DEFAULT '''')

DECLARE @detailedReportName NVARCHAR(1024) = "Version and Service Pack"

DECLARE @criticalThreshold INT = 6

DECLARE @warningThreshold INT = 4

DECLARE @CSVersion VARCHAR(10)

DECLARE @majorVer INT = 0

IF OBJECT_ID(''tempdb..#TempResSimGetPatchHealthStatus'') IS NOT NULL

       DROP TABLE #TempResSimGetPatchHealthStatus

CREATE TABLE #TempResSimGetPatchHealthStatus (ClientType VARCHAR(128)

				, ClientName VARCHAR(2048)

				, ReleaseStr VARCHAR(16)

				, SPMajor INT

				, SPMinor INT

				, CSReleaseStr VARCHAR(16)

				, CSSPMajor INT

				, CSSPMinor INT

				, LatestReleaseStr VARCHAR(16)

				, LatestSPMajor INT

				, LatestSPMinor INT

				, LatestSPMajorOnInstalledVersion INT

				, LatestSPMinorOnInstalledVersion INT

				, InstalledAddUpdates VARCHAR(max)

				, missingInstalledPatches VARCHAR(max)

				, missingDownloadedPatches VARCHAR(max)) 

IF OBJECT_ID(''tempdb..#TempResSimGetPatchHealthStatusWithStatus'') IS NOT NULL

       DROP TABLE #TempResSimGetPatchHealthStatusWithStatus

CREATE TABLE #TempResSimGetPatchHealthStatusWithStatus (ClientType VARCHAR(128)

				, ClientName VARCHAR(2048)

				, ReleaseStr VARCHAR(16)

				, SPMajor INT

				, SPMinor INT

				, CSReleaseStr VARCHAR(16)

				, CSSPMajor INT

				, CSSPMinor INT

				, LatestReleaseStr VARCHAR(16)

				, LatestSPMajor INT

				, LatestSPMinor INT

				, LatestSPMajorOnInstalledVersion INT

				, LatestSPMinorOnInstalledVersion INT

				, InstalledAddUpdates VARCHAR(max)

				, missingUpdatesPatches VARCHAR(max)

, StatusInt INT default 2 -- Status: 1 -- TileSeverity_Info, 2 -- TileSeverity_Good , 3 -- TileSeverity_Warning, 4 -- TileSeverity_Critical

				, ReasonInt INT default -1)  --Reason: 0 -- Behind Rel/SP, 1 -- Updates not installed form Cache, 2 -- Cache not uptodate, 3 -- Release not supported

EXEC simGetPatchHealthStatus 15
INSERT INTO #TempResSimGetPatchHealthStatusWithStatus (ClientType, ClientName, ReleaseStr, SPMajor, SPMinor, CSReleaseStr, CSSPMajor, CSSPMinor, LatestReleaseStr, LatestSPMajor, LatestSPMinor, LatestSPMajorOnInstalledVersion, LatestSPMinorOnInstalledVersion, InstalledAddUpdates, missingUpdatesPatches)


SELECT ClientType, ClientName, ReleaseStr, SPMajor, SPMinor, CSReleaseStr, CSSPMajor, CSSPMinor, LatestReleaseStr, LatestSPMajor, LatestSPMinor, LatestSPMajorOnInstalledVersion, LatestSPMinorOnInstalledVersion, InstalledAddUpdates

	, CASE 

	WHEN (missingInstalledPatches IS NULL OR LEN(missingInstalledPatches) = 0) AND  (missingDownloadedPatches IS NULL OR LEN(missingDownloadedPatches) = 0) THEN ''''

	WHEN (missingInstalledPatches IS NOT NULL AND LEN(missingInstalledPatches) <> 0) AND  (missingDownloadedPatches IS NULL OR LEN(missingDownloadedPatches) = 0) THEN missingInstalledPatches

	WHEN (missingInstalledPatches IS NULL OR LEN(missingInstalledPatches) = 0) AND  (missingDownloadedPatches IS NOT NULL AND LEN(missingDownloadedPatches) <> 0) THEN missingDownloadedPatches

	WHEN (missingInstalledPatches IS  NOT NULL AND LEN(missingInstalledPatches) <> 0) AND  (missingDownloadedPatches IS NOT NULL AND LEN(missingDownloadedPatches) <> 0) THEN missingInstalledPatches + '','' + missingDownloadedPatches

	ELSE ''''

END 

FROM #TempResSimGetPatchHealthStatus

IF OBJECT_ID(''tempdb..#TempResSimGetPatchHealthStatus'') IS NOT NULL

       DROP TABLE #TempResSimGetPatchHealthStatus

--Laptops Behind on service pack/Missing hotfixes TileSeverity_Info 

update #TempResSimGetPatchHealthStatusWithStatus  SET StatusInt = 1, ReasonInt = (CASE WHEN LEN(missingUpdatesPatches) > 0 THEN 1 ELSE 0 END)

	WHERE  ClientType = ''Laptops'' and ((ReleaseStr = CSReleaseStr AND CSSPMajor > SPMajor) OR (ReleaseStr < CSReleaseStr AND LatestSPMajorOnInstalledVersion > SPMajor) OR LEN(missingUpdatesPatches) > 0)

--CS Warning if SP older than warningThreshold and less than criticalThreshold   TileSeverity_Warning 

update #TempResSimGetPatchHealthStatusWithStatus  SET StatusInt = (CASE WHEN (LatestSPMajor - SPMajor) < @warningThreshold THEN 2 ELSE 3 END), ReasonInt = 0

	WHERE  ClientType = ''CommServ'' and (ReleaseStr = LatestReleaseStr AND (LatestSPMajor - SPMajor) < @criticalThreshold)

--Server Behind on service pack/Missing hotfixes TileSeverity_Warning 

update #TempResSimGetPatchHealthStatusWithStatus  SET StatusInt = 3, ReasonInt = (CASE WHEN LEN(missingUpdatesPatches) > 0 THEN 1 ELSE 0 END)

	WHERE  ClientType = ''Servers'' and ((ReleaseStr = CSReleaseStr AND CSSPMajor > SPMajor) OR (ReleaseStr < CSReleaseStr AND LatestSPMajorOnInstalledVersion > SPMajor) OR LEN(missingUpdatesPatches) > 0)

--CS critical if older release or is behind by 6 or more SP TileSeverity_Critical

update #TempResSimGetPatchHealthStatusWithStatus  SET StatusInt = 4, ReasonInt = 0

	WHERE  ClientType = ''CommServ'' and (ReleaseStr <> LatestReleaseStr OR (LatestSPMajor - SPMajor) >= @criticalThreshold)

--MA Behind on service pack/Missing hotfixes TileSeverity_Critical

update #TempResSimGetPatchHealthStatusWithStatus  SET StatusInt = 4, ReasonInt = (CASE WHEN LEN(missingUpdatesPatches) > 0 THEN 1 ELSE 0 END)

	WHERE  ClientType = ''MediaAgents'' and ((ReleaseStr = CSReleaseStr AND CSSPMajor > SPMajor) OR (ReleaseStr < CSReleaseStr AND LatestSPMajorOnInstalledVersion > SPMajor) OR LEN(missingUpdatesPatches) > 0)

--CS Critical if hotfixes missing TileSeverity_Critical

update #TempResSimGetPatchHealthStatusWithStatus  SET StatusInt = 4, ReasonInt = 1

	WHERE  ClientType in (''CommServ'') and LEN(missingUpdatesPatches) > 0

--CS Critical if release is v9 as we have reached end of life for v9

update #TempResSimGetPatchHealthStatusWithStatus  SET StatusInt = 4, ReasonInt = 3

	WHERE  ClientType in (''CommServ'', ''MediaAgents'',''Servers'',''Laptops'') and CAST(ReleaseStr AS FLOAT) < 10	

SELECT @CSVersion = CSReleaseStr, @majorVer = CSSPMajor FROM #TempResSimGetPatchHealthStatusWithStatus where ClientType = ''CommServ''

SELECT @severity = MAX(StatusInt) FROM #TempResSimGetPatchHealthStatusWithStatus
INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType) 


VALUES(

(3683 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

	(SELECT 

		(SELECT 1 AS ''@paramPos'', @CSVersion AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE),

		(SELECT 2 AS ''@paramPos'', CAST(@majorVer AS VARCHAR(10)) AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE) 

    FOR XML PATH(''MsgParams'')),

	'''',

	'''',

	2

)

DECLARE @lagsBy INT = 2 --(@availabeSP-@majorVer)

--TILE_CS_VERSION_ALERT
INSERT INTO @alarmCriteria(criteriaId, msgId, alarm, alarmValue, defaultComparator) 


VALUES(1, (3722 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Installed Service Pack is behind by ##val## or more Service Pack releases'', CAST(@lagsBy AS VARCHAR(10)), ''1''/*AlertOperationType.MORETHAN*/)

IF EXISTS (SELECT * FROM #TempResSimGetPatchHealthStatusWithStatus WHERE ClientType = ''CommServ'' AND StatusInt = 4)

BEGIN

	--TILEOUTCOME_CS_VERSION_CSMISSINGUPDATES
	INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType, fixWFMsgId, fixWFName, fixWFGUID)  


		VALUES(

(3685 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

			'''', 

			'''', 

			'''', 

			2,

			--TILE_CS_VERSION_FIX

(3723 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

			''Install or Schedule updates'', ''''

		)	

END

IF EXISTS (SELECT * FROM #TempResSimGetPatchHealthStatusWithStatus WHERE ClientType <> ''CommServ'' AND StatusInt >= 3)

BEGIN	

	DECLARE @NoServers int = 0

	DECLARE @NoLaptops int = 0

	DECLARE @NoMediaAgents int = 0

	SELECT @NoServers = COUNT(*) FROM #TempResSimGetPatchHealthStatusWithStatus WHERE StatusInt >= 3 AND ClientType = ''Servers''

	SELECT @NoLaptops = COUNT(*) FROM #TempResSimGetPatchHealthStatusWithStatus WHERE StatusInt >= 3 AND ClientType = ''Laptops''

	SELECT @NoMediaAgents = COUNT(*) FROM #TempResSimGetPatchHealthStatusWithStatus WHERE StatusInt >= 3 AND ClientType = ''MediaAgents''
	INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType, fixWFMsgId, fixWFName, fixWFGUID)    


		VALUES

		(

(3684 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

			(SELECT 

				(SELECT 1 AS ''@paramPos'', @NoServers AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE),

				(SELECT 2 AS ''@paramPos'', @NoLaptops AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE),

				(SELECT 3 AS ''@paramPos'', @NoMediaAgents AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE)

			FOR XML PATH(''MsgParams'')), 

			'''',

			'''',

			2,

(3723 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

			''Install or Schedule updates'', ''''

		)	

END

IF @severity = 4

BEGIN

IF EXISTS (SELECT * FROM #TempResSimGetPatchHealthStatusWithStatus WHERE StatusInt = 4 AND ReasonInt = 3)

		--TILE_CS_VERSION_CRITICAL
		INSERT INTO @severityThresholds 


VALUES((3770 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Behind by latest supported release.'')

		ELSE 

		--TILE_CS_VERSION_CRITICAL
		INSERT INTO @severityThresholds 


VALUES((3657 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Behind by 6 or more Service Packs or needs hotfixes installed from software cache.'')

IF EXISTS (SELECT * FROM #TempResSimGetPatchHealthStatusWithStatus WHERE StatusInt = 4 AND ReasonInt = 0)

		--TILERECOMMENDATION_CS_VERSION
		INSERT INTO @recommendation


VALUES((3690 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Install latest Service Pack'')

IF EXISTS (SELECT * FROM #TempResSimGetPatchHealthStatusWithStatus WHERE StatusInt = 4 AND ReasonInt = 1)

		--TILERECOMMENDATION_CS_VERSION_MISSING_HOTFIXES
		INSERT INTO @recommendation


VALUES((3743 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Install missing Hotfixes.'')

IF EXISTS (SELECT * FROM #TempResSimGetPatchHealthStatusWithStatus WHERE StatusInt = 4 AND ReasonInt = 3)

		--TILERECOMMENDATION_CS_VERSION
		INSERT INTO @recommendation


VALUES((3771 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Upgrade to latest supported release.'')

END 

ELSE IF @severity = 3

BEGIN

	--TILE_CS_VERSION_WARNING
	INSERT INTO @severityThresholds 


VALUES((3659 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Behind by 4 Service Packs.'')

IF EXISTS (SELECT * FROM #TempResSimGetPatchHealthStatusWithStatus WHERE StatusInt = 3 AND ReasonInt = 0)

	--TILERECOMMENDATION_CS_VERSION
	INSERT INTO @recommendation


VALUES((3690 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Install latest Service Pack'')

IF EXISTS (SELECT * FROM #TempResSimGetPatchHealthStatusWithStatus WHERE StatusInt = 3 AND ReasonInt = 1)

	--TILERECOMMENDATION_CS_VERSION_MISSING_HOTFIXES
	INSERT INTO @recommendation


VALUES((3743 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Install missing Hotfixes'')

END

ELSE IF @severity = 2

BEGIN

	--TILE_CS_VERSION_GOOD
	INSERT INTO @severityThresholds 


VALUES((3658 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''One of the 4 latest Service Packs is installed and all hotfixes are installed.'')

	--TILERECOMMENDATION_UPTODATE
	INSERT INTO @recommendation


VALUES((3695 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Up-to-Date'')

END

DECLARE @severityThresholdXML XML = ''''

SELECT @severityThresholdXML = 

(SELECT msgId AS ''@msgId'', threshold AS ''@value'' FROM @severityThresholds FOR XML PATH(''thresholds''))

DECLARE @outcomeXML XML = ''''

SELECT @outcomeXML = 

(SELECT 

	keyMsgId ''@outcomeKeyMsgId'',

	fixWFMsgId AS ''@fixWFMsgId'', 

	fixWFName AS ''@fixWFName'', 

	fixWFGUID AS ''@fixWFGUID'', 	 

	outcomeKey AS ''@outcomeKey'', 

	outcomeValue AS ''@outcomeValue'',

	outcomeType AS ''@outcomeType'',

	keyMsgParams AS ''outcomeKeyMsgParams''

FROM @outcome FOR XML PATH(''outcomes''))

DECLARE @recommendationXML XML = ''''

SELECT @recommendationXML = 

(SELECT msgId AS ''@msgId'', recommendation AS ''@value'' FROM @recommendation FOR XML PATH(''recommendations''))

DECLARE @alarmCriteriaXML XML = ''''

SELECT @alarmCriteriaXML = 

(SELECT criteriaId AS ''@criteriaId'', msgId AS ''@msgId'', alarm AS ''@alarm'', alarmValue AS ''@alarmValue'', defaultComparator AS ''@defaultComparator'' FROM @alarmCriteria FOR XML PATH(''alarmCriteria''))

SELECT

	@tileId AS ''TileId'',

	@tileName AS ''TileName'', 

	@tileMsgid AS ''TileMsgId'',

	@categoryId AS ''CategoryId'',

	@categoryName AS ''CategoryName'', 

	@categoryMsgId AS ''CategoryMsgId'',

	@severity AS ''Severity'',

	@severityThresholdXML AS ''SeverityThresholds'',

	@outcomeXML AS ''Outcome'',

	@recommendationXML AS ''Recommendation'',

	@detailedReportName AS ''DetailedReport'',

	@alarmCriteriaXML AS ''AlarmCriteria''

IF OBJECT_ID(''tempdb..#TempResSimGetPatchHealthStatusWithStatus'') IS NOT NULL

       DROP TABLE #TempResSimGetPatchHealthStatusWithStatus

SET NOCOUNT OFF'

IF NOT EXISTS (SELECT * FROM RptTiles WHERE TileId = @id)
	INSERT INTO RptTiles(TileId, TileName, MessageId, Description, TileCategoryId, Status, Flags, Revision, GUID, CollectionQuery, CreatedTime, ModifiedTime)


	VALUES(@id, @name, @messageId, @description, @tileCategoryId, @status, @flags, @revision, @guid, @CollectionQuery, @nowTime, @nowTime)

ELSE

	UPDATE RptTiles SET

		TileName = @name, 

		MessageId = @messageId, 

		Description = @description, 

		TileCategoryId = @tileCategoryId, 

		Status = @status, 

		Flags = @flags, 

		Revision = @revision, 

		GUID = @guid, 

		CollectionQuery = @CollectionQuery, 

		ModifiedTime = @nowTime

	WHERE TileId = @id

