

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/RptTileSyntheticFullSchedules.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/RptTileSyntheticFullSchedules.script,v $ $Id: RptTileSyntheticFullSchedules.script,v 1.1.4.4 2020/10/04 00:49:35 abilbrey Exp $";

GO
-- TABLENAME RptTiles

print '... inserting Table: RptTiles'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME RptTiles

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @id INT

DECLARE @name NVARCHAR(512)

DECLARE @messageId INT

DECLARE @description nvarchar(MAX)

DECLARE @tileCategoryId INT

DECLARE @status INT

DECLARE @flags INT

DECLARE @revision nvarchar(255)

DECLARE @guid nvarchar(256)

DECLARE @CollectionQuery NVARCHAR(MAX)

SET @id = 3

SET @name = 'Synthetic Full Schedules'

SET @messageId = (3775 | (CAST(POWER(2, 24) AS BIGINT) * 61))

SET @description = ''

SET @tileCategoryId = 1

SET @status = 0

--Bit 0 of flags for height of tile

SET @flags = 1 

SET @revision = '$Revision: 1.1.4.4 $'

SET @guid = '8843744F-6772-487E-A118-5EA686414F00'

SET @CollectionQuery = 

'SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON 

DECLARE @tileId INT = 3

DECLARE @tileName NVARCHAR(512) = ''Synthetic Full Schedules''

DECLARE @tileMsgid BIGINT = (3775 | (CAST(POWER(2, 24) AS BIGINT) * 61))

DECLARE @categoryId INT = 1

DECLARE @categoryName NVARCHAR(512) = ''Configuration''

DECLARE @categoryMsgId BIGINT = (3672 | (CAST(POWER(2, 24) AS BIGINT) * 61))

DECLARE @severity INT										--enum TileSeverity       

DECLARE @severityThresholds TABLE(msgId BIGINT, threshold NVARCHAR(MAX))

DECLARE @outcome TABLE(keyMsgId BIGINT, keyMsgParams XML, outcomeKey NVARCHAR(MAX), outcomeValue NVARCHAR(MAX), outcomeType INT, fixWFMsgId BIGINT, fixWFName NVARCHAR(MAX), fixWFGUID NVARCHAR(512))

DECLARE @recommendation TABLE(msgId BIGINT, recommendation NVARCHAR(MAX))

DECLARE @detailedReportName NVARCHAR(1024)

DECLARE @SubClientCount INT = 0

IF object_id(''tempdb.dbo.#subclientSchedules_initInfoTable'') is not null

DROP TABLE #subclientSchedules_initInfoTable

CREATE TABLE #subclientSchedules_initInfoTable

(taskId INT, stId INT, freq_type INT, backuplevel INT, automaticSchFreq INT)

CREATE CLUSTERED INDEX subclientSchedules_initInfoTable_stId_Index1 ON #subclientSchedules_initInfoTable (stId)
INSERT INTO #subclientSchedules_initInfoTable


(taskId, stId, freq_type, backupLevel, automaticSchFreq)

SELECT DISTINCT

TASK.taskId,

STASK.subTaskId,

PAT.freq_type,

SOPT.value, 1

FROM

TM_Task as TASK JOIN

TM_SubTask as STASK ON TASK.taskId = STASK.taskId  JOIN

TM_SubTaskOptions as SOPT ON STASK.subTaskId = SOPT.subTaskId JOIN

TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = STASK.subTaskId JOIN

TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId  JOIN

TM_RunTime AS RT ON RT.patternId = PAT.patternId  JOIN

TM_RunTimeAssoc AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId

WHERE

STASK.subTaskType = 2 AND

SOPT.optionId = 458405394 AND

(SOPT.value = 4 OR SOPT.value = 1) AND

TASK.deleted = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0  

        AND PAT.freq_type < 16 -- Consider only schedules which run less than  monthly

        UNION

--This is to cover automatic schedules

SELECT DISTINCT

TASK.taskId,

STASK.subTaskId,

PAT.freq_type,

SOPT.value,

SOPT1.value

FROM

TM_Task as TASK JOIN

TM_SubTask as STASK ON TASK.taskId = STASK.taskId  JOIN

TM_SubTaskOptions as SOPT ON STASK.subTaskId = SOPT.subTaskId AND SOPT.optionId = 458405394 JOIN

TM_SubTaskOptions as SOPT1 ON STASK.subTaskId = SOPT1.subTaskId AND  SOPT1.optionId = 1765126965 JOIN

TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = STASK.subTaskId JOIN

TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId AND freq_type = 1024

WHERE

STASK.subTaskType = 2 AND

(SOPT.value = 4 OR SOPT.value = 1) AND

SOPT1.value < 30 AND -- Consider only schedules which run less than monthly

TASK.deleted = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0  

IF object_id(''tempdb.dbo.#listofSynthfullClients'') is not null

DROP TABLE #listofSynthfullClients

CREATE TABLE #listofSynthfullClients (clientName VARCHAR(1024), subclient VARCHAR(256), subclientid INT,

backupLevel INT,  schedulepolicyfrequency INT, storagepolicyretnetion INT, clientStatus INT )
INSERT INTO #listofSynthfullClients


SELECT C.name, T.subclientName, T.id, backupLevel, 

    CASE WHEN T.freq_type = 4 THEN 1

                    WHEN T.freq_type = 8 THEN 7

                    --WHEN T.freq_type >= 16 AND T.freq_type <= 32 THEN 30

                    WHEN T.freq_type = 1024 THEN automaticSchFreq

                    ELSE 365 END AS Frequency, 32, C.status

FROM

(      

        SELECT IT.taskId, stId, freq_type, backupLevel, AA.id, AA.subclientName, AA.clientId, AA.apptypeId, automaticSchFreq

        FROM #subclientSchedules_initInfoTable IT JOIN

        TM_AssocEntity AS ASSOC ON ASSOC.taskId = IT.taskId JOIN

        APP_ClientGroupAssoc ACG ON (ASSOC.assocType = 28 AND ASSOC.clientGroupId = ACG.clientGroupId) JOIN      

        APP_Application AA ON ( ASSOC.exclude = 0 AND (ACG.clientId = AA.clientId))

                                                        AND AA.subclientStatus & (0x00010) = 0      --Dummy

                                                        AND AA.subclientStatus & (0x00020) = 0      --Hidden    

                                                        AND AA.subclientStatus & (0x00004) = 0      --deleted

                                                        AND AA.subclientStatus & (0x00002) = 0      --uninstalled

                                                        AND AA.appTypeId <> 1000                    --DR Subclient  

                                                                                                AND AA.dataArchGrpID > 1 

        UNION

        SELECT IT.taskId, stId, freq_type, backupLevel, AA.id, AA.subclientName, AA.clientId, AA.apptypeId, automaticSchFreq

        FROM #subclientSchedules_initInfoTable IT JOIN

        TM_AssocEntity AS ASSOC ON ASSOC.taskId = IT.taskId JOIN

        APP_Application AA ON ( ASSOC.exclude = 0 AND ((ASSOC.clientId=AA.clientId AND ASSOC.assocType=3 )      

                                                                                                        OR (ASSOC.clientId=AA.clientId AND ASSOC.appTypeId=AA.appTypeId AND ASSOC.assocType=4)

                                                                                                        OR (ASSOC.instanceId =AA.instance AND ASSOC.assocType=5)

                                                                                                        OR (ASSOC.backupsetId = AA.backupSet AND ASSOC.assocType=6)

                                                                                                        OR (ASSOC.subclientId = AA.id AND ASSOC.assocType=7)

                                                                                                        OR ASSOC.assocType=2)) 

                                                        AND AA.subclientStatus & (0x00010) = 0      --Dummy

                                                        AND AA.subclientStatus & (0x00020) = 0      --Hidden    

                                                        AND AA.subclientStatus & (0x00004) = 0      --deleted

                                                        AND AA.subclientStatus & (0x00002) = 0      --uninstalled

                                                        AND AA.appTypeId <> 1000                    --DR Subclient   

                                                                                                AND AA.dataArchGrpID > 1 

) T

JOIN APP_Client C ON C.id = T.clientId

CROSS APPLY dbo.GetAppTypesForAppGroup(35, 0) APG      --APPGRP_FileSystemIDA

WHERE T.appTypeId = APG.appTypeId

IF object_id(''tempdb.dbo.#subclientSchedules_initInfoTable'') is not null

        DROP TABLE #subclientSchedules_initInfoTable

DELETE FROM #listofSynthfullClients WHERE backupLevel = 1 AND clientStatus <> 4096

AND NOT EXISTS ( SELECT componentNameId FROM APP_SubClientProp sub WITH (NOLOCK) 

WHERE subclientid = sub.componentNameId AND attrName = ''Is Turbo Subclient'' AND attrVal = ''1'' AND modified = 0 )

IF object_id(''tempdb.dbo.#archGroupIdList'') is not null

DROP TABLE #archGroupIdList

CREATE TABLE #archGroupIdList (appId INT, archgroupcopyId INT, archgroupId INT)
INSERT INTO #archGroupIdList


SELECT A.id, C.id, B.id

FROM  #listofSynthfullClients temp JOIN APP_Application A WITH (NOLOCK) ON A.id = subclientid

JOIN archGroup B WITH (NOLOCK) ON A.dataArchGrpID = B.id

JOIN archGroupCopy C WITH (NOLOCK) ON B.id = C.archGroupId AND isSnapCopy = 0

IF object_id(''tempdb.dbo.#spRetentionDays'') is not null

DROP TABLE #spRetentionDays

CREATE TABLE #spRetentionDays (appId INT, retentionDays INT, archgroupId INT, retentionCopy VARCHAR(32))
INSERT INTO #spRetentionDays


SELECT appId, CASE WHEN retentionRule = 262144 THEN 1*EveryXHours /24

                                  WHEN retentionRule = 524288 THEN 1

                                  WHEN retentionRule = 4 THEN 7

                                  WHEN retentionRule = 8 THEN 30

                                  WHEN retentionRule = 16 THEN 90

                                  WHEN retentionRule = 32 THEN 180 ELSE 365 END,

archgroupId, ''ExtendedRetentionDays''

FROM #archGroupIdList A JOIN

ArchAgingRuleExtended B WITH (NOLOCK) ON A.archgroupcopyId = B.copyId

UNION

SELECT appId, CASE WHEN type = 10 THEN 1*numPeriod /24

                                  WHEN type = 3 THEN 1*numPeriod

                                  WHEN type = 2 THEN 7*numPeriod

                                  WHEN type = 4 THEN 30*numPeriod ELSE 365 END , 

                                  archgroupId,''SelectiveCopy''

FROM #archGroupIdList A JOIN

archSelectiveCopy B WITH (NOLOCK) ON A.archgroupcopyId = B.copyId

UPDATE #listofSynthfullClients SET storagepolicyretnetion = retentionDays

FROM (SELECT appId, MIN(retentionDays) retentionDays FROM #spRetentionDays GROUP BY appId) A

WHERE A.appId = subclientid

select @SubClientCount = COUNT(subclientid) from #listofSynthfullClients where storagepolicyretnetion > schedulepolicyfrequency 

IF object_id(''tempdb.dbo.#archGroupIdList'') is not null

DROP TABLE #archGroupIdList

IF object_id(''tempdb.dbo.#spRetentionDays'') is not null

DROP TABLE #spRetentionDays

IF object_id(''tempdb.dbo.#listofSynthfullClients'') is not null

DROP TABLE #listofSynthfullClients

IF (@SubClientCount = 0)

BEGIN
	INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType)  


	VALUES(

(3778 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

		'''',

		'''',

		'''',

2

	)

SELECT @severity = 2
	INSERT INTO @severityThresholds 


VALUES((3777 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "No subclient is configured to run synthetic full jobs more frequently than needed.")
	INSERT INTO @recommendation


VALUES((3694 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "Meets Expectation")

END

ELSE

BEGIN
	INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType)  


	VALUES(

(3779 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

		(SELECT 

			(SELECT 1 AS ''@paramPos'', CAST(@SubClientCount AS VARCHAR(10)) AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE)

		FOR XML PATH(''MsgParams'')),

		'''',

		'''',

2

	)

SELECT @severity = 4

	SELECT @detailedReportName = "Suboptimal Synthetic Full Schedules"
	INSERT INTO @severityThresholds 


VALUES((3776 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "One or more Subclients are configured to run Synthetic Full jobs more frequently than needed.")
	INSERT INTO @recommendation


VALUES((3780 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "Please view the affected subclients and change the schedules to Automatic and Number of days to 30.")

END

DECLARE @severityThresholdXML XML = ''''

SELECT @severityThresholdXML = 

(SELECT msgId AS ''@msgId'', threshold AS ''@value'' FROM @severityThresholds FOR XML PATH(''thresholds''))

DECLARE @outcomeXML XML = ''''

SELECT @outcomeXML = 

(SELECT 

	keyMsgId ''@outcomeKeyMsgId'',

	fixWFMsgId AS ''@fixWFMsgId'', 

	fixWFName AS ''@fixWFName'', 

	fixWFGUID AS ''@fixWFGUID'', 	 

	outcomeKey AS ''@outcomeKey'', 

	outcomeValue AS ''@outcomeValue'',

	outcomeType AS ''@outcomeType'',

	keyMsgParams AS ''outcomeKeyMsgParams''

FROM @outcome FOR XML PATH(''outcomes''))

DECLARE @recommendationXML XML = ''''

SELECT @recommendationXML = 

(SELECT msgId AS ''@msgId'', recommendation AS ''@value'' FROM @recommendation FOR XML PATH(''recommendations''))

DECLARE @alarmCriteriaXML XML = ''''

SELECT

	@tileId AS ''TileId'',

	@tileName AS ''TileName'', 

	@tileMsgid AS ''TileMsgId'',

	@categoryId AS ''CategoryId'',

	@categoryName AS ''CategoryName'', 

	@categoryMsgId AS ''CategoryMsgId'',

	@severity AS ''Severity'',

	@severityThresholdXML AS ''SeverityThresholds'',

	@outcomeXML AS ''Outcome'',

	@recommendationXML AS ''Recommendation'',

	@detailedReportName AS ''DetailedReport'',

	@alarmCriteriaXML AS ''AlarmCriteria''

SET NOCOUNT OFF'

IF NOT EXISTS (SELECT * FROM RptTiles WHERE TileId = @id)
	INSERT INTO RptTiles(TileId, TileName, MessageId, Description, TileCategoryId, Status, Flags, Revision, GUID, CollectionQuery, CreatedTime, ModifiedTime)


	VALUES(@id, @name, @messageId, @description, @tileCategoryId, @status, @flags, @revision, @guid, @CollectionQuery, @nowTime, @nowTime)

ELSE

	UPDATE RptTiles SET

		TileName = @name, 

		MessageId = @messageId, 

		Description = @description, 

		TileCategoryId = @tileCategoryId, 

		Status = @status, 

		Flags = @flags, 

		Revision = @revision, 

		GUID = @guid, 

		CollectionQuery = @CollectionQuery, 

		ModifiedTime = @nowTime

	WHERE TileId = @id

