

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/RptTileDRBackup.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/RptTileDRBackup.script,v $ $Id: RptTileDRBackup.script,v 1.1.2.10 2020/10/04 01:04:59 abilbrey Exp $";

GO
-- TABLENAME RptTiles

print '... inserting Table: RptTiles'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME RptTiles

SET QUOTED_IDENTIFIER ON

-- Tbl script file should not have any function calls because they may not exist during upgrade

DECLARE @nowTime int = datediff(second, '01/01/1970', getUTCDate())

DECLARE @id INT

DECLARE @name NVARCHAR(512)

DECLARE @messageId INT

DECLARE @description nvarchar(MAX)

DECLARE @tileCategoryId INT

DECLARE @status INT

DECLARE @flags INT

DECLARE @revision nvarchar(255)

DECLARE @guid nvarchar(256)

DECLARE @CollectionQuery NVARCHAR(MAX)

SET @id = 2

SET @name = 'Disaster Recovery Backup'

SET @messageId = (3661 | (CAST(POWER(2, 24) AS BIGINT) * 61))

SET @description = ''

SET @tileCategoryId = 1

SET @status = 0

--Bit 0 of flags for height of tile

SET @flags = 1 

SET @revision = '$Revision: 1.1.2.10 $'

SET @guid = 'B851F5B7-5CAC-4C2E-B4AD-C4F0E802E284'

SET @CollectionQuery = 

'SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON 

DECLARE @tileId INT = 2

DECLARE @tileName NVARCHAR(512) = ''Disaster Recovery Backup''

DECLARE @tileMsgid BIGINT = (3661 | (CAST(POWER(2, 24) AS BIGINT) * 61))

DECLARE @categoryId INT = 1

DECLARE @categoryName NVARCHAR(512) = ''Configuration''

DECLARE @categoryMsgId BIGINT = (3672 | (CAST(POWER(2, 24) AS BIGINT) * 61))

DECLARE @severity INT										--enum TileSeverity       

DECLARE @severityThresholds TABLE(msgId BIGINT, threshold NVARCHAR(MAX))

DECLARE @outcome TABLE(keyMsgId BIGINT, keyMsgParams XML, outcomeKey NVARCHAR(MAX), outcomeValue NVARCHAR(MAX), outcomeType INT, fixWFMsgId BIGINT, fixWFName NVARCHAR(MAX), fixWFGUID NVARCHAR(512))

DECLARE @recommendation TABLE(msgId BIGINT, recommendation NVARCHAR(MAX))

DECLARE @alarmCriteria TABLE(criteriaId INT, msgId BIGINT, alarm NVARCHAR(MAX), alarmValue NVARCHAR(MAX), defaultComparator NVARCHAR(10) DEFAULT '''')

DECLARE @detailedReportName NVARCHAR(1024) = "Disaster Recovery Backup"

DECLARE @last_dr_success INTEGER = 0

DECLARE @last_dr_failed INTEGER = 0

DECLARE @optype_DR_bkp INTEGER = 11

SET @last_dr_success =ISNULL((SELECT MAX(servEnd) FROM JMAdminJobStatsTable WITH (NOLOCK) WHERE opType = @optype_DR_bkp AND status =1), 0)

SET @last_dr_failed =ISNULL((SELECT MAX(servEnd) FROM JMAdminJobStatsTable WITH (NOLOCK) WHERE opType = @optype_DR_bkp AND status NOT IN (4,8,9,1)), 0)

DECLARE @lt_fullJobsToRetain varchar(256)

DECLARE @lt_useNetworkPath    varchar(10)

-- Number of full DR metadata dumps to retain

SELECT @lt_fullJobsToRetain = value FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = ''DRNumFulls''

-- Find whether metadata dumps are saved to network path or local file system path

SELECT @lt_useNetworkPath = (CASE WHEN value like ''\\%'' THEN ''true'' ELSE ''false'' END) FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = ''DRDumpLocation''

IF (@last_dr_success = 0)
INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType)  


VALUES(

(3688 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

	'''',

	'''',

	'''',

2

)

ELSE

BEGIN

IF (@last_dr_success > @last_dr_failed)
	INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType)  


	VALUES(

(3687 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

		(SELECT 

			(SELECT 1 AS ''@paramPos'', CONVERT(VARCHAR(12), dbo.UTCToCellLocalTime(dbo.GetDateTime(@last_dr_success), 2), 107) AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE)

		FOR XML PATH(''MsgParams'')),

		'''',

		'''',

2

	)

ELSE
	INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType)  


	VALUES(

(3766 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

		(SELECT 

			(SELECT 1 AS ''@paramPos'', CONVERT(VARCHAR(12), dbo.UTCToCellLocalTime(dbo.GetDateTime(@last_dr_failed), 2), 107) AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE)

		FOR XML PATH(''MsgParams'')),

		'''',

		'''',

2

	)

END
INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType) 


	VALUES

	(

(3686 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

		(SELECT 

			(SELECT 1 AS ''@paramPos'', CASE WHEN @lt_useNetworkPath = ''false'' THEN ''Local'' ELSE ''UNC'' END AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE)

		FOR XML PATH(''MsgParams'')), 

		'''',

		'''',

2

	)
INSERT INTO @outcome(keyMsgId, keyMsgParams, outcomeKey, outcomeValue, outcomeType) 


	VALUES

	(

(3689 | (CAST(POWER(2, 24) AS BIGINT) * 61)),

		(SELECT 

			(SELECT 1 AS ''@paramPos'', @lt_fullJobsToRetain AS ''@paramValue'' FOR XML PATH (''msgParam''), TYPE)

		FOR XML PATH(''MsgParams'')), 

		'''',

		'''',

2

	)

DECLARE @daysSinceLastDRJob INT

SELECT @daysSinceLastDRJob = CASE WHEN @last_dr_success = 0 THEN 9999 ELSE DATEDIFF(DD, dbo.GetDateTime(@last_dr_success), GETUTCDATE()) END
INSERT INTO @alarmCriteria(criteriaId, msgId, alarm, alarmValue) 


VALUES(1, (3724 | (CAST(POWER(2, 24) AS BIGINT) * 61)), ''Days since last DR Backup is ##op## ##val## days'', CAST(@daysSinceLastDRJob AS NVARCHAR(MAX)))

--Check for critical condition

IF ( 

	(dbo.GetUnixTime(GETUTCDATE()) - @last_dr_success > (7 * 24 * 60 * 60)) --Days since last DR Backup > 7 days 

	OR @lt_useNetworkPath = ''false'' --Local path is used 

	OR @lt_fullJobsToRetain = 0	--Full jobs retention is set to 0

	OR (@last_dr_success < @last_dr_failed)

)

BEGIN  

SELECT @severity = 4

UPDATE @outcome SET fixWFMsgId = (3725 | (CAST(POWER(2, 24) AS BIGINT) * 61)), fixWFName = ''Start and schedule disaster recovery''
	INSERT INTO @severityThresholds 


VALUES((3662 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "7 or more days since last DR Backup. Local path is used. Full jobs retention is set to 0.")
	INSERT INTO @recommendation


VALUES((3692 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "It is strongly recommended to run DR backup every day and use UNC path as destination with minimum of 2 metadata retentions.")

END

--warning

ELSE IF (

	((dbo.GetUnixTime(GETUTCDATE()) - @last_dr_success <= (7 * 24 * 60 * 60)) AND  (dbo.GetUnixTime(GETUTCDATE()) - @last_dr_success > (3 * 24 * 60 * 60))) --Days since last DR Backup is between 3 and 7 days 

	OR @lt_fullJobsToRetain = 1  --Full jobs retention is set to 1

)

BEGIN

SELECT @severity = 3

UPDATE @outcome SET fixWFMsgId = (3725 | (CAST(POWER(2, 24) AS BIGINT) * 61)), fixWFName = ''Start and schedule disaster recovery''
	INSERT INTO @severityThresholds 


VALUES((3664 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "Days since last DR Backup is between 3 and 7 days. Full jobs retention is set to 1.")
	INSERT INTO @recommendation


VALUES((3693 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "It is recommended to run DR backup every day and use UNC path as destination with minimum of 2 metadata retentions.")

END

ELSE

BEGIN

	--Days since last DR Backup < 3 days 

	--Network path is used 

	--Full jobs retention is >= 2

SELECT @severity = 2
	INSERT INTO @severityThresholds 


VALUES((3663 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "Days since last DR Backup is less than 3 days. Network path is used. 2 or more Full jobs retained.")
	INSERT INTO @recommendation


VALUES((3694 | (CAST(POWER(2, 24) AS BIGINT) * 61)), "Meets Expectation")

END

DECLARE @severityThresholdXML XML = ''''

SELECT @severityThresholdXML = 

(SELECT msgId AS ''@msgId'', threshold AS ''@value'' FROM @severityThresholds FOR XML PATH(''thresholds''))

DECLARE @outcomeXML XML = ''''

SELECT @outcomeXML = 

(SELECT 

	keyMsgId ''@outcomeKeyMsgId'',

	fixWFMsgId AS ''@fixWFMsgId'', 

	fixWFName AS ''@fixWFName'', 

	fixWFGUID AS ''@fixWFGUID'', 	 

	outcomeKey AS ''@outcomeKey'', 

	outcomeValue AS ''@outcomeValue'',

	outcomeType AS ''@outcomeType'',

	keyMsgParams AS ''outcomeKeyMsgParams''

FROM @outcome FOR XML PATH(''outcomes''))

DECLARE @recommendationXML XML = ''''

SELECT @recommendationXML = 

(SELECT msgId AS ''@msgId'', recommendation AS ''@value'' FROM @recommendation FOR XML PATH(''recommendations''))

DECLARE @alarmCriteriaXML XML = ''''

SELECT @alarmCriteriaXML = 

(SELECT criteriaId AS ''@criteriaId'', msgId AS ''@msgId'', alarm AS ''@alarm'', alarmValue AS ''@alarmValue'' FROM @alarmCriteria FOR XML PATH(''alarmCriteria''))

SELECT

	@tileId AS ''TileId'',

	@tileName AS ''TileName'', 

	@tileMsgid AS ''TileMsgId'',

	@categoryId AS ''CategoryId'',

	@categoryName AS ''CategoryName'', 

	@categoryMsgId AS ''CategoryMsgId'',

	@severity AS ''Severity'',

	@severityThresholdXML AS ''SeverityThresholds'',

	@outcomeXML AS ''Outcome'',

	@recommendationXML AS ''Recommendation'',

	@detailedReportName AS ''DetailedReport'',

	@alarmCriteriaXML AS ''AlarmCriteria''

SET NOCOUNT OFF'

IF NOT EXISTS (SELECT * FROM RptTiles WHERE TileId = @id)
	INSERT INTO RptTiles(TileId, TileName, MessageId, Description, TileCategoryId, Status, Flags, Revision, GUID, CollectionQuery, CreatedTime, ModifiedTime)


	VALUES(@id, @name, @messageId, @description, @tileCategoryId, @status, @flags, @revision, @guid, @CollectionQuery, @nowTime, @nowTime)

ELSE

	UPDATE RptTiles SET

		TileName = @name, 

		MessageId = @messageId, 

		Description = @description, 

		TileCategoryId = @tileCategoryId, 

		Status = @status, 

		Flags = @flags, 

		Revision = @revision, 

		GUID = @guid, 

		CollectionQuery = @CollectionQuery, 

		ModifiedTime = @nowTime

	WHERE TileId = @id

